/* 
 * pic18f2682.h - device specific declarations
 *
 * This file is part of the GNU PIC library for SDCC,
 * originally devised by Vangelis Rokas <vrokas AT otenet.gr>
 *
 * It has been automatically generated by inc2h-pic16.pl,
 * (c) 2007 by Raphael Neider <rneider AT web.de>
 */

#ifndef __PIC18F2682_H__
#define __PIC18F2682_H__ 1



// Configuration Bits
#define	__CONFIG1H          	0x300001
#define	__CONFIG2L          	0x300002
#define	__CONFIG2H          	0x300003
#define	__CONFIG3H          	0x300005
#define	__CONFIG4L          	0x300006
#define	__CONFIG5L          	0x300008
#define	__CONFIG5H          	0x300009
#define	__CONFIG6L          	0x30000A
#define	__CONFIG6H          	0x30000B
#define	__CONFIG7L          	0x30000C
#define	__CONFIG7H          	0x30000D

// CONFIG1H Options
#define	_OSC_LP_1H          	0xF0	 // LP oscillator
#define	_OSC_XT_1H          	0xF1	 // XT oscillator
#define	_OSC_HS_1H          	0xF2	 // HS oscillator
#define	_OSC_RC_1H          	0xF3	 // External RC oscillator, CLKO function on RA6
#define	_OSC_EC_1H          	0xF4	 // EC oscillator, CLKO function on RA6
#define	_OSC_ECIO_1H        	0xF5	 // EC oscillator, port function on RA6
#define	_OSC_HSPLL_1H       	0xF6	 // HS oscillator, PLL enabled (Clock Frequency = 4 x FOSC1)
#define	_OSC_RCIO_1H        	0xF7	 // External RC oscillator, port function on RA6
#define	_OSC_IRCIO67_1H     	0xF8	 // Internal oscillator block, port function on RA6 and RA7
#define	_OSC_IRCIO7_1H      	0xF9	 // Internal oscillator block, CLKO function on RA6, port function on RA7
#define	_FCMEN_OFF_1H       	0xBF	 // Fail-Safe Clock Monitor disabled
#define	_FCMEN_ON_1H        	0xFF	 // Fail-Safe Clock Monitor enabled
#define	_IESO_OFF_1H        	0x7F	 // Oscillator Switchover mode disabled
#define	_IESO_ON_1H         	0xFF	 // Oscillator Switchover mode enabled

// CONFIG2L Options
#define	_PWRT_ON_2L         	0xFE	 // PWRT enabled
#define	_PWRT_OFF_2L        	0xFF	 // PWRT disabled
#define	_BOREN_OFF_2L       	0xF9	 // Brown-out Reset disabled in hardware and software
#define	_BOREN_SBORENCTRL_2L	0xFB	 // Brown-out Reset enabled and controlled by software (SBOREN is enabled)
#define	_BOREN_BOACTIVE_2L  	0xFD	 // Brown-out Reset enabled in hardware only and disabled in Sleep mode (SBOREN is disabled)
#define	_BOREN_BOHW_2L      	0xFF	 // Brown-out Reset enabled in hardware only (SBOREN is disabled)
#define	_BORV_0_2L          	0xE7	 // Maximum setting
#define	_BORV_1_2L          	0xEF	 // 
#define	_BORV_2_2L          	0xF7	 // 
#define	_BORV_3_2L          	0xFF	 // Minimum setting

// CONFIG2H Options
#define	_WDT_OFF_2H         	0xFE	 // WDT disabled (control is placed on the SWDTEN bit)
#define	_WDT_ON_2H          	0xFF	 // WDT enabled
#define	_WDTPS_1_2H         	0xE1	 // 1:1
#define	_WDTPS_2_2H         	0xE3	 // 1:2
#define	_WDTPS_4_2H         	0xE5	 // 1:4
#define	_WDTPS_8_2H         	0xE7	 // 1:8
#define	_WDTPS_16_2H        	0xE9	 // 1:16
#define	_WDTPS_32_2H        	0xEB	 // 1:32
#define	_WDTPS_64_2H        	0xED	 // 1:64
#define	_WDTPS_128_2H       	0xEF	 // 1:128
#define	_WDTPS_256_2H       	0xF1	 // 1:256
#define	_WDTPS_512_2H       	0xF3	 // 1:512
#define	_WDTPS_1024_2H      	0xF5	 // 1:1024
#define	_WDTPS_2048_2H      	0xF7	 // 1:2048
#define	_WDTPS_4096_2H      	0xF9	 // 1:4096
#define	_WDTPS_8192_2H      	0xFB	 // 1:8192
#define	_WDTPS_16384_2H     	0xFD	 // 1:16384
#define	_WDTPS_32768_2H     	0xFF	 // 1:32768

// CONFIG3H Options
#define	_MCLRE_OFF_3H       	0x7F	 // RE3 input pin enabled; MCLR disabled
#define	_MCLRE_ON_3H        	0xFF	 // MCLR pin enabled; RE3 input pin disabled
#define	_LPT1OSC_OFF_3H     	0xFB	 // Timer1 configured for higher power operation
#define	_LPT1OSC_ON_3H      	0xFF	 // Timer1 configured for low-power operation
#define	_PBADEN_OFF_3H      	0xFD	 // PORTB<4> and PORTB<1:0> Configured as Digital I/O Pins on Reset
#define	_PBADEN_ON_3H       	0xFF	 // PORTB<4> and PORTB<1:0> Configured as Analog Pins on Reset

// CONFIG4L Options
#define	_DEBUG_ON_4L        	0x7F	 // Background debugger enabled, RB6 and RB7 are dedicated to In-Circuit Debug
#define	_DEBUG_OFF_4L       	0xFF	 // Background debugger disabled, RB6 and RB7 configured as general purpose I/O pins
#define	_XINST_OFF_4L       	0xBF	 // Instruction set extension and Indexed Addressing mode disabled (Legacy mode)
#define	_XINST_ON_4L        	0xFF	 // Instruction set extension and Indexed Addressing mode enabled
#define	_BBSIZ_1024_4L      	0xCF	 // 1K words (2K bytes) Boot Block
#define	_BBSIZ_2048_4L      	0xDF	 // 2K words (4K bytes) Boot Block
#define	_BBSIZ_4096_4L      	0xEF	 // 4K words (8K bytes) Boot Block
#define	_LVP_OFF_4L         	0xFB	 // Disabled
#define	_LVP_ON_4L          	0xFF	 // Enabled
#define	_STVREN_OFF_4L      	0xFE	 // Stack full/underflow will not cause Reset
#define	_STVREN_ON_4L       	0xFF	 // Stack full/underflow will cause Reset

// CONFIG5L Options
#define	_CP0_ON_5L          	0xFE	 // Block 0 (000800-003FFFh) code-protected
#define	_CP0_OFF_5L         	0xFF	 // Block 0 (000800-003FFFh) not code-protected
#define	_CP1_ON_5L          	0xFD	 // Block 1 (004000-007FFFh) code-protected
#define	_CP1_OFF_5L         	0xFF	 // Block 1 (004000-007FFFh) not code-protected
#define	_CP2_ON_5L          	0xFB	 // Block 2 (008000-00BFFFh) code-protected
#define	_CP2_OFF_5L         	0xFF	 // Block 2 (008000-00BFFFh) not code-protected
#define	_CP3_ON_5L          	0xF7	 // Block 3 (00C000-00FFFFh) code-protected
#define	_CP3_OFF_5L         	0xFF	 // Block 3 (00C000-00FFFFh) not code-protected
#define	_CP4_ON_5L          	0xEF	 // Block 4 (010000-013FFFh) code-protected
#define	_CP4_OFF_5L         	0xFF	 // Block 4 (010000-013FFFh) not code-protected

// CONFIG5H Options
#define	_CPB_ON_5H          	0xBF	 // Boot Block (000000-0007FFh) code-protected
#define	_CPB_OFF_5H         	0xFF	 // Boot Block (000000-0007FFh) not code-protected
#define	_CPD_ON_5H          	0x7F	 // Data EEPROM code-protected
#define	_CPD_OFF_5H         	0xFF	 // Data EEPROM not code-protected

// CONFIG6L Options
#define	_WRT0_ON_6L         	0xFE	 // Block 0 (000800-003FFFh) write-protected
#define	_WRT0_OFF_6L        	0xFF	 // Block 0 (000800-003FFFh) not write-protected
#define	_WRT1_ON_6L         	0xFD	 // Block 1 (004000-007FFFh) write-protected
#define	_WRT1_OFF_6L        	0xFF	 // Block 1 (004000-007FFFh) not write-protected
#define	_WRT2_ON_6L         	0xFB	 // Block 2 (008000-00BFFFh) write-protected
#define	_WRT2_OFF_6L        	0xFF	 // Block 2 (008000-00BFFFh) not write-protected
#define	_WRT3_ON_6L         	0xF7	 // Block 3 (00C000-00FFFFh) write-protected
#define	_WRT3_OFF_6L        	0xFF	 // Block 3 (00C000-00FFFFh) not write-protected
#define	_WRT4_ON_6L         	0xEF	 // Block 4 (010000-013FFFh) write-protected
#define	_WRT4_OFF_6L        	0xFF	 // Block 4 (010000-013FFFh) not write-protected

// CONFIG6H Options
#define	_WRTB_ON_6H         	0xBF	 // Boot Block (000000-0007FFh) write-protected
#define	_WRTB_OFF_6H        	0xFF	 // Boot Block (000000-0007FFh) not write-protected
#define	_WRTC_ON_6H         	0xDF	 // Configuration registers (300000-3000FFh) write-protected
#define	_WRTC_OFF_6H        	0xFF	 // Configuration registers (300000-3000FFh) not write-protected
#define	_WRTD_ON_6H         	0x7F	 // Data EEPROM write-protected
#define	_WRTD_OFF_6H        	0xFF	 // Data EEPROM not write-protected

// CONFIG7L Options
#define	_EBTR0_ON_7L        	0xFE	 // Block 0 (000800-003FFFh) protected from table reads executed in other blocks
#define	_EBTR0_OFF_7L       	0xFF	 // Block 0 (000800-003FFFh) not protected from table reads executed in other blocks
#define	_EBTR1_ON_7L        	0xFD	 // Block 1 (004000-007FFFh) protected from table reads executed in other blocks
#define	_EBTR1_OFF_7L       	0xFF	 // Block 1 (004000-007FFFh) not protected from table reads executed in other blocks
#define	_EBTR2_ON_7L        	0xFB	 // Block 2 (008000-00BFFFh) protected from table reads executed in other blocks
#define	_EBTR2_OFF_7L       	0xFF	 // Block 2 (008000-00BFFFh) not protected from table reads executed in other blocks
#define	_EBTR3_ON_7L        	0xF7	 // Block 3 (00C000-00FFFFh) protected from table reads executed in other blocks
#define	_EBTR3_OFF_7L       	0xFF	 // Block 3 (00C000-00FFFFh) not protected from table reads executed in other blocks
#define	_EBTR4_ON_7L        	0xEF	 // Block 4 (010000-013FFFh) protected from table reads executed in other blocks
#define	_EBTR4_OFF_7L       	0xFF	 // Block 4 (010000-013FFFh) not protected from table reads executed in other blocks

// CONFIG7H Options
#define	_EBTRB_ON_7H        	0xBF	 // Boot Block (000000-0007FFh) protected from table reads executed in other blocks
#define	_EBTRB_OFF_7H       	0xFF	 // Boot Block (000000-0007FFh) not protected from table reads executed in other blocks
#define	_DEVID1             	0x3FFFFE
#define	_DEVID2             	0x3FFFFF
#define	_IDLOC0             	0x200000
#define	_IDLOC1             	0x200001
#define	_IDLOC2             	0x200002
#define	_IDLOC3             	0x200003
#define	_IDLOC4             	0x200004
#define	_IDLOC5             	0x200005
#define	_IDLOC6             	0x200006
#define	_IDLOC7             	0x200007

extern __sfr __at (0xD60) RXF6SIDH;
typedef union {
	struct {
		unsigned SID3      	: 1;
		unsigned SID4      	: 1;
		unsigned SID5      	: 1;
		unsigned SID6      	: 1;
		unsigned SID7      	: 1;
		unsigned SID8      	: 1;
		unsigned SID9      	: 1;
		unsigned SID10     	: 1;
	};
} __RXF6SIDHbits_t;
extern volatile __RXF6SIDHbits_t __at (0xD60) RXF6SIDHbits;

extern __sfr __at (0xD61) RXF6SIDL;
typedef union {
	struct {
		unsigned EID16     	: 1;
		unsigned EID17     	: 1;
		unsigned           	: 1;
		unsigned EXIDE     	: 1;
		unsigned           	: 1;
		unsigned SID0      	: 1;
		unsigned SID1      	: 1;
		unsigned SID2      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned EXIDEN    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __RXF6SIDLbits_t;
extern volatile __RXF6SIDLbits_t __at (0xD61) RXF6SIDLbits;

extern __sfr __at (0xD62) RXF6EIDH;
typedef union {
	struct {
		unsigned EID8      	: 1;
		unsigned EID9      	: 1;
		unsigned EID10     	: 1;
		unsigned EID11     	: 1;
		unsigned EID12     	: 1;
		unsigned EID13     	: 1;
		unsigned EID14     	: 1;
		unsigned EID15     	: 1;
	};
} __RXF6EIDHbits_t;
extern volatile __RXF6EIDHbits_t __at (0xD62) RXF6EIDHbits;

extern __sfr __at (0xD63) RXF6EIDL;
typedef union {
	struct {
		unsigned EID0      	: 1;
		unsigned EID1      	: 1;
		unsigned EID2      	: 1;
		unsigned EID3      	: 1;
		unsigned EID4      	: 1;
		unsigned EID5      	: 1;
		unsigned EID6      	: 1;
		unsigned EID7      	: 1;
	};
} __RXF6EIDLbits_t;
extern volatile __RXF6EIDLbits_t __at (0xD63) RXF6EIDLbits;

extern __sfr __at (0xD64) RXF7SIDH;
typedef union {
	struct {
		unsigned SID3      	: 1;
		unsigned SID4      	: 1;
		unsigned SID5      	: 1;
		unsigned SID6      	: 1;
		unsigned SID7      	: 1;
		unsigned SID8      	: 1;
		unsigned SID9      	: 1;
		unsigned SID10     	: 1;
	};
} __RXF7SIDHbits_t;
extern volatile __RXF7SIDHbits_t __at (0xD64) RXF7SIDHbits;

extern __sfr __at (0xD65) RXF7SIDL;
typedef union {
	struct {
		unsigned EID16     	: 1;
		unsigned EID17     	: 1;
		unsigned           	: 1;
		unsigned EXIDE     	: 1;
		unsigned           	: 1;
		unsigned SID0      	: 1;
		unsigned SID1      	: 1;
		unsigned SID2      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned EXIDEN    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __RXF7SIDLbits_t;
extern volatile __RXF7SIDLbits_t __at (0xD65) RXF7SIDLbits;

extern __sfr __at (0xD66) RXF7EIDH;
typedef union {
	struct {
		unsigned EID8      	: 1;
		unsigned EID9      	: 1;
		unsigned EID10     	: 1;
		unsigned EID11     	: 1;
		unsigned EID12     	: 1;
		unsigned EID13     	: 1;
		unsigned EID14     	: 1;
		unsigned EID15     	: 1;
	};
} __RXF7EIDHbits_t;
extern volatile __RXF7EIDHbits_t __at (0xD66) RXF7EIDHbits;

extern __sfr __at (0xD67) RXF7EIDL;
typedef union {
	struct {
		unsigned EID0      	: 1;
		unsigned EID1      	: 1;
		unsigned EID2      	: 1;
		unsigned EID3      	: 1;
		unsigned EID4      	: 1;
		unsigned EID5      	: 1;
		unsigned EID6      	: 1;
		unsigned EID7      	: 1;
	};
} __RXF7EIDLbits_t;
extern volatile __RXF7EIDLbits_t __at (0xD67) RXF7EIDLbits;

extern __sfr __at (0xD68) RXF8SIDH;
typedef union {
	struct {
		unsigned SID3      	: 1;
		unsigned SID4      	: 1;
		unsigned SID5      	: 1;
		unsigned SID6      	: 1;
		unsigned SID7      	: 1;
		unsigned SID8      	: 1;
		unsigned SID9      	: 1;
		unsigned SID10     	: 1;
	};
} __RXF8SIDHbits_t;
extern volatile __RXF8SIDHbits_t __at (0xD68) RXF8SIDHbits;

extern __sfr __at (0xD69) RXF8SIDL;
typedef union {
	struct {
		unsigned EID16     	: 1;
		unsigned EID17     	: 1;
		unsigned           	: 1;
		unsigned EXIDE     	: 1;
		unsigned           	: 1;
		unsigned SID0      	: 1;
		unsigned SID1      	: 1;
		unsigned SID2      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned EXIDEN    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __RXF8SIDLbits_t;
extern volatile __RXF8SIDLbits_t __at (0xD69) RXF8SIDLbits;

extern __sfr __at (0xD6A) RXF8EIDH;
typedef union {
	struct {
		unsigned EID8      	: 1;
		unsigned EID9      	: 1;
		unsigned EID10     	: 1;
		unsigned EID11     	: 1;
		unsigned EID12     	: 1;
		unsigned EID13     	: 1;
		unsigned EID14     	: 1;
		unsigned EID15     	: 1;
	};
} __RXF8EIDHbits_t;
extern volatile __RXF8EIDHbits_t __at (0xD6A) RXF8EIDHbits;

extern __sfr __at (0xD6B) RXF8EIDL;
typedef union {
	struct {
		unsigned EID0      	: 1;
		unsigned EID1      	: 1;
		unsigned EID2      	: 1;
		unsigned EID3      	: 1;
		unsigned EID4      	: 1;
		unsigned EID5      	: 1;
		unsigned EID6      	: 1;
		unsigned EID7      	: 1;
	};
} __RXF8EIDLbits_t;
extern volatile __RXF8EIDLbits_t __at (0xD6B) RXF8EIDLbits;

extern __sfr __at (0xD70) RXF9SIDH;
typedef union {
	struct {
		unsigned SID3      	: 1;
		unsigned SID4      	: 1;
		unsigned SID5      	: 1;
		unsigned SID6      	: 1;
		unsigned SID7      	: 1;
		unsigned SID8      	: 1;
		unsigned SID9      	: 1;
		unsigned SID10     	: 1;
	};
} __RXF9SIDHbits_t;
extern volatile __RXF9SIDHbits_t __at (0xD70) RXF9SIDHbits;

extern __sfr __at (0xD71) RXF9SIDL;
typedef union {
	struct {
		unsigned EID16     	: 1;
		unsigned EID17     	: 1;
		unsigned           	: 1;
		unsigned EXIDE     	: 1;
		unsigned           	: 1;
		unsigned SID0      	: 1;
		unsigned SID1      	: 1;
		unsigned SID2      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned EXIDEN    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __RXF9SIDLbits_t;
extern volatile __RXF9SIDLbits_t __at (0xD71) RXF9SIDLbits;

extern __sfr __at (0xD72) RXF9EIDH;
typedef union {
	struct {
		unsigned EID8      	: 1;
		unsigned EID9      	: 1;
		unsigned EID10     	: 1;
		unsigned EID11     	: 1;
		unsigned EID12     	: 1;
		unsigned EID13     	: 1;
		unsigned EID14     	: 1;
		unsigned EID15     	: 1;
	};
} __RXF9EIDHbits_t;
extern volatile __RXF9EIDHbits_t __at (0xD72) RXF9EIDHbits;

extern __sfr __at (0xD73) RXF9EIDL;
typedef union {
	struct {
		unsigned EID0      	: 1;
		unsigned EID1      	: 1;
		unsigned EID2      	: 1;
		unsigned EID3      	: 1;
		unsigned EID4      	: 1;
		unsigned EID5      	: 1;
		unsigned EID6      	: 1;
		unsigned EID7      	: 1;
	};
} __RXF9EIDLbits_t;
extern volatile __RXF9EIDLbits_t __at (0xD73) RXF9EIDLbits;

extern __sfr __at (0xD74) RXF10SIDH;
typedef union {
	struct {
		unsigned SID3      	: 1;
		unsigned SID4      	: 1;
		unsigned SID5      	: 1;
		unsigned SID6      	: 1;
		unsigned SID7      	: 1;
		unsigned SID8      	: 1;
		unsigned SID9      	: 1;
		unsigned SID10     	: 1;
	};
} __RXF10SIDHbits_t;
extern volatile __RXF10SIDHbits_t __at (0xD74) RXF10SIDHbits;

extern __sfr __at (0xD75) RXF10SIDL;
typedef union {
	struct {
		unsigned EID16     	: 1;
		unsigned EID17     	: 1;
		unsigned           	: 1;
		unsigned EXIDE     	: 1;
		unsigned           	: 1;
		unsigned SID0      	: 1;
		unsigned SID1      	: 1;
		unsigned SID2      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned EXIDEN    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __RXF10SIDLbits_t;
extern volatile __RXF10SIDLbits_t __at (0xD75) RXF10SIDLbits;

extern __sfr __at (0xD76) RXF10EIDH;
typedef union {
	struct {
		unsigned EID8      	: 1;
		unsigned EID9      	: 1;
		unsigned EID10     	: 1;
		unsigned EID11     	: 1;
		unsigned EID12     	: 1;
		unsigned EID13     	: 1;
		unsigned EID14     	: 1;
		unsigned EID15     	: 1;
	};
} __RXF10EIDHbits_t;
extern volatile __RXF10EIDHbits_t __at (0xD76) RXF10EIDHbits;

extern __sfr __at (0xD77) RXF10EIDL;
typedef union {
	struct {
		unsigned EID0      	: 1;
		unsigned EID1      	: 1;
		unsigned EID2      	: 1;
		unsigned EID3      	: 1;
		unsigned EID4      	: 1;
		unsigned EID5      	: 1;
		unsigned EID6      	: 1;
		unsigned EID7      	: 1;
	};
} __RXF10EIDLbits_t;
extern volatile __RXF10EIDLbits_t __at (0xD77) RXF10EIDLbits;

extern __sfr __at (0xD78) RXF11SIDH;
typedef union {
	struct {
		unsigned SID3      	: 1;
		unsigned SID4      	: 1;
		unsigned SID5      	: 1;
		unsigned SID6      	: 1;
		unsigned SID7      	: 1;
		unsigned SID8      	: 1;
		unsigned SID9      	: 1;
		unsigned SID10     	: 1;
	};
} __RXF11SIDHbits_t;
extern volatile __RXF11SIDHbits_t __at (0xD78) RXF11SIDHbits;

extern __sfr __at (0xD79) RXF11SIDL;
typedef union {
	struct {
		unsigned EID16     	: 1;
		unsigned EID17     	: 1;
		unsigned           	: 1;
		unsigned EXIDE     	: 1;
		unsigned           	: 1;
		unsigned SID0      	: 1;
		unsigned SID1      	: 1;
		unsigned SID2      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned EXIDEN    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __RXF11SIDLbits_t;
extern volatile __RXF11SIDLbits_t __at (0xD79) RXF11SIDLbits;

extern __sfr __at (0xD7A) RXF11EIDH;
typedef union {
	struct {
		unsigned EID8      	: 1;
		unsigned EID9      	: 1;
		unsigned EID10     	: 1;
		unsigned EID11     	: 1;
		unsigned EID12     	: 1;
		unsigned EID13     	: 1;
		unsigned EID14     	: 1;
		unsigned EID15     	: 1;
	};
} __RXF11EIDHbits_t;
extern volatile __RXF11EIDHbits_t __at (0xD7A) RXF11EIDHbits;

extern __sfr __at (0xD7B) RXF11EIDL;
typedef union {
	struct {
		unsigned EID0      	: 1;
		unsigned EID1      	: 1;
		unsigned EID2      	: 1;
		unsigned EID3      	: 1;
		unsigned EID4      	: 1;
		unsigned EID5      	: 1;
		unsigned EID6      	: 1;
		unsigned EID7      	: 1;
	};
} __RXF11EIDLbits_t;
extern volatile __RXF11EIDLbits_t __at (0xD7B) RXF11EIDLbits;

extern __sfr __at (0xD80) RXF12SIDH;
typedef union {
	struct {
		unsigned SID3      	: 1;
		unsigned SID4      	: 1;
		unsigned SID5      	: 1;
		unsigned SID6      	: 1;
		unsigned SID7      	: 1;
		unsigned SID8      	: 1;
		unsigned SID9      	: 1;
		unsigned SID10     	: 1;
	};
} __RXF12SIDHbits_t;
extern volatile __RXF12SIDHbits_t __at (0xD80) RXF12SIDHbits;

extern __sfr __at (0xD81) RXF12SIDL;
typedef union {
	struct {
		unsigned EID16     	: 1;
		unsigned EID17     	: 1;
		unsigned           	: 1;
		unsigned EXIDE     	: 1;
		unsigned           	: 1;
		unsigned SID0      	: 1;
		unsigned SID1      	: 1;
		unsigned SID2      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned EXIDEN    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __RXF12SIDLbits_t;
extern volatile __RXF12SIDLbits_t __at (0xD81) RXF12SIDLbits;

extern __sfr __at (0xD82) RXF12EIDH;
typedef union {
	struct {
		unsigned EID8      	: 1;
		unsigned EID9      	: 1;
		unsigned EID10     	: 1;
		unsigned EID11     	: 1;
		unsigned EID12     	: 1;
		unsigned EID13     	: 1;
		unsigned EID14     	: 1;
		unsigned EID15     	: 1;
	};
} __RXF12EIDHbits_t;
extern volatile __RXF12EIDHbits_t __at (0xD82) RXF12EIDHbits;

extern __sfr __at (0xD83) RXF12EIDL;
typedef union {
	struct {
		unsigned EID0      	: 1;
		unsigned EID1      	: 1;
		unsigned EID2      	: 1;
		unsigned EID3      	: 1;
		unsigned EID4      	: 1;
		unsigned EID5      	: 1;
		unsigned EID6      	: 1;
		unsigned EID7      	: 1;
	};
} __RXF12EIDLbits_t;
extern volatile __RXF12EIDLbits_t __at (0xD83) RXF12EIDLbits;

extern __sfr __at (0xD84) RXF13SIDH;
typedef union {
	struct {
		unsigned SID3      	: 1;
		unsigned SID4      	: 1;
		unsigned SID5      	: 1;
		unsigned SID6      	: 1;
		unsigned SID7      	: 1;
		unsigned SID8      	: 1;
		unsigned SID9      	: 1;
		unsigned SID10     	: 1;
	};
} __RXF13SIDHbits_t;
extern volatile __RXF13SIDHbits_t __at (0xD84) RXF13SIDHbits;

extern __sfr __at (0xD85) RXF13SIDL;
typedef union {
	struct {
		unsigned EID16     	: 1;
		unsigned EID17     	: 1;
		unsigned           	: 1;
		unsigned EXIDE     	: 1;
		unsigned           	: 1;
		unsigned SID0      	: 1;
		unsigned SID1      	: 1;
		unsigned SID2      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned EXIDEN    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __RXF13SIDLbits_t;
extern volatile __RXF13SIDLbits_t __at (0xD85) RXF13SIDLbits;

extern __sfr __at (0xD86) RXF13EIDH;
typedef union {
	struct {
		unsigned EID8      	: 1;
		unsigned EID9      	: 1;
		unsigned EID10     	: 1;
		unsigned EID11     	: 1;
		unsigned EID12     	: 1;
		unsigned EID13     	: 1;
		unsigned EID14     	: 1;
		unsigned EID15     	: 1;
	};
} __RXF13EIDHbits_t;
extern volatile __RXF13EIDHbits_t __at (0xD86) RXF13EIDHbits;

extern __sfr __at (0xD87) RXF13EIDL;
typedef union {
	struct {
		unsigned EID0      	: 1;
		unsigned EID1      	: 1;
		unsigned EID2      	: 1;
		unsigned EID3      	: 1;
		unsigned EID4      	: 1;
		unsigned EID5      	: 1;
		unsigned EID6      	: 1;
		unsigned EID7      	: 1;
	};
} __RXF13EIDLbits_t;
extern volatile __RXF13EIDLbits_t __at (0xD87) RXF13EIDLbits;

extern __sfr __at (0xD88) RXF14SIDH;
typedef union {
	struct {
		unsigned SID3      	: 1;
		unsigned SID4      	: 1;
		unsigned SID5      	: 1;
		unsigned SID6      	: 1;
		unsigned SID7      	: 1;
		unsigned SID8      	: 1;
		unsigned SID9      	: 1;
		unsigned SID10     	: 1;
	};
} __RXF14SIDHbits_t;
extern volatile __RXF14SIDHbits_t __at (0xD88) RXF14SIDHbits;

extern __sfr __at (0xD89) RXF14SIDL;
typedef union {
	struct {
		unsigned EID16     	: 1;
		unsigned EID17     	: 1;
		unsigned           	: 1;
		unsigned EXIDE     	: 1;
		unsigned           	: 1;
		unsigned SID0      	: 1;
		unsigned SID1      	: 1;
		unsigned SID2      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned EXIDEN    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __RXF14SIDLbits_t;
extern volatile __RXF14SIDLbits_t __at (0xD89) RXF14SIDLbits;

extern __sfr __at (0xD8A) RXF14EIDH;
typedef union {
	struct {
		unsigned EID8      	: 1;
		unsigned EID9      	: 1;
		unsigned EID10     	: 1;
		unsigned EID11     	: 1;
		unsigned EID12     	: 1;
		unsigned EID13     	: 1;
		unsigned EID14     	: 1;
		unsigned EID15     	: 1;
	};
} __RXF14EIDHbits_t;
extern volatile __RXF14EIDHbits_t __at (0xD8A) RXF14EIDHbits;

extern __sfr __at (0xD8B) RXF14EIDL;
typedef union {
	struct {
		unsigned EID0      	: 1;
		unsigned EID1      	: 1;
		unsigned EID2      	: 1;
		unsigned EID3      	: 1;
		unsigned EID4      	: 1;
		unsigned EID5      	: 1;
		unsigned EID6      	: 1;
		unsigned EID7      	: 1;
	};
} __RXF14EIDLbits_t;
extern volatile __RXF14EIDLbits_t __at (0xD8B) RXF14EIDLbits;

extern __sfr __at (0xD90) RXF15SIDH;
typedef union {
	struct {
		unsigned SID3      	: 1;
		unsigned SID4      	: 1;
		unsigned SID5      	: 1;
		unsigned SID6      	: 1;
		unsigned SID7      	: 1;
		unsigned SID8      	: 1;
		unsigned SID9      	: 1;
		unsigned SID10     	: 1;
	};
} __RXF15SIDHbits_t;
extern volatile __RXF15SIDHbits_t __at (0xD90) RXF15SIDHbits;

extern __sfr __at (0xD91) RXF15SIDL;
typedef union {
	struct {
		unsigned EID16     	: 1;
		unsigned EID17     	: 1;
		unsigned           	: 1;
		unsigned EXIDE     	: 1;
		unsigned           	: 1;
		unsigned SID0      	: 1;
		unsigned SID1      	: 1;
		unsigned SID2      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned EXIDEN    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __RXF15SIDLbits_t;
extern volatile __RXF15SIDLbits_t __at (0xD91) RXF15SIDLbits;

extern __sfr __at (0xD92) RXF15EIDH;
typedef union {
	struct {
		unsigned EID8      	: 1;
		unsigned EID9      	: 1;
		unsigned EID10     	: 1;
		unsigned EID11     	: 1;
		unsigned EID12     	: 1;
		unsigned EID13     	: 1;
		unsigned EID14     	: 1;
		unsigned EID15     	: 1;
	};
} __RXF15EIDHbits_t;
extern volatile __RXF15EIDHbits_t __at (0xD92) RXF15EIDHbits;

extern __sfr __at (0xD93) RXF15EIDL;
typedef union {
	struct {
		unsigned EID0      	: 1;
		unsigned EID1      	: 1;
		unsigned EID2      	: 1;
		unsigned EID3      	: 1;
		unsigned EID4      	: 1;
		unsigned EID5      	: 1;
		unsigned EID6      	: 1;
		unsigned EID7      	: 1;
	};
} __RXF15EIDLbits_t;
extern volatile __RXF15EIDLbits_t __at (0xD93) RXF15EIDLbits;

extern __sfr __at (0xDD4) RXFCON0;
typedef union {
	struct {
		unsigned RXF0EN    	: 1;
		unsigned RXF1EN    	: 1;
		unsigned RXF2EN    	: 1;
		unsigned RXF3EN    	: 1;
		unsigned RXF4EN    	: 1;
		unsigned RXF5EN    	: 1;
		unsigned RXF6EN    	: 1;
		unsigned RXF7EN    	: 1;
	};
} __RXFCON0bits_t;
extern volatile __RXFCON0bits_t __at (0xDD4) RXFCON0bits;

extern __sfr __at (0xDD5) RXFCON1;
typedef union {
	struct {
		unsigned RXF8EN    	: 1;
		unsigned RXF9EN    	: 1;
		unsigned RXF10EN   	: 1;
		unsigned RXF11EN   	: 1;
		unsigned RXF12EN   	: 1;
		unsigned RXF13EN   	: 1;
		unsigned RXF14EN   	: 1;
		unsigned RXF15EN   	: 1;
	};
} __RXFCON1bits_t;
extern volatile __RXFCON1bits_t __at (0xDD5) RXFCON1bits;

extern __sfr __at (0xDD8) SDFLC;
typedef union {
	struct {
		unsigned DFLC0     	: 1;
		unsigned DFLC1     	: 1;
		unsigned DFLC2     	: 1;
		unsigned DFLC3     	: 1;
		unsigned DFLC4     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned FLC0      	: 1;
		unsigned FLC1      	: 1;
		unsigned FLC2      	: 1;
		unsigned FLC3      	: 1;
		unsigned FLC4      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __SDFLCbits_t;
extern volatile __SDFLCbits_t __at (0xDD8) SDFLCbits;

extern __sfr __at (0xDE0) RXFBCON0;
typedef union {
	struct {
		unsigned F0BP_0    	: 1;
		unsigned F0BP_1    	: 1;
		unsigned F0BP_2    	: 1;
		unsigned F0BP_3    	: 1;
		unsigned F1BP_0    	: 1;
		unsigned F1BP_1    	: 1;
		unsigned F1BP_2    	: 1;
		unsigned F1BP_3    	: 1;
	};
} __RXFBCON0bits_t;
extern volatile __RXFBCON0bits_t __at (0xDE0) RXFBCON0bits;

extern __sfr __at (0xDE1) RXFBCON1;
typedef union {
	struct {
		unsigned F2BP_0    	: 1;
		unsigned F2BP_1    	: 1;
		unsigned F2BP_2    	: 1;
		unsigned F2BP_3    	: 1;
		unsigned F3BP_0    	: 1;
		unsigned F3BP_1    	: 1;
		unsigned F3BP_2    	: 1;
		unsigned F3BP_3    	: 1;
	};
} __RXFBCON1bits_t;
extern volatile __RXFBCON1bits_t __at (0xDE1) RXFBCON1bits;

extern __sfr __at (0xDE2) RXFBCON2;
typedef union {
	struct {
		unsigned F4BP_0    	: 1;
		unsigned F4BP_1    	: 1;
		unsigned F4BP_2    	: 1;
		unsigned F4BP_3    	: 1;
		unsigned F5BP_0    	: 1;
		unsigned F5BP_1    	: 1;
		unsigned F5BP_2    	: 1;
		unsigned F5BP_3    	: 1;
	};
} __RXFBCON2bits_t;
extern volatile __RXFBCON2bits_t __at (0xDE2) RXFBCON2bits;

extern __sfr __at (0xDE3) RXFBCON3;
typedef union {
	struct {
		unsigned F6BP_0    	: 1;
		unsigned F6BP_1    	: 1;
		unsigned F6BP_2    	: 1;
		unsigned F6BP_3    	: 1;
		unsigned F7BP_0    	: 1;
		unsigned F7BP_1    	: 1;
		unsigned F7BP_2    	: 1;
		unsigned F7BP_3    	: 1;
	};
} __RXFBCON3bits_t;
extern volatile __RXFBCON3bits_t __at (0xDE3) RXFBCON3bits;

extern __sfr __at (0xDE4) RXFBCON4;
typedef union {
	struct {
		unsigned F8BP_0    	: 1;
		unsigned F8BP_1    	: 1;
		unsigned F8BP_2    	: 1;
		unsigned F8BP_3    	: 1;
		unsigned F9BP_0    	: 1;
		unsigned F9BP_1    	: 1;
		unsigned F9BP_2    	: 1;
		unsigned F9BP_3    	: 1;
	};
} __RXFBCON4bits_t;
extern volatile __RXFBCON4bits_t __at (0xDE4) RXFBCON4bits;

extern __sfr __at (0xDE5) RXFBCON5;
typedef union {
	struct {
		unsigned F10BP_0   	: 1;
		unsigned F10BP_1   	: 1;
		unsigned F10BP_2   	: 1;
		unsigned F10BP_3   	: 1;
		unsigned F11BP_0   	: 1;
		unsigned F11BP_1   	: 1;
		unsigned F11BP_2   	: 1;
		unsigned F11BP_3   	: 1;
	};
} __RXFBCON5bits_t;
extern volatile __RXFBCON5bits_t __at (0xDE5) RXFBCON5bits;

extern __sfr __at (0xDE6) RXFBCON6;
typedef union {
	struct {
		unsigned F12BP_0   	: 1;
		unsigned F12BP_1   	: 1;
		unsigned F12BP_2   	: 1;
		unsigned F12BP_3   	: 1;
		unsigned F13BP_0   	: 1;
		unsigned F13BP_1   	: 1;
		unsigned F13BP_2   	: 1;
		unsigned F13BP_3   	: 1;
	};
} __RXFBCON6bits_t;
extern volatile __RXFBCON6bits_t __at (0xDE6) RXFBCON6bits;

extern __sfr __at (0xDE7) RXFBCON7;
typedef union {
	struct {
		unsigned F14BP_0   	: 1;
		unsigned F14BP_1   	: 1;
		unsigned F14BP_2   	: 1;
		unsigned F14BP_3   	: 1;
		unsigned F15BP_0   	: 1;
		unsigned F15BP_1   	: 1;
		unsigned F15BP_2   	: 1;
		unsigned F15BP_3   	: 1;
	};
} __RXFBCON7bits_t;
extern volatile __RXFBCON7bits_t __at (0xDE7) RXFBCON7bits;

extern __sfr __at (0xDF0) MSEL0;
typedef union {
	struct {
		unsigned FIL0_0    	: 1;
		unsigned FIL0_1    	: 1;
		unsigned FIL1_0    	: 1;
		unsigned FIL1_1    	: 1;
		unsigned FIL2_0    	: 1;
		unsigned FIL2_1    	: 1;
		unsigned FIL3_0    	: 1;
		unsigned FIL3_1    	: 1;
	};
} __MSEL0bits_t;
extern volatile __MSEL0bits_t __at (0xDF0) MSEL0bits;

extern __sfr __at (0xDF1) MSEL1;
typedef union {
	struct {
		unsigned FIL4_0    	: 1;
		unsigned FIL4_1    	: 1;
		unsigned FIL5_0    	: 1;
		unsigned FIL5_1    	: 1;
		unsigned FIL6_0    	: 1;
		unsigned FIL6_1    	: 1;
		unsigned FIL7_0    	: 1;
		unsigned FIL7_1    	: 1;
	};
} __MSEL1bits_t;
extern volatile __MSEL1bits_t __at (0xDF1) MSEL1bits;

extern __sfr __at (0xDF2) MSEL2;
typedef union {
	struct {
		unsigned FIL8_0    	: 1;
		unsigned FIL8_1    	: 1;
		unsigned FIL9_0    	: 1;
		unsigned FIL9_1    	: 1;
		unsigned FIL10_0   	: 1;
		unsigned FIL10_1   	: 1;
		unsigned FIL11_0   	: 1;
		unsigned FIL11_1   	: 1;
	};
} __MSEL2bits_t;
extern volatile __MSEL2bits_t __at (0xDF2) MSEL2bits;

extern __sfr __at (0xDF3) MSEL3;
typedef union {
	struct {
		unsigned FIL12_0   	: 1;
		unsigned FIL12_1   	: 1;
		unsigned FIL13_0   	: 1;
		unsigned FIL13_1   	: 1;
		unsigned FIL14_0   	: 1;
		unsigned FIL14_1   	: 1;
		unsigned FIL15_0   	: 1;
		unsigned FIL15_1   	: 1;
	};
} __MSEL3bits_t;
extern volatile __MSEL3bits_t __at (0xDF3) MSEL3bits;

extern __sfr __at (0xDF8) BSEL0;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned B0TXEN    	: 1;
		unsigned B1TXEN    	: 1;
		unsigned B2TXEN    	: 1;
		unsigned B3TXEN    	: 1;
		unsigned B4TXEN    	: 1;
		unsigned B5TXEN    	: 1;
	};
} __BSEL0bits_t;
extern volatile __BSEL0bits_t __at (0xDF8) BSEL0bits;

extern __sfr __at (0xDFA) BIE0;
typedef union {
	struct {
		unsigned RXB0IE    	: 1;
		unsigned RXB1IE    	: 1;
		unsigned B0IE      	: 1;
		unsigned B1IE      	: 1;
		unsigned B2IE      	: 1;
		unsigned B3IE      	: 1;
		unsigned B4IE      	: 1;
		unsigned B5IE      	: 1;
	};
} __BIE0bits_t;
extern volatile __BIE0bits_t __at (0xDFA) BIE0bits;

extern __sfr __at (0xDFC) TXBIE;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned TXB0IE    	: 1;
		unsigned TXB1IE    	: 1;
		unsigned TXB2IE    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __TXBIEbits_t;
extern volatile __TXBIEbits_t __at (0xDFC) TXBIEbits;

extern __sfr __at (0xE20) B0CON;
typedef union {
	struct {
		unsigned FILHIT0   	: 1;
		unsigned FILHIT1   	: 1;
		unsigned FILHIT2   	: 1;
		unsigned FILHIT3   	: 1;
		unsigned FILHIT4   	: 1;
		unsigned RTRRO     	: 1;
		unsigned RXM1      	: 1;
		unsigned RXFUL     	: 1;
	};
	struct {
		unsigned TXPRI0    	: 1;
		unsigned TXPRI1    	: 1;
		unsigned RTREN     	: 1;
		unsigned TXREQ     	: 1;
		unsigned TXERR     	: 1;
		unsigned TXLARB    	: 1;
		unsigned TXABT     	: 1;
		unsigned TXBIF     	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned RXRTRRO_B0CON	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __B0CONbits_t;
extern volatile __B0CONbits_t __at (0xE20) B0CONbits;

extern __sfr __at (0xE21) B0SIDH;
typedef union {
	struct {
		unsigned SID3      	: 1;
		unsigned SID4      	: 1;
		unsigned SID5      	: 1;
		unsigned SID6      	: 1;
		unsigned SID7      	: 1;
		unsigned SID8      	: 1;
		unsigned SID9      	: 1;
		unsigned SID10     	: 1;
	};
} __B0SIDHbits_t;
extern volatile __B0SIDHbits_t __at (0xE21) B0SIDHbits;

extern __sfr __at (0xE22) B0SIDL;
typedef union {
	struct {
		unsigned EID16     	: 1;
		unsigned EID17     	: 1;
		unsigned           	: 1;
		unsigned EXID      	: 1;
		unsigned SRR       	: 1;
		unsigned SID0      	: 1;
		unsigned SID1      	: 1;
		unsigned SID2      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned EXIDE     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __B0SIDLbits_t;
extern volatile __B0SIDLbits_t __at (0xE22) B0SIDLbits;

extern __sfr __at (0xE23) B0EIDH;
typedef union {
	struct {
		unsigned EID8      	: 1;
		unsigned EID9      	: 1;
		unsigned EID10     	: 1;
		unsigned EID11     	: 1;
		unsigned EID12     	: 1;
		unsigned EID13     	: 1;
		unsigned EID14     	: 1;
		unsigned EID15     	: 1;
	};
} __B0EIDHbits_t;
extern volatile __B0EIDHbits_t __at (0xE23) B0EIDHbits;

extern __sfr __at (0xE24) B0EIDL;
typedef union {
	struct {
		unsigned EID0      	: 1;
		unsigned EID1      	: 1;
		unsigned EID2      	: 1;
		unsigned EID3      	: 1;
		unsigned EID4      	: 1;
		unsigned EID5      	: 1;
		unsigned EID6      	: 1;
		unsigned EID7      	: 1;
	};
} __B0EIDLbits_t;
extern volatile __B0EIDLbits_t __at (0xE24) B0EIDLbits;

extern __sfr __at (0xE25) B0DLC;
typedef union {
	struct {
		unsigned DLC0      	: 1;
		unsigned DLC1      	: 1;
		unsigned DLC2      	: 1;
		unsigned DLC3      	: 1;
		unsigned RESRB0    	: 1;
		unsigned RESRB1    	: 1;
		unsigned RXRTR     	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned RB0_B0DLC 	: 1;
		unsigned RB1_B0DLC 	: 1;
		unsigned TXRTR     	: 1;
		unsigned           	: 1;
	};
} __B0DLCbits_t;
extern volatile __B0DLCbits_t __at (0xE25) B0DLCbits;

extern __sfr __at (0xE26) B0D0;
typedef union {
	struct {
		unsigned B0D00     	: 1;
		unsigned B0D01     	: 1;
		unsigned B0D02     	: 1;
		unsigned B0D03     	: 1;
		unsigned B0D04     	: 1;
		unsigned B0D05     	: 1;
		unsigned B0D06     	: 1;
		unsigned B0D07     	: 1;
	};
} __B0D0bits_t;
extern volatile __B0D0bits_t __at (0xE26) B0D0bits;

extern __sfr __at (0xE27) B0D1;
typedef union {
	struct {
		unsigned B0D10     	: 1;
		unsigned B0D11     	: 1;
		unsigned B0D12     	: 1;
		unsigned B0D13     	: 1;
		unsigned B0D14     	: 1;
		unsigned B0D15     	: 1;
		unsigned B0D16     	: 1;
		unsigned B0D17     	: 1;
	};
} __B0D1bits_t;
extern volatile __B0D1bits_t __at (0xE27) B0D1bits;

extern __sfr __at (0xE28) B0D2;
typedef union {
	struct {
		unsigned B0D20     	: 1;
		unsigned B0D21     	: 1;
		unsigned B0D22     	: 1;
		unsigned B0D23     	: 1;
		unsigned B0D24     	: 1;
		unsigned B0D25     	: 1;
		unsigned B0D26     	: 1;
		unsigned B0D27     	: 1;
	};
} __B0D2bits_t;
extern volatile __B0D2bits_t __at (0xE28) B0D2bits;

extern __sfr __at (0xE29) B0D3;
typedef union {
	struct {
		unsigned B0D30     	: 1;
		unsigned B0D31     	: 1;
		unsigned B0D32     	: 1;
		unsigned B0D33     	: 1;
		unsigned B0D34     	: 1;
		unsigned B0D35     	: 1;
		unsigned B0D36     	: 1;
		unsigned B0D37     	: 1;
	};
} __B0D3bits_t;
extern volatile __B0D3bits_t __at (0xE29) B0D3bits;

extern __sfr __at (0xE2A) B0D4;
typedef union {
	struct {
		unsigned B0D40     	: 1;
		unsigned B0D41     	: 1;
		unsigned B0D42     	: 1;
		unsigned B0D43     	: 1;
		unsigned B0D44     	: 1;
		unsigned B0D45     	: 1;
		unsigned B0D46     	: 1;
		unsigned B0D47     	: 1;
	};
} __B0D4bits_t;
extern volatile __B0D4bits_t __at (0xE2A) B0D4bits;

extern __sfr __at (0xE2B) B0D5;
typedef union {
	struct {
		unsigned B0D50     	: 1;
		unsigned B0D51     	: 1;
		unsigned B0D52     	: 1;
		unsigned B0D53     	: 1;
		unsigned B0D54     	: 1;
		unsigned B0D55     	: 1;
		unsigned B0D56     	: 1;
		unsigned B0D57     	: 1;
	};
} __B0D5bits_t;
extern volatile __B0D5bits_t __at (0xE2B) B0D5bits;

extern __sfr __at (0xE2C) B0D6;
typedef union {
	struct {
		unsigned B0D60     	: 1;
		unsigned B0D61     	: 1;
		unsigned B0D62     	: 1;
		unsigned B0D63     	: 1;
		unsigned B0D64     	: 1;
		unsigned B0D65     	: 1;
		unsigned B0D66     	: 1;
		unsigned B0D67     	: 1;
	};
} __B0D6bits_t;
extern volatile __B0D6bits_t __at (0xE2C) B0D6bits;

extern __sfr __at (0xE2D) B0D7;
typedef union {
	struct {
		unsigned B0D70     	: 1;
		unsigned B0D71     	: 1;
		unsigned B0D72     	: 1;
		unsigned B0D73     	: 1;
		unsigned B0D74     	: 1;
		unsigned B0D75     	: 1;
		unsigned B0D76     	: 1;
		unsigned B0D77     	: 1;
	};
} __B0D7bits_t;
extern volatile __B0D7bits_t __at (0xE2D) B0D7bits;

extern __sfr __at (0xE2E) CANSTAT_RO9;
typedef union {
	struct {
		unsigned ICODE0    	: 1;
		unsigned ICODE1    	: 1;
		unsigned ICODE2    	: 1;
		unsigned ICODE3    	: 1;
		unsigned ICODE4    	: 1;
		unsigned OPMODE    	: 1;
		unsigned REQOP1    	: 1;
		unsigned REQOP2    	: 1;
	};
} __CANSTAT_RO9bits_t;
extern volatile __CANSTAT_RO9bits_t __at (0xE2E) CANSTAT_RO9bits;

extern __sfr __at (0xE2F) CANCON_RO9;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned WIN0      	: 1;
		unsigned WIN1      	: 1;
		unsigned WIN2      	: 1;
		unsigned ABAT      	: 1;
		unsigned REQOP0    	: 1;
		unsigned REQOP1    	: 1;
		unsigned REQOP2    	: 1;
	};
} __CANCON_RO9bits_t;
extern volatile __CANCON_RO9bits_t __at (0xE2F) CANCON_RO9bits;

extern __sfr __at (0xE30) B1CON;
typedef union {
	struct {
		unsigned FILHIT0   	: 1;
		unsigned FILHIT1   	: 1;
		unsigned FILHIT2   	: 1;
		unsigned FILHIT3   	: 1;
		unsigned FILHIT4   	: 1;
		unsigned RTRRO     	: 1;
		unsigned RXM1      	: 1;
		unsigned RXFUL     	: 1;
	};
	struct {
		unsigned TXPRI0    	: 1;
		unsigned TXPRI1    	: 1;
		unsigned RTREN     	: 1;
		unsigned TXREQ     	: 1;
		unsigned TXERR     	: 1;
		unsigned TXLARB    	: 1;
		unsigned TXABT     	: 1;
		unsigned TXBIF     	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned RXRTRRO_B1CON	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __B1CONbits_t;
extern volatile __B1CONbits_t __at (0xE30) B1CONbits;

extern __sfr __at (0xE31) B1SIDH;
typedef union {
	struct {
		unsigned SID3      	: 1;
		unsigned SID4      	: 1;
		unsigned SID5      	: 1;
		unsigned SID6      	: 1;
		unsigned SID7      	: 1;
		unsigned SID8      	: 1;
		unsigned SID9      	: 1;
		unsigned SID10     	: 1;
	};
} __B1SIDHbits_t;
extern volatile __B1SIDHbits_t __at (0xE31) B1SIDHbits;

extern __sfr __at (0xE32) B1SIDL;
typedef union {
	struct {
		unsigned EID16     	: 1;
		unsigned EID17     	: 1;
		unsigned           	: 1;
		unsigned EXID      	: 1;
		unsigned SRR       	: 1;
		unsigned SID0      	: 1;
		unsigned SID1      	: 1;
		unsigned SID2      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned EXIDE     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __B1SIDLbits_t;
extern volatile __B1SIDLbits_t __at (0xE32) B1SIDLbits;

extern __sfr __at (0xE33) B1EIDH;
typedef union {
	struct {
		unsigned EID8      	: 1;
		unsigned EID9      	: 1;
		unsigned EID10     	: 1;
		unsigned EID11     	: 1;
		unsigned EID12     	: 1;
		unsigned EID13     	: 1;
		unsigned EID14     	: 1;
		unsigned EID15     	: 1;
	};
} __B1EIDHbits_t;
extern volatile __B1EIDHbits_t __at (0xE33) B1EIDHbits;

extern __sfr __at (0xE34) B1EIDL;
typedef union {
	struct {
		unsigned EID0      	: 1;
		unsigned EID1      	: 1;
		unsigned EID2      	: 1;
		unsigned EID3      	: 1;
		unsigned EID4      	: 1;
		unsigned EID5      	: 1;
		unsigned EID6      	: 1;
		unsigned EID7      	: 1;
	};
} __B1EIDLbits_t;
extern volatile __B1EIDLbits_t __at (0xE34) B1EIDLbits;

extern __sfr __at (0xE35) B1DLC;
typedef union {
	struct {
		unsigned DLC0      	: 1;
		unsigned DLC1      	: 1;
		unsigned DLC2      	: 1;
		unsigned DLC3      	: 1;
		unsigned RESRB0    	: 1;
		unsigned RESRB1    	: 1;
		unsigned RXRTR     	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned RB0_B1DLC 	: 1;
		unsigned RB1_B1DLC 	: 1;
		unsigned TXRTR     	: 1;
		unsigned           	: 1;
	};
} __B1DLCbits_t;
extern volatile __B1DLCbits_t __at (0xE35) B1DLCbits;

extern __sfr __at (0xE36) B1D0;
typedef union {
	struct {
		unsigned B1D00     	: 1;
		unsigned B1D01     	: 1;
		unsigned B1D02     	: 1;
		unsigned B1D03     	: 1;
		unsigned B1D04     	: 1;
		unsigned B1D05     	: 1;
		unsigned B1D06     	: 1;
		unsigned B1D07     	: 1;
	};
} __B1D0bits_t;
extern volatile __B1D0bits_t __at (0xE36) B1D0bits;

extern __sfr __at (0xE37) B1D1;
typedef union {
	struct {
		unsigned B1D10     	: 1;
		unsigned B1D11     	: 1;
		unsigned B1D12     	: 1;
		unsigned B1D13     	: 1;
		unsigned B1D14     	: 1;
		unsigned B1D15     	: 1;
		unsigned B1D16     	: 1;
		unsigned B1D17     	: 1;
	};
} __B1D1bits_t;
extern volatile __B1D1bits_t __at (0xE37) B1D1bits;

extern __sfr __at (0xE38) B1D2;
typedef union {
	struct {
		unsigned B1D20     	: 1;
		unsigned B1D21     	: 1;
		unsigned B1D22     	: 1;
		unsigned B1D23     	: 1;
		unsigned B1D24     	: 1;
		unsigned B1D25     	: 1;
		unsigned B1D26     	: 1;
		unsigned B1D27     	: 1;
	};
} __B1D2bits_t;
extern volatile __B1D2bits_t __at (0xE38) B1D2bits;

extern __sfr __at (0xE39) B1D3;
typedef union {
	struct {
		unsigned B1D30     	: 1;
		unsigned B1D31     	: 1;
		unsigned B1D32     	: 1;
		unsigned B1D33     	: 1;
		unsigned B1D34     	: 1;
		unsigned B1D35     	: 1;
		unsigned B1D36     	: 1;
		unsigned B1D37     	: 1;
	};
} __B1D3bits_t;
extern volatile __B1D3bits_t __at (0xE39) B1D3bits;

extern __sfr __at (0xE3A) B1D4;
typedef union {
	struct {
		unsigned B1D40     	: 1;
		unsigned B1D41     	: 1;
		unsigned B1D42     	: 1;
		unsigned B1D43     	: 1;
		unsigned B1D44     	: 1;
		unsigned B1D45     	: 1;
		unsigned B1D46     	: 1;
		unsigned B1D47     	: 1;
	};
} __B1D4bits_t;
extern volatile __B1D4bits_t __at (0xE3A) B1D4bits;

extern __sfr __at (0xE3B) B1D5;
typedef union {
	struct {
		unsigned B1D50     	: 1;
		unsigned B1D51     	: 1;
		unsigned B1D52     	: 1;
		unsigned B1D53     	: 1;
		unsigned B1D54     	: 1;
		unsigned B1D55     	: 1;
		unsigned B1D56     	: 1;
		unsigned B1D57     	: 1;
	};
} __B1D5bits_t;
extern volatile __B1D5bits_t __at (0xE3B) B1D5bits;

extern __sfr __at (0xE3C) B1D6;
typedef union {
	struct {
		unsigned B1D60     	: 1;
		unsigned B1D61     	: 1;
		unsigned B1D62     	: 1;
		unsigned B1D63     	: 1;
		unsigned B1D64     	: 1;
		unsigned B1D65     	: 1;
		unsigned B1D66     	: 1;
		unsigned B1D67     	: 1;
	};
} __B1D6bits_t;
extern volatile __B1D6bits_t __at (0xE3C) B1D6bits;

extern __sfr __at (0xE3D) B1D7;
typedef union {
	struct {
		unsigned B1D70     	: 1;
		unsigned B1D71     	: 1;
		unsigned B1D72     	: 1;
		unsigned B1D73     	: 1;
		unsigned B1D74     	: 1;
		unsigned B1D75     	: 1;
		unsigned B1D76     	: 1;
		unsigned B1D77     	: 1;
	};
} __B1D7bits_t;
extern volatile __B1D7bits_t __at (0xE3D) B1D7bits;

extern __sfr __at (0xE3E) CANSTAT_RO8;
typedef union {
	struct {
		unsigned ICODE0    	: 1;
		unsigned ICODE1    	: 1;
		unsigned ICODE2    	: 1;
		unsigned ICODE3    	: 1;
		unsigned ICODE4    	: 1;
		unsigned OPMODE    	: 1;
		unsigned REQOP1    	: 1;
		unsigned REQOP2    	: 1;
	};
} __CANSTAT_RO8bits_t;
extern volatile __CANSTAT_RO8bits_t __at (0xE3E) CANSTAT_RO8bits;

extern __sfr __at (0xE3F) CANCON_RO8;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned WIN0      	: 1;
		unsigned WIN1      	: 1;
		unsigned WIN2      	: 1;
		unsigned ABAT      	: 1;
		unsigned REQOP0    	: 1;
		unsigned REQOP1    	: 1;
		unsigned REQOP2    	: 1;
	};
} __CANCON_RO8bits_t;
extern volatile __CANCON_RO8bits_t __at (0xE3F) CANCON_RO8bits;

extern __sfr __at (0xE40) B2CON;
typedef union {
	struct {
		unsigned FILHIT0   	: 1;
		unsigned FILHIT1   	: 1;
		unsigned FILHIT2   	: 1;
		unsigned FILHIT3   	: 1;
		unsigned FILHIT4   	: 1;
		unsigned RTRRO     	: 1;
		unsigned RXM1      	: 1;
		unsigned RXFUL     	: 1;
	};
	struct {
		unsigned TXPRI0    	: 1;
		unsigned TXPRI1    	: 1;
		unsigned RTREN     	: 1;
		unsigned TXREQ     	: 1;
		unsigned TXERR     	: 1;
		unsigned TXLARB    	: 1;
		unsigned TXABT     	: 1;
		unsigned TXBIF     	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned RXRTRRO_B2CON	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __B2CONbits_t;
extern volatile __B2CONbits_t __at (0xE40) B2CONbits;

extern __sfr __at (0xE41) B2SIDH;
typedef union {
	struct {
		unsigned SID3      	: 1;
		unsigned SID4      	: 1;
		unsigned SID5      	: 1;
		unsigned SID6      	: 1;
		unsigned SID7      	: 1;
		unsigned SID8      	: 1;
		unsigned SID9      	: 1;
		unsigned SID10     	: 1;
	};
} __B2SIDHbits_t;
extern volatile __B2SIDHbits_t __at (0xE41) B2SIDHbits;

extern __sfr __at (0xE42) B2SIDL;
typedef union {
	struct {
		unsigned EID16     	: 1;
		unsigned EID17     	: 1;
		unsigned           	: 1;
		unsigned EXID      	: 1;
		unsigned SRR       	: 1;
		unsigned SID0      	: 1;
		unsigned SID1      	: 1;
		unsigned SID2      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned EXIDE     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __B2SIDLbits_t;
extern volatile __B2SIDLbits_t __at (0xE42) B2SIDLbits;

extern __sfr __at (0xE43) B2EIDH;
typedef union {
	struct {
		unsigned EID8      	: 1;
		unsigned EID9      	: 1;
		unsigned EID10     	: 1;
		unsigned EID11     	: 1;
		unsigned EID12     	: 1;
		unsigned EID13     	: 1;
		unsigned EID14     	: 1;
		unsigned EID15     	: 1;
	};
} __B2EIDHbits_t;
extern volatile __B2EIDHbits_t __at (0xE43) B2EIDHbits;

extern __sfr __at (0xE44) B2EIDL;
typedef union {
	struct {
		unsigned EID0      	: 1;
		unsigned EID1      	: 1;
		unsigned EID2      	: 1;
		unsigned EID3      	: 1;
		unsigned EID4      	: 1;
		unsigned EID5      	: 1;
		unsigned EID6      	: 1;
		unsigned EID7      	: 1;
	};
} __B2EIDLbits_t;
extern volatile __B2EIDLbits_t __at (0xE44) B2EIDLbits;

extern __sfr __at (0xE45) B2DLC;
typedef union {
	struct {
		unsigned DLC0      	: 1;
		unsigned DLC1      	: 1;
		unsigned DLC2      	: 1;
		unsigned DLC3      	: 1;
		unsigned RESRB0    	: 1;
		unsigned RESRB1    	: 1;
		unsigned RXRTR     	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned RB0_B2DLC 	: 1;
		unsigned RB1_B2DLC 	: 1;
		unsigned TXRTR     	: 1;
		unsigned           	: 1;
	};
} __B2DLCbits_t;
extern volatile __B2DLCbits_t __at (0xE45) B2DLCbits;

extern __sfr __at (0xE46) B2D0;
typedef union {
	struct {
		unsigned B2D00     	: 1;
		unsigned B2D01     	: 1;
		unsigned B2D02     	: 1;
		unsigned B2D03     	: 1;
		unsigned B2D04     	: 1;
		unsigned B2D05     	: 1;
		unsigned B2D06     	: 1;
		unsigned B2D07     	: 1;
	};
} __B2D0bits_t;
extern volatile __B2D0bits_t __at (0xE46) B2D0bits;

extern __sfr __at (0xE47) B2D1;
typedef union {
	struct {
		unsigned B2D10     	: 1;
		unsigned B2D11     	: 1;
		unsigned B2D12     	: 1;
		unsigned B2D13     	: 1;
		unsigned B2D14     	: 1;
		unsigned B2D15     	: 1;
		unsigned B2D16     	: 1;
		unsigned B2D17     	: 1;
	};
} __B2D1bits_t;
extern volatile __B2D1bits_t __at (0xE47) B2D1bits;

extern __sfr __at (0xE48) B2D2;
typedef union {
	struct {
		unsigned B2D20     	: 1;
		unsigned B2D21     	: 1;
		unsigned B2D22     	: 1;
		unsigned B2D23     	: 1;
		unsigned B2D24     	: 1;
		unsigned B2D25     	: 1;
		unsigned B2D26     	: 1;
		unsigned B2D27     	: 1;
	};
} __B2D2bits_t;
extern volatile __B2D2bits_t __at (0xE48) B2D2bits;

extern __sfr __at (0xE49) B2D3;
typedef union {
	struct {
		unsigned B2D30     	: 1;
		unsigned B2D31     	: 1;
		unsigned B2D32     	: 1;
		unsigned B2D33     	: 1;
		unsigned B2D34     	: 1;
		unsigned B2D35     	: 1;
		unsigned B2D36     	: 1;
		unsigned B2D37     	: 1;
	};
} __B2D3bits_t;
extern volatile __B2D3bits_t __at (0xE49) B2D3bits;

extern __sfr __at (0xE4A) B2D4;
typedef union {
	struct {
		unsigned B2D40     	: 1;
		unsigned B2D41     	: 1;
		unsigned B2D42     	: 1;
		unsigned B2D43     	: 1;
		unsigned B2D44     	: 1;
		unsigned B2D45     	: 1;
		unsigned B2D46     	: 1;
		unsigned B2D47     	: 1;
	};
} __B2D4bits_t;
extern volatile __B2D4bits_t __at (0xE4A) B2D4bits;

extern __sfr __at (0xE4B) B2D5;
typedef union {
	struct {
		unsigned B2D50     	: 1;
		unsigned B2D51     	: 1;
		unsigned B2D52     	: 1;
		unsigned B2D53     	: 1;
		unsigned B2D54     	: 1;
		unsigned B2D55     	: 1;
		unsigned B2D56     	: 1;
		unsigned B2D57     	: 1;
	};
} __B2D5bits_t;
extern volatile __B2D5bits_t __at (0xE4B) B2D5bits;

extern __sfr __at (0xE4C) B2D6;
typedef union {
	struct {
		unsigned B2D60     	: 1;
		unsigned B2D61     	: 1;
		unsigned B2D62     	: 1;
		unsigned B2D63     	: 1;
		unsigned B2D64     	: 1;
		unsigned B2D65     	: 1;
		unsigned B2D66     	: 1;
		unsigned B2D67     	: 1;
	};
} __B2D6bits_t;
extern volatile __B2D6bits_t __at (0xE4C) B2D6bits;

extern __sfr __at (0xE4D) B2D7;
typedef union {
	struct {
		unsigned B2D70     	: 1;
		unsigned B2D71     	: 1;
		unsigned B2D72     	: 1;
		unsigned B2D73     	: 1;
		unsigned B2D74     	: 1;
		unsigned B2D75     	: 1;
		unsigned B2D76     	: 1;
		unsigned B2D77     	: 1;
	};
} __B2D7bits_t;
extern volatile __B2D7bits_t __at (0xE4D) B2D7bits;

extern __sfr __at (0xE4E) CANSTAT_RO7;
typedef union {
	struct {
		unsigned ICODE0    	: 1;
		unsigned ICODE1    	: 1;
		unsigned ICODE2    	: 1;
		unsigned ICODE3    	: 1;
		unsigned ICODE4    	: 1;
		unsigned OPMODE    	: 1;
		unsigned REQOP1    	: 1;
		unsigned REQOP2    	: 1;
	};
} __CANSTAT_RO7bits_t;
extern volatile __CANSTAT_RO7bits_t __at (0xE4E) CANSTAT_RO7bits;

extern __sfr __at (0xE4F) CANCON_RO7;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned WIN0      	: 1;
		unsigned WIN1      	: 1;
		unsigned WIN2      	: 1;
		unsigned ABAT      	: 1;
		unsigned REQOP0    	: 1;
		unsigned REQOP1    	: 1;
		unsigned REQOP2    	: 1;
	};
} __CANCON_RO7bits_t;
extern volatile __CANCON_RO7bits_t __at (0xE4F) CANCON_RO7bits;

extern __sfr __at (0xE50) B3CON;
typedef union {
	struct {
		unsigned FILHIT0   	: 1;
		unsigned FILHIT1   	: 1;
		unsigned FILHIT2   	: 1;
		unsigned FILHIT3   	: 1;
		unsigned FILHIT4   	: 1;
		unsigned RTRRO     	: 1;
		unsigned RXM1      	: 1;
		unsigned RXFUL     	: 1;
	};
	struct {
		unsigned TXPRI0    	: 1;
		unsigned TXPRI1    	: 1;
		unsigned RTREN     	: 1;
		unsigned TXREQ     	: 1;
		unsigned TXERR     	: 1;
		unsigned TXLARB    	: 1;
		unsigned TXABT     	: 1;
		unsigned TXBIF     	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned RXRTRRO_B3CON	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __B3CONbits_t;
extern volatile __B3CONbits_t __at (0xE50) B3CONbits;

extern __sfr __at (0xE51) B3SIDH;
typedef union {
	struct {
		unsigned SID3      	: 1;
		unsigned SID4      	: 1;
		unsigned SID5      	: 1;
		unsigned SID6      	: 1;
		unsigned SID7      	: 1;
		unsigned SID8      	: 1;
		unsigned SID9      	: 1;
		unsigned SID10     	: 1;
	};
} __B3SIDHbits_t;
extern volatile __B3SIDHbits_t __at (0xE51) B3SIDHbits;

extern __sfr __at (0xE52) B3SIDL;
typedef union {
	struct {
		unsigned EID16     	: 1;
		unsigned EID17     	: 1;
		unsigned           	: 1;
		unsigned EXID      	: 1;
		unsigned SRR       	: 1;
		unsigned SID0      	: 1;
		unsigned SID1      	: 1;
		unsigned SID2      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned EXIDE     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __B3SIDLbits_t;
extern volatile __B3SIDLbits_t __at (0xE52) B3SIDLbits;

extern __sfr __at (0xE53) B3EIDH;
typedef union {
	struct {
		unsigned EID8      	: 1;
		unsigned EID9      	: 1;
		unsigned EID10     	: 1;
		unsigned EID11     	: 1;
		unsigned EID12     	: 1;
		unsigned EID13     	: 1;
		unsigned EID14     	: 1;
		unsigned EID15     	: 1;
	};
} __B3EIDHbits_t;
extern volatile __B3EIDHbits_t __at (0xE53) B3EIDHbits;

extern __sfr __at (0xE54) B3EIDL;
typedef union {
	struct {
		unsigned EID0      	: 1;
		unsigned EID1      	: 1;
		unsigned EID2      	: 1;
		unsigned EID3      	: 1;
		unsigned EID4      	: 1;
		unsigned EID5      	: 1;
		unsigned EID6      	: 1;
		unsigned EID7      	: 1;
	};
} __B3EIDLbits_t;
extern volatile __B3EIDLbits_t __at (0xE54) B3EIDLbits;

extern __sfr __at (0xE55) B3DLC;
typedef union {
	struct {
		unsigned DLC0      	: 1;
		unsigned DLC1      	: 1;
		unsigned DLC2      	: 1;
		unsigned DLC3      	: 1;
		unsigned RESRB0    	: 1;
		unsigned RESRB1    	: 1;
		unsigned RXRTR     	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned RB0_B3DLC 	: 1;
		unsigned RB1_B3DLC 	: 1;
		unsigned TXRTR     	: 1;
		unsigned           	: 1;
	};
} __B3DLCbits_t;
extern volatile __B3DLCbits_t __at (0xE55) B3DLCbits;

extern __sfr __at (0xE56) B3D0;
typedef union {
	struct {
		unsigned B3D00     	: 1;
		unsigned B3D01     	: 1;
		unsigned B3D02     	: 1;
		unsigned B3D03     	: 1;
		unsigned B3D04     	: 1;
		unsigned B3D05     	: 1;
		unsigned B3D06     	: 1;
		unsigned B3D07     	: 1;
	};
} __B3D0bits_t;
extern volatile __B3D0bits_t __at (0xE56) B3D0bits;

extern __sfr __at (0xE57) B3D1;
typedef union {
	struct {
		unsigned B3D10     	: 1;
		unsigned B3D11     	: 1;
		unsigned B3D12     	: 1;
		unsigned B3D13     	: 1;
		unsigned B3D14     	: 1;
		unsigned B3D15     	: 1;
		unsigned B3D16     	: 1;
		unsigned B3D17     	: 1;
	};
} __B3D1bits_t;
extern volatile __B3D1bits_t __at (0xE57) B3D1bits;

extern __sfr __at (0xE58) B3D2;
typedef union {
	struct {
		unsigned B3D20     	: 1;
		unsigned B3D21     	: 1;
		unsigned B3D22     	: 1;
		unsigned B3D23     	: 1;
		unsigned B3D24     	: 1;
		unsigned B3D25     	: 1;
		unsigned B3D26     	: 1;
		unsigned B3D27     	: 1;
	};
} __B3D2bits_t;
extern volatile __B3D2bits_t __at (0xE58) B3D2bits;

extern __sfr __at (0xE59) B3D3;
typedef union {
	struct {
		unsigned B3D30     	: 1;
		unsigned B3D31     	: 1;
		unsigned B3D32     	: 1;
		unsigned B3D33     	: 1;
		unsigned B3D34     	: 1;
		unsigned B3D35     	: 1;
		unsigned B3D36     	: 1;
		unsigned B3D37     	: 1;
	};
} __B3D3bits_t;
extern volatile __B3D3bits_t __at (0xE59) B3D3bits;

extern __sfr __at (0xE5A) B3D4;
typedef union {
	struct {
		unsigned B3D40     	: 1;
		unsigned B3D41     	: 1;
		unsigned B3D42     	: 1;
		unsigned B3D43     	: 1;
		unsigned B3D44     	: 1;
		unsigned B3D45     	: 1;
		unsigned B3D46     	: 1;
		unsigned B3D47     	: 1;
	};
} __B3D4bits_t;
extern volatile __B3D4bits_t __at (0xE5A) B3D4bits;

extern __sfr __at (0xE5B) B3D5;
typedef union {
	struct {
		unsigned B3D50     	: 1;
		unsigned B3D51     	: 1;
		unsigned B3D52     	: 1;
		unsigned B3D53     	: 1;
		unsigned B3D54     	: 1;
		unsigned B3D55     	: 1;
		unsigned B3D56     	: 1;
		unsigned B3D57     	: 1;
	};
} __B3D5bits_t;
extern volatile __B3D5bits_t __at (0xE5B) B3D5bits;

extern __sfr __at (0xE5C) B3D6;
typedef union {
	struct {
		unsigned B3D60     	: 1;
		unsigned B3D61     	: 1;
		unsigned B3D62     	: 1;
		unsigned B3D63     	: 1;
		unsigned B3D64     	: 1;
		unsigned B3D65     	: 1;
		unsigned B3D66     	: 1;
		unsigned B3D67     	: 1;
	};
} __B3D6bits_t;
extern volatile __B3D6bits_t __at (0xE5C) B3D6bits;

extern __sfr __at (0xE5D) B3D7;
typedef union {
	struct {
		unsigned B3D70     	: 1;
		unsigned B3D71     	: 1;
		unsigned B3D72     	: 1;
		unsigned B3D73     	: 1;
		unsigned B3D74     	: 1;
		unsigned B3D75     	: 1;
		unsigned B3D76     	: 1;
		unsigned B3D77     	: 1;
	};
} __B3D7bits_t;
extern volatile __B3D7bits_t __at (0xE5D) B3D7bits;

extern __sfr __at (0xE5E) CANSTAT_RO6;
typedef union {
	struct {
		unsigned ICODE0    	: 1;
		unsigned ICODE1    	: 1;
		unsigned ICODE2    	: 1;
		unsigned ICODE3    	: 1;
		unsigned ICODE4    	: 1;
		unsigned OPMODE    	: 1;
		unsigned REQOP1    	: 1;
		unsigned REQOP2    	: 1;
	};
} __CANSTAT_RO6bits_t;
extern volatile __CANSTAT_RO6bits_t __at (0xE5E) CANSTAT_RO6bits;

extern __sfr __at (0xE5F) CANCON_RO6;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned WIN0      	: 1;
		unsigned WIN1      	: 1;
		unsigned WIN2      	: 1;
		unsigned ABAT      	: 1;
		unsigned REQOP0    	: 1;
		unsigned REQOP1    	: 1;
		unsigned REQOP2    	: 1;
	};
} __CANCON_RO6bits_t;
extern volatile __CANCON_RO6bits_t __at (0xE5F) CANCON_RO6bits;

extern __sfr __at (0xE60) B4CON;
typedef union {
	struct {
		unsigned FILHIT0   	: 1;
		unsigned FILHIT1   	: 1;
		unsigned FILHIT2   	: 1;
		unsigned FILHIT3   	: 1;
		unsigned FILHIT4   	: 1;
		unsigned RTRRO     	: 1;
		unsigned RXM1      	: 1;
		unsigned RXFUL     	: 1;
	};
	struct {
		unsigned TXPRI0    	: 1;
		unsigned TXPRI1    	: 1;
		unsigned RTREN     	: 1;
		unsigned TXREQ     	: 1;
		unsigned TXERR     	: 1;
		unsigned TXLARB    	: 1;
		unsigned TXABT     	: 1;
		unsigned TXBIF     	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned RXRTRRO_B4CON	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __B4CONbits_t;
extern volatile __B4CONbits_t __at (0xE60) B4CONbits;

extern __sfr __at (0xE61) B4SIDH;
typedef union {
	struct {
		unsigned SID3      	: 1;
		unsigned SID4      	: 1;
		unsigned SID5      	: 1;
		unsigned SID6      	: 1;
		unsigned SID7      	: 1;
		unsigned SID8      	: 1;
		unsigned SID9      	: 1;
		unsigned SID10     	: 1;
	};
} __B4SIDHbits_t;
extern volatile __B4SIDHbits_t __at (0xE61) B4SIDHbits;

extern __sfr __at (0xE62) B4SIDL;
typedef union {
	struct {
		unsigned EID16     	: 1;
		unsigned EID17     	: 1;
		unsigned           	: 1;
		unsigned EXID      	: 1;
		unsigned SRR       	: 1;
		unsigned SID0      	: 1;
		unsigned SID1      	: 1;
		unsigned SID2      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned EXIDE     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __B4SIDLbits_t;
extern volatile __B4SIDLbits_t __at (0xE62) B4SIDLbits;

extern __sfr __at (0xE63) B4EIDH;
typedef union {
	struct {
		unsigned EID8      	: 1;
		unsigned EID9      	: 1;
		unsigned EID10     	: 1;
		unsigned EID11     	: 1;
		unsigned EID12     	: 1;
		unsigned EID13     	: 1;
		unsigned EID14     	: 1;
		unsigned EID15     	: 1;
	};
} __B4EIDHbits_t;
extern volatile __B4EIDHbits_t __at (0xE63) B4EIDHbits;

extern __sfr __at (0xE64) B4EIDL;
typedef union {
	struct {
		unsigned EID0      	: 1;
		unsigned EID1      	: 1;
		unsigned EID2      	: 1;
		unsigned EID3      	: 1;
		unsigned EID4      	: 1;
		unsigned EID5      	: 1;
		unsigned EID6      	: 1;
		unsigned EID7      	: 1;
	};
} __B4EIDLbits_t;
extern volatile __B4EIDLbits_t __at (0xE64) B4EIDLbits;

extern __sfr __at (0xE65) B4DLC;
typedef union {
	struct {
		unsigned DLC0      	: 1;
		unsigned DLC1      	: 1;
		unsigned DLC2      	: 1;
		unsigned DLC3      	: 1;
		unsigned RESRB0    	: 1;
		unsigned RESRB1    	: 1;
		unsigned RXRTR     	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned RB0_B4DLC 	: 1;
		unsigned RB1_B4DLC 	: 1;
		unsigned TXRTR     	: 1;
		unsigned           	: 1;
	};
} __B4DLCbits_t;
extern volatile __B4DLCbits_t __at (0xE65) B4DLCbits;

extern __sfr __at (0xE66) B4D0;
typedef union {
	struct {
		unsigned B4D00     	: 1;
		unsigned B4D01     	: 1;
		unsigned B4D02     	: 1;
		unsigned B4D03     	: 1;
		unsigned B4D04     	: 1;
		unsigned B4D05     	: 1;
		unsigned B4D06     	: 1;
		unsigned B4D07     	: 1;
	};
} __B4D0bits_t;
extern volatile __B4D0bits_t __at (0xE66) B4D0bits;

extern __sfr __at (0xE67) B4D1;
typedef union {
	struct {
		unsigned B4D10     	: 1;
		unsigned B4D11     	: 1;
		unsigned B4D12     	: 1;
		unsigned B4D13     	: 1;
		unsigned B4D14     	: 1;
		unsigned B4D15     	: 1;
		unsigned B4D16     	: 1;
		unsigned B4D17     	: 1;
	};
} __B4D1bits_t;
extern volatile __B4D1bits_t __at (0xE67) B4D1bits;

extern __sfr __at (0xE68) B4D2;
typedef union {
	struct {
		unsigned B4D20     	: 1;
		unsigned B4D21     	: 1;
		unsigned B4D22     	: 1;
		unsigned B4D23     	: 1;
		unsigned B4D24     	: 1;
		unsigned B4D25     	: 1;
		unsigned B4D26     	: 1;
		unsigned B4D27     	: 1;
	};
} __B4D2bits_t;
extern volatile __B4D2bits_t __at (0xE68) B4D2bits;

extern __sfr __at (0xE69) B4D3;
typedef union {
	struct {
		unsigned B4D30     	: 1;
		unsigned B4D31     	: 1;
		unsigned B4D32     	: 1;
		unsigned B4D33     	: 1;
		unsigned B4D34     	: 1;
		unsigned B4D35     	: 1;
		unsigned B4D36     	: 1;
		unsigned B4D37     	: 1;
	};
} __B4D3bits_t;
extern volatile __B4D3bits_t __at (0xE69) B4D3bits;

extern __sfr __at (0xE6A) B4D4;
typedef union {
	struct {
		unsigned B4D40     	: 1;
		unsigned B4D41     	: 1;
		unsigned B4D42     	: 1;
		unsigned B4D43     	: 1;
		unsigned B4D44     	: 1;
		unsigned B4D45     	: 1;
		unsigned B4D46     	: 1;
		unsigned B4D47     	: 1;
	};
} __B4D4bits_t;
extern volatile __B4D4bits_t __at (0xE6A) B4D4bits;

extern __sfr __at (0xE6B) B4D5;
typedef union {
	struct {
		unsigned B4D50     	: 1;
		unsigned B4D51     	: 1;
		unsigned B4D52     	: 1;
		unsigned B4D53     	: 1;
		unsigned B4D54     	: 1;
		unsigned B4D55     	: 1;
		unsigned B4D56     	: 1;
		unsigned B4D57     	: 1;
	};
} __B4D5bits_t;
extern volatile __B4D5bits_t __at (0xE6B) B4D5bits;

extern __sfr __at (0xE6C) B4D6;
typedef union {
	struct {
		unsigned B4D60     	: 1;
		unsigned B4D61     	: 1;
		unsigned B4D62     	: 1;
		unsigned B4D63     	: 1;
		unsigned B4D64     	: 1;
		unsigned B4D65     	: 1;
		unsigned B4D66     	: 1;
		unsigned B4D67     	: 1;
	};
} __B4D6bits_t;
extern volatile __B4D6bits_t __at (0xE6C) B4D6bits;

extern __sfr __at (0xE6D) B4D7;
typedef union {
	struct {
		unsigned B4D70     	: 1;
		unsigned B4D71     	: 1;
		unsigned B4D72     	: 1;
		unsigned B4D73     	: 1;
		unsigned B4D74     	: 1;
		unsigned B4D75     	: 1;
		unsigned B4D76     	: 1;
		unsigned B46D77    	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned B4D77     	: 1;
	};
} __B4D7bits_t;
extern volatile __B4D7bits_t __at (0xE6D) B4D7bits;

extern __sfr __at (0xE6E) CANSTAT_RO5;
typedef union {
	struct {
		unsigned ICODE0    	: 1;
		unsigned ICODE1    	: 1;
		unsigned ICODE2    	: 1;
		unsigned ICODE3    	: 1;
		unsigned ICODE4    	: 1;
		unsigned OPMODE    	: 1;
		unsigned REQOP1    	: 1;
		unsigned REQOP2    	: 1;
	};
} __CANSTAT_RO5bits_t;
extern volatile __CANSTAT_RO5bits_t __at (0xE6E) CANSTAT_RO5bits;

extern __sfr __at (0xE6F) CANCON_RO5;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned WIN0      	: 1;
		unsigned WIN1      	: 1;
		unsigned WIN2      	: 1;
		unsigned ABAT      	: 1;
		unsigned REQOP0    	: 1;
		unsigned REQOP1    	: 1;
		unsigned REQOP2    	: 1;
	};
} __CANCON_RO5bits_t;
extern volatile __CANCON_RO5bits_t __at (0xE6F) CANCON_RO5bits;

extern __sfr __at (0xE70) B5CON;
typedef union {
	struct {
		unsigned FILHIT0   	: 1;
		unsigned FILHIT1   	: 1;
		unsigned FILHIT2   	: 1;
		unsigned FILHIT3   	: 1;
		unsigned FILHIT4   	: 1;
		unsigned RTRRO     	: 1;
		unsigned RXM1      	: 1;
		unsigned RXFUL     	: 1;
	};
	struct {
		unsigned TXPRI0    	: 1;
		unsigned TXPRI1    	: 1;
		unsigned RTREN     	: 1;
		unsigned TXREQ     	: 1;
		unsigned TXERR     	: 1;
		unsigned TXLARB    	: 1;
		unsigned TXABT     	: 1;
		unsigned TXBIF     	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned RXRTRRO_B5CON	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __B5CONbits_t;
extern volatile __B5CONbits_t __at (0xE70) B5CONbits;

extern __sfr __at (0xE71) B5SIDH;
typedef union {
	struct {
		unsigned SID3      	: 1;
		unsigned SID4      	: 1;
		unsigned SID5      	: 1;
		unsigned SID6      	: 1;
		unsigned SID7      	: 1;
		unsigned SID8      	: 1;
		unsigned SID9      	: 1;
		unsigned SID10     	: 1;
	};
} __B5SIDHbits_t;
extern volatile __B5SIDHbits_t __at (0xE71) B5SIDHbits;

extern __sfr __at (0xE72) B5SIDL;
typedef union {
	struct {
		unsigned EID16     	: 1;
		unsigned EID17     	: 1;
		unsigned           	: 1;
		unsigned EXID      	: 1;
		unsigned SRR       	: 1;
		unsigned SID0      	: 1;
		unsigned SID1      	: 1;
		unsigned SID2      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned EXIDEN    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __B5SIDLbits_t;
extern volatile __B5SIDLbits_t __at (0xE72) B5SIDLbits;

extern __sfr __at (0xE73) B5EIDH;
typedef union {
	struct {
		unsigned EID8      	: 1;
		unsigned EID9      	: 1;
		unsigned EID10     	: 1;
		unsigned EID11     	: 1;
		unsigned EID12     	: 1;
		unsigned EID13     	: 1;
		unsigned EID14     	: 1;
		unsigned EID15     	: 1;
	};
} __B5EIDHbits_t;
extern volatile __B5EIDHbits_t __at (0xE73) B5EIDHbits;

extern __sfr __at (0xE74) B5EIDL;
typedef union {
	struct {
		unsigned EID0      	: 1;
		unsigned EID1      	: 1;
		unsigned EID2      	: 1;
		unsigned EID3      	: 1;
		unsigned EID4      	: 1;
		unsigned EID5      	: 1;
		unsigned EID6      	: 1;
		unsigned EID7      	: 1;
	};
} __B5EIDLbits_t;
extern volatile __B5EIDLbits_t __at (0xE74) B5EIDLbits;

extern __sfr __at (0xE75) B5DLC;
typedef union {
	struct {
		unsigned DLC0      	: 1;
		unsigned DLC1      	: 1;
		unsigned DLC2      	: 1;
		unsigned DLC3      	: 1;
		unsigned RESRB0    	: 1;
		unsigned RESRB1    	: 1;
		unsigned RXRTR     	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned RB0_B5DLC 	: 1;
		unsigned RB1_B5DLC 	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __B5DLCbits_t;
extern volatile __B5DLCbits_t __at (0xE75) B5DLCbits;

extern __sfr __at (0xE76) B5D0;
typedef union {
	struct {
		unsigned B5D00     	: 1;
		unsigned B5D01     	: 1;
		unsigned B5D02     	: 1;
		unsigned B5D03     	: 1;
		unsigned B5D04     	: 1;
		unsigned B5D05     	: 1;
		unsigned B5D06     	: 1;
		unsigned B57D07    	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned B5D07     	: 1;
	};
} __B5D0bits_t;
extern volatile __B5D0bits_t __at (0xE76) B5D0bits;

extern __sfr __at (0xE77) B5D1;
typedef union {
	struct {
		unsigned B5D10     	: 1;
		unsigned B5D11     	: 1;
		unsigned B5D12     	: 1;
		unsigned B5D13     	: 1;
		unsigned B5D14     	: 1;
		unsigned B5D15     	: 1;
		unsigned B5D16     	: 1;
		unsigned B5D17     	: 1;
	};
} __B5D1bits_t;
extern volatile __B5D1bits_t __at (0xE77) B5D1bits;

extern __sfr __at (0xE78) B5D2;
typedef union {
	struct {
		unsigned B5D20     	: 1;
		unsigned B5D21     	: 1;
		unsigned B5D22     	: 1;
		unsigned B57D23    	: 1;
		unsigned B5D24     	: 1;
		unsigned B5D25     	: 1;
		unsigned B5D26     	: 1;
		unsigned B5D27     	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned B5D23     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __B5D2bits_t;
extern volatile __B5D2bits_t __at (0xE78) B5D2bits;

extern __sfr __at (0xE79) B5D3;
typedef union {
	struct {
		unsigned B5D30     	: 1;
		unsigned B5D31     	: 1;
		unsigned B5D32     	: 1;
		unsigned B5D33     	: 1;
		unsigned B5D34     	: 1;
		unsigned B5D35     	: 1;
		unsigned B5D36     	: 1;
		unsigned B5D37     	: 1;
	};
} __B5D3bits_t;
extern volatile __B5D3bits_t __at (0xE79) B5D3bits;

extern __sfr __at (0xE7A) B5D4;
typedef union {
	struct {
		unsigned B5D40     	: 1;
		unsigned B5D41     	: 1;
		unsigned B5D42     	: 1;
		unsigned B5D43     	: 1;
		unsigned B5D44     	: 1;
		unsigned B5D45     	: 1;
		unsigned B5D46     	: 1;
		unsigned B5D47     	: 1;
	};
} __B5D4bits_t;
extern volatile __B5D4bits_t __at (0xE7A) B5D4bits;

extern __sfr __at (0xE7B) B5D5;
typedef union {
	struct {
		unsigned B5D50     	: 1;
		unsigned B5D51     	: 1;
		unsigned B5D52     	: 1;
		unsigned B5D53     	: 1;
		unsigned B5D54     	: 1;
		unsigned B5D55     	: 1;
		unsigned B5D56     	: 1;
		unsigned B5D57     	: 1;
	};
} __B5D5bits_t;
extern volatile __B5D5bits_t __at (0xE7B) B5D5bits;

extern __sfr __at (0xE7C) B5D6;
typedef union {
	struct {
		unsigned B5D60     	: 1;
		unsigned B5D61     	: 1;
		unsigned B5D62     	: 1;
		unsigned B5D63     	: 1;
		unsigned B5D64     	: 1;
		unsigned B5D65     	: 1;
		unsigned B5D66     	: 1;
		unsigned B5D67     	: 1;
	};
} __B5D6bits_t;
extern volatile __B5D6bits_t __at (0xE7C) B5D6bits;

extern __sfr __at (0xE7D) B5D7;
typedef union {
	struct {
		unsigned B5D70     	: 1;
		unsigned B5D71     	: 1;
		unsigned B5D72     	: 1;
		unsigned B5D73     	: 1;
		unsigned B5D74     	: 1;
		unsigned B5D75     	: 1;
		unsigned B5D76     	: 1;
		unsigned B5D77     	: 1;
	};
} __B5D7bits_t;
extern volatile __B5D7bits_t __at (0xE7D) B5D7bits;

extern __sfr __at (0xE7E) CANSTAT_RO4;
typedef union {
	struct {
		unsigned ICODE0    	: 1;
		unsigned ICODE1    	: 1;
		unsigned ICODE2    	: 1;
		unsigned ICODE3    	: 1;
		unsigned ICODE4    	: 1;
		unsigned OPMODE    	: 1;
		unsigned REQOP1    	: 1;
		unsigned REQOP2    	: 1;
	};
} __CANSTAT_RO4bits_t;
extern volatile __CANSTAT_RO4bits_t __at (0xE7E) CANSTAT_RO4bits;

extern __sfr __at (0xE7F) CANCON_RO4;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned WIN0      	: 1;
		unsigned WIN1      	: 1;
		unsigned WIN2      	: 1;
		unsigned ABAT      	: 1;
		unsigned REQOP0    	: 1;
		unsigned REQOP1    	: 1;
		unsigned REQOP2    	: 1;
	};
} __CANCON_RO4bits_t;
extern volatile __CANCON_RO4bits_t __at (0xE7F) CANCON_RO4bits;

extern __sfr __at (0xF00) RXF0SIDH;
typedef union {
	struct {
		unsigned SID3      	: 1;
		unsigned SID4      	: 1;
		unsigned SID5      	: 1;
		unsigned SID6      	: 1;
		unsigned SID7      	: 1;
		unsigned SID8      	: 1;
		unsigned SID9      	: 1;
		unsigned SID10     	: 1;
	};
} __RXF0SIDHbits_t;
extern volatile __RXF0SIDHbits_t __at (0xF00) RXF0SIDHbits;

extern __sfr __at (0xF01) RXF0SIDL;
typedef union {
	struct {
		unsigned EID16     	: 1;
		unsigned EID17     	: 1;
		unsigned           	: 1;
		unsigned EXIDE     	: 1;
		unsigned           	: 1;
		unsigned SID0      	: 1;
		unsigned SID1      	: 1;
		unsigned SID2      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned EXIDEN    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __RXF0SIDLbits_t;
extern volatile __RXF0SIDLbits_t __at (0xF01) RXF0SIDLbits;

extern __sfr __at (0xF02) RXF0EIDH;
typedef union {
	struct {
		unsigned EID8      	: 1;
		unsigned EID9      	: 1;
		unsigned EID10     	: 1;
		unsigned EID11     	: 1;
		unsigned EID12     	: 1;
		unsigned EID13     	: 1;
		unsigned EID14     	: 1;
		unsigned EID15     	: 1;
	};
} __RXF0EIDHbits_t;
extern volatile __RXF0EIDHbits_t __at (0xF02) RXF0EIDHbits;

extern __sfr __at (0xF03) RXF0EIDL;
typedef union {
	struct {
		unsigned EID0      	: 1;
		unsigned EID1      	: 1;
		unsigned EID2      	: 1;
		unsigned EID3      	: 1;
		unsigned EID4      	: 1;
		unsigned EID5      	: 1;
		unsigned EID6      	: 1;
		unsigned EID7      	: 1;
	};
} __RXF0EIDLbits_t;
extern volatile __RXF0EIDLbits_t __at (0xF03) RXF0EIDLbits;

extern __sfr __at (0xF04) RXF1SIDH;
typedef union {
	struct {
		unsigned SID3      	: 1;
		unsigned SID4      	: 1;
		unsigned SID5      	: 1;
		unsigned SID6      	: 1;
		unsigned SID7      	: 1;
		unsigned SID8      	: 1;
		unsigned SID9      	: 1;
		unsigned SID10     	: 1;
	};
} __RXF1SIDHbits_t;
extern volatile __RXF1SIDHbits_t __at (0xF04) RXF1SIDHbits;

extern __sfr __at (0xF05) RXF1SIDL;
typedef union {
	struct {
		unsigned EID16     	: 1;
		unsigned EID17     	: 1;
		unsigned           	: 1;
		unsigned EXIDE     	: 1;
		unsigned           	: 1;
		unsigned SID0      	: 1;
		unsigned SID1      	: 1;
		unsigned SID2      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned EXIDEN    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __RXF1SIDLbits_t;
extern volatile __RXF1SIDLbits_t __at (0xF05) RXF1SIDLbits;

extern __sfr __at (0xF06) RXF1EIDH;
typedef union {
	struct {
		unsigned EID8      	: 1;
		unsigned EID9      	: 1;
		unsigned EID10     	: 1;
		unsigned EID11     	: 1;
		unsigned EID12     	: 1;
		unsigned EID13     	: 1;
		unsigned EID14     	: 1;
		unsigned EID15     	: 1;
	};
} __RXF1EIDHbits_t;
extern volatile __RXF1EIDHbits_t __at (0xF06) RXF1EIDHbits;

extern __sfr __at (0xF07) RXF1EIDL;
typedef union {
	struct {
		unsigned EID0      	: 1;
		unsigned EID1      	: 1;
		unsigned EID2      	: 1;
		unsigned EID3      	: 1;
		unsigned EID4      	: 1;
		unsigned EID5      	: 1;
		unsigned EID6      	: 1;
		unsigned EID7      	: 1;
	};
} __RXF1EIDLbits_t;
extern volatile __RXF1EIDLbits_t __at (0xF07) RXF1EIDLbits;

extern __sfr __at (0xF08) RXF2SIDH;
typedef union {
	struct {
		unsigned SID3      	: 1;
		unsigned SID4      	: 1;
		unsigned SID5      	: 1;
		unsigned SID6      	: 1;
		unsigned SID7      	: 1;
		unsigned SID8      	: 1;
		unsigned SID9      	: 1;
		unsigned SID10     	: 1;
	};
} __RXF2SIDHbits_t;
extern volatile __RXF2SIDHbits_t __at (0xF08) RXF2SIDHbits;

extern __sfr __at (0xF09) RXF2SIDL;
typedef union {
	struct {
		unsigned EID16     	: 1;
		unsigned EID17     	: 1;
		unsigned           	: 1;
		unsigned EXIDE     	: 1;
		unsigned           	: 1;
		unsigned SID0      	: 1;
		unsigned SID1      	: 1;
		unsigned SID2      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned EXIDEN    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __RXF2SIDLbits_t;
extern volatile __RXF2SIDLbits_t __at (0xF09) RXF2SIDLbits;

extern __sfr __at (0xF0A) RXF2EIDH;
typedef union {
	struct {
		unsigned EID8      	: 1;
		unsigned EID9      	: 1;
		unsigned EID10     	: 1;
		unsigned EID11     	: 1;
		unsigned EID12     	: 1;
		unsigned EID13     	: 1;
		unsigned EID14     	: 1;
		unsigned EID15     	: 1;
	};
} __RXF2EIDHbits_t;
extern volatile __RXF2EIDHbits_t __at (0xF0A) RXF2EIDHbits;

extern __sfr __at (0xF0B) RXF2EIDL;
typedef union {
	struct {
		unsigned EID0      	: 1;
		unsigned EID1      	: 1;
		unsigned EID2      	: 1;
		unsigned EID3      	: 1;
		unsigned EID4      	: 1;
		unsigned EID5      	: 1;
		unsigned EID6      	: 1;
		unsigned EID7      	: 1;
	};
} __RXF2EIDLbits_t;
extern volatile __RXF2EIDLbits_t __at (0xF0B) RXF2EIDLbits;

extern __sfr __at (0xF0C) RXF3SIDH;
typedef union {
	struct {
		unsigned SID3      	: 1;
		unsigned SID4      	: 1;
		unsigned SID5      	: 1;
		unsigned SID6      	: 1;
		unsigned SID7      	: 1;
		unsigned SID8      	: 1;
		unsigned SID9      	: 1;
		unsigned SID10     	: 1;
	};
} __RXF3SIDHbits_t;
extern volatile __RXF3SIDHbits_t __at (0xF0C) RXF3SIDHbits;

extern __sfr __at (0xF0D) RXF3SIDL;
typedef union {
	struct {
		unsigned EID16     	: 1;
		unsigned EID17     	: 1;
		unsigned           	: 1;
		unsigned EXIDE     	: 1;
		unsigned           	: 1;
		unsigned SID0      	: 1;
		unsigned SID1      	: 1;
		unsigned SID2      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned EXIDEN    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __RXF3SIDLbits_t;
extern volatile __RXF3SIDLbits_t __at (0xF0D) RXF3SIDLbits;

extern __sfr __at (0xF0E) RXF3EIDH;
typedef union {
	struct {
		unsigned EID8      	: 1;
		unsigned EID9      	: 1;
		unsigned EID10     	: 1;
		unsigned EID11     	: 1;
		unsigned EID12     	: 1;
		unsigned EID13     	: 1;
		unsigned EID14     	: 1;
		unsigned EID15     	: 1;
	};
} __RXF3EIDHbits_t;
extern volatile __RXF3EIDHbits_t __at (0xF0E) RXF3EIDHbits;

extern __sfr __at (0xF0F) RXF3EIDL;
typedef union {
	struct {
		unsigned EID0      	: 1;
		unsigned EID1      	: 1;
		unsigned EID2      	: 1;
		unsigned EID3      	: 1;
		unsigned EID4      	: 1;
		unsigned EID5      	: 1;
		unsigned EID6      	: 1;
		unsigned EID7      	: 1;
	};
} __RXF3EIDLbits_t;
extern volatile __RXF3EIDLbits_t __at (0xF0F) RXF3EIDLbits;

extern __sfr __at (0xF10) RXF4SIDH;
typedef union {
	struct {
		unsigned SID3      	: 1;
		unsigned SID4      	: 1;
		unsigned SID5      	: 1;
		unsigned SID6      	: 1;
		unsigned SID7      	: 1;
		unsigned SID8      	: 1;
		unsigned SID9      	: 1;
		unsigned SID10     	: 1;
	};
} __RXF4SIDHbits_t;
extern volatile __RXF4SIDHbits_t __at (0xF10) RXF4SIDHbits;

extern __sfr __at (0xF11) RXF4SIDL;
typedef union {
	struct {
		unsigned EID16     	: 1;
		unsigned EID17     	: 1;
		unsigned           	: 1;
		unsigned EXIDE     	: 1;
		unsigned           	: 1;
		unsigned SID0      	: 1;
		unsigned SID1      	: 1;
		unsigned SID2      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned EXIDEN    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __RXF4SIDLbits_t;
extern volatile __RXF4SIDLbits_t __at (0xF11) RXF4SIDLbits;

extern __sfr __at (0xF12) RXF4EIDH;
typedef union {
	struct {
		unsigned EID8      	: 1;
		unsigned EID9      	: 1;
		unsigned EID10     	: 1;
		unsigned EID11     	: 1;
		unsigned EID12     	: 1;
		unsigned EID13     	: 1;
		unsigned EID14     	: 1;
		unsigned EID15     	: 1;
	};
} __RXF4EIDHbits_t;
extern volatile __RXF4EIDHbits_t __at (0xF12) RXF4EIDHbits;

extern __sfr __at (0xF13) RXF4EIDL;
typedef union {
	struct {
		unsigned EID0      	: 1;
		unsigned EID1      	: 1;
		unsigned EID2      	: 1;
		unsigned EID3      	: 1;
		unsigned EID4      	: 1;
		unsigned EID5      	: 1;
		unsigned EID6      	: 1;
		unsigned EID7      	: 1;
	};
} __RXF4EIDLbits_t;
extern volatile __RXF4EIDLbits_t __at (0xF13) RXF4EIDLbits;

extern __sfr __at (0xF14) RXF5SIDH;
typedef union {
	struct {
		unsigned SID3      	: 1;
		unsigned SID4      	: 1;
		unsigned SID5      	: 1;
		unsigned SID6      	: 1;
		unsigned SID7      	: 1;
		unsigned SID8      	: 1;
		unsigned SID9      	: 1;
		unsigned SID10     	: 1;
	};
} __RXF5SIDHbits_t;
extern volatile __RXF5SIDHbits_t __at (0xF14) RXF5SIDHbits;

extern __sfr __at (0xF15) RXF5SIDL;
typedef union {
	struct {
		unsigned EID16     	: 1;
		unsigned EID17     	: 1;
		unsigned           	: 1;
		unsigned EXIDE     	: 1;
		unsigned           	: 1;
		unsigned SID0      	: 1;
		unsigned SID1      	: 1;
		unsigned SID2      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned EXIDEN    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __RXF5SIDLbits_t;
extern volatile __RXF5SIDLbits_t __at (0xF15) RXF5SIDLbits;

extern __sfr __at (0xF16) RXF5EIDH;
typedef union {
	struct {
		unsigned EID8      	: 1;
		unsigned EID9      	: 1;
		unsigned EID10     	: 1;
		unsigned EID11     	: 1;
		unsigned EID12     	: 1;
		unsigned EID13     	: 1;
		unsigned EID14     	: 1;
		unsigned EID15     	: 1;
	};
} __RXF5EIDHbits_t;
extern volatile __RXF5EIDHbits_t __at (0xF16) RXF5EIDHbits;

extern __sfr __at (0xF17) RXF5EIDL;
typedef union {
	struct {
		unsigned EID0      	: 1;
		unsigned EID1      	: 1;
		unsigned EID2      	: 1;
		unsigned EID3      	: 1;
		unsigned EID4      	: 1;
		unsigned EID5      	: 1;
		unsigned EID6      	: 1;
		unsigned EID7      	: 1;
	};
} __RXF5EIDLbits_t;
extern volatile __RXF5EIDLbits_t __at (0xF17) RXF5EIDLbits;

extern __sfr __at (0xF18) RXM0SIDH;
typedef union {
	struct {
		unsigned SID3      	: 1;
		unsigned SID4      	: 1;
		unsigned SID5      	: 1;
		unsigned SID6      	: 1;
		unsigned SID7      	: 1;
		unsigned SID8      	: 1;
		unsigned SID9      	: 1;
		unsigned SID10     	: 1;
	};
} __RXM0SIDHbits_t;
extern volatile __RXM0SIDHbits_t __at (0xF18) RXM0SIDHbits;

extern __sfr __at (0xF19) RXM0SIDL;
typedef union {
	struct {
		unsigned EID16     	: 1;
		unsigned EID17     	: 1;
		unsigned           	: 1;
		unsigned EXIDEN    	: 1;
		unsigned           	: 1;
		unsigned SID0      	: 1;
		unsigned SID1      	: 1;
		unsigned SID2      	: 1;
	};
} __RXM0SIDLbits_t;
extern volatile __RXM0SIDLbits_t __at (0xF19) RXM0SIDLbits;

extern __sfr __at (0xF1A) RXM0EIDH;
typedef union {
	struct {
		unsigned EID8      	: 1;
		unsigned EID9      	: 1;
		unsigned EID10     	: 1;
		unsigned EID11     	: 1;
		unsigned EID12     	: 1;
		unsigned EID13     	: 1;
		unsigned EID14     	: 1;
		unsigned EID15     	: 1;
	};
} __RXM0EIDHbits_t;
extern volatile __RXM0EIDHbits_t __at (0xF1A) RXM0EIDHbits;

extern __sfr __at (0xF1B) RXM0EIDL;
typedef union {
	struct {
		unsigned EID0      	: 1;
		unsigned EID1      	: 1;
		unsigned EID2      	: 1;
		unsigned EID3      	: 1;
		unsigned EID4      	: 1;
		unsigned EID5      	: 1;
		unsigned EID6      	: 1;
		unsigned EID7      	: 1;
	};
} __RXM0EIDLbits_t;
extern volatile __RXM0EIDLbits_t __at (0xF1B) RXM0EIDLbits;

extern __sfr __at (0xF1C) RXM1SIDH;
typedef union {
	struct {
		unsigned SID3      	: 1;
		unsigned SID4      	: 1;
		unsigned SID5      	: 1;
		unsigned SID6      	: 1;
		unsigned SID7      	: 1;
		unsigned SID8      	: 1;
		unsigned SID9      	: 1;
		unsigned SID10     	: 1;
	};
} __RXM1SIDHbits_t;
extern volatile __RXM1SIDHbits_t __at (0xF1C) RXM1SIDHbits;

extern __sfr __at (0xF1D) RXM1SIDL;
typedef union {
	struct {
		unsigned EID16     	: 1;
		unsigned EID17     	: 1;
		unsigned           	: 1;
		unsigned EXIDEN    	: 1;
		unsigned           	: 1;
		unsigned SID0      	: 1;
		unsigned SID1      	: 1;
		unsigned SID2      	: 1;
	};
} __RXM1SIDLbits_t;
extern volatile __RXM1SIDLbits_t __at (0xF1D) RXM1SIDLbits;

extern __sfr __at (0xF1E) RXM1EIDH;
typedef union {
	struct {
		unsigned EID8      	: 1;
		unsigned EID9      	: 1;
		unsigned EID10     	: 1;
		unsigned EID11     	: 1;
		unsigned EID12     	: 1;
		unsigned EID13     	: 1;
		unsigned EID14     	: 1;
		unsigned EID15     	: 1;
	};
} __RXM1EIDHbits_t;
extern volatile __RXM1EIDHbits_t __at (0xF1E) RXM1EIDHbits;

extern __sfr __at (0xF1F) RXM1EIDL;
typedef union {
	struct {
		unsigned EID0      	: 1;
		unsigned EID1      	: 1;
		unsigned EID2      	: 1;
		unsigned EID3      	: 1;
		unsigned EID4      	: 1;
		unsigned EID5      	: 1;
		unsigned EID6      	: 1;
		unsigned EID7      	: 1;
	};
} __RXM1EIDLbits_t;
extern volatile __RXM1EIDLbits_t __at (0xF1F) RXM1EIDLbits;

extern __sfr __at (0xF20) TXB2CON;
typedef union {
	struct {
		unsigned TXPRI0    	: 1;
		unsigned TXPRI1    	: 1;
		unsigned           	: 1;
		unsigned TXREQ     	: 1;
		unsigned TXERR     	: 1;
		unsigned TXLARB    	: 1;
		unsigned TXABT     	: 1;
		unsigned TXBIFBXB2CON	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned TXBIF     	: 1;
	};
} __TXB2CONbits_t;
extern volatile __TXB2CONbits_t __at (0xF20) TXB2CONbits;

extern __sfr __at (0xF21) TXB2SIDH;
typedef union {
	struct {
		unsigned SID3      	: 1;
		unsigned SID4      	: 1;
		unsigned SID5      	: 1;
		unsigned SID6      	: 1;
		unsigned SID7      	: 1;
		unsigned SID8      	: 1;
		unsigned SID9      	: 1;
		unsigned SID10     	: 1;
	};
} __TXB2SIDHbits_t;
extern volatile __TXB2SIDHbits_t __at (0xF21) TXB2SIDHbits;

extern __sfr __at (0xF22) TXB2SIDL;
typedef union {
	struct {
		unsigned EID16     	: 1;
		unsigned EID17     	: 1;
		unsigned           	: 1;
		unsigned EXIDE     	: 1;
		unsigned           	: 1;
		unsigned SID0      	: 1;
		unsigned SID1      	: 1;
		unsigned SID2      	: 1;
	};
} __TXB2SIDLbits_t;
extern volatile __TXB2SIDLbits_t __at (0xF22) TXB2SIDLbits;

extern __sfr __at (0xF23) TXB2EIDH;
typedef union {
	struct {
		unsigned EID8      	: 1;
		unsigned EID9      	: 1;
		unsigned EID10     	: 1;
		unsigned EID11     	: 1;
		unsigned EID12     	: 1;
		unsigned EID13     	: 1;
		unsigned EID14     	: 1;
		unsigned EID15     	: 1;
	};
} __TXB2EIDHbits_t;
extern volatile __TXB2EIDHbits_t __at (0xF23) TXB2EIDHbits;

extern __sfr __at (0xF24) TXB2EIDL;
typedef union {
	struct {
		unsigned EID0      	: 1;
		unsigned EID1      	: 1;
		unsigned EID2      	: 1;
		unsigned EID3      	: 1;
		unsigned EID4      	: 1;
		unsigned EID5      	: 1;
		unsigned EID6      	: 1;
		unsigned EID7      	: 1;
	};
} __TXB2EIDLbits_t;
extern volatile __TXB2EIDLbits_t __at (0xF24) TXB2EIDLbits;

extern __sfr __at (0xF25) TXB2DLC;
typedef union {
	struct {
		unsigned DLC0      	: 1;
		unsigned DLC1      	: 1;
		unsigned DLC2      	: 1;
		unsigned DLC3      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned TXRTR     	: 1;
		unsigned           	: 1;
	};
} __TXB2DLCbits_t;
extern volatile __TXB2DLCbits_t __at (0xF25) TXB2DLCbits;

extern __sfr __at (0xF26) TXB2D0;
typedef union {
	struct {
		unsigned TXB2D00   	: 1;
		unsigned TXB2D01   	: 1;
		unsigned TXB2D02   	: 1;
		unsigned TXB2D03   	: 1;
		unsigned TXB2D04   	: 1;
		unsigned TXB2D05   	: 1;
		unsigned TXB2D06   	: 1;
		unsigned TXB2D07   	: 1;
	};
} __TXB2D0bits_t;
extern volatile __TXB2D0bits_t __at (0xF26) TXB2D0bits;

extern __sfr __at (0xF27) TXB2D1;
typedef union {
	struct {
		unsigned TXB2D10   	: 1;
		unsigned TXB2D11   	: 1;
		unsigned TXB2D12   	: 1;
		unsigned TXB2D13   	: 1;
		unsigned TXB2D14   	: 1;
		unsigned TXB2D15   	: 1;
		unsigned TXB2D16   	: 1;
		unsigned TXB2D17   	: 1;
	};
} __TXB2D1bits_t;
extern volatile __TXB2D1bits_t __at (0xF27) TXB2D1bits;

extern __sfr __at (0xF28) TXB2D2;
typedef union {
	struct {
		unsigned TXB2D20   	: 1;
		unsigned TXB2D21   	: 1;
		unsigned TXB2D22   	: 1;
		unsigned TXB2D23   	: 1;
		unsigned TXB2D24   	: 1;
		unsigned TXB2D25   	: 1;
		unsigned TXB2D26   	: 1;
		unsigned TXB2D27   	: 1;
	};
} __TXB2D2bits_t;
extern volatile __TXB2D2bits_t __at (0xF28) TXB2D2bits;

extern __sfr __at (0xF29) TXB2D3;
typedef union {
	struct {
		unsigned TXB2D30   	: 1;
		unsigned TXB2D31   	: 1;
		unsigned TXB2D32   	: 1;
		unsigned TXB2D33   	: 1;
		unsigned TXB2D34   	: 1;
		unsigned TXB2D35   	: 1;
		unsigned TXB2D36   	: 1;
		unsigned TXB2D37   	: 1;
	};
} __TXB2D3bits_t;
extern volatile __TXB2D3bits_t __at (0xF29) TXB2D3bits;

extern __sfr __at (0xF2A) TXB2D4;
typedef union {
	struct {
		unsigned TXB2D40   	: 1;
		unsigned TXB2D41   	: 1;
		unsigned TXB2D42   	: 1;
		unsigned TXB2D43   	: 1;
		unsigned TXB2D44   	: 1;
		unsigned TXB2D45   	: 1;
		unsigned TXB2D46   	: 1;
		unsigned TXB2D47   	: 1;
	};
} __TXB2D4bits_t;
extern volatile __TXB2D4bits_t __at (0xF2A) TXB2D4bits;

extern __sfr __at (0xF2B) TXB2D5;
typedef union {
	struct {
		unsigned TXB2D50   	: 1;
		unsigned TXB2D51   	: 1;
		unsigned TXB2D52   	: 1;
		unsigned TXB2D53   	: 1;
		unsigned TXB2D54   	: 1;
		unsigned TXB2D55   	: 1;
		unsigned TXB2D56   	: 1;
		unsigned TXB2D57   	: 1;
	};
} __TXB2D5bits_t;
extern volatile __TXB2D5bits_t __at (0xF2B) TXB2D5bits;

extern __sfr __at (0xF2C) TXB2D6;
typedef union {
	struct {
		unsigned TXB2D60   	: 1;
		unsigned TXB2D61   	: 1;
		unsigned TXB2D62   	: 1;
		unsigned TXB2D63   	: 1;
		unsigned TXB2D64   	: 1;
		unsigned TXB2D65   	: 1;
		unsigned TXB2D66   	: 1;
		unsigned TXB2D67   	: 1;
	};
} __TXB2D6bits_t;
extern volatile __TXB2D6bits_t __at (0xF2C) TXB2D6bits;

extern __sfr __at (0xF2D) TXB2D7;
typedef union {
	struct {
		unsigned TXB2D70   	: 1;
		unsigned TXB2D71   	: 1;
		unsigned TXB2D72   	: 1;
		unsigned TXB2D73   	: 1;
		unsigned TXB2D74   	: 1;
		unsigned TXB2D75   	: 1;
		unsigned TXB2D76   	: 1;
		unsigned TXB2D77   	: 1;
	};
} __TXB2D7bits_t;
extern volatile __TXB2D7bits_t __at (0xF2D) TXB2D7bits;

extern __sfr __at (0xF2E) CANSTAT_RO3;
typedef union {
	struct {
		unsigned ICODE0    	: 1;
		unsigned ICODE1    	: 1;
		unsigned ICODE2    	: 1;
		unsigned ICODE3    	: 1;
		unsigned ICODE4    	: 1;
		unsigned OPMODE    	: 1;
		unsigned REQOP1    	: 1;
		unsigned REQOP2    	: 1;
	};
} __CANSTAT_RO3bits_t;
extern volatile __CANSTAT_RO3bits_t __at (0xF2E) CANSTAT_RO3bits;

extern __sfr __at (0xF2F) CANCON_RO3;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned WIN0      	: 1;
		unsigned WIN1      	: 1;
		unsigned WIN2      	: 1;
		unsigned ABAT      	: 1;
		unsigned REQOP0    	: 1;
		unsigned REQOP1    	: 1;
		unsigned REQOP2    	: 1;
	};
} __CANCON_RO3bits_t;
extern volatile __CANCON_RO3bits_t __at (0xF2F) CANCON_RO3bits;

extern __sfr __at (0xF30) TXB1CON;
typedef union {
	struct {
		unsigned TXPRI0    	: 1;
		unsigned TXPRI1    	: 1;
		unsigned           	: 1;
		unsigned TXREQ     	: 1;
		unsigned TXERR     	: 1;
		unsigned TXLARB    	: 1;
		unsigned TXABT     	: 1;
		unsigned TXBIFTXB1CON	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned TXBIF     	: 1;
	};
} __TXB1CONbits_t;
extern volatile __TXB1CONbits_t __at (0xF30) TXB1CONbits;

extern __sfr __at (0xF31) TXB1SIDH;
typedef union {
	struct {
		unsigned SID3      	: 1;
		unsigned SID4      	: 1;
		unsigned SID5      	: 1;
		unsigned SID6      	: 1;
		unsigned SID7      	: 1;
		unsigned SID8      	: 1;
		unsigned SID9      	: 1;
		unsigned SID10     	: 1;
	};
} __TXB1SIDHbits_t;
extern volatile __TXB1SIDHbits_t __at (0xF31) TXB1SIDHbits;

extern __sfr __at (0xF32) TXB1SIDL;
typedef union {
	struct {
		unsigned EID16     	: 1;
		unsigned EID17     	: 1;
		unsigned           	: 1;
		unsigned EXIDE     	: 1;
		unsigned           	: 1;
		unsigned SID0      	: 1;
		unsigned SID1      	: 1;
		unsigned SID2      	: 1;
	};
} __TXB1SIDLbits_t;
extern volatile __TXB1SIDLbits_t __at (0xF32) TXB1SIDLbits;

extern __sfr __at (0xF33) TXB1EIDH;
typedef union {
	struct {
		unsigned EID8      	: 1;
		unsigned EID9      	: 1;
		unsigned EID10     	: 1;
		unsigned EID11     	: 1;
		unsigned EID12     	: 1;
		unsigned EID13     	: 1;
		unsigned EID14     	: 1;
		unsigned EID15     	: 1;
	};
} __TXB1EIDHbits_t;
extern volatile __TXB1EIDHbits_t __at (0xF33) TXB1EIDHbits;

extern __sfr __at (0xF34) TXB1EIDL;
typedef union {
	struct {
		unsigned EID0      	: 1;
		unsigned EID1      	: 1;
		unsigned EID2      	: 1;
		unsigned EID3      	: 1;
		unsigned EID4      	: 1;
		unsigned EID5      	: 1;
		unsigned EID6      	: 1;
		unsigned EID7      	: 1;
	};
} __TXB1EIDLbits_t;
extern volatile __TXB1EIDLbits_t __at (0xF34) TXB1EIDLbits;

extern __sfr __at (0xF35) TXB1DLC;
typedef union {
	struct {
		unsigned DLC0      	: 1;
		unsigned DLC1      	: 1;
		unsigned DLC2      	: 1;
		unsigned DLC3      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned TXRTR     	: 1;
		unsigned           	: 1;
	};
} __TXB1DLCbits_t;
extern volatile __TXB1DLCbits_t __at (0xF35) TXB1DLCbits;

extern __sfr __at (0xF36) TXB1D0;
typedef union {
	struct {
		unsigned TXB1D00   	: 1;
		unsigned TXB1D01   	: 1;
		unsigned TXB1D02   	: 1;
		unsigned TXB1D03   	: 1;
		unsigned TXB1D04   	: 1;
		unsigned TXB1D05   	: 1;
		unsigned TXB1D06   	: 1;
		unsigned TXB1D07   	: 1;
	};
} __TXB1D0bits_t;
extern volatile __TXB1D0bits_t __at (0xF36) TXB1D0bits;

extern __sfr __at (0xF37) TXB1D1;
typedef union {
	struct {
		unsigned TXB1D10   	: 1;
		unsigned TXB1D11   	: 1;
		unsigned TXB1D12   	: 1;
		unsigned TXB1D13   	: 1;
		unsigned TXB1D14   	: 1;
		unsigned TXB1D15   	: 1;
		unsigned TXB1D16   	: 1;
		unsigned TXB1D17   	: 1;
	};
} __TXB1D1bits_t;
extern volatile __TXB1D1bits_t __at (0xF37) TXB1D1bits;

extern __sfr __at (0xF38) TXB1D2;
typedef union {
	struct {
		unsigned TXB1D20   	: 1;
		unsigned TXB1D21   	: 1;
		unsigned TXB1D22   	: 1;
		unsigned TXB1D23   	: 1;
		unsigned TXB1D24   	: 1;
		unsigned TXB1D25   	: 1;
		unsigned TXB1D26   	: 1;
		unsigned TXB1D27   	: 1;
	};
} __TXB1D2bits_t;
extern volatile __TXB1D2bits_t __at (0xF38) TXB1D2bits;

extern __sfr __at (0xF39) TXB1D3;
typedef union {
	struct {
		unsigned TXB1D30   	: 1;
		unsigned TXB1D31   	: 1;
		unsigned TXB1D32   	: 1;
		unsigned TXB1D33   	: 1;
		unsigned TXB1D34   	: 1;
		unsigned TXB1D35   	: 1;
		unsigned TXB1D36   	: 1;
		unsigned TXB1D37   	: 1;
	};
} __TXB1D3bits_t;
extern volatile __TXB1D3bits_t __at (0xF39) TXB1D3bits;

extern __sfr __at (0xF3A) TXB1D4;
typedef union {
	struct {
		unsigned TXB1D40   	: 1;
		unsigned TXB1D41   	: 1;
		unsigned TXB1D42   	: 1;
		unsigned TXB1D43   	: 1;
		unsigned TXB1D44   	: 1;
		unsigned TXB1D45   	: 1;
		unsigned TXB1D46   	: 1;
		unsigned TXB1D47   	: 1;
	};
} __TXB1D4bits_t;
extern volatile __TXB1D4bits_t __at (0xF3A) TXB1D4bits;

extern __sfr __at (0xF3B) TXB1D5;
typedef union {
	struct {
		unsigned TXB1D50   	: 1;
		unsigned TXB1D51   	: 1;
		unsigned TXB1D52   	: 1;
		unsigned TXB1D53   	: 1;
		unsigned TXB1D54   	: 1;
		unsigned TXB1D55   	: 1;
		unsigned TXB1D56   	: 1;
		unsigned TXB1D57   	: 1;
	};
} __TXB1D5bits_t;
extern volatile __TXB1D5bits_t __at (0xF3B) TXB1D5bits;

extern __sfr __at (0xF3C) TXB1D6;
typedef union {
	struct {
		unsigned TXB1D60   	: 1;
		unsigned TXB1D61   	: 1;
		unsigned TXB1D62   	: 1;
		unsigned TXB1D63   	: 1;
		unsigned TXB1D64   	: 1;
		unsigned TXB1D65   	: 1;
		unsigned TXB1D66   	: 1;
		unsigned TXB1D67   	: 1;
	};
} __TXB1D6bits_t;
extern volatile __TXB1D6bits_t __at (0xF3C) TXB1D6bits;

extern __sfr __at (0xF3D) TXB1D7;
typedef union {
	struct {
		unsigned TXB1D70   	: 1;
		unsigned TXB1D71   	: 1;
		unsigned TXB1D72   	: 1;
		unsigned TXB1D73   	: 1;
		unsigned TXB1D74   	: 1;
		unsigned TXB1D75   	: 1;
		unsigned TXB1D76   	: 1;
		unsigned TXB1D77   	: 1;
	};
} __TXB1D7bits_t;
extern volatile __TXB1D7bits_t __at (0xF3D) TXB1D7bits;

extern __sfr __at (0xF3E) CANSTAT_RO2;
typedef union {
	struct {
		unsigned ICODE0    	: 1;
		unsigned ICODE1    	: 1;
		unsigned ICODE2    	: 1;
		unsigned ICODE3    	: 1;
		unsigned ICODE4    	: 1;
		unsigned OPMODE    	: 1;
		unsigned REQOP1    	: 1;
		unsigned REQOP2    	: 1;
	};
} __CANSTAT_RO2bits_t;
extern volatile __CANSTAT_RO2bits_t __at (0xF3E) CANSTAT_RO2bits;

extern __sfr __at (0xF3F) CANCON_RO2;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned WIN0      	: 1;
		unsigned WIN1      	: 1;
		unsigned WIN2      	: 1;
		unsigned ABAT      	: 1;
		unsigned REQOP0    	: 1;
		unsigned REQOP1    	: 1;
		unsigned REQOP2    	: 1;
	};
} __CANCON_RO2bits_t;
extern volatile __CANCON_RO2bits_t __at (0xF3F) CANCON_RO2bits;

extern __sfr __at (0xF40) TXB0CON;
typedef union {
	struct {
		unsigned TXPRI0    	: 1;
		unsigned TXPRI1    	: 1;
		unsigned           	: 1;
		unsigned TXREQ     	: 1;
		unsigned TXERR     	: 1;
		unsigned TXLARB    	: 1;
		unsigned TXABT     	: 1;
		unsigned TXBIF     	: 1;
	};
} __TXB0CONbits_t;
extern volatile __TXB0CONbits_t __at (0xF40) TXB0CONbits;

extern __sfr __at (0xF41) TXB0SIDH;
typedef union {
	struct {
		unsigned SID3      	: 1;
		unsigned SID4      	: 1;
		unsigned SID5      	: 1;
		unsigned SID6      	: 1;
		unsigned SID7      	: 1;
		unsigned SID8      	: 1;
		unsigned SID9      	: 1;
		unsigned SID10     	: 1;
	};
} __TXB0SIDHbits_t;
extern volatile __TXB0SIDHbits_t __at (0xF41) TXB0SIDHbits;

extern __sfr __at (0xF42) TXB0SIDL;
typedef union {
	struct {
		unsigned EID16     	: 1;
		unsigned EID17     	: 1;
		unsigned           	: 1;
		unsigned EXIDE     	: 1;
		unsigned           	: 1;
		unsigned SID0      	: 1;
		unsigned SID1      	: 1;
		unsigned SID2      	: 1;
	};
} __TXB0SIDLbits_t;
extern volatile __TXB0SIDLbits_t __at (0xF42) TXB0SIDLbits;

extern __sfr __at (0xF43) TXB0EIDH;
typedef union {
	struct {
		unsigned EID8      	: 1;
		unsigned EID9      	: 1;
		unsigned EID10     	: 1;
		unsigned EID11     	: 1;
		unsigned EID12     	: 1;
		unsigned EID13     	: 1;
		unsigned EID14     	: 1;
		unsigned EID15     	: 1;
	};
} __TXB0EIDHbits_t;
extern volatile __TXB0EIDHbits_t __at (0xF43) TXB0EIDHbits;

extern __sfr __at (0xF44) TXB0EIDL;
typedef union {
	struct {
		unsigned EID0      	: 1;
		unsigned EID1      	: 1;
		unsigned EID2      	: 1;
		unsigned EID3      	: 1;
		unsigned EID4      	: 1;
		unsigned EID5      	: 1;
		unsigned EID6      	: 1;
		unsigned EID7      	: 1;
	};
} __TXB0EIDLbits_t;
extern volatile __TXB0EIDLbits_t __at (0xF44) TXB0EIDLbits;

extern __sfr __at (0xF45) TXB0DLC;
typedef union {
	struct {
		unsigned DLC0      	: 1;
		unsigned DLC1      	: 1;
		unsigned DLC2      	: 1;
		unsigned DLC3      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned TXRTR     	: 1;
		unsigned           	: 1;
	};
} __TXB0DLCbits_t;
extern volatile __TXB0DLCbits_t __at (0xF45) TXB0DLCbits;

extern __sfr __at (0xF46) TXB0D0;
typedef union {
	struct {
		unsigned TXB0D00   	: 1;
		unsigned TXB0D01   	: 1;
		unsigned TXB0D02   	: 1;
		unsigned TXB0D03   	: 1;
		unsigned TXB0D04   	: 1;
		unsigned TXB0D05   	: 1;
		unsigned TXB0D06   	: 1;
		unsigned TXB0D07   	: 1;
	};
} __TXB0D0bits_t;
extern volatile __TXB0D0bits_t __at (0xF46) TXB0D0bits;

extern __sfr __at (0xF47) TXB0D1;
typedef union {
	struct {
		unsigned TXB0D10   	: 1;
		unsigned TXB0D11   	: 1;
		unsigned TXB0D12   	: 1;
		unsigned TXB0D13   	: 1;
		unsigned TXB0D14   	: 1;
		unsigned TXB0D15   	: 1;
		unsigned TXB0D16   	: 1;
		unsigned TXB0D17   	: 1;
	};
} __TXB0D1bits_t;
extern volatile __TXB0D1bits_t __at (0xF47) TXB0D1bits;

extern __sfr __at (0xF48) TXB0D2;
typedef union {
	struct {
		unsigned TXB0D20   	: 1;
		unsigned TXB0D21   	: 1;
		unsigned TXB0D22   	: 1;
		unsigned TXB0D23   	: 1;
		unsigned TXB0D24   	: 1;
		unsigned TXB0D25   	: 1;
		unsigned TXB0D26   	: 1;
		unsigned TXB0D27   	: 1;
	};
} __TXB0D2bits_t;
extern volatile __TXB0D2bits_t __at (0xF48) TXB0D2bits;

extern __sfr __at (0xF49) TXB0D3;
typedef union {
	struct {
		unsigned TXB0D30   	: 1;
		unsigned TXB0D31   	: 1;
		unsigned TXB0D32   	: 1;
		unsigned TXB0D33   	: 1;
		unsigned TXB0D34   	: 1;
		unsigned TXB0D35   	: 1;
		unsigned TXB0D36   	: 1;
		unsigned TXB0D37   	: 1;
	};
} __TXB0D3bits_t;
extern volatile __TXB0D3bits_t __at (0xF49) TXB0D3bits;

extern __sfr __at (0xF4A) TXB0D4;
typedef union {
	struct {
		unsigned TXB0D40   	: 1;
		unsigned TXB0D41   	: 1;
		unsigned TXB0D42   	: 1;
		unsigned TXB0D43   	: 1;
		unsigned TXB0D44   	: 1;
		unsigned TXB0D45   	: 1;
		unsigned TXB0D46   	: 1;
		unsigned TXB0D47   	: 1;
	};
} __TXB0D4bits_t;
extern volatile __TXB0D4bits_t __at (0xF4A) TXB0D4bits;

extern __sfr __at (0xF4B) TXB0D5;
typedef union {
	struct {
		unsigned TXB0D50   	: 1;
		unsigned TXB0D51   	: 1;
		unsigned TXB0D52   	: 1;
		unsigned TXB0D53   	: 1;
		unsigned TXB0D54   	: 1;
		unsigned TXB0D55   	: 1;
		unsigned TXB0D56   	: 1;
		unsigned TXB0D57   	: 1;
	};
} __TXB0D5bits_t;
extern volatile __TXB0D5bits_t __at (0xF4B) TXB0D5bits;

extern __sfr __at (0xF4C) TXB0D6;
typedef union {
	struct {
		unsigned TXB0D60   	: 1;
		unsigned TXB0D61   	: 1;
		unsigned TXB0D62   	: 1;
		unsigned TXB0D63   	: 1;
		unsigned TXB0D64   	: 1;
		unsigned TXB0D65   	: 1;
		unsigned TXB0D66   	: 1;
		unsigned TXB0D67   	: 1;
	};
} __TXB0D6bits_t;
extern volatile __TXB0D6bits_t __at (0xF4C) TXB0D6bits;

extern __sfr __at (0xF4D) TXB0D7;
typedef union {
	struct {
		unsigned TXB0D70   	: 1;
		unsigned TXB0D71   	: 1;
		unsigned TXB0D72   	: 1;
		unsigned TXB0D73   	: 1;
		unsigned TXB0D74   	: 1;
		unsigned TXB0D75   	: 1;
		unsigned TXB0D76   	: 1;
		unsigned TXB0D77   	: 1;
	};
} __TXB0D7bits_t;
extern volatile __TXB0D7bits_t __at (0xF4D) TXB0D7bits;

extern __sfr __at (0xF4E) CANSTAT_RO1;
typedef union {
	struct {
		unsigned ICODE0    	: 1;
		unsigned ICODE1    	: 1;
		unsigned ICODE2    	: 1;
		unsigned ICODE3    	: 1;
		unsigned ICODE4    	: 1;
		unsigned OPMODE    	: 1;
		unsigned REQOP1    	: 1;
		unsigned REQOP2    	: 1;
	};
} __CANSTAT_RO1bits_t;
extern volatile __CANSTAT_RO1bits_t __at (0xF4E) CANSTAT_RO1bits;

extern __sfr __at (0xF4F) CANCON_RO1;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned WIN0      	: 1;
		unsigned WIN1      	: 1;
		unsigned WIN2      	: 1;
		unsigned ABAT      	: 1;
		unsigned REQOP0    	: 1;
		unsigned REQOP1    	: 1;
		unsigned REQOP2    	: 1;
	};
} __CANCON_RO1bits_t;
extern volatile __CANCON_RO1bits_t __at (0xF4F) CANCON_RO1bits;

extern __sfr __at (0xF50) RXB1CON;
typedef union {
	struct {
		unsigned FILHIT0   	: 1;
		unsigned FILHIT1   	: 1;
		unsigned FILHIT2   	: 1;
		unsigned RXRTRRO_RXB1CON	: 1;
		unsigned FILHIT4   	: 1;
		unsigned RXM0      	: 1;
		unsigned RXM1      	: 1;
		unsigned RXFUL     	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned FILHIT3   	: 1;
		unsigned           	: 1;
		unsigned RTRRO     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __RXB1CONbits_t;
extern volatile __RXB1CONbits_t __at (0xF50) RXB1CONbits;

extern __sfr __at (0xF51) RXB1SIDH;
typedef union {
	struct {
		unsigned SID3      	: 1;
		unsigned SID4      	: 1;
		unsigned SID5      	: 1;
		unsigned SID6      	: 1;
		unsigned SID7      	: 1;
		unsigned SID8      	: 1;
		unsigned SID9      	: 1;
		unsigned SID10     	: 1;
	};
} __RXB1SIDHbits_t;
extern volatile __RXB1SIDHbits_t __at (0xF51) RXB1SIDHbits;

extern __sfr __at (0xF52) RXB1SIDL;
typedef union {
	struct {
		unsigned EID16     	: 1;
		unsigned EID17     	: 1;
		unsigned           	: 1;
		unsigned EXID      	: 1;
		unsigned SRR       	: 1;
		unsigned SID0      	: 1;
		unsigned SID1      	: 1;
		unsigned SID2      	: 1;
	};
} __RXB1SIDLbits_t;
extern volatile __RXB1SIDLbits_t __at (0xF52) RXB1SIDLbits;

extern __sfr __at (0xF53) RXB1EIDH;
typedef union {
	struct {
		unsigned EID8      	: 1;
		unsigned EID9      	: 1;
		unsigned EID10     	: 1;
		unsigned EID11     	: 1;
		unsigned EID12     	: 1;
		unsigned EID13     	: 1;
		unsigned EID14     	: 1;
		unsigned EID15     	: 1;
	};
} __RXB1EIDHbits_t;
extern volatile __RXB1EIDHbits_t __at (0xF53) RXB1EIDHbits;

extern __sfr __at (0xF54) RXB1EIDL;
typedef union {
	struct {
		unsigned EID0      	: 1;
		unsigned EID1      	: 1;
		unsigned EID2      	: 1;
		unsigned EID3      	: 1;
		unsigned EID4      	: 1;
		unsigned EID5      	: 1;
		unsigned EID6      	: 1;
		unsigned EID7      	: 1;
	};
} __RXB1EIDLbits_t;
extern volatile __RXB1EIDLbits_t __at (0xF54) RXB1EIDLbits;

extern __sfr __at (0xF55) RXB1DLC;
typedef union {
	struct {
		unsigned DLC0      	: 1;
		unsigned DLC1      	: 1;
		unsigned DLC2      	: 1;
		unsigned DLC3      	: 1;
		unsigned RESRB0    	: 1;
		unsigned RESRB1    	: 1;
		unsigned RXRTR     	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned RB0_RXB1DLC	: 1;
		unsigned RB1_RXB1DLC	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __RXB1DLCbits_t;
extern volatile __RXB1DLCbits_t __at (0xF55) RXB1DLCbits;

extern __sfr __at (0xF56) RXB1D0;
typedef union {
	struct {
		unsigned RXB1D00   	: 1;
		unsigned RXB1D01   	: 1;
		unsigned RXB1D02   	: 1;
		unsigned RXB1D03   	: 1;
		unsigned RXB1D04   	: 1;
		unsigned RXB1D05   	: 1;
		unsigned RXB1D06   	: 1;
		unsigned RXB1D07   	: 1;
	};
} __RXB1D0bits_t;
extern volatile __RXB1D0bits_t __at (0xF56) RXB1D0bits;

extern __sfr __at (0xF57) RXB1D1;
typedef union {
	struct {
		unsigned RXB1D10   	: 1;
		unsigned RXB1D11   	: 1;
		unsigned RXB1D12   	: 1;
		unsigned RXB1D13   	: 1;
		unsigned RXB1D14   	: 1;
		unsigned RXB1D15   	: 1;
		unsigned RXB1D16   	: 1;
		unsigned RXB1D17   	: 1;
	};
} __RXB1D1bits_t;
extern volatile __RXB1D1bits_t __at (0xF57) RXB1D1bits;

extern __sfr __at (0xF58) RXB1D2;
typedef union {
	struct {
		unsigned RXB1D20   	: 1;
		unsigned RXB1D21   	: 1;
		unsigned RXB1D22   	: 1;
		unsigned RXB1D23   	: 1;
		unsigned RXB1D24   	: 1;
		unsigned RXB1D25   	: 1;
		unsigned RXB1D26   	: 1;
		unsigned RXB1D27   	: 1;
	};
} __RXB1D2bits_t;
extern volatile __RXB1D2bits_t __at (0xF58) RXB1D2bits;

extern __sfr __at (0xF59) RXB1D3;
typedef union {
	struct {
		unsigned RXB1D30   	: 1;
		unsigned RXB1D31   	: 1;
		unsigned RXB1D32   	: 1;
		unsigned RXB1D33   	: 1;
		unsigned RXB1D34   	: 1;
		unsigned RXB1D35   	: 1;
		unsigned RXB1D36   	: 1;
		unsigned RXB1D37   	: 1;
	};
} __RXB1D3bits_t;
extern volatile __RXB1D3bits_t __at (0xF59) RXB1D3bits;

extern __sfr __at (0xF5A) RXB1D4;
typedef union {
	struct {
		unsigned RXB1D40   	: 1;
		unsigned RXB1D41   	: 1;
		unsigned RXB1D42   	: 1;
		unsigned RXB1D43   	: 1;
		unsigned RXB1D44   	: 1;
		unsigned RXB1D45   	: 1;
		unsigned RXB1D46   	: 1;
		unsigned RXB1D47   	: 1;
	};
} __RXB1D4bits_t;
extern volatile __RXB1D4bits_t __at (0xF5A) RXB1D4bits;

extern __sfr __at (0xF5B) RXB1D5;
typedef union {
	struct {
		unsigned RXB1D50   	: 1;
		unsigned RXB1D51   	: 1;
		unsigned RXB1D52   	: 1;
		unsigned RXB1D53   	: 1;
		unsigned RXB1D54   	: 1;
		unsigned RXB1D55   	: 1;
		unsigned RXB1D56   	: 1;
		unsigned RXB1D57   	: 1;
	};
} __RXB1D5bits_t;
extern volatile __RXB1D5bits_t __at (0xF5B) RXB1D5bits;

extern __sfr __at (0xF5C) RXB1D6;
typedef union {
	struct {
		unsigned RXB1D60   	: 1;
		unsigned RXB1D61   	: 1;
		unsigned RXB1D62   	: 1;
		unsigned RXB1D63   	: 1;
		unsigned RXB1D64   	: 1;
		unsigned RXB1D65   	: 1;
		unsigned RXB1D66   	: 1;
		unsigned RXB1D67   	: 1;
	};
} __RXB1D6bits_t;
extern volatile __RXB1D6bits_t __at (0xF5C) RXB1D6bits;

extern __sfr __at (0xF5D) RXB1D7;
typedef union {
	struct {
		unsigned RXB1D70   	: 1;
		unsigned RXB1D71   	: 1;
		unsigned RXB1D72   	: 1;
		unsigned RXB1D73   	: 1;
		unsigned RXB1D74   	: 1;
		unsigned RXB1D75   	: 1;
		unsigned RXB1D76   	: 1;
		unsigned RXB1D77   	: 1;
	};
} __RXB1D7bits_t;
extern volatile __RXB1D7bits_t __at (0xF5D) RXB1D7bits;

extern __sfr __at (0xF5E) CANSTAT_RO0;
typedef union {
	struct {
		unsigned ICODE0    	: 1;
		unsigned ICODE1    	: 1;
		unsigned ICODE2    	: 1;
		unsigned ICODE3    	: 1;
		unsigned ICODE4    	: 1;
		unsigned OPMODE    	: 1;
		unsigned REQOP1    	: 1;
		unsigned REQOP2    	: 1;
	};
} __CANSTAT_RO0bits_t;
extern volatile __CANSTAT_RO0bits_t __at (0xF5E) CANSTAT_RO0bits;

extern __sfr __at (0xF5F) CANCON_RO0;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned WIN0      	: 1;
		unsigned WIN1      	: 1;
		unsigned WIN2      	: 1;
		unsigned ABAT      	: 1;
		unsigned REQOP0    	: 1;
		unsigned REQOP1    	: 1;
		unsigned REQOP2    	: 1;
	};
} __CANCON_RO0bits_t;
extern volatile __CANCON_RO0bits_t __at (0xF5F) CANCON_RO0bits;

extern __sfr __at (0xF60) RXB0CON;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned JTOFF     	: 1;
		unsigned RXB0DBEN  	: 1;
		unsigned RXRTRRO_RXB0CON	: 1;
		unsigned           	: 1;
		unsigned RXM0      	: 1;
		unsigned RXM1      	: 1;
		unsigned RXFUL     	: 1;
	};
	struct {
		unsigned FILHIT0   	: 1;
		unsigned FILHIT1   	: 1;
		unsigned FILHIT2   	: 1;
		unsigned FILHIT3   	: 1;
		unsigned FILHIT4   	: 1;
		unsigned RTRRO     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __RXB0CONbits_t;
extern volatile __RXB0CONbits_t __at (0xF60) RXB0CONbits;

extern __sfr __at (0xF61) RXB0SIDH;
typedef union {
	struct {
		unsigned SID3      	: 1;
		unsigned SID4      	: 1;
		unsigned SID5      	: 1;
		unsigned SID6      	: 1;
		unsigned SID7      	: 1;
		unsigned SID8      	: 1;
		unsigned SID9      	: 1;
		unsigned SID10     	: 1;
	};
} __RXB0SIDHbits_t;
extern volatile __RXB0SIDHbits_t __at (0xF61) RXB0SIDHbits;

extern __sfr __at (0xF62) RXB0SIDL;
typedef union {
	struct {
		unsigned EID16     	: 1;
		unsigned EID17     	: 1;
		unsigned           	: 1;
		unsigned EXID      	: 1;
		unsigned SRR       	: 1;
		unsigned SID0      	: 1;
		unsigned SID1      	: 1;
		unsigned SID2      	: 1;
	};
} __RXB0SIDLbits_t;
extern volatile __RXB0SIDLbits_t __at (0xF62) RXB0SIDLbits;

extern __sfr __at (0xF63) RXB0EIDH;
typedef union {
	struct {
		unsigned EID8      	: 1;
		unsigned EID9      	: 1;
		unsigned EID10     	: 1;
		unsigned EID11     	: 1;
		unsigned EID12     	: 1;
		unsigned EID13     	: 1;
		unsigned EID14     	: 1;
		unsigned EID15     	: 1;
	};
} __RXB0EIDHbits_t;
extern volatile __RXB0EIDHbits_t __at (0xF63) RXB0EIDHbits;

extern __sfr __at (0xF64) RXB0EIDL;
typedef union {
	struct {
		unsigned EID0      	: 1;
		unsigned EID1      	: 1;
		unsigned EID2      	: 1;
		unsigned EID3      	: 1;
		unsigned EID4      	: 1;
		unsigned EID5      	: 1;
		unsigned EID6      	: 1;
		unsigned EID7      	: 1;
	};
} __RXB0EIDLbits_t;
extern volatile __RXB0EIDLbits_t __at (0xF64) RXB0EIDLbits;

extern __sfr __at (0xF65) RXB0DLC;
typedef union {
	struct {
		unsigned DLC0      	: 1;
		unsigned DLC1      	: 1;
		unsigned DLC2      	: 1;
		unsigned DLC3      	: 1;
		unsigned RESRB0    	: 1;
		unsigned RESRB1    	: 1;
		unsigned RXRTR     	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned RB0_RXB0DLC	: 1;
		unsigned RB1_RXB0DLC	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __RXB0DLCbits_t;
extern volatile __RXB0DLCbits_t __at (0xF65) RXB0DLCbits;

extern __sfr __at (0xF66) RXB0D0;
typedef union {
	struct {
		unsigned RXB0D00   	: 1;
		unsigned RXB0D01   	: 1;
		unsigned RXB0D02   	: 1;
		unsigned RXB0D03   	: 1;
		unsigned RXB0D04   	: 1;
		unsigned RXB0D05   	: 1;
		unsigned RXB0D06   	: 1;
		unsigned RXB0D07   	: 1;
	};
} __RXB0D0bits_t;
extern volatile __RXB0D0bits_t __at (0xF66) RXB0D0bits;

extern __sfr __at (0xF67) RXB0D1;
typedef union {
	struct {
		unsigned RXB0D10   	: 1;
		unsigned RXB0D11   	: 1;
		unsigned RXB0D12   	: 1;
		unsigned RXB0D13   	: 1;
		unsigned RXB0D14   	: 1;
		unsigned RXB0D15   	: 1;
		unsigned RXB0D16   	: 1;
		unsigned RXB0D17   	: 1;
	};
} __RXB0D1bits_t;
extern volatile __RXB0D1bits_t __at (0xF67) RXB0D1bits;

extern __sfr __at (0xF68) RXB0D2;
typedef union {
	struct {
		unsigned RXB0D20   	: 1;
		unsigned RXB0D21   	: 1;
		unsigned RXB0D22   	: 1;
		unsigned RXB0D23   	: 1;
		unsigned RXB0D24   	: 1;
		unsigned RXB0D25   	: 1;
		unsigned RXB0D26   	: 1;
		unsigned RXB0D27   	: 1;
	};
} __RXB0D2bits_t;
extern volatile __RXB0D2bits_t __at (0xF68) RXB0D2bits;

extern __sfr __at (0xF69) RXB0D3;
typedef union {
	struct {
		unsigned RXB0D30   	: 1;
		unsigned RXB0D31   	: 1;
		unsigned RXB0D32   	: 1;
		unsigned RXB0D33   	: 1;
		unsigned RXB0D34   	: 1;
		unsigned RXB0D35   	: 1;
		unsigned RXB0D36   	: 1;
		unsigned RXB0D37   	: 1;
	};
} __RXB0D3bits_t;
extern volatile __RXB0D3bits_t __at (0xF69) RXB0D3bits;

extern __sfr __at (0xF6A) RXB0D4;
typedef union {
	struct {
		unsigned RXB0D40   	: 1;
		unsigned RXB0D41   	: 1;
		unsigned RXB0D42   	: 1;
		unsigned RXB0D43   	: 1;
		unsigned RXB0D44   	: 1;
		unsigned RXB0D45   	: 1;
		unsigned RXB0D46   	: 1;
		unsigned RXB0D47   	: 1;
	};
} __RXB0D4bits_t;
extern volatile __RXB0D4bits_t __at (0xF6A) RXB0D4bits;

extern __sfr __at (0xF6B) RXB0D5;
typedef union {
	struct {
		unsigned RXB0D50   	: 1;
		unsigned RXB0D51   	: 1;
		unsigned RXB0D52   	: 1;
		unsigned RXB0D53   	: 1;
		unsigned RXB0D54   	: 1;
		unsigned RXB0D55   	: 1;
		unsigned RXB0D56   	: 1;
		unsigned RXB0D57   	: 1;
	};
} __RXB0D5bits_t;
extern volatile __RXB0D5bits_t __at (0xF6B) RXB0D5bits;

extern __sfr __at (0xF6C) RXB0D6;
typedef union {
	struct {
		unsigned RXB0D60   	: 1;
		unsigned RXB0D61   	: 1;
		unsigned RXB0D62   	: 1;
		unsigned RXB0D63   	: 1;
		unsigned RXB0D64   	: 1;
		unsigned RXB0D65   	: 1;
		unsigned RXB0D66   	: 1;
		unsigned RXB0D67   	: 1;
	};
} __RXB0D6bits_t;
extern volatile __RXB0D6bits_t __at (0xF6C) RXB0D6bits;

extern __sfr __at (0xF6D) RXB0D7;
typedef union {
	struct {
		unsigned RXB0D70   	: 1;
		unsigned RXB0D71   	: 1;
		unsigned RXB0D72   	: 1;
		unsigned RXB0D73   	: 1;
		unsigned RXB0D74   	: 1;
		unsigned RXB0D75   	: 1;
		unsigned RXB0D76   	: 1;
		unsigned RXB0D77   	: 1;
	};
} __RXB0D7bits_t;
extern volatile __RXB0D7bits_t __at (0xF6D) RXB0D7bits;

extern __sfr __at (0xF6E) CANSTAT;
typedef union {
	struct {
		unsigned EICODE0   	: 1;
		unsigned ICODE1    	: 1;
		unsigned ICODE2    	: 1;
		unsigned ICODE3    	: 1;
		unsigned EICODE4   	: 1;
		unsigned OPMODE0   	: 1;
		unsigned OPMODE1   	: 1;
		unsigned OPMODE2   	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned EICODE1   	: 1;
		unsigned EICODE2   	: 1;
		unsigned EICODE3   	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __CANSTATbits_t;
extern volatile __CANSTATbits_t __at (0xF6E) CANSTATbits;

extern __sfr __at (0xF6F) CANCON;
typedef union {
	struct {
		unsigned FP0       	: 1;
		unsigned WIN0      	: 1;
		unsigned WIN1      	: 1;
		unsigned WIN2      	: 1;
		unsigned ABAT      	: 1;
		unsigned REQOP0    	: 1;
		unsigned REQOP1    	: 1;
		unsigned REQOP2    	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned FP1       	: 1;
		unsigned FP2       	: 1;
		unsigned FP3       	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __CANCONbits_t;
extern volatile __CANCONbits_t __at (0xF6F) CANCONbits;

extern __sfr __at (0xF70) BRGCON1;
typedef union {
	struct {
		unsigned BRP0      	: 1;
		unsigned BRP1      	: 1;
		unsigned BRP2      	: 1;
		unsigned BRP3      	: 1;
		unsigned BRP4      	: 1;
		unsigned BRP5      	: 1;
		unsigned SJW0      	: 1;
		unsigned SJW1      	: 1;
	};
} __BRGCON1bits_t;
extern volatile __BRGCON1bits_t __at (0xF70) BRGCON1bits;

extern __sfr __at (0xF71) BRGCON2;
typedef union {
	struct {
		unsigned PRSEG0    	: 1;
		unsigned PRSEG1    	: 1;
		unsigned PRSEG2    	: 1;
		unsigned SEG1PH0   	: 1;
		unsigned SEG1PH1   	: 1;
		unsigned SEG1PH2   	: 1;
		unsigned SAM       	: 1;
		unsigned SEG2PHTS  	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned SEG2PHT   	: 1;
	};
} __BRGCON2bits_t;
extern volatile __BRGCON2bits_t __at (0xF71) BRGCON2bits;

extern __sfr __at (0xF72) BRGCON3;
typedef union {
	struct {
		unsigned SEG2PH0   	: 1;
		unsigned SEG2PH1   	: 1;
		unsigned SEG2PH2   	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned WAKFIL    	: 1;
		unsigned WAKDIS    	: 1;
	};
} __BRGCON3bits_t;
extern volatile __BRGCON3bits_t __at (0xF72) BRGCON3bits;

extern __sfr __at (0xF73) CIOCON;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned CANCAP    	: 1;
		unsigned ENDRHI    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __CIOCONbits_t;
extern volatile __CIOCONbits_t __at (0xF73) CIOCONbits;

extern __sfr __at (0xF74) COMSTAT;
typedef union {
	struct {
		unsigned EWARN     	: 1;
		unsigned RXWARN    	: 1;
		unsigned TXWARN    	: 1;
		unsigned RXBP      	: 1;
		unsigned TXBP      	: 1;
		unsigned TXBO      	: 1;
		unsigned RXB1OVFL  	: 1;
		unsigned RXB0OVFL  	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned RXBnOVFL  	: 1;
		unsigned FIFOEMPTY 	: 1;
	};
} __COMSTATbits_t;
extern volatile __COMSTATbits_t __at (0xF74) COMSTATbits;

extern __sfr __at (0xF75) RXERRCNT;
typedef union {
	struct {
		unsigned REC0      	: 1;
		unsigned REC1      	: 1;
		unsigned REC2      	: 1;
		unsigned REC3      	: 1;
		unsigned REC4      	: 1;
		unsigned REC5      	: 1;
		unsigned REC6      	: 1;
		unsigned REC7      	: 1;
	};
} __RXERRCNTbits_t;
extern volatile __RXERRCNTbits_t __at (0xF75) RXERRCNTbits;

extern __sfr __at (0xF76) TXERRCNT;
typedef union {
	struct {
		unsigned TEC0      	: 1;
		unsigned TEC1      	: 1;
		unsigned TEC2      	: 1;
		unsigned TEC3      	: 1;
		unsigned TEC4      	: 1;
		unsigned TEC5      	: 1;
		unsigned TEC6      	: 1;
		unsigned TEC7      	: 1;
	};
} __TXERRCNTbits_t;
extern volatile __TXERRCNTbits_t __at (0xF76) TXERRCNTbits;

extern __sfr __at (0xF77) ECANCON;
typedef union {
	struct {
		unsigned EWIN0     	: 1;
		unsigned EWIN1     	: 1;
		unsigned EWIN2     	: 1;
		unsigned EWIN3     	: 1;
		unsigned EWIN4     	: 1;
		unsigned FIFOWM    	: 1;
		unsigned MDSEL0    	: 1;
		unsigned MDSEL1    	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned F         	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __ECANCONbits_t;
extern volatile __ECANCONbits_t __at (0xF77) ECANCONbits;

extern __sfr __at (0xF80) PORTA;
typedef union {
	struct {
		unsigned RA0       	: 1;
		unsigned RA1       	: 1;
		unsigned RA2       	: 1;
		unsigned RA3       	: 1;
		unsigned RA4       	: 1;
		unsigned RA5       	: 1;
		unsigned RA6       	: 1;
		unsigned RA7       	: 1;
	};
	struct {
		unsigned AN0       	: 1;
		unsigned AN1       	: 1;
		unsigned AN2       	: 1;
		unsigned AN3       	: 1;
		unsigned T0CKI     	: 1;
		unsigned AN4       	: 1;
		unsigned OSC2      	: 1;
		unsigned OSC1      	: 1;
	};
	struct {
		unsigned CVREF     	: 1;
		unsigned           	: 1;
		unsigned VREFM     	: 1;
		unsigned VREFP     	: 1;
		unsigned           	: 1;
		unsigned LVDIN     	: 1;
		unsigned CLKO      	: 1;
		unsigned CLKI      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned SS        	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_SS    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned HLVDIN    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __PORTAbits_t;
extern volatile __PORTAbits_t __at (0xF80) PORTAbits;

extern __sfr __at (0xF81) PORTB;
typedef union {
	struct {
		unsigned RB0_PORTB 	: 1;
		unsigned RB1_PORTB 	: 1;
		unsigned RB2       	: 1;
		unsigned RB3       	: 1;
		unsigned RB4       	: 1;
		unsigned RB5       	: 1;
		unsigned RB6       	: 1;
		unsigned RB7       	: 1;
	};
	struct {
		unsigned INT0      	: 1;
		unsigned INT1      	: 1;
		unsigned INT2      	: 1;
		unsigned CANRX     	: 1;
		unsigned KBI0      	: 1;
		unsigned KBI1      	: 1;
		unsigned KBI2      	: 1;
		unsigned KBI3      	: 1;
	};
	struct {
		unsigned AN10      	: 1;
		unsigned AN8       	: 1;
		unsigned CANTX     	: 1;
		unsigned           	: 1;
		unsigned AN9       	: 1;
		unsigned PGM       	: 1;
		unsigned PGC       	: 1;
		unsigned PGD       	: 1;
	};
	struct {
		unsigned FLT0      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __PORTBbits_t;
extern volatile __PORTBbits_t __at (0xF81) PORTBbits;

extern __sfr __at (0xF82) PORTC;
typedef union {
	struct {
		unsigned RC0       	: 1;
		unsigned RC1       	: 1;
		unsigned RC2       	: 1;
		unsigned RC3       	: 1;
		unsigned RC4       	: 1;
		unsigned RC5       	: 1;
		unsigned RC6       	: 1;
		unsigned RC7       	: 1;
	};
	struct {
		unsigned T1OSO     	: 1;
		unsigned T1OSI     	: 1;
		unsigned CCP1      	: 1;
		unsigned SCK       	: 1;
		unsigned SDI       	: 1;
		unsigned SDO       	: 1;
		unsigned TX        	: 1;
		unsigned RX        	: 1;
	};
	struct {
		unsigned T13CKI    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned SCL       	: 1;
		unsigned SDA       	: 1;
		unsigned           	: 1;
		unsigned CK        	: 1;
		unsigned DT        	: 1;
	};
} __PORTCbits_t;
extern volatile __PORTCbits_t __at (0xF82) PORTCbits;


extern __sfr __at (0xF89) LATA;
typedef union {
	struct {
		unsigned LATA0     	: 1;
		unsigned LATA1     	: 1;
		unsigned LATA2     	: 1;
		unsigned LATA3     	: 1;
		unsigned LATA4     	: 1;
		unsigned LATA5     	: 1;
		unsigned LATA6     	: 1;
		unsigned LATA7     	: 1;
	};
} __LATAbits_t;
extern volatile __LATAbits_t __at (0xF89) LATAbits;

extern __sfr __at (0xF8A) LATB;
typedef union {
	struct {
		unsigned LATB0     	: 1;
		unsigned LATB1     	: 1;
		unsigned LATB2     	: 1;
		unsigned LATB3     	: 1;
		unsigned LATB4     	: 1;
		unsigned LATB5     	: 1;
		unsigned LATB6     	: 1;
		unsigned LATB7     	: 1;
	};
} __LATBbits_t;
extern volatile __LATBbits_t __at (0xF8A) LATBbits;

extern __sfr __at (0xF8B) LATC;
typedef union {
	struct {
		unsigned LATC0     	: 1;
		unsigned LATC1     	: 1;
		unsigned LATC2     	: 1;
		unsigned LATC3     	: 1;
		unsigned LATC4     	: 1;
		unsigned LATC5     	: 1;
		unsigned LATC6     	: 1;
		unsigned LATC7     	: 1;
	};
} __LATCbits_t;
extern volatile __LATCbits_t __at (0xF8B) LATCbits;

extern __sfr __at (0xF92) DDRA;
typedef union {
	struct {
		unsigned RA0       	: 1;
		unsigned RA1       	: 1;
		unsigned RA2       	: 1;
		unsigned RA3       	: 1;
		unsigned RA4       	: 1;
		unsigned RA5       	: 1;
		unsigned RA6       	: 1;
		unsigned           	: 1;
	};
} __DDRAbits_t;
extern volatile __DDRAbits_t __at (0xF92) DDRAbits;

extern __sfr __at (0xF92) TRISA;
typedef union {
	struct {
		unsigned TRISA0    	: 1;
		unsigned TRISA1    	: 1;
		unsigned TRISA2    	: 1;
		unsigned TRISA3    	: 1;
		unsigned TRISA4    	: 1;
		unsigned TRISA5    	: 1;
		unsigned TRISA6    	: 1;
		unsigned TRISA7    	: 1;
	};
} __TRISAbits_t;
extern volatile __TRISAbits_t __at (0xF92) TRISAbits;

extern __sfr __at (0xF93) DDRB;
typedef union {
	struct {
		unsigned RB0_DDRB  	: 1;
		unsigned RB1_DDRB  	: 1;
		unsigned RB2       	: 1;
		unsigned RB3       	: 1;
		unsigned RB4       	: 1;
		unsigned RB5       	: 1;
		unsigned RB6       	: 1;
		unsigned RB7       	: 1;
	};
} __DDRBbits_t;
extern volatile __DDRBbits_t __at (0xF93) DDRBbits;

extern __sfr __at (0xF93) TRISB;
typedef union {
	struct {
		unsigned TRISB0    	: 1;
		unsigned TRISB1    	: 1;
		unsigned TRISB2    	: 1;
		unsigned TRISB3    	: 1;
		unsigned TRISB4    	: 1;
		unsigned TRISB5    	: 1;
		unsigned TRISB6    	: 1;
		unsigned TRISB7    	: 1;
	};
} __TRISBbits_t;
extern volatile __TRISBbits_t __at (0xF93) TRISBbits;

extern __sfr __at (0xF94) DDRC;
typedef union {
	struct {
		unsigned RC0       	: 1;
		unsigned RC1       	: 1;
		unsigned RC2       	: 1;
		unsigned RC3       	: 1;
		unsigned RC4       	: 1;
		unsigned RC5       	: 1;
		unsigned RC6       	: 1;
		unsigned RC7       	: 1;
	};
} __DDRCbits_t;
extern volatile __DDRCbits_t __at (0xF94) DDRCbits;

extern __sfr __at (0xF94) TRISC;
typedef union {
	struct {
		unsigned TRISC0    	: 1;
		unsigned TRISC1    	: 1;
		unsigned TRISC2    	: 1;
		unsigned TRISC3    	: 1;
		unsigned TRISC4    	: 1;
		unsigned TRISC5    	: 1;
		unsigned TRISC6    	: 1;
		unsigned TRISC7    	: 1;
	};
} __TRISCbits_t;
extern volatile __TRISCbits_t __at (0xF94) TRISCbits;

extern __sfr __at (0xF9B) OSCTUNE;
typedef union {
	struct {
		unsigned TUN0      	: 1;
		unsigned TUN1      	: 1;
		unsigned TUN2      	: 1;
		unsigned TUN3      	: 1;
		unsigned TUN4      	: 1;
		unsigned           	: 1;
		unsigned PLLEN     	: 1;
		unsigned INTSCR    	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned INTSRC    	: 1;
	};
} __OSCTUNEbits_t;
extern volatile __OSCTUNEbits_t __at (0xF9B) OSCTUNEbits;

extern __sfr __at (0xF9D) PIE1;
typedef union {
	struct {
		unsigned TMR1IE    	: 1;
		unsigned TMR2IE    	: 1;
		unsigned CCP1IE    	: 1;
		unsigned SSPIE     	: 1;
		unsigned TXIE      	: 1;
		unsigned RCIE      	: 1;
		unsigned ADIE      	: 1;
		unsigned           	: 1;
	};
} __PIE1bits_t;
extern volatile __PIE1bits_t __at (0xF9D) PIE1bits;

extern __sfr __at (0xF9E) PIR1;
typedef union {
	struct {
		unsigned TMR1IF    	: 1;
		unsigned TMR2IF    	: 1;
		unsigned CCP1IF    	: 1;
		unsigned SSPIF     	: 1;
		unsigned TXIF      	: 1;
		unsigned RCIF      	: 1;
		unsigned ADIF      	: 1;
		unsigned           	: 1;
	};
} __PIR1bits_t;
extern volatile __PIR1bits_t __at (0xF9E) PIR1bits;

extern __sfr __at (0xF9F) IPR1;
typedef union {
	struct {
		unsigned TMR1IP    	: 1;
		unsigned TMR2IP    	: 1;
		unsigned CCP1IP    	: 1;
		unsigned SSPIP     	: 1;
		unsigned TXBIP     	: 1;
		unsigned RCIP      	: 1;
		unsigned ADIP      	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned TXIP      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __IPR1bits_t;
extern volatile __IPR1bits_t __at (0xF9F) IPR1bits;

extern __sfr __at (0xFA0) PIE2;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned TMR3IE    	: 1;
		unsigned LVDIE     	: 1;
		unsigned BCLIE     	: 1;
		unsigned EEIE      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned OSCFIE    	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned HLVDIE    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __PIE2bits_t;
extern volatile __PIE2bits_t __at (0xFA0) PIE2bits;

extern __sfr __at (0xFA1) PIR2;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned TMR3IF    	: 1;
		unsigned LVDIF     	: 1;
		unsigned BCLIF     	: 1;
		unsigned EEIF      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned OSCFIF    	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned HLVDIF    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __PIR2bits_t;
extern volatile __PIR2bits_t __at (0xFA1) PIR2bits;

extern __sfr __at (0xFA2) IPR2;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned TMR3IP    	: 1;
		unsigned LVDIP     	: 1;
		unsigned BCLIP     	: 1;
		unsigned EEIP      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned OSCFIP    	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned HLVDIP    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __IPR2bits_t;
extern volatile __IPR2bits_t __at (0xFA2) IPR2bits;

extern __sfr __at (0xFA3) PIE3;
typedef union {
	struct {
		unsigned RXB0IE    	: 1;
		unsigned RXB1IE    	: 1;
		unsigned TXB0IE    	: 1;
		unsigned TXB1IE    	: 1;
		unsigned TXB2IE    	: 1;
		unsigned ERRIE     	: 1;
		unsigned WAKIE     	: 1;
		unsigned IRXIE     	: 1;
	};
	struct {
		unsigned FIFOWMIE  	: 1;
		unsigned RXBnIE    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned TXBnIE    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned FIFOMWIE  	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __PIE3bits_t;
extern volatile __PIE3bits_t __at (0xFA3) PIE3bits;

extern __sfr __at (0xFA4) PIR3;
typedef union {
	struct {
		unsigned RXB0IF    	: 1;
		unsigned RXB1IF    	: 1;
		unsigned TXB0IF    	: 1;
		unsigned TXB1IF    	: 1;
		unsigned TXB2IF    	: 1;
		unsigned ERRIF     	: 1;
		unsigned WAKIF     	: 1;
		unsigned IRXIF     	: 1;
	};
	struct {
		unsigned FIFOWMIF  	: 1;
		unsigned RXBnIF    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned TXBnIF    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __PIR3bits_t;
extern volatile __PIR3bits_t __at (0xFA4) PIR3bits;

extern __sfr __at (0xFA5) IPR3;
typedef union {
	struct {
		unsigned RXB0IP    	: 1;
		unsigned RXB1IP    	: 1;
		unsigned TXB0IP    	: 1;
		unsigned TXB1IP    	: 1;
		unsigned TXB2IP    	: 1;
		unsigned ERRIP     	: 1;
		unsigned WAKIP     	: 1;
		unsigned IRXIP     	: 1;
	};
	struct {
		unsigned FIFOWMIP  	: 1;
		unsigned RXBnIP    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned TXBnIP    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __IPR3bits_t;
extern volatile __IPR3bits_t __at (0xFA5) IPR3bits;

extern __sfr __at (0xFA6) EECON1;
typedef union {
	struct {
		unsigned RD        	: 1;
		unsigned WR        	: 1;
		unsigned WREN      	: 1;
		unsigned WRERR     	: 1;
		unsigned FREE      	: 1;
		unsigned           	: 1;
		unsigned CFGS      	: 1;
		unsigned EEPGD     	: 1;
	};
} __EECON1bits_t;
extern volatile __EECON1bits_t __at (0xFA6) EECON1bits;

extern __sfr __at (0xFA7) EECON2;

extern __sfr __at (0xFA8) EEDATA;

extern __sfr __at (0xFA9) EEADR;

extern __sfr __at (0xFAA) EEADRH;

extern __sfr __at (0xFAB) RCSTA;
typedef union {
	struct {
		unsigned RX9D      	: 1;
		unsigned OERR      	: 1;
		unsigned FERR      	: 1;
		unsigned ADEN      	: 1;
		unsigned CREN      	: 1;
		unsigned SREN      	: 1;
		unsigned RX9       	: 1;
		unsigned SPEN      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned ADDEN     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __RCSTAbits_t;
extern volatile __RCSTAbits_t __at (0xFAB) RCSTAbits;

extern __sfr __at (0xFAC) TXSTA;
typedef union {
	struct {
		unsigned TX9D      	: 1;
		unsigned TRMT      	: 1;
		unsigned BRGH      	: 1;
		unsigned SENDB     	: 1;
		unsigned SYNC      	: 1;
		unsigned TXEN      	: 1;
		unsigned TX9       	: 1;
		unsigned CSRC      	: 1;
	};
} __TXSTAbits_t;
extern volatile __TXSTAbits_t __at (0xFAC) TXSTAbits;

extern __sfr __at (0xFAD) TXREG;

extern __sfr __at (0xFAE) RCREG;

extern __sfr __at (0xFAF) SPBRG;

extern __sfr __at (0xFB0) SPBRGH;

extern __sfr __at (0xFB1) T3CON;
typedef union {
	struct {
		unsigned TMR3ON    	: 1;
		unsigned TMR3CS    	: 1;
		unsigned T3SYNC    	: 1;
		unsigned T3CCP1    	: 1;
		unsigned T3CKPS0   	: 1;
		unsigned T3CKPS1   	: 1;
		unsigned T3CCP2    	: 1;
		unsigned RD16      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned T3NSYNC   	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned T3ECCP1   	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_T3SYNC	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __T3CONbits_t;
extern volatile __T3CONbits_t __at (0xFB1) T3CONbits;

extern __sfr __at (0xFB2) TMR3L;

extern __sfr __at (0xFB3) TMR3H;

extern __sfr __at (0xFB8) BAUDCON;
typedef union {
	struct {
		unsigned ABDEN     	: 1;
		unsigned WUE       	: 1;
		unsigned           	: 1;
		unsigned BRG16     	: 1;
		unsigned SCKP      	: 1;
		unsigned           	: 1;
		unsigned RCIDL     	: 1;
		unsigned ABDOVF    	: 1;
	};
} __BAUDCONbits_t;
extern volatile __BAUDCONbits_t __at (0xFB8) BAUDCONbits;

extern __sfr __at (0xFBD) CCP1CON;
typedef union {
	struct {
		unsigned CCP1M0    	: 1;
		unsigned CCP1M1    	: 1;
		unsigned CCP1M2    	: 1;
		unsigned CCP1M3    	: 1;
		unsigned DC1B0     	: 1;
		unsigned DC1B1     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __CCP1CONbits_t;
extern volatile __CCP1CONbits_t __at (0xFBD) CCP1CONbits;

extern __sfr __at (0xFBE) CCPR1;

extern __sfr __at (0xFBE) CCPR1L;

extern __sfr __at (0xFBF) CCPR1H;

extern __sfr __at (0xFC0) ADCON2;
typedef union {
	struct {
		unsigned ADCS0     	: 1;
		unsigned ADCS1     	: 1;
		unsigned ADCS2     	: 1;
		unsigned ACQT0     	: 1;
		unsigned ACQT1     	: 1;
		unsigned ACQT2     	: 1;
		unsigned           	: 1;
		unsigned ADFM      	: 1;
	};
} __ADCON2bits_t;
extern volatile __ADCON2bits_t __at (0xFC0) ADCON2bits;

extern __sfr __at (0xFC1) ADCON1;
typedef union {
	struct {
		unsigned PCFG0     	: 1;
		unsigned PCFG1     	: 1;
		unsigned PCFG2     	: 1;
		unsigned PCFG3     	: 1;
		unsigned VCFG0     	: 1;
		unsigned VCFG1     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __ADCON1bits_t;
extern volatile __ADCON1bits_t __at (0xFC1) ADCON1bits;

extern __sfr __at (0xFC2) ADCON0;
typedef union {
	struct {
		unsigned ADON      	: 1;
		unsigned GO_DONE   	: 1;
		unsigned CHS0      	: 1;
		unsigned CHS1      	: 1;
		unsigned CHS2      	: 1;
		unsigned CHS3      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned DONE      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned GO        	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned NOT_DONE  	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __ADCON0bits_t;
extern volatile __ADCON0bits_t __at (0xFC2) ADCON0bits;

extern __sfr __at (0xFC3) ADRES;

extern __sfr __at (0xFC3) ADRESL;

extern __sfr __at (0xFC4) ADRESH;

extern __sfr __at (0xFC5) SSPCON2;
typedef union {
	struct {
		unsigned SEN       	: 1;
		unsigned RSEN      	: 1;
		unsigned PEN       	: 1;
		unsigned RCEN      	: 1;
		unsigned ACKEN     	: 1;
		unsigned ACKDT     	: 1;
		unsigned ACKSTAT   	: 1;
		unsigned GCEN      	: 1;
	};
} __SSPCON2bits_t;
extern volatile __SSPCON2bits_t __at (0xFC5) SSPCON2bits;

extern __sfr __at (0xFC6) SSPCON1;
typedef union {
	struct {
		unsigned SSPM0     	: 1;
		unsigned SSPM1     	: 1;
		unsigned SSPM2     	: 1;
		unsigned SSPM3     	: 1;
		unsigned CKP       	: 1;
		unsigned SSPEN     	: 1;
		unsigned SSPOV     	: 1;
		unsigned WCOL      	: 1;
	};
} __SSPCON1bits_t;
extern volatile __SSPCON1bits_t __at (0xFC6) SSPCON1bits;

extern __sfr __at (0xFC7) SSPSTAT;
typedef union {
	struct {
		unsigned BF        	: 1;
		unsigned UA        	: 1;
		unsigned R_W       	: 1;
		unsigned S         	: 1;
		unsigned P         	: 1;
		unsigned D_A       	: 1;
		unsigned CKE       	: 1;
		unsigned SMP       	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned I2C_READ  	: 1;
		unsigned I2C_START 	: 1;
		unsigned I2C_STOP  	: 1;
		unsigned I2C_DAT   	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_W     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_A     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_WRITE 	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_ADDRESS	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned READ_WRITE	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned DATA_ADDRESS	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned R         	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned D         	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __SSPSTATbits_t;
extern volatile __SSPSTATbits_t __at (0xFC7) SSPSTATbits;

extern __sfr __at (0xFC8) SSPADD;

extern __sfr __at (0xFC9) SSPBUF;

extern __sfr __at (0xFCA) T2CON;
typedef union {
	struct {
		unsigned T2CKPS0   	: 1;
		unsigned T2CKPS1   	: 1;
		unsigned TMR2ON    	: 1;
		unsigned T2OUTPS0  	: 1;
		unsigned T2OUTPS1  	: 1;
		unsigned T2OUTPS2  	: 1;
		unsigned T2OUTPS3  	: 1;
		unsigned           	: 1;
	};
} __T2CONbits_t;
extern volatile __T2CONbits_t __at (0xFCA) T2CONbits;

extern __sfr __at (0xFCB) PR2;

extern __sfr __at (0xFCC) TMR2;

extern __sfr __at (0xFCD) T1CON;
typedef union {
	struct {
		unsigned TMR1ON    	: 1;
		unsigned TMR1CS    	: 1;
		unsigned T1SYNC    	: 1;
		unsigned T1OSCEN   	: 1;
		unsigned T1CKPS0   	: 1;
		unsigned T1CKPS1   	: 1;
		unsigned T1RUN     	: 1;
		unsigned RD16      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned T1INSYNC  	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_T1SYNC	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __T1CONbits_t;
extern volatile __T1CONbits_t __at (0xFCD) T1CONbits;

extern __sfr __at (0xFCE) TMR1L;

extern __sfr __at (0xFCF) TMR1H;

extern __sfr __at (0xFD0) RCON;
typedef union {
	struct {
		unsigned NOT_BOR   	: 1;
		unsigned NOT_POR   	: 1;
		unsigned NOT_PD    	: 1;
		unsigned NOT_TO    	: 1;
		unsigned NOT_RI    	: 1;
		unsigned           	: 1;
		unsigned SBOREN    	: 1;
		unsigned IPEN      	: 1;
	};
	struct {
		unsigned BOR       	: 1;
		unsigned POR       	: 1;
		unsigned PD        	: 1;
		unsigned TO        	: 1;
		unsigned RI        	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __RCONbits_t;
extern volatile __RCONbits_t __at (0xFD0) RCONbits;

extern __sfr __at (0xFD1) WDTCON;
typedef union {
	struct {
		unsigned SWDTEN    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned SWDTE     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __WDTCONbits_t;
extern volatile __WDTCONbits_t __at (0xFD1) WDTCONbits;

extern __sfr __at (0xFD2) HLVDCON;
typedef union {
	struct {
		unsigned LVDL0     	: 1;
		unsigned LVDL1     	: 1;
		unsigned LVDL2     	: 1;
		unsigned LVDL3     	: 1;
		unsigned LVDEN     	: 1;
		unsigned IRVST     	: 1;
		unsigned           	: 1;
		unsigned VDIRMAG   	: 1;
	};
	struct {
		unsigned LVV0      	: 1;
		unsigned LVV1      	: 1;
		unsigned LVV2      	: 1;
		unsigned LVV3      	: 1;
		unsigned HLVDEN    	: 1;
		unsigned BGST      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned HLVDL0    	: 1;
		unsigned HLVDL1    	: 1;
		unsigned HLVDL2    	: 1;
		unsigned HLVDL3    	: 1;
		unsigned           	: 1;
		unsigned IVRST     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __HLVDCONbits_t;
extern volatile __HLVDCONbits_t __at (0xFD2) HLVDCONbits;

extern __sfr __at (0xFD2) LVDCON;
typedef union {
	struct {
		unsigned LVDL0     	: 1;
		unsigned LVDL1     	: 1;
		unsigned LVDL2     	: 1;
		unsigned LVDL3     	: 1;
		unsigned LVDEN     	: 1;
		unsigned IRVST     	: 1;
		unsigned           	: 1;
		unsigned VDIRMAG   	: 1;
	};
	struct {
		unsigned LVV0      	: 1;
		unsigned LVV1      	: 1;
		unsigned LVV2      	: 1;
		unsigned LVV3      	: 1;
		unsigned HLVDEN    	: 1;
		unsigned BGST      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned HLVDL0    	: 1;
		unsigned HLVDL1    	: 1;
		unsigned HLVDL2    	: 1;
		unsigned HLVDL3    	: 1;
		unsigned           	: 1;
		unsigned IVRST     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __LVDCONbits_t;
extern volatile __LVDCONbits_t __at (0xFD2) LVDCONbits;

extern __sfr __at (0xFD3) OSCCON;
typedef union {
	struct {
		unsigned SCS0      	: 1;
		unsigned SCS1      	: 1;
		unsigned IOFS      	: 1;
		unsigned OSTS      	: 1;
		unsigned IRCF0     	: 1;
		unsigned IRCF1     	: 1;
		unsigned IRCF2     	: 1;
		unsigned IDLEN     	: 1;
	};
} __OSCCONbits_t;
extern volatile __OSCCONbits_t __at (0xFD3) OSCCONbits;

extern __sfr __at (0xFD5) T0CON;
typedef union {
	struct {
		unsigned T0PS0     	: 1;
		unsigned T0PS1     	: 1;
		unsigned T0PS2     	: 1;
		unsigned PSA       	: 1;
		unsigned T0SE      	: 1;
		unsigned T0CS      	: 1;
		unsigned T08BIT    	: 1;
		unsigned TMR0ON    	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned T0PS3     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __T0CONbits_t;
extern volatile __T0CONbits_t __at (0xFD5) T0CONbits;

extern __sfr __at (0xFD6) TMR0L;

extern __sfr __at (0xFD7) TMR0H;

extern __sfr __at (0xFD8) STATUS;
typedef union {
	struct {
		unsigned C         	: 1;
		unsigned DC        	: 1;
		unsigned Z         	: 1;
		unsigned OV        	: 1;
		unsigned N         	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __STATUSbits_t;
extern volatile __STATUSbits_t __at (0xFD8) STATUSbits;

extern __sfr __at (0xFD9) FSR2L;

extern __sfr __at (0xFDA) FSR2H;

extern __sfr __at (0xFDB) PLUSW2;

extern __sfr __at (0xFDC) PREINC2;

extern __sfr __at (0xFDD) POSTDEC2;

extern __sfr __at (0xFDE) POSTINC2;

extern __sfr __at (0xFDF) INDF2;

extern __sfr __at (0xFE0) BSR;

extern __sfr __at (0xFE1) FSR1L;

extern __sfr __at (0xFE2) FSR1H;

extern __sfr __at (0xFE3) PLUSW1;

extern __sfr __at (0xFE4) PREINC1;

extern __sfr __at (0xFE5) POSTDEC1;

extern __sfr __at (0xFE6) POSTINC1;

extern __sfr __at (0xFE7) INDF1;

extern __sfr __at (0xFE8) WREG;

extern __sfr __at (0xFE9) FSR0L;

extern __sfr __at (0xFEA) FSR0H;

extern __sfr __at (0xFEB) PLUSW0;

extern __sfr __at (0xFEC) PREINC0;

extern __sfr __at (0xFED) POSTDEC0;

extern __sfr __at (0xFEE) POSTINC0;

extern __sfr __at (0xFEF) INDF0;

extern __sfr __at (0xFF0) INTCON3;
typedef union {
	struct {
		unsigned INT1IF    	: 1;
		unsigned INT2IF    	: 1;
		unsigned           	: 1;
		unsigned INT1IE    	: 1;
		unsigned INT2IE    	: 1;
		unsigned           	: 1;
		unsigned INT1IP    	: 1;
		unsigned INT2IP    	: 1;
	};
	struct {
		unsigned INT1F     	: 1;
		unsigned INT2F     	: 1;
		unsigned           	: 1;
		unsigned INT1E     	: 1;
		unsigned INT2E     	: 1;
		unsigned           	: 1;
		unsigned INT1P     	: 1;
		unsigned INT2P     	: 1;
	};
} __INTCON3bits_t;
extern volatile __INTCON3bits_t __at (0xFF0) INTCON3bits;

extern __sfr __at (0xFF1) INTCON2;
typedef union {
	struct {
		unsigned RBIP      	: 1;
		unsigned           	: 1;
		unsigned TMR0IP    	: 1;
		unsigned           	: 1;
		unsigned INTEDG2   	: 1;
		unsigned INTEDG1   	: 1;
		unsigned INTEDG0   	: 1;
		unsigned NOT_RBPU  	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned T0IP      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned RBPU      	: 1;
	};
} __INTCON2bits_t;
extern volatile __INTCON2bits_t __at (0xFF1) INTCON2bits;

extern __sfr __at (0xFF2) INTCON;
typedef union {
	struct {
		unsigned RBIF      	: 1;
		unsigned INT0IF    	: 1;
		unsigned TMR0IF    	: 1;
		unsigned RBIE      	: 1;
		unsigned INT0IE    	: 1;
		unsigned TMR0IE    	: 1;
		unsigned PEIE      	: 1;
		unsigned GIE       	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned INT0F     	: 1;
		unsigned T0IF      	: 1;
		unsigned           	: 1;
		unsigned INT0E     	: 1;
		unsigned T0IE      	: 1;
		unsigned GIEL      	: 1;
		unsigned GIEH      	: 1;
	};
} __INTCONbits_t;
extern volatile __INTCONbits_t __at (0xFF2) INTCONbits;

extern __sfr __at (0xFF3) PROD;

extern __sfr __at (0xFF3) PRODL;

extern __sfr __at (0xFF4) PRODH;

extern __sfr __at (0xFF5) TABLAT;

extern __sfr __at (0xFF6) TBLPTR;

extern __sfr __at (0xFF6) TBLPTRL;

extern __sfr __at (0xFF7) TBLPTRH;

extern __sfr __at (0xFF8) TBLPTRU;

extern __sfr __at (0xFF9) PC;

extern __sfr __at (0xFF9) PCL;

extern __sfr __at (0xFFA) PCLATH;

extern __sfr __at (0xFFB) PCLATU;

extern __sfr __at (0xFFC) STKPTR;
typedef union {
	struct {
		unsigned STKPTR0   	: 1;
		unsigned STKPTR1   	: 1;
		unsigned STKPTR2   	: 1;
		unsigned STKPTR3   	: 1;
		unsigned STKPTR4   	: 1;
		unsigned           	: 1;
		unsigned STKUNF    	: 1;
		unsigned STKOVF    	: 1;
	};
	struct {
		unsigned SP0       	: 1;
		unsigned SP1       	: 1;
		unsigned SP2       	: 1;
		unsigned SP3       	: 1;
		unsigned SP4       	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned STKFUL    	: 1;
	};
} __STKPTRbits_t;
extern volatile __STKPTRbits_t __at (0xFFC) STKPTRbits;

extern __sfr __at (0xFFD) TOS;

extern __sfr __at (0xFFD) TOSL;

extern __sfr __at (0xFFE) TOSH;

extern __sfr __at (0xFFF) TOSU;


#endif

