/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.event;

import gnu.classpath.jdwp.VMVirtualMachine;
import gnu.classpath.jdwp.event.Event;
import gnu.classpath.jdwp.event.EventRequest;
import gnu.classpath.jdwp.exception.InvalidEventTypeException;
import gnu.classpath.jdwp.exception.JdwpException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;

public class EventManager {
    private static EventManager _instance = null;
    private Hashtable _requests;

    private /* synthetic */ void finit$() {
        this._requests = null;
    }

    public static EventManager getDefault() {
        if (_instance == null) {
            _instance = new EventManager();
        }
        return _instance;
    }

    private EventManager() {
        this.finit$();
        this._requests = new Hashtable();
        this._requests.put(new Byte(1), new Hashtable());
        this._requests.put(new Byte(2), new Hashtable());
        this._requests.put(new Byte(3), new Hashtable());
        this._requests.put(new Byte(4), new Hashtable());
        this._requests.put(new Byte(5), new Hashtable());
        this._requests.put(new Byte(6), new Hashtable());
        this._requests.put(new Byte(7), new Hashtable());
        this._requests.put(new Byte(8), new Hashtable());
        this._requests.put(new Byte(9), new Hashtable());
        this._requests.put(new Byte(10), new Hashtable());
        this._requests.put(new Byte(20), new Hashtable());
        this._requests.put(new Byte(21), new Hashtable());
        this._requests.put(new Byte(40), new Hashtable());
        this._requests.put(new Byte(41), new Hashtable());
        this._requests.put(new Byte(90), new Hashtable());
        this._requests.put(new Byte(99), new Hashtable());
        try {
            this.requestEvent(new EventRequest(0, 90, 0));
            this.requestEvent(new EventRequest(0, 99, 0));
        }
        catch (JdwpException jdwpException) {
            // empty catch block
        }
    }

    public EventRequest getEventRequest(Event event) {
        EventRequest eventRequest = null;
        Byte by = new Byte(event.getEventKind());
        Hashtable hashtable = (Hashtable)this._requests.get(by);
        if (hashtable == null) {
            throw new IllegalArgumentException("invalid event kind: " + by);
        }
        boolean bl = false;
        Iterator iterator = hashtable.values().iterator();
        while (iterator.hasNext()) {
            EventRequest eventRequest2 = (EventRequest)iterator.next();
            if (!eventRequest2.matches(event)) continue;
            eventRequest = eventRequest2;
        }
        return eventRequest;
    }

    public void requestEvent(EventRequest eventRequest) throws JdwpException {
        Byte by = new Byte(eventRequest.getEventKind());
        Hashtable hashtable = (Hashtable)this._requests.get(by);
        if (hashtable == null) {
            throw new InvalidEventTypeException(eventRequest.getEventKind());
        }
        VMVirtualMachine.registerEvent(eventRequest);
        hashtable.put(new Integer(eventRequest.getId()), eventRequest);
    }

    public void deleteRequest(byte by, int n) throws JdwpException {
        Hashtable hashtable = (Hashtable)this._requests.get(new Byte(by));
        if (hashtable == null) {
            throw new IllegalArgumentException("invalid event kind: " + by);
        }
        Integer n2 = new Integer(n);
        EventRequest eventRequest = (EventRequest)hashtable.get(n2);
        if (eventRequest != null) {
            VMVirtualMachine.unregisterEvent(eventRequest);
            hashtable.remove(n2);
        }
    }

    public void clearRequests(byte by) throws JdwpException {
        Hashtable hashtable = (Hashtable)this._requests.get(new Byte(by));
        if (hashtable == null) {
            throw new IllegalArgumentException("invalid event kind: " + by);
        }
        VMVirtualMachine.clearEvents(by);
        hashtable.clear();
    }

    public EventRequest getRequest(byte by, int n) {
        Hashtable hashtable = (Hashtable)this._requests.get(new Byte(by));
        if (hashtable == null) {
            throw new IllegalArgumentException("invalid event kind: " + by);
        }
        return (EventRequest)hashtable.get(new Integer(n));
    }

    public Collection getRequests(byte by) {
        Hashtable hashtable = (Hashtable)this._requests.get(new Byte(by));
        if (hashtable == null) {
            throw new IllegalArgumentException("invalid event kind: " + by);
        }
        return hashtable.values();
    }
}

