/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.jpeg;

import gnu.javax.imageio.jpeg.DCT;
import gnu.javax.imageio.jpeg.HuffmanTable;
import gnu.javax.imageio.jpeg.JPEGException;
import gnu.javax.imageio.jpeg.JPEGImageInputStream;
import gnu.javax.imageio.jpeg.ZigZag;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.plugins.jpeg.JPEGHuffmanTable;

public class JPEGComponent {
    public byte factorH;
    public byte factorV;
    public byte component_id;
    public byte quant_id;
    public int width;
    public int height;
    public int maxV;
    public int maxH;
    public HuffmanTable ACTable;
    public HuffmanTable DCTable;
    public int[] quantizationTable;
    public double previousDC;
    ArrayList data;

    private /* synthetic */ void finit$() {
        this.width = 0;
        this.height = 0;
        this.maxV = 0;
        this.maxH = 0;
        this.previousDC = 0.0;
        this.data = new ArrayList();
    }

    public JPEGComponent(byte by, byte by2, byte by3, byte by4) {
        this.finit$();
        this.component_id = by;
        this.factorH = by2;
        this.factorV = by3;
        this.quant_id = by4;
    }

    public void padMCU(int n, int n2) {
        double[] dArray = (double[])this.data.get(n - 1);
        for (int i = 0; i < n2; ++i) {
            this.data.add(n, dArray);
        }
    }

    public void resetInterval() {
        this.previousDC = 0.0;
    }

    public void quantitizeData() {
        for (int i = 0; i < this.data.size(); ++i) {
            double[] dArray = (double[])this.data.get(i);
            for (int j = 0; j < dArray.length; ++j) {
                int n = j;
                dArray[n] = dArray[n] * (double)this.quantizationTable[j];
            }
        }
    }

    public void setDCTable(JPEGHuffmanTable jPEGHuffmanTable) {
        this.DCTable = new HuffmanTable(jPEGHuffmanTable);
    }

    public void setACTable(JPEGHuffmanTable jPEGHuffmanTable) {
        this.ACTable = new HuffmanTable(jPEGHuffmanTable);
    }

    public void idctData(DCT dCT) {
        for (int i = 0; i < this.data.size(); ++i) {
            this.data.add(i, dCT.fast_idct(ZigZag.decode8x8_map((double[])this.data.remove(i))));
        }
    }

    public void scaleByFactors() {
        int n;
        int n2;
        double[][] dArray;
        double[][] dArray2;
        int n3;
        int n4 = this.maxV / this.factorV;
        int n5 = this.maxH / this.factorH;
        if (n4 > 1) {
            for (n3 = 0; n3 < this.data.size(); ++n3) {
                dArray2 = (double[][])this.data.remove(n3);
                dArray = new double[dArray2.length * n4][dArray2[0].length];
                for (n2 = 0; n2 < dArray2.length; ++n2) {
                    for (n = 0; n < n4; ++n) {
                        dArray[n2 * n4 + n] = dArray2[n2];
                    }
                }
                this.data.add(n3, dArray);
            }
        }
        if (n5 > 1) {
            for (n3 = 0; n3 < this.data.size(); ++n3) {
                dArray2 = (double[][])this.data.remove(n3);
                dArray = new double[dArray2.length][dArray2[0].length * n5];
                for (n2 = 0; n2 < dArray2.length; ++n2) {
                    for (n = 0; n < dArray2[0].length; ++n) {
                        for (int i = 0; i < n5; ++i) {
                            dArray[n2][n * n5 + i] = dArray2[n2][n];
                        }
                    }
                }
                this.data.add(n3, dArray);
            }
        }
    }

    public void writeBlock(WritableRaster writableRaster, double[][] dArray, int n, int n2, int n3) {
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                if (n2 + j >= writableRaster.getWidth() || n3 + i >= writableRaster.getHeight()) continue;
                writableRaster.setSample(n2 + j, n3 + i, n, dArray[i][j]);
            }
        }
    }

    public void writeData(WritableRaster writableRaster, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (this.data.size() > 0) {
            int n6 = 0;
            int n7 = 0;
            if (n2 >= writableRaster.getWidth()) {
                n2 = 0;
                n3 += n5;
            }
            for (int i = 0; i < this.factorV; ++i) {
                n6 = 0;
                for (int j = 0; j < this.factorH; ++j) {
                    double[][] dArray = (double[][])this.data.remove(0);
                    this.writeBlock(writableRaster, dArray, n, n2, n3);
                    n6 += dArray[0].length;
                    n2 += dArray[0].length;
                    n7 = dArray.length;
                }
                n3 += n7;
                n2 -= n6;
                n4 += n7;
            }
            n3 -= n4;
            n5 = n4;
            n4 = 0;
            n2 += n6;
        }
    }

    public void setQuantizationTable(int[] nArray) {
        this.quantizationTable = nArray;
    }

    public void readComponentMCU(JPEGImageInputStream jPEGImageInputStream) throws JPEGException, IOException {
        for (int i = 0; i < this.factorH * this.factorV; ++i) {
            double d = this.decode_dc_coefficient(jPEGImageInputStream);
            double[] dArray = this.decode_ac_coefficients(jPEGImageInputStream);
            dArray[0] = d;
            this.data.add(dArray);
        }
    }

    public double decode_dc_coefficient(JPEGImageInputStream jPEGImageInputStream) throws JPEGException, IOException {
        int n = this.DCTable.decode(jPEGImageInputStream);
        double d = jPEGImageInputStream.readBits(n);
        d = HuffmanTable.extend((int)d, n);
        this.previousDC = d = this.previousDC + d;
        return d;
    }

    public double[] decode_ac_coefficients(JPEGImageInputStream jPEGImageInputStream) throws JPEGException, IOException {
        double[] dArray = new double[64];
        for (int i = 1; i < 64; ++i) {
            int n = this.ACTable.decode(jPEGImageInputStream);
            int n2 = n >> 4;
            if ((n &= 0xF) != 0) {
                i += n2;
                n2 = (int)jPEGImageInputStream.readBits(n);
                n = HuffmanTable.extend(n2, n);
                dArray[i] = n;
                continue;
            }
            if (n2 != 15) {
                return dArray;
            }
            i += 15;
        }
        return dArray;
    }
}

