require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&LAPIC_ID)) {
    sub LAPIC_ID () {	0x20;}
}
unless(defined(&LAPIC_ID_MASK)) {
    sub LAPIC_ID_MASK () {	0xf000000;}
}
unless(defined(&LAPIC_ID_SHIFT)) {
    sub LAPIC_ID_SHIFT () {	24;}
}
unless(defined(&LAPIC_VERS)) {
    sub LAPIC_VERS () {	0x30;}
}
unless(defined(&LAPIC_VERSION_MASK)) {
    sub LAPIC_VERSION_MASK () {	0xff;}
}
unless(defined(&LAPIC_VERSION_LVT_MASK)) {
    sub LAPIC_VERSION_LVT_MASK () {	0xff0000;}
}
unless(defined(&LAPIC_VERSION_LVT_SHIFT)) {
    sub LAPIC_VERSION_LVT_SHIFT () {	16;}
}
unless(defined(&LAPIC_TPRI)) {
    sub LAPIC_TPRI () {	0x80;}
}
unless(defined(&LAPIC_TPRI_MASK)) {
    sub LAPIC_TPRI_MASK () {	0xff;}
}
unless(defined(&LAPIC_TPRI_INT_MASK)) {
    sub LAPIC_TPRI_INT_MASK () {	0xf0;}
}
unless(defined(&LAPIC_TPRI_SUB_MASK)) {
    sub LAPIC_TPRI_SUB_MASK () {	0xf;}
}
unless(defined(&LAPIC_APRI)) {
    sub LAPIC_APRI () {	0x90;}
}
unless(defined(&LAPIC_APRI_MASK)) {
    sub LAPIC_APRI_MASK () {	0xff;}
}
unless(defined(&LAPIC_PPRI)) {
    sub LAPIC_PPRI () {	0xa0;}
}
unless(defined(&LAPIC_EOI)) {
    sub LAPIC_EOI () {	0xb0;}
}
unless(defined(&LAPIC_RRR)) {
    sub LAPIC_RRR () {	0xc0;}
}
unless(defined(&LAPIC_LDR)) {
    sub LAPIC_LDR () {	0xd0;}
}
unless(defined(&LAPIC_DFR)) {
    sub LAPIC_DFR () {	0xe0;}
}
unless(defined(&LAPIC_SVR)) {
    sub LAPIC_SVR () {	0xf0;}
}
unless(defined(&LAPIC_SVR_VECTOR_MASK)) {
    sub LAPIC_SVR_VECTOR_MASK () {	0xff;}
}
unless(defined(&LAPIC_SVR_VEC_FIX)) {
    sub LAPIC_SVR_VEC_FIX () {	0xf;}
}
unless(defined(&LAPIC_SVR_VEC_PROG)) {
    sub LAPIC_SVR_VEC_PROG () {	0xf0;}
}
unless(defined(&LAPIC_SVR_ENABLE)) {
    sub LAPIC_SVR_ENABLE () {	0x100;}
}
unless(defined(&LAPIC_SVR_SWEN)) {
    sub LAPIC_SVR_SWEN () {	0x100;}
}
unless(defined(&LAPIC_SVR_FOCUS)) {
    sub LAPIC_SVR_FOCUS () {	0x200;}
}
unless(defined(&LAPIC_SVR_FDIS)) {
    sub LAPIC_SVR_FDIS () {	0x200;}
}
unless(defined(&LAPIC_ISR)) {
    sub LAPIC_ISR () {	0x100;}
}
unless(defined(&LAPIC_TMR)) {
    sub LAPIC_TMR () {	0x180;}
}
unless(defined(&LAPIC_IRR)) {
    sub LAPIC_IRR () {	0x200;}
}
unless(defined(&LAPIC_ESR)) {
    sub LAPIC_ESR () {	0x280;}
}
unless(defined(&LAPIC_ICRLO)) {
    sub LAPIC_ICRLO () {	0x300;}
}
unless(defined(&LAPIC_DLMODE_MASK)) {
    sub LAPIC_DLMODE_MASK () {	0x700;}
}
unless(defined(&LAPIC_DLMODE_FIXED)) {
    sub LAPIC_DLMODE_FIXED () {	0x;}
}
unless(defined(&LAPIC_DLMODE_LOW)) {
    sub LAPIC_DLMODE_LOW () {	0x100;}
}
unless(defined(&LAPIC_DLMODE_SMI)) {
    sub LAPIC_DLMODE_SMI () {	0x200;}
}
unless(defined(&LAPIC_DLMODE_RR)) {
    sub LAPIC_DLMODE_RR () {	0x300;}
}
unless(defined(&LAPIC_DLMODE_NMI)) {
    sub LAPIC_DLMODE_NMI () {	0x400;}
}
unless(defined(&LAPIC_DLMODE_INIT)) {
    sub LAPIC_DLMODE_INIT () {	0x500;}
}
unless(defined(&LAPIC_DLMODE_STARTUP)) {
    sub LAPIC_DLMODE_STARTUP () {	0x600;}
}
unless(defined(&LAPIC_DSTMODE_LOG)) {
    sub LAPIC_DSTMODE_LOG () {	0x800;}
}
unless(defined(&LAPIC_DLSTAT_BUSY)) {
    sub LAPIC_DLSTAT_BUSY () {	0x1000;}
}
unless(defined(&LAPIC_LVL_ASSERT)) {
    sub LAPIC_LVL_ASSERT () {	0x4000;}
}
unless(defined(&LAPIC_LVL_DEASSERT)) {
    sub LAPIC_LVL_DEASSERT () {	0x;}
}
unless(defined(&LAPIC_LVL_TRIG)) {
    sub LAPIC_LVL_TRIG () {	0x8000;}
}
unless(defined(&LAPIC_RRSTAT_MASK)) {
    sub LAPIC_RRSTAT_MASK () {	0x30000;}
}
unless(defined(&LAPIC_RRSTAT_INPROG)) {
    sub LAPIC_RRSTAT_INPROG () {	0x10000;}
}
unless(defined(&LAPIC_RRSTAT_VALID)) {
    sub LAPIC_RRSTAT_VALID () {	0x20000;}
}
unless(defined(&LAPIC_DEST_MASK)) {
    sub LAPIC_DEST_MASK () {	0xc0000;}
}
unless(defined(&LAPIC_DEST_SELF)) {
    sub LAPIC_DEST_SELF () {	0x40000;}
}
unless(defined(&LAPIC_DEST_ALLINCL)) {
    sub LAPIC_DEST_ALLINCL () {	0x80000;}
}
unless(defined(&LAPIC_DEST_ALLEXCL)) {
    sub LAPIC_DEST_ALLEXCL () {	0xc0000;}
}
unless(defined(&LAPIC_RESV2_MASK)) {
    sub LAPIC_RESV2_MASK () {	0xfff00000;}
}
unless(defined(&LAPIC_ICRHI)) {
    sub LAPIC_ICRHI () {	0x310;}
}
unless(defined(&LAPIC_ID_MASK)) {
    sub LAPIC_ID_MASK () {	0xf000000;}
}
unless(defined(&LAPIC_ID_SHIFT)) {
    sub LAPIC_ID_SHIFT () {	24;}
}
unless(defined(&LAPIC_LVTT)) {
    sub LAPIC_LVTT () {	0x320;}
}
unless(defined(&LAPIC_LVTT_VEC_MASK)) {
    sub LAPIC_LVTT_VEC_MASK () {	0xff;}
}
unless(defined(&LAPIC_LVTT_DS)) {
    sub LAPIC_LVTT_DS () {	0x1000;}
}
unless(defined(&LAPIC_LVTT_M)) {
    sub LAPIC_LVTT_M () {	0x10000;}
}
unless(defined(&LAPIC_LVTT_TM)) {
    sub LAPIC_LVTT_TM () {	0x20000;}
}
unless(defined(&LAPIC_PCINT)) {
    sub LAPIC_PCINT () {	0x340;}
}
unless(defined(&LAPIC_LVINT0)) {
    sub LAPIC_LVINT0 () {	0x350;}
}
unless(defined(&LAPIC_LVT_PERIODIC)) {
    sub LAPIC_LVT_PERIODIC () {	0x20000;}
}
unless(defined(&LAPIC_LVT_MASKED)) {
    sub LAPIC_LVT_MASKED () {	0x10000;}
}
unless(defined(&LAPIC_LVT_LEVTRIG)) {
    sub LAPIC_LVT_LEVTRIG () {	0x8000;}
}
unless(defined(&LAPIC_LVT_REMOTE_IRR)) {
    sub LAPIC_LVT_REMOTE_IRR () {	0x4000;}
}
unless(defined(&LAPIC_INP_POL)) {
    sub LAPIC_INP_POL () {	0x2000;}
}
unless(defined(&LAPIC_PEND_SEND)) {
    sub LAPIC_PEND_SEND () {	0x1000;}
}
unless(defined(&LAPIC_LVINT1)) {
    sub LAPIC_LVINT1 () {	0x360;}
}
unless(defined(&LAPIC_LVERR)) {
    sub LAPIC_LVERR () {	0x370;}
}
unless(defined(&LAPIC_ICR_TIMER)) {
    sub LAPIC_ICR_TIMER () {	0x380;}
}
unless(defined(&LAPIC_CCR_TIMER)) {
    sub LAPIC_CCR_TIMER () {	0x390;}
}
unless(defined(&LAPIC_DCR_TIMER)) {
    sub LAPIC_DCR_TIMER () {	0x3e0;}
}
unless(defined(&LAPIC_DCRT_DIV1)) {
    sub LAPIC_DCRT_DIV1 () {	0xb;}
}
unless(defined(&LAPIC_DCRT_DIV2)) {
    sub LAPIC_DCRT_DIV2 () {	0x;}
}
unless(defined(&LAPIC_DCRT_DIV4)) {
    sub LAPIC_DCRT_DIV4 () {	0x1;}
}
unless(defined(&LAPIC_DCRT_DIV8)) {
    sub LAPIC_DCRT_DIV8 () {	0x2;}
}
unless(defined(&LAPIC_DCRT_DIV16)) {
    sub LAPIC_DCRT_DIV16 () {	0x3;}
}
unless(defined(&LAPIC_DCRT_DIV32)) {
    sub LAPIC_DCRT_DIV32 () {	0x8;}
}
unless(defined(&LAPIC_DCRT_DIV64)) {
    sub LAPIC_DCRT_DIV64 () {	0x9;}
}
unless(defined(&LAPIC_DCRT_DIV128)) {
    sub LAPIC_DCRT_DIV128 () {	0xa;}
}
unless(defined(&LAPIC_BASE)) {
    sub LAPIC_BASE () {	0xfee00000;}
}
unless(defined(&LAPIC_IRQ_MASK)) {
    sub LAPIC_IRQ_MASK {
	my($i) = @_;
	eval q((1<< (($i) + 1)));
    }
}
1;
