require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&__X86EMU_REGS_H)) {
    eval 'sub __X86EMU_REGS_H () {1;}' unless defined(&__X86EMU_REGS_H);
    eval 'sub R_AH () { ($register_a->{I8_reg}->{h_reg});}' unless defined(&R_AH);
    eval 'sub R_AL () { ($register_a->{I8_reg}->{l_reg});}' unless defined(&R_AL);
    eval 'sub R_BH () { ($register_b->{I8_reg}->{h_reg});}' unless defined(&R_BH);
    eval 'sub R_BL () { ($register_b->{I8_reg}->{l_reg});}' unless defined(&R_BL);
    eval 'sub R_CH () { ($register_c->{I8_reg}->{h_reg});}' unless defined(&R_CH);
    eval 'sub R_CL () { ($register_c->{I8_reg}->{l_reg});}' unless defined(&R_CL);
    eval 'sub R_DH () { ($register_d->{I8_reg}->{h_reg});}' unless defined(&R_DH);
    eval 'sub R_DL () { ($register_d->{I8_reg}->{l_reg});}' unless defined(&R_DL);
    eval 'sub R_AX () { ($register_a->{I16_reg}->{x_reg});}' unless defined(&R_AX);
    eval 'sub R_BX () { ($register_b->{I16_reg}->{x_reg});}' unless defined(&R_BX);
    eval 'sub R_CX () { ($register_c->{I16_reg}->{x_reg});}' unless defined(&R_CX);
    eval 'sub R_DX () { ($register_d->{I16_reg}->{x_reg});}' unless defined(&R_DX);
    eval 'sub R_EAX () { ($register_a->{I32_reg}->{e_reg});}' unless defined(&R_EAX);
    eval 'sub R_EBX () { ($register_b->{I32_reg}->{e_reg});}' unless defined(&R_EBX);
    eval 'sub R_ECX () { ($register_c->{I32_reg}->{e_reg});}' unless defined(&R_ECX);
    eval 'sub R_EDX () { ($register_d->{I32_reg}->{e_reg});}' unless defined(&R_EDX);
    eval 'sub R_SP () { ($register_sp->{I16_reg}->{x_reg});}' unless defined(&R_SP);
    eval 'sub R_BP () { ($register_bp->{I16_reg}->{x_reg});}' unless defined(&R_BP);
    eval 'sub R_SI () { ($register_si->{I16_reg}->{x_reg});}' unless defined(&R_SI);
    eval 'sub R_DI () { ($register_di->{I16_reg}->{x_reg});}' unless defined(&R_DI);
    eval 'sub R_IP () { ($register_ip->{I16_reg}->{x_reg});}' unless defined(&R_IP);
    eval 'sub R_FLG () { &register_flags;}' unless defined(&R_FLG);
    eval 'sub R_ESP () { ($register_sp->{I32_reg}->{e_reg});}' unless defined(&R_ESP);
    eval 'sub R_EBP () { ($register_bp->{I32_reg}->{e_reg});}' unless defined(&R_EBP);
    eval 'sub R_ESI () { ($register_si->{I32_reg}->{e_reg});}' unless defined(&R_ESI);
    eval 'sub R_EDI () { ($register_di->{I32_reg}->{e_reg});}' unless defined(&R_EDI);
    eval 'sub R_EIP () { ($register_ip->{I32_reg}->{e_reg});}' unless defined(&R_EIP);
    eval 'sub R_EFLG () { &register_flags;}' unless defined(&R_EFLG);
    eval 'sub R_CS () { &register_cs;}' unless defined(&R_CS);
    eval 'sub R_DS () { &register_ds;}' unless defined(&R_DS);
    eval 'sub R_SS () { &register_ss;}' unless defined(&R_SS);
    eval 'sub R_ES () { &register_es;}' unless defined(&R_ES);
    eval 'sub R_FS () { &register_fs;}' unless defined(&R_FS);
    eval 'sub R_GS () { &register_gs;}' unless defined(&R_GS);
    eval 'sub FB_CF () {0x1;}' unless defined(&FB_CF);
    eval 'sub FB_PF () {0x4;}' unless defined(&FB_PF);
    eval 'sub FB_AF () {0x10;}' unless defined(&FB_AF);
    eval 'sub FB_ZF () {0x40;}' unless defined(&FB_ZF);
    eval 'sub FB_SF () {0x80;}' unless defined(&FB_SF);
    eval 'sub FB_TF () {0x100;}' unless defined(&FB_TF);
    eval 'sub FB_IF () {0x200;}' unless defined(&FB_IF);
    eval 'sub FB_DF () {0x400;}' unless defined(&FB_DF);
    eval 'sub FB_OF () {0x800;}' unless defined(&FB_OF);
    eval 'sub F_ALWAYS_ON () {(0x2);}' unless defined(&F_ALWAYS_ON);
    eval 'sub F_MSK () {( &FB_CF| &FB_PF| &FB_AF| &FB_ZF| &FB_SF| &FB_TF| &FB_IF| &FB_DF| &FB_OF);}' unless defined(&F_MSK);
    eval 'sub F_CF () {0x1;}' unless defined(&F_CF);
    eval 'sub F_PF () {0x4;}' unless defined(&F_PF);
    eval 'sub F_AF () {0x10;}' unless defined(&F_AF);
    eval 'sub F_ZF () {0x40;}' unless defined(&F_ZF);
    eval 'sub F_SF () {0x80;}' unless defined(&F_SF);
    eval 'sub F_TF () {0x100;}' unless defined(&F_TF);
    eval 'sub F_IF () {0x200;}' unless defined(&F_IF);
    eval 'sub F_DF () {0x400;}' unless defined(&F_DF);
    eval 'sub F_OF () {0x800;}' unless defined(&F_OF);
    eval 'sub SET_FLAG {
        my($flag) = @_;
	    eval q(( ($emu->{x86}->{R_FLG}) |= ($flag)));
    }' unless defined(&SET_FLAG);
    eval 'sub CLEAR_FLAG {
        my($flag) = @_;
	    eval q(( ($emu->{x86}->{R_FLG}) &= ~($flag)));
    }' unless defined(&CLEAR_FLAG);
    eval 'sub ACCESS_FLAG {
        my($flag) = @_;
	    eval q(( ($emu->{x86}->{R_FLG}) & ($flag)));
    }' unless defined(&ACCESS_FLAG);
    eval 'sub CLEARALL_FLAG {
        my($m) = @_;
	    eval q(( ($e$mu->{x86}->{R_FLG}) = 0));
    }' unless defined(&CLEARALL_FLAG);
    eval 'sub CONDITIONAL_SET_FLAG {
        my($COND,$FLAG) = @_;
	    eval q( &if ($COND)  &SET_FLAG($FLAG);  &else  &CLEAR_FLAG($FLAG));
    }' unless defined(&CONDITIONAL_SET_FLAG);
    eval 'sub F_PF_CALC () {0x10000;}' unless defined(&F_PF_CALC);
    eval 'sub F_ZF_CALC () {0x20000;}' unless defined(&F_ZF_CALC);
    eval 'sub F_SF_CALC () {0x40000;}' unless defined(&F_SF_CALC);
    eval 'sub F_ALL_CALC () {0xff0000;}' unless defined(&F_ALL_CALC);
    eval 'sub SYSMODE_SEG_DS_SS () {0x1;}' unless defined(&SYSMODE_SEG_DS_SS);
    eval 'sub SYSMODE_SEGOVR_CS () {0x2;}' unless defined(&SYSMODE_SEGOVR_CS);
    eval 'sub SYSMODE_SEGOVR_DS () {0x4;}' unless defined(&SYSMODE_SEGOVR_DS);
    eval 'sub SYSMODE_SEGOVR_ES () {0x8;}' unless defined(&SYSMODE_SEGOVR_ES);
    eval 'sub SYSMODE_SEGOVR_FS () {0x10;}' unless defined(&SYSMODE_SEGOVR_FS);
    eval 'sub SYSMODE_SEGOVR_GS () {0x20;}' unless defined(&SYSMODE_SEGOVR_GS);
    eval 'sub SYSMODE_SEGOVR_SS () {0x40;}' unless defined(&SYSMODE_SEGOVR_SS);
    eval 'sub SYSMODE_PREFIX_REPE () {0x80;}' unless defined(&SYSMODE_PREFIX_REPE);
    eval 'sub SYSMODE_PREFIX_REPNE () {0x100;}' unless defined(&SYSMODE_PREFIX_REPNE);
    eval 'sub SYSMODE_PREFIX_DATA () {0x200;}' unless defined(&SYSMODE_PREFIX_DATA);
    eval 'sub SYSMODE_PREFIX_ADDR () {0x400;}' unless defined(&SYSMODE_PREFIX_ADDR);
    eval 'sub SYSMODE_INTR_PENDING () {0x10000000;}' unless defined(&SYSMODE_INTR_PENDING);
    eval 'sub SYSMODE_EXTRN_INTR () {0x20000000;}' unless defined(&SYSMODE_EXTRN_INTR);
    eval 'sub SYSMODE_HALTED () {0x40000000;}' unless defined(&SYSMODE_HALTED);
    eval 'sub SYSMODE_SEGMASK () {( &SYSMODE_SEG_DS_SS |  &SYSMODE_SEGOVR_CS |  &SYSMODE_SEGOVR_DS |  &SYSMODE_SEGOVR_ES |  &SYSMODE_SEGOVR_FS |  &SYSMODE_SEGOVR_GS |  &SYSMODE_SEGOVR_SS);}' unless defined(&SYSMODE_SEGMASK);
    eval 'sub SYSMODE_CLRMASK () {( &SYSMODE_SEG_DS_SS |  &SYSMODE_SEGOVR_CS |  &SYSMODE_SEGOVR_DS |  &SYSMODE_SEGOVR_ES |  &SYSMODE_SEGOVR_FS |  &SYSMODE_SEGOVR_GS |  &SYSMODE_SEGOVR_SS |  &SYSMODE_PREFIX_DATA |  &SYSMODE_PREFIX_ADDR);}' unless defined(&SYSMODE_CLRMASK);
    eval 'sub INTR_SYNCH () {0x1;}' unless defined(&INTR_SYNCH);
}
1;
