require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_M88K_CPU_H_)) {
    eval 'sub _M88K_CPU_H_ () {1;}' unless defined(&_M88K_CPU_H_);
    eval 'sub CPU_CONSDEV () {1;}' unless defined(&CPU_CONSDEV);
    eval 'sub CPU_CPUTYPE () {2;}' unless defined(&CPU_CPUTYPE);
    eval 'sub CPU_MAXID () {3;}' unless defined(&CPU_MAXID);
    eval 'sub CTL_MACHDEP_NAMES () {{ { 0, 0}, { "console_device",  &CTLTYPE_STRUCT }, { "cputype",  &CTLTYPE_INT }, };}' unless defined(&CTL_MACHDEP_NAMES);
    if(defined(&_KERNEL)) {
	require 'machine/atomic.ph';
	require 'machine/pcb.ph';
	require 'machine/psl.ph';
	require 'machine/intr.ph';
	require 'sys/queue.ph';
	require 'sys/sched.ph';
	if(defined(&MULTIPROCESSOR)) {
	    if(!defined(&MAX_CPUS) || (defined(&MAX_CPUS) ? &MAX_CPUS : undef) > 4) {
		undef(&MAX_CPUS) if defined(&MAX_CPUS);
		eval 'sub MAX_CPUS () {4;}' unless defined(&MAX_CPUS);
	    }
	} else {
	    if(!defined(&MAX_CPUS)) {
		undef(&MAX_CPUS) if defined(&MAX_CPUS);
		eval 'sub MAX_CPUS () {1;}' unless defined(&MAX_CPUS);
	    }
	}
	unless(defined(&_LOCORE)) {
	    require 'machine/lock.ph';
	    eval 'sub CIF_ALIVE () {0x1;}' unless defined(&CIF_ALIVE);
	    eval 'sub CIF_PRIMARY () {0x2;}' unless defined(&CIF_PRIMARY);
	    eval 'sub ci_pfsr_i0 () { &ci_cpudep0;}' unless defined(&ci_pfsr_i0);
	    eval 'sub ci_pfsr_i1 () { &ci_cpudep1;}' unless defined(&ci_pfsr_i1);
	    eval 'sub ci_pfsr_d0 () { &ci_cpudep2;}' unless defined(&ci_pfsr_d0);
	    eval 'sub ci_pfsr_d1 () { &ci_cpudep3;}' unless defined(&ci_pfsr_d1);
	    eval 'sub ci_ipi_arg1 () { &ci_cpudep0;}' unless defined(&ci_ipi_arg1);
	    eval 'sub ci_ipi_arg2 () { &ci_cpudep1;}' unless defined(&ci_ipi_arg2);
	    eval 'sub ci_h_sxip () { &ci_cpudep2;}' unless defined(&ci_h_sxip);
	    eval 'sub ci_h_epsr () { &ci_cpudep3;}' unless defined(&ci_h_epsr);
	    eval 'sub ci_s_sxip () { &ci_cpudep4;}' unless defined(&ci_s_sxip);
	    eval 'sub ci_s_epsr () { &ci_cpudep5;}' unless defined(&ci_s_epsr);
	    eval 'sub CI_DDB_RUNNING () {0;}' unless defined(&CI_DDB_RUNNING);
	    eval 'sub CI_DDB_ENTERDDB () {1;}' unless defined(&CI_DDB_ENTERDDB);
	    eval 'sub CI_DDB_INDDB () {2;}' unless defined(&CI_DDB_INDDB);
	    eval 'sub CI_DDB_PAUSE () {3;}' unless defined(&CI_DDB_PAUSE);
	    eval 'sub CI_IPI_NOTIFY () {0x1;}' unless defined(&CI_IPI_NOTIFY);
	    eval 'sub CI_IPI_HARDCLOCK () {0x2;}' unless defined(&CI_IPI_HARDCLOCK);
	    eval 'sub CI_IPI_STATCLOCK () {0x4;}' unless defined(&CI_IPI_STATCLOCK);
	    eval 'sub CI_IPI_DDB () {0x8;}' unless defined(&CI_IPI_DDB);
	    eval 'sub CI_IPI_TLB_FLUSH_KERNEL () {0x10;}' unless defined(&CI_IPI_TLB_FLUSH_KERNEL);
	    eval 'sub CI_IPI_TLB_FLUSH_USER () {0x20;}' unless defined(&CI_IPI_TLB_FLUSH_USER);
	    eval 'sub CI_IPI_CACHE_FLUSH () {0x40;}' unless defined(&CI_IPI_CACHE_FLUSH);
	    eval 'sub CI_IPI_ICACHE_FLUSH () {0x80;}' unless defined(&CI_IPI_ICACHE_FLUSH);
	    eval 'sub CI_IPI_DMA_CACHECTL () {0x100;}' unless defined(&CI_IPI_DMA_CACHECTL);
	    if(defined(&DIAGNOSTIC)) {
	    }
	    eval 'sub CPU_INFO_ITERATOR () { &cpuid_t;}' unless defined(&CPU_INFO_ITERATOR);
	    eval 'sub CPU_INFO_FOREACH {
	        my($cii, $ci) = @_;
    		eval q( &for (($cii) = 0; ($cii) <  &MAX_CPUS; ($cii)++)  &if ((($ci) =  $m88k_cpus[$cii])-> &ci_flags &  &CIF_ALIVE));
	    }' unless defined(&CPU_INFO_FOREACH);
	    eval 'sub CPU_INFO_UNIT {
	        my($ci) = @_;
    		eval q((($ci)-> &ci_cpuid));
	    }' unless defined(&CPU_INFO_UNIT);
	    eval 'sub MAXCPUS () { &MAX_CPUS;}' unless defined(&MAXCPUS);
	    if(defined(&MULTIPROCESSOR)) {
		eval 'sub CPU_IS_PRIMARY {
		    my($ci) = @_;
    		    eval q((($ci)-> &ci_flags &  &CIF_PRIMARY));
		}' unless defined(&CPU_IS_PRIMARY);
	    } else {
		eval 'sub curcpu () {
		    eval q(( $m88k_cpus[0]));
		}' unless defined(&curcpu);
		eval 'sub cpu_unidle {
		    my($ci) = @_;
    		    eval q( &do { }  &while (0));
		}' unless defined(&cpu_unidle);
		eval 'sub CPU_IS_PRIMARY {
		    my($ci) = @_;
    		    eval q(1);
		}' unless defined(&CPU_IS_PRIMARY);
	    }
	    if(!defined(&cpu_number)) {
		eval 'sub cpu_number () {
		    eval q( &curcpu()-> &ci_cpuid);
		}' unless defined(&cpu_number);
	    }
	    eval 'sub curpcb () { &curcpu()-> &ci_curpcb;}' unless defined(&curpcb);
	}
	eval 'sub cpu_exec {
	    my($p) = @_;
    	    eval q( &do { }  &while (0));
	}' unless defined(&cpu_exec);
	eval 'sub cpu_idle_enter () {
	    eval q( &do { }  &while (0));
	}' unless defined(&cpu_idle_enter);
	eval 'sub cpu_idle_cycle () {
	    eval q( &do { }  &while (0));
	}' unless defined(&cpu_idle_cycle);
	eval 'sub cpu_idle_leave () {
	    eval q( &do { }  &while (0));
	}' unless defined(&cpu_idle_leave);
	if(defined(&MULTIPROCESSOR)) {
	    require 'sys/lock.ph';
	    require 'sys/mplock.ph';
	}
	eval 'sub CLKF_USERMODE {
	    my($framep) = @_;
    	    eval q(((($framep)-> ($tf->{tf_epsr}) &  &PSR_MODE) == 0));
	}' unless defined(&CLKF_USERMODE);
	eval 'sub CLKF_PC {
	    my($framep) = @_;
    	    eval q((($framep)-> ($tf->{tf_sxip}) &  &XIP_ADDR));
	}' unless defined(&CLKF_PC);
	eval 'sub CLKF_INTR {
	    my($framep) = @_;
    	    eval q(((($framep)-> ($tf->{tf_cpu}))-> &ci_intrdepth > 1));
	}' unless defined(&CLKF_INTR);
	eval 'sub aston {
	    my($p) = @_;
    	    eval q((($p)-> ($p_md->{md_astpending}) = 1));
	}' unless defined(&aston);
	eval 'sub PC_REGS {
	    my($regs) = @_;
    	    eval q(( &CPU_IS88110 ? (($regs)-> &exip &  &XIP_ADDR) : (($regs)-> &sxip &  &XIP_V ? ($regs)-> &sxip &  &XIP_ADDR : (($regs)-> &snip &  &NIP_V ? ($regs)-> &snip &  &NIP_ADDR : ($regs)-> &sfip &  &FIP_ADDR))));
	}' unless defined(&PC_REGS);
	eval 'sub PROC_PC {
	    my($p) = @_;
    	    eval q( &PC_REGS((($p)-> ($p_md->{md_tf}))));
	}' unless defined(&PROC_PC);
	eval 'sub clear_resched {
	    my($ci) = @_;
    	    eval q(($ci)-> &ci_want_resched = 0);
	}' unless defined(&clear_resched);
	eval 'sub need_proftick {
	    my($p) = @_;
    	    eval q( &aston($p));
	}' unless defined(&need_proftick);
    }
}
1;
