/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.profile;

import ca.sqlpower.architect.ddl.DDLUtils;
import ca.sqlpower.architect.profile.AbstractTableProfileCreator;
import ca.sqlpower.architect.profile.ColumnProfileResult;
import ca.sqlpower.architect.profile.ProfileFunctionDescriptor;
import ca.sqlpower.architect.profile.ProfileSettings;
import ca.sqlpower.architect.profile.TableProfileResult;
import ca.sqlpower.sql.JDBCDataSourceType;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLDatabase;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLTable;
import ca.sqlpower.util.Monitorable;
import ca.sqlpower.util.MonitorableImpl;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class RemoteDatabaseProfileCreator
extends AbstractTableProfileCreator {
    private static final Logger logger = Logger.getLogger(RemoteDatabaseProfileCreator.class);
    private Map<String, ProfileFunctionDescriptor> profileFunctionMap;
    private StringLengthSQLFunction stringLengthSQLFunction;
    private AverageSQLFunction averageSQLFunction;
    private CaseWhenNullSQLFunction caseWhenNullSQLFunction;
    private final ProfileSettings settings;

    public RemoteDatabaseProfileCreator(ProfileSettings settings) {
        this.settings = settings;
    }

    @Override
    public boolean doProfileImpl(TableProfileResult tpr) {
        MonitorableImpl pm = (MonitorableImpl)tpr.getProgressMonitor();
        try {
            this.doTableProfile(tpr);
            SQLTable table = (SQLTable)tpr.getProfiledObject();
            JDBCDataSourceType dsType = table.getParentDatabase().getDataSource().getParentType();
            this.createProfileFunctions(dsType);
            for (SQLColumn col : table.getColumns()) {
                ColumnProfileResult columnResult = new ColumnProfileResult(col);
                tpr.addColumnProfileResult(columnResult);
                this.doColumnProfile(columnResult, pm);
                pm.setProgress(pm.getProgress() + 1);
            }
            return !pm.isCancelled();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTableProfile(TableProfileResult tpr) throws SQLException, SQLObjectException {
        block15: {
            logger.debug((Object)("Doing profile for table " + tpr.getProfiledObject()));
            MonitorableImpl pm = (MonitorableImpl)tpr.getProgressMonitor();
            pm.setProgress(0);
            Connection conn = null;
            Statement stmt = null;
            ResultSet rs = null;
            try {
                SQLTable table = (SQLTable)tpr.getProfiledObject();
                pm.setJobSize(Integer.valueOf(table.getColumns().size() + 1));
                SQLDatabase db = table.getParentDatabase();
                conn = db.getConnection();
                String databaseIdentifierQuoteString = null;
                databaseIdentifierQuoteString = conn.getMetaData().getIdentifierQuoteString();
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT COUNT(*) AS ROW__COUNT");
                sql.append("\nFROM ");
                sql.append(DDLUtils.toQualifiedName(table.getCatalogName(), table.getSchemaName(), table.getName(), databaseIdentifierQuoteString, databaseIdentifierQuoteString));
                stmt = conn.createStatement();
                stmt.setEscapeProcessing(false);
                String lastSQL = sql.toString();
                pm.setProgress(pm.getProgress() + 1);
                rs = stmt.executeQuery(lastSQL);
                if (rs.next()) {
                    tpr.setRowCount(rs.getInt("ROW__COUNT"));
                    break block15;
                }
                throw new AssertionError((Object)"No rows came back from COUNT(*) query!");
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex) {
                    logger.error((Object)"Couldn't clean up result set", (Throwable)ex);
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException ex) {
                    logger.error((Object)"Couldn't clean up statement", (Throwable)ex);
                }
                if (conn != null) {
                    conn.close();
                }
            }
        }
    }

    private void execProfileFunctions(ColumnProfileResult cpr, ProfileFunctionDescriptor pfd, SQLColumn col, Connection con, Monitorable pm) throws SQLException {
        logger.debug((Object)("Starting execProfileFunctions for " + col));
        long createStartTime = System.currentTimeMillis();
        boolean i = false;
        StringBuffer sql = new StringBuffer();
        Statement stmt = null;
        ResultSet rs = null;
        String lastSQL = null;
        String columnName = null;
        String databaseIdentifierQuoteString = null;
        cpr.setCreateStartTime(createStartTime);
        SQLTable table = col.getParent();
        try {
            databaseIdentifierQuoteString = con.getMetaData().getIdentifierQuoteString();
            sql.append("SELECT 1");
            int tryCount = 0;
            if (this.settings.isFindingDistinctCount() && pfd.isCountDist()) {
                sql.append(",\n COUNT(DISTINCT ");
                sql.append(databaseIdentifierQuoteString);
                sql.append(col.getName());
                sql.append(databaseIdentifierQuoteString);
                sql.append(") AS DISTINCTCOUNT_0");
                ++tryCount;
            }
            if (this.settings.isFindingMin() && pfd.isMinValue()) {
                sql.append(",\n MIN(");
                sql.append(databaseIdentifierQuoteString);
                sql.append(col.getName());
                sql.append(databaseIdentifierQuoteString);
                sql.append(") AS MINVALUE_0");
                ++tryCount;
            }
            if (this.settings.isFindingMax() && pfd.isMaxValue()) {
                sql.append(",\n MAX(");
                sql.append(databaseIdentifierQuoteString);
                sql.append(col.getName());
                sql.append(databaseIdentifierQuoteString);
                sql.append(") AS MAXVALUE_0");
                ++tryCount;
            }
            if (this.settings.isFindingAvg() && pfd.isAvgValue()) {
                sql.append(",\n ");
                sql.append(this.averageSQLFunction.getAverageSQLFunction(databaseIdentifierQuoteString + col.getName() + databaseIdentifierQuoteString));
                sql.append(" AS AVGVALUE_0");
                ++tryCount;
            }
            if (this.settings.isFindingMinLength() && pfd.isMinLength()) {
                sql.append(",\n MIN(");
                sql.append(this.stringLengthSQLFunction.getStringLengthSQLFunction(databaseIdentifierQuoteString + col.getName() + databaseIdentifierQuoteString));
                sql.append(") AS MINLENGTH_0");
                ++tryCount;
            }
            if (this.settings.isFindingMaxLength() && pfd.isMaxLength()) {
                sql.append(",\n MAX(");
                sql.append(this.stringLengthSQLFunction.getStringLengthSQLFunction(databaseIdentifierQuoteString + col.getName() + databaseIdentifierQuoteString));
                sql.append(") AS MAXLENGTH_0");
                ++tryCount;
            }
            if (this.settings.isFindingAvgLength() && pfd.isAvgLength()) {
                sql.append(",\n AVG(");
                sql.append(this.stringLengthSQLFunction.getStringLengthSQLFunction(databaseIdentifierQuoteString + col.getName() + databaseIdentifierQuoteString));
                sql.append(") AS AVGLENGTH_0");
                ++tryCount;
            }
            if (this.settings.isFindingNullCount() && pfd.isSumDecode()) {
                sql.append(",\n SUM(");
                sql.append(this.caseWhenNullSQLFunction.getCaseWhenNullSQLFunction(databaseIdentifierQuoteString + col.getName() + databaseIdentifierQuoteString, "1"));
                sql.append(") AS NULLCOUNT_0");
                ++tryCount;
            }
            if (tryCount > 0 && !pm.isCancelled()) {
                sql.append("\n FROM ");
                sql.append(DDLUtils.toQualifiedName(table.getCatalogName(), table.getSchemaName(), table.getName(), databaseIdentifierQuoteString, databaseIdentifierQuoteString));
                stmt = con.createStatement();
                stmt.setEscapeProcessing(false);
                lastSQL = sql.toString();
                if (pm.isCancelled()) {
                    return;
                }
                rs = stmt.executeQuery(lastSQL);
                if (pm.isCancelled()) {
                    return;
                }
                if (rs.next()) {
                    if (this.settings.isFindingDistinctCount() && pfd.isCountDist()) {
                        columnName = "DISTINCTCOUNT_0";
                        cpr.setDistinctValueCount(rs.getInt(columnName));
                    }
                    if (this.settings.isFindingMin() && pfd.isMinValue()) {
                        columnName = "MINVALUE_0";
                        cpr.setMinValue(rs.getObject(columnName));
                    }
                    if (this.settings.isFindingMax() && pfd.isMaxValue()) {
                        columnName = "MAXVALUE_0";
                        cpr.setMaxValue(rs.getObject(columnName));
                    }
                    if (this.settings.isFindingAvg() && pfd.isAvgValue()) {
                        columnName = "AVGVALUE_0";
                        cpr.setAvgValue(rs.getObject(columnName));
                    }
                    if (this.settings.isFindingMinLength() && pfd.isMinLength()) {
                        columnName = "MINLENGTH_0";
                        cpr.setMinLength(rs.getInt(columnName));
                    }
                    if (this.settings.isFindingMaxLength() && pfd.isMaxLength()) {
                        columnName = "MAXLENGTH_0";
                        cpr.setMaxLength(rs.getInt(columnName));
                    }
                    if (this.settings.isFindingAvgLength() && pfd.isAvgLength()) {
                        columnName = "AVGLENGTH_0";
                        cpr.setAvgLength(rs.getDouble(columnName));
                    }
                    if (this.settings.isFindingNullCount() && pfd.isSumDecode()) {
                        columnName = "NULLCOUNT_0";
                        cpr.setNullCount(rs.getInt(columnName));
                    }
                } else {
                    throw new IllegalStateException("Query executed, but returns no rows:\n" + lastSQL + "\nColumn Name: " + columnName);
                }
                rs.close();
                rs = null;
            }
            if (this.settings.isFindingTopTen() && pfd.isCountDist() && !pm.isCancelled()) {
                sql = new StringBuffer();
                sql.append("SELECT ").append(databaseIdentifierQuoteString);
                sql.append(col.getName()).append(databaseIdentifierQuoteString);
                sql.append(" AS MYVALUE, COUNT(*) AS COUNT1 FROM ");
                sql.append(DDLUtils.toQualifiedName(table.getCatalogName(), table.getSchemaName(), table.getName(), databaseIdentifierQuoteString, databaseIdentifierQuoteString));
                sql.append(" GROUP BY ").append(databaseIdentifierQuoteString);
                sql.append(col.getName()).append(databaseIdentifierQuoteString);
                sql.append(" ORDER BY COUNT1 DESC");
                lastSQL = sql.toString();
                rs = stmt.executeQuery(lastSQL);
                int topNCount = this.settings.getTopNCount();
                int topNSum = 0;
                for (int n = 0; rs.next() && n < topNCount; ++n) {
                    cpr.addValueCount(rs.getObject("MYVALUE"), rs.getInt("COUNT1"));
                    topNSum += rs.getInt("COUNT1");
                }
                int remainingCount = cpr.getParent().getRowCount() - topNSum;
                if (remainingCount > 0) {
                    cpr.addValueCount("Other Values", remainingCount);
                }
                rs.close();
                rs = null;
            }
            cpr.setCreateEndTime(System.currentTimeMillis());
        }
        catch (SQLException ex) {
            logger.error((Object)"Profiling query failed.  Will throw exception.  Query was:");
            logger.error(lastSQL);
            throw ex;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException ex) {
                logger.error((Object)"Couldn't clean up result set", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doColumnProfile(ColumnProfileResult cpr, MonitorableImpl pm) throws SQLException, SQLObjectException {
        logger.debug((Object)("Doing profile for column " + ((SQLColumn)cpr.getProfiledObject()).getName()));
        if (pm.isCancelled()) {
            return;
        }
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        String lastSQL = null;
        try {
            SQLColumn col = (SQLColumn)cpr.getProfiledObject();
            SQLDatabase db = col.getParent().getParentDatabase();
            con = db.getConnection();
            stmt = con.createStatement();
            stmt.setEscapeProcessing(false);
            ProfileFunctionDescriptor pfd = this.profileFunctionMap.get(col.getSourceDataTypeName());
            long profileStartTime = System.currentTimeMillis();
            if (pfd == null) {
                logger.debug((Object)(col.getName() + " Unknown DataType:(" + col.getSourceDataTypeName() + ")."));
                logger.debug((Object)("Known data types are: " + this.profileFunctionMap.keySet()));
                pfd = this.discoverProfileFunctionDescriptor(col, con, (Monitorable)pm);
                this.profileFunctionMap.put(col.getSourceDataTypeName(), pfd);
            }
            try {
                this.execProfileFunctions(cpr, pfd, col, con, (Monitorable)pm);
            }
            catch (Exception ex) {
                cpr.setCreateStartTime(profileStartTime);
                cpr.setException(ex);
                cpr.setCreateEndTime(System.currentTimeMillis());
                logger.error((Object)("Error in Column Profiling: " + lastSQL), (Throwable)ex);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                logger.error((Object)"Couldn't clean up result set", (Throwable)ex);
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException ex) {
                logger.error((Object)"Couldn't clean up statement", (Throwable)ex);
            }
            if (con != null) {
                con.close();
            }
        }
    }

    private void createProfileFunctions(JDBCDataSourceType dsType) {
        String dataTypeToParse;
        this.profileFunctionMap = new HashMap<String, ProfileFunctionDescriptor>();
        logger.debug((Object)("The property to retrieve is " + ProfileFunctionDescriptor.class.getName() + "_(number)"));
        int dataTypeCount = 0;
        while ((dataTypeToParse = dsType.getProperty(ProfileFunctionDescriptor.class.getName() + "_" + dataTypeCount)) != null) {
            ProfileFunctionDescriptor pfd = ProfileFunctionDescriptor.parseDescriptorString(dataTypeToParse);
            this.profileFunctionMap.put(pfd.getArchitectSpecificName(), pfd);
            ++dataTypeCount;
        }
        logger.debug((Object)("The property to retrieve is " + RemoteDatabaseProfileCreator.propName(StringLengthSQLFunction.class)));
        String function = dsType.getProperty(RemoteDatabaseProfileCreator.propName(StringLengthSQLFunction.class));
        String[] functionParts = function.split(":");
        if (functionParts.length != 2) {
            throw new RuntimeException("Configuration error in SQL String Length Function Descriptor for " + dsType.getName() + ":\n" + "Function descriptor must have exactly one : character in it (eg. 'LENGTH(:)')\n" + "Current setting for your database is '" + function + "'");
        }
        this.stringLengthSQLFunction = new StringLengthSQLFunction(functionParts[0], functionParts[1]);
        function = dsType.getProperty(RemoteDatabaseProfileCreator.propName(AverageSQLFunction.class));
        functionParts = function.split(":");
        if (functionParts.length != 2) {
            throw new RuntimeException("Configuration error in SQL Average Function Descriptor for " + dsType.getName() + ":\n" + "Function descriptor must have exactly one : character in it (eg. 'AVG(:)')\n" + "Current setting for your database is '" + function + "'");
        }
        this.averageSQLFunction = new AverageSQLFunction(functionParts[0], functionParts[1]);
        function = dsType.getProperty(RemoteDatabaseProfileCreator.propName(CaseWhenNullSQLFunction.class));
        functionParts = function.split(":");
        if (functionParts.length != 3) {
            throw new RuntimeException("Configuration error in SQL WHEN NULL Function Descriptor for " + dsType.getName() + ":\n" + "Function descriptor must have exactly two : characters in it (eg. 'CASE WHEN : IS NULL THEN : END')\n" + "Current setting for your database is '" + function + "'");
        }
        this.caseWhenNullSQLFunction = new CaseWhenNullSQLFunction(functionParts[0], functionParts[1], functionParts[2]);
    }

    private ProfileFunctionDescriptor discoverProfileFunctionDescriptor(SQLColumn col, Connection conn, Monitorable pm) {
        ProfileFunctionDescriptor pfd = new ProfileFunctionDescriptor(col.getSourceDataTypeName(), col.getType(), false, false, false, false, false, false, false, false);
        TableProfileResult dummyParent = new TableProfileResult(col.getParent(), new ProfileSettings());
        dummyParent.setRowCount(1);
        ColumnProfileResult dummy = new ColumnProfileResult(col);
        dummyParent.addColumnProfileResult(dummy);
        logger.debug((Object)("Discovering profile functions for column " + col));
        if (pm.isCancelled()) {
            return null;
        }
        try {
            pfd.setCountDist(true);
            this.execProfileFunctions(dummy, pfd, col, conn, pm);
            logger.debug((Object)"countDist worked");
        }
        catch (Exception e) {
            logger.debug((Object)"countDist failed", (Throwable)e);
            pfd.setCountDist(false);
        }
        if (pm.isCancelled()) {
            return null;
        }
        try {
            pfd.setMaxValue(true);
            pfd.setMinValue(true);
            this.execProfileFunctions(dummy, pfd, col, conn, pm);
            logger.debug((Object)"min/max worked");
        }
        catch (Exception e) {
            logger.debug((Object)"min/max failed", (Throwable)e);
            pfd.setMaxValue(false);
            pfd.setMinValue(false);
        }
        if (pm.isCancelled()) {
            return null;
        }
        try {
            pfd.setAvgValue(true);
            this.execProfileFunctions(dummy, pfd, col, conn, pm);
            logger.debug((Object)"avg worked");
        }
        catch (Exception e) {
            logger.debug((Object)"avg failed", (Throwable)e);
            pfd.setAvgValue(false);
        }
        if (pm.isCancelled()) {
            return null;
        }
        try {
            pfd.setMaxLength(true);
            pfd.setMinLength(true);
            pfd.setAvgLength(true);
            this.execProfileFunctions(dummy, pfd, col, conn, pm);
            logger.debug((Object)"min/max/avg length worked");
        }
        catch (Exception e) {
            logger.debug((Object)"min/max/avg length failed", (Throwable)e);
            pfd.setMaxLength(false);
            pfd.setMinLength(false);
            pfd.setAvgLength(false);
        }
        if (pm.isCancelled()) {
            return null;
        }
        try {
            pfd.setSumDecode(true);
            this.execProfileFunctions(dummy, pfd, col, conn, pm);
            logger.debug((Object)"sumDecode worked");
        }
        catch (Exception e) {
            logger.debug((Object)"sumDecode failed", (Throwable)e);
            pfd.setSumDecode(false);
        }
        return pfd;
    }

    public static String propName(Class<?> forClass) {
        if (forClass == AverageSQLFunction.class) {
            return "ca.sqlpower.architect.profile.ColumnProfileResult$AverageSQLFunction";
        }
        if (forClass == CaseWhenNullSQLFunction.class) {
            return "ca.sqlpower.architect.profile.ColumnProfileResult$CaseWhenNullSQLFunction";
        }
        if (forClass == StringLengthSQLFunction.class) {
            return "ca.sqlpower.architect.profile.ColumnProfileResult$StringLengthSQLFunction";
        }
        return forClass.getName();
    }

    public String toString() {
        return "Remote Database";
    }

    public class CaseWhenNullSQLFunction {
        private String startOfNullCase;
        private String middleOfNullCase;
        private String endOfNullCase;

        public CaseWhenNullSQLFunction(String startOfNullCase, String middleOfNullCase, String endOfNullCase) {
            this.startOfNullCase = startOfNullCase;
            this.middleOfNullCase = middleOfNullCase;
            this.endOfNullCase = endOfNullCase;
        }

        public String getCaseWhenNullSQLFunction(String expression, String then) {
            return this.startOfNullCase + expression + this.middleOfNullCase + then + this.endOfNullCase;
        }
    }

    public class AverageSQLFunction {
        private String startOfAverage;
        private String endOfAverage;

        public AverageSQLFunction(String startOfAverage, String endOfAverage) {
            this.startOfAverage = startOfAverage;
            this.endOfAverage = endOfAverage;
        }

        public String getAverageSQLFunction(String expression) {
            return this.startOfAverage + expression + this.endOfAverage;
        }
    }

    public class StringLengthSQLFunction {
        private String startOfLength;
        private String endOfLength;

        public StringLengthSQLFunction(String startOfLength, String endOfLength) {
            this.startOfLength = startOfLength;
            this.endOfLength = endOfLength;
        }

        public String getStringLengthSQLFunction(String expression) {
            return this.startOfLength + expression + this.endOfLength;
        }
    }
}

