/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.ARef;
import clojure.lang.IFn;
import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentStack;
import clojure.lang.IPersistentVector;
import clojure.lang.ISeq;
import clojure.lang.Keyword;
import clojure.lang.LockingTransaction;
import clojure.lang.PersistentQueue;
import clojure.lang.PersistentVector;
import clojure.lang.RT;
import clojure.lang.Util;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class Agent
extends ARef {
    static final Keyword CONTINUE = Keyword.intern(null, "continue");
    static final Keyword FAIL = Keyword.intern(null, "fail");
    volatile Object state;
    AtomicReference<ActionQueue> aq = new AtomicReference<ActionQueue>(ActionQueue.EMPTY);
    volatile Keyword errorMode = CONTINUE;
    volatile IFn errorHandler = null;
    private static final AtomicLong sendThreadPoolCounter = new AtomicLong(0L);
    private static final AtomicLong sendOffThreadPoolCounter = new AtomicLong(0L);
    public static final ExecutorService pooledExecutor = Executors.newFixedThreadPool(2 + Runtime.getRuntime().availableProcessors(), Agent.createThreadFactory("clojure-agent-send-pool-%d", sendThreadPoolCounter));
    public static final ExecutorService soloExecutor = Executors.newCachedThreadPool(Agent.createThreadFactory("clojure-agent-send-off-pool-%d", sendOffThreadPoolCounter));
    static final ThreadLocal<IPersistentVector> nested = new ThreadLocal();

    private static ThreadFactory createThreadFactory(final String format2, final AtomicLong threadPoolCounter) {
        return new ThreadFactory(){

            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable);
                thread.setName(String.format(format2, threadPoolCounter.getAndIncrement()));
                return thread;
            }
        };
    }

    public static void shutdown() {
        soloExecutor.shutdown();
        pooledExecutor.shutdown();
    }

    public Agent(Object state) {
        this(state, null);
    }

    public Agent(Object state, IPersistentMap meta2) {
        super(meta2);
        this.setState(state);
    }

    boolean setState(Object newState) {
        this.validate(newState);
        boolean ret = this.state != newState;
        this.state = newState;
        return ret;
    }

    public Object deref() {
        return this.state;
    }

    public Throwable getError() {
        return this.aq.get().error;
    }

    public void setErrorMode(Keyword k) {
        this.errorMode = k;
    }

    public Keyword getErrorMode() {
        return this.errorMode;
    }

    public void setErrorHandler(IFn f) {
        this.errorHandler = f;
    }

    public IFn getErrorHandler() {
        return this.errorHandler;
    }

    public synchronized Object restart(Object newState, boolean clearActions) {
        if (this.getError() == null) {
            throw Util.runtimeException("Agent does not need a restart");
        }
        this.validate(newState);
        this.state = newState;
        if (clearActions) {
            this.aq.set(ActionQueue.EMPTY);
        } else {
            boolean restarted = false;
            ActionQueue prior = null;
            while (!restarted) {
                prior = this.aq.get();
                restarted = this.aq.compareAndSet(prior, new ActionQueue(prior.q, null));
            }
            if (prior.q.count() > 0) {
                ((Action)prior.q.peek()).execute();
            }
        }
        return newState;
    }

    public Object dispatch(IFn fn2, ISeq args, boolean solo) {
        Throwable error = this.getError();
        if (error != null) {
            throw Util.runtimeException("Agent is failed, needs restart", error);
        }
        Action action = new Action(this, fn2, args, solo);
        Agent.dispatchAction(action);
        return this;
    }

    static void dispatchAction(Action action) {
        LockingTransaction trans = LockingTransaction.getRunning();
        if (trans != null) {
            trans.enqueue(action);
        } else if (nested.get() != null) {
            nested.set(nested.get().cons(action));
        } else {
            action.agent.enqueue(action);
        }
    }

    void enqueue(Action action) {
        boolean queued = false;
        ActionQueue prior = null;
        while (!queued) {
            prior = this.aq.get();
            queued = this.aq.compareAndSet(prior, new ActionQueue((IPersistentStack)prior.q.cons(action), prior.error));
        }
        if (prior.q.count() == 0 && prior.error == null) {
            action.execute();
        }
    }

    public int getQueueCount() {
        return this.aq.get().q.count();
    }

    public static int releasePendingSends() {
        IPersistentVector sends = nested.get();
        if (sends == null) {
            return 0;
        }
        for (int i = 0; i < sends.count(); ++i) {
            Action a = (Action)sends.valAt(i);
            a.agent.enqueue(a);
        }
        nested.set(PersistentVector.EMPTY);
        return sends.count();
    }

    static class Action
    implements Runnable {
        final Agent agent;
        final IFn fn;
        final ISeq args;
        final boolean solo;

        public Action(Agent agent2, IFn fn2, ISeq args, boolean solo) {
            this.agent = agent2;
            this.args = args;
            this.fn = fn2;
            this.solo = solo;
        }

        void execute() {
            block6: {
                try {
                    if (this.solo) {
                        soloExecutor.execute(this);
                    } else {
                        pooledExecutor.execute(this);
                    }
                }
                catch (Throwable error) {
                    if (this.agent.errorHandler == null) break block6;
                    try {
                        this.agent.errorHandler.invoke(this.agent, error);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void doRun(Action action) {
            try {
                nested.set(PersistentVector.EMPTY);
                Throwable error = null;
                try {
                    Object oldval = action.agent.state;
                    Object newval = action.fn.applyTo(RT.cons(action.agent.state, action.args));
                    action.agent.setState(newval);
                    action.agent.notifyWatches(oldval, newval);
                }
                catch (Throwable e2) {
                    error = e2;
                }
                if (error == null) {
                    Agent.releasePendingSends();
                } else {
                    nested.set(null);
                    if (action.agent.errorHandler != null) {
                        try {
                            action.agent.errorHandler.invoke(action.agent, error);
                        }
                        catch (Throwable e3) {
                            // empty catch block
                        }
                    }
                    if (action.agent.errorMode == CONTINUE) {
                        error = null;
                    }
                }
                boolean popped = false;
                ActionQueue next2 = null;
                while (!popped) {
                    ActionQueue prior = action.agent.aq.get();
                    next2 = new ActionQueue(prior.q.pop(), error);
                    popped = action.agent.aq.compareAndSet(prior, next2);
                }
                if (error == null && next2.q.count() > 0) {
                    ((Action)next2.q.peek()).execute();
                }
            }
            finally {
                nested.set(null);
            }
        }

        public void run() {
            Action.doRun(this);
        }
    }

    static class ActionQueue {
        public final IPersistentStack q;
        public final Throwable error;
        static final ActionQueue EMPTY = new ActionQueue(PersistentQueue.EMPTY, null);

        public ActionQueue(IPersistentStack q, Throwable error) {
            this.q = q;
            this.error = error;
        }
    }
}

