/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.importer.ui.contribution.base;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.converter.ModelConverter;
import org.eclipse.emf.converter.ui.contribution.base.ModelConverterPackagePage;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.importer.ImporterPlugin;
import org.eclipse.emf.importer.ModelImporter;
import org.eclipse.emf.importer.ui.contribution.base.IModelImporterPage;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class ModelImporterPackagePage
extends ModelConverterPackagePage
implements IModelImporterPage {
    public ModelImporterPackagePage(ModelImporter modelImporter, String pageName) {
        super((ModelConverter)modelImporter, pageName);
        this.setDescription(ImporterPlugin.INSTANCE.getString("_UI_PackageSelection_description"));
    }

    public ModelImporter getModelImporter() {
        return (ModelImporter)this.getModelConverter();
    }

    protected void adjustEPackagesTableViewer(CheckboxTableViewer ePackagesTableViewer) {
        super.adjustEPackagesTableViewer(ePackagesTableViewer);
        this.createEPackageDataColumnTableEditor();
    }

    protected boolean validateEPackageData(EPackage ePackage, String data) {
        return this.validateEcoreModelFileName(data, null);
    }

    protected void setEPackageData(EPackage ePackage, String data) {
        ModelImporter.EPackageImportInfo ePackageInfo = this.getModelImporter().getEPackageImportInfo(ePackage);
        ePackageInfo.setEcoreFileName(data);
    }

    protected String getEPackageData(EPackage ePackage) {
        return this.getModelImporter().getEPackageImportInfo(ePackage).getEcoreFileName();
    }

    protected String getLabel(EPackage ePackage) {
        String result = super.getLabel(ePackage);
        String basePackage = this.getModelImporter().getEPackageImportInfo(ePackage).getBasePackage();
        if (basePackage != null) {
            result = String.valueOf(basePackage) + "." + result;
        }
        return result;
    }

    protected String getEPackageDataColumnLabel() {
        return ImporterPlugin.INSTANCE.getString("_UI_EcoreFileName_label");
    }

    protected void validate() {
        super.validate();
        if (this.getErrorMessage() == null) {
            List tableCheckedEPackages = this.getCheckedEPackages();
            Iterator i = tableCheckedEPackages.iterator();
            while (i.hasNext()) {
                EPackage ePackage = (EPackage)i.next();
                String fileName = this.getModelImporter().getEPackageImportInfo(ePackage).getEcoreFileName();
                if (this.validateEcoreModelFileName(fileName, ePackage.getName())) continue;
                return;
            }
            this.setErrorMessage(this.checkEcoreFileNames());
        }
    }

    protected String getPackagesLabel() {
        return ImporterPlugin.INSTANCE.getString("_UI_RootPackages_label");
    }

    protected boolean validateEcoreModelFileName(String fileName, String packageName) {
        Diagnostic diagnostic = this.getModelImporter().checkEcoreModelFileName(fileName, packageName);
        this.handleDiagnostic(diagnostic);
        return diagnostic.getSeverity() == 0;
    }

    protected String checkEcoreFileNames() {
        HashSet<String> fileNames = new HashSet<String>();
        int checkedCount = 0;
        Table table = this.ePackagesCheckboxTableViewer.getTable();
        TableItem[] tableItems = table.getItems();
        int i = 0;
        while (i < tableItems.length) {
            if (tableItems[i].getChecked()) {
                ++checkedCount;
                fileNames.add(tableItems[i].getText(1));
            }
            ++i;
        }
        return fileNames.size() < checkedCount ? ImporterPlugin.INSTANCE.getString("_UI_DuplicateEcoreNames_message") : null;
    }

    protected void addReferencedGenModels(List genModels) {
        super.addReferencedGenModels(genModels);
        if (this.getModelImporter().getOriginalGenModel() != null) {
            Iterator i = this.getModelImporter().getOriginalGenModel().getUsedGenPackages().iterator();
            block0: while (i.hasNext()) {
                GenModel genModel = ((GenPackage)i.next()).getGenModel();
                if (genModel == null) continue;
                URI genModelURI = genModel.eResource().getURI();
                Iterator k = genModels.iterator();
                while (k.hasNext()) {
                    GenModel otherGenModel = (GenModel)k.next();
                    if (genModelURI.equals((Object)otherGenModel.eResource().getURI())) continue block0;
                }
                genModels.add(genModel);
            }
        }
    }
}

