/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.plugin.eclipse;

import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.TigerSubstitutes;
import edu.umd.cs.findbugs.config.AnalysisFeatureSetting;
import edu.umd.cs.findbugs.config.SortedProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedPreferences
implements Cloneable {
    public static final String EFFORT_MIN = "min";
    public static final String EFFORT_DEFAULT = "default";
    public static final String EFFORT_MAX = "max";
    private static final String EFFORT_KEY = "effort";
    private static final String INCLUDE_FILTER_KEY = "includefilter";
    private static final String EXCLUDE_FILTER_KEY = "excludefilter";
    private String effort = "default";
    private Collection<String> includeFilterFiles = TigerSubstitutes.emptySet();
    private Collection<String> excludeFilterFiles = TigerSubstitutes.emptySet();

    public String getEffort() {
        return this.effort;
    }

    public void setEffort(String effort) {
        if (!(EFFORT_MIN.equals(effort) || EFFORT_DEFAULT.equals(effort) || EFFORT_MAX.equals(effort))) {
            throw new IllegalArgumentException(new StringBuffer().append("Effort \"").append(effort).append("\" is not a valid effort value.").toString());
        }
        this.effort = effort;
    }

    public Collection<String> getIncludeFilterFiles() {
        return this.includeFilterFiles;
    }

    public void setIncludeFilterFiles(Collection<String> includeFilterFiles) {
        if (includeFilterFiles == null) {
            throw new IllegalArgumentException("includeFilterFiles may not be null.");
        }
        this.includeFilterFiles = includeFilterFiles;
    }

    public void setExcludeFilterFiles(Collection<String> excludeFilterFiles) {
        if (excludeFilterFiles == null) {
            throw new IllegalArgumentException("excludeFilterFiles may not be null.");
        }
        this.excludeFilterFiles = excludeFilterFiles;
    }

    public Collection<String> getExcludeFilterFiles() {
        return this.excludeFilterFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("File may not be null");
        }
        if (!file.exists() || !file.isFile()) {
            throw new IllegalArgumentException(new StringBuffer().append("File \"").append(file.getAbsolutePath()).append("\" should exist and must be a file.").toString());
        }
        Properties props = new Properties();
        FileInputStream inputStream = new FileInputStream(file);
        try {
            props.load(inputStream);
        }
        finally {
            inputStream.close();
        }
        this.effort = props.getProperty(EFFORT_KEY, EFFORT_DEFAULT);
        this.includeFilterFiles = this.readFilters(props, INCLUDE_FILTER_KEY);
        this.excludeFilterFiles = this.readFilters(props, EXCLUDE_FILTER_KEY);
    }

    private Set<String> readFilters(Properties props, String keyPrefix) {
        LinkedHashSet<String> filters = new LinkedHashSet<String>();
        int counter = 0;
        boolean keyFound = true;
        while (keyFound) {
            String property = props.getProperty(new StringBuffer().append(keyPrefix).append(counter).toString());
            if (property != null) {
                filters.add(property);
                ++counter;
                continue;
            }
            keyFound = false;
        }
        return filters;
    }

    private void writeFilters(Properties props, String keyPrefix, Collection<String> filters) {
        int counter = 0;
        for (String s : filters) {
            props.setProperty(new StringBuffer().append(keyPrefix).append(counter).toString(), s);
            ++counter;
        }
        boolean keyFound = true;
        while (keyFound) {
            String key = new StringBuffer().append(keyPrefix).append(counter).toString();
            String property = props.getProperty(key);
            if (property == null) {
                keyFound = false;
                continue;
            }
            props.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("File may not be null");
        }
        if (!file.exists() || !file.isFile()) {
            throw new IllegalArgumentException(new StringBuffer().append("File \"").append(file.getAbsolutePath()).append("\" should exist and must be a file.").toString());
        }
        SortedProperties props = new SortedProperties();
        FileInputStream inputStream = new FileInputStream(file);
        try {
            props.load(inputStream);
            props.setProperty(EFFORT_KEY, this.effort);
            this.writeFilters((Properties)props, INCLUDE_FILTER_KEY, this.includeFilterFiles);
            this.writeFilters((Properties)props, EXCLUDE_FILTER_KEY, this.excludeFilterFiles);
            FileOutputStream outputStream = new FileOutputStream(file);
            try {
                props.store(outputStream, "FindBugs User Preferences");
            }
            finally {
                outputStream.close();
            }
        }
        finally {
            inputStream.close();
        }
        this.effort = props.getProperty(EFFORT_KEY, EFFORT_DEFAULT);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public int hashCode() {
        return this.effort.hashCode() + ((Object)this.includeFilterFiles).hashCode() + ((Object)this.excludeFilterFiles).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof ExtendedPreferences) {
            ExtendedPreferences other = (ExtendedPreferences)obj;
            return this.effort.equals(other.effort) && ((Object)this.includeFilterFiles).equals(other.includeFilterFiles) && ((Object)this.excludeFilterFiles).equals(other.excludeFilterFiles);
        }
        return false;
    }

    public AnalysisFeatureSetting[] getAnalysisFeatureSettings() {
        if (this.effort.equals(EFFORT_DEFAULT)) {
            return FindBugs.DEFAULT_EFFORT;
        }
        if (this.effort.equals(EFFORT_MIN)) {
            return FindBugs.MIN_EFFORT;
        }
        return FindBugs.MAX_EFFORT;
    }
}

