/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;

public class ConfusionBetweenInheritedAndOuterMethod
extends BytecodeScanningDetector {
    BugReporter bugReporter;
    boolean hasThisDollarZero;
    OpcodeStack stack = new OpcodeStack();

    public ConfusionBetweenInheritedAndOuterMethod(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitJavaClass(JavaClass obj) {
        this.hasThisDollarZero = false;
        if (obj.getClassName().indexOf(36) >= 0) {
            super.visitJavaClass(obj);
        }
    }

    public void visit(Field f) {
        if (f.getName().equals("this$0")) {
            this.hasThisDollarZero = true;
        }
    }

    public void visit(Code obj) {
        if (this.hasThisDollarZero) {
            this.stack.resetForMethodEntry((DismantleBytecode)this);
            super.visit(obj);
        }
    }

    private static String stripLastDollar(String s) {
        int i = s.lastIndexOf(36);
        if (i == -1) {
            throw new IllegalArgumentException();
        }
        return s.substring(0, i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        block15: {
            this.stack.mergeJumps((DismantleBytecode)this);
            try {
                XMethod alternativeMethod;
                if (seen != 182) {
                    return;
                }
                if (!this.getClassName().equals(this.getClassConstantOperand())) {
                    return;
                }
                XMethod invokedMethod = XFactory.createXMethod((String)this.getDottedClassConstantOperand(), (String)this.getNameConstantOperand(), (String)this.getSigConstantOperand(), (boolean)false);
                if (invokedMethod.isResolved() && invokedMethod.getClassName().equals(this.getDottedClassConstantOperand())) {
                    return;
                }
                String possibleTargetClass = this.getDottedClassName();
                String superClassName = this.getDottedSuperclassName();
                do {
                    int i;
                    if ((i = possibleTargetClass.lastIndexOf(36)) == -1) {
                    } else if (!(possibleTargetClass = possibleTargetClass.substring(0, i)).equals(superClassName)) continue;
                    break block15;
                } while (!(alternativeMethod = XFactory.createXMethod((String)possibleTargetClass, (String)this.getNameConstantOperand(), (String)this.getSigConstantOperand(), (boolean)false)).isResolved() || !alternativeMethod.getClassName().equals(possibleTargetClass));
                String targetPackage = invokedMethod.getPackageName();
                String alternativePackage = alternativeMethod.getPackageName();
                int priority = 1;
                if (targetPackage.equals(alternativePackage)) {
                    ++priority;
                }
                if (targetPackage.startsWith("javax.swing") || targetPackage.startsWith("java.awt")) {
                    priority += 2;
                }
                if (invokedMethod.getName().equals(this.getMethodName())) {
                    ++priority;
                }
                this.bugReporter.reportBug(new BugInstance((Detector)this, "IA_AMBIGUOUS_INVOCATION_OF_INHERITED_OR_OUTER_METHOD", priority).addClassAndMethod((PreorderVisitor)this).addMethod(invokedMethod).describe("METHOD_INHERITED").addMethod(alternativeMethod).describe("METHOD_ALTERNATIVE_TARGET").addSourceLine((BytecodeScanningDetector)this, this.getPC()));
            }
            finally {
                this.stack.sawOpcode((DismantleBytecode)this, seen);
            }
        }
    }
}

