/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.internal.AbstractWorkingSet;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.util.Util;

public class AggregateWorkingSet
extends AbstractWorkingSet
implements IPropertyChangeListener {
    private IWorkingSet[] components;

    public AggregateWorkingSet(String name, String label, IWorkingSet[] components) {
        super(name, label);
        IWorkingSet[] componentCopy = new IWorkingSet[components.length];
        System.arraycopy(components, 0, componentCopy, 0, components.length);
        this.internalSetComponents(componentCopy);
        this.constructElements(false);
    }

    public AggregateWorkingSet(String name, String label, IMemento memento) {
        super(name, label);
        this.workingSetMemento = memento;
    }

    void setComponents(IWorkingSet[] components) {
        this.internalSetComponents(components);
        this.constructElements(true);
    }

    private void internalSetComponents(IWorkingSet[] components) {
        this.components = components;
    }

    private void constructElements(boolean fireEvent) {
        HashSet elements = new HashSet();
        int i = 0;
        while (i < this.components.length) {
            IWorkingSet workingSet = this.components[i];
            elements.addAll(Arrays.asList(workingSet.getElements()));
            ++i;
        }
        this.internalSetElements(elements.toArray(new IAdaptable[elements.size()]));
        if (fireEvent) {
            this.fireWorkingSetChanged("workingSetContentChange", null);
        }
    }

    public String getId() {
        return null;
    }

    public ImageDescriptor getImage() {
        return WorkbenchImages.getImageDescriptor("IMG_OBJ_WORKING_SETS");
    }

    public void setElements(IAdaptable[] elements) {
    }

    public void setId(String id) {
    }

    public boolean isEditable() {
        return false;
    }

    public boolean isVisible() {
        return false;
    }

    public void saveState(IMemento memento) {
        if (this.workingSetMemento != null) {
            memento.putMemento(this.workingSetMemento);
        } else {
            memento.putString("name", this.getName());
            memento.putString("label", this.getLabel());
            memento.putString("aggregate", Boolean.TRUE.toString());
            int i = 0;
            while (i < this.components.length) {
                IWorkingSet componentSet = this.components[i];
                memento.createChild("workingSet", componentSet.getName());
                ++i;
            }
        }
    }

    public void connect(IWorkingSetManager manager) {
        manager.addPropertyChangeListener(this);
        super.connect(manager);
    }

    public void disconnect() {
        this.getManager().removePropertyChangeListener(this);
        super.disconnect();
    }

    public IWorkingSet[] getComponents() {
        if (this.components == null) {
            this.restoreWorkingSet();
            this.workingSetMemento = null;
        }
        return this.components;
    }

    public void propertyChange(PropertyChangeEvent event) {
        block4: {
            String property;
            block5: {
                property = event.getProperty();
                if (!property.equals("workingSetRemove")) break block5;
                int i = 0;
                while (i < this.getComponents().length) {
                    IWorkingSet set = this.getComponents()[i];
                    if (set.equals(event.getOldValue())) {
                        Object[] newComponents = new IWorkingSet[this.components.length - 1];
                        Util.arrayCopyWithRemoval(this.getComponents(), newComponents, i);
                        this.setComponents((IWorkingSet[])newComponents);
                    }
                    ++i;
                }
                break block4;
            }
            if (!property.equals("workingSetContentChange")) break block4;
            int i = 0;
            while (i < this.getComponents().length) {
                IWorkingSet set = this.getComponents()[i];
                if (set.equals(event.getNewValue())) {
                    this.constructElements(true);
                    break;
                }
                ++i;
            }
        }
    }

    void restoreWorkingSet() {
        IWorkingSetManager manager = this.getManager();
        if (manager == null) {
            throw new IllegalStateException();
        }
        IMemento[] workingSetReferences = this.workingSetMemento.getChildren("workingSet");
        ArrayList<IWorkingSet> list = new ArrayList<IWorkingSet>(workingSetReferences.length);
        int i = 0;
        while (i < workingSetReferences.length) {
            IMemento setReference = workingSetReferences[i];
            String setId = setReference.getID();
            IWorkingSet set = manager.getWorkingSet(setId);
            if (set != null) {
                list.add(set);
            }
            ++i;
        }
        this.internalSetComponents(list.toArray(new IWorkingSet[list.size()]));
        this.constructElements(false);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof AggregateWorkingSet) {
            AggregateWorkingSet workingSet = (AggregateWorkingSet)object;
            return Util.equals(workingSet.getName(), this.getName()) && Util.equals(workingSet.getComponents(), this.getComponents());
        }
        return false;
    }

    public int hashCode() {
        int hashCode = this.getName().hashCode() & this.getComponents().hashCode();
        return hashCode;
    }

    public boolean isSelfUpdating() {
        if (this.components == null || this.components.length == 0) {
            return false;
        }
        int i = 0;
        while (i < this.components.length) {
            if (!this.components[i].isSelfUpdating()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isAggregateWorkingSet() {
        return true;
    }
}

