/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal.env;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.apt.core.internal.AptPlugin;
import org.eclipse.jdt.apt.core.internal.env.BuildEnv;
import org.eclipse.jdt.apt.core.internal.generatedfile.FileGenerationResult;
import org.eclipse.jdt.apt.core.internal.generatedfile.GeneratedFileManager;

public class JavaSourceFilePrintWriter
extends PrintWriter {
    private final StringWriter _sw;
    private final String _typeName;
    private final BuildEnv _env;

    public JavaSourceFilePrintWriter(String typeName, StringWriter sw, BuildEnv env) {
        super(sw);
        this._sw = sw;
        this._typeName = typeName;
        this._env = env;
    }

    public void close() {
        try {
            String contents = this._sw.toString();
            super.close();
            GeneratedFileManager gfm = this._env.getAptProject().getGeneratedFileManager();
            FileGenerationResult result = gfm.generateFileDuringBuild(this._env.getFile(), this._typeName, contents, null);
            if (result != null) {
                this._env.addGeneratedSourceFile(result.getFile(), result.isModified());
            }
        }
        catch (CoreException ce) {
            AptPlugin.log(ce, "Unable to generate type when JavaSourceFilePrintWriter was closed");
        }
    }
}

