/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.dtd;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.ant.internal.ui.dtd.AntDTDMessages;
import org.eclipse.ant.internal.ui.dtd.ISchema;
import org.eclipse.ant.internal.ui.dtd.ParseError;
import org.eclipse.ant.internal.ui.dtd.schema.SchemaFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class Parser {
    public static final String NOT_SUPPORTED = AntDTDMessages.Parser_XML_parser_does_not_support_DeclHandler_1;
    public static final String PARSE_ERROR = AntDTDMessages.Parser_Error_parsing_XML_document_or_DTD_2;
    private static final String INTERNAL = "internal://usereader.objfac.com";

    public ISchema parse(InputSource inputSource, EntityResolver entityResolver) throws ParseError, IOException {
        XMLReader parser = null;
        SchemaFactory factory = new SchemaFactory();
        try {
            parser = this.getXMLReader();
            SchemaFactory handler = factory;
            parser.setProperty("http://xml.org/sax/properties/declaration-handler", handler);
            if (entityResolver != null) {
                parser.setEntityResolver(entityResolver);
            }
            parser.parse(inputSource);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            throw new ParseError(NOT_SUPPORTED);
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            throw new ParseError(NOT_SUPPORTED);
        }
        catch (SAXException e) {
            factory.setErrorException(e);
        }
        return factory.getSchema();
    }

    private XMLReader getXMLReader() throws ParseError {
        SAXParser parser = null;
        try {
            parser = SAXParserFactory.newInstance().newSAXParser();
            return parser.getXMLReader();
        }
        catch (ParserConfigurationException e) {
            throw new ParseError(e.getMessage());
        }
        catch (SAXException e) {
            throw new ParseError(e.getMessage());
        }
    }

    public ISchema parse(String url) throws ParseError, IOException {
        return this.parse(new InputSource(url), null);
    }

    public ISchema parse(Reader reader) throws ParseError, IOException {
        return this.parse(new InputSource(reader), null);
    }

    public ISchema parseDTD(String pub, String sys, String root) throws ParseError, IOException {
        return this.parse(new InputSource(new DTDReader(pub, sys, root)), null);
    }

    public ISchema parseDTD(Reader reader, String root) throws ParseError, IOException {
        return this.parse(new InputSource(new DTDReader(INTERNAL, INTERNAL, root)), new DTDEntityResolver(reader));
    }

    private static class DTDReader
    extends Reader {
        private Reader fDelegate;

        public DTDReader(String pub, String sys, String root) {
            String document = "<!DOCTYPE " + root + " PUBLIC '" + pub + "' '" + sys + "'><" + root + "/>";
            this.fDelegate = new StringReader(document);
        }

        public void close() throws IOException {
            this.fDelegate.close();
        }

        public int read(char[] cbuf, int off, int len) throws IOException {
            return this.fDelegate.read(cbuf, off, len);
        }
    }

    private static class DTDEntityResolver
    implements EntityResolver {
        private Reader reader;

        public DTDEntityResolver(Reader reader) {
            this.reader = reader;
        }

        public InputSource resolveEntity(String publicId, String systemId) {
            if (publicId.equals(Parser.INTERNAL) && systemId.equals(Parser.INTERNAL)) {
                return new InputSource(this.reader);
            }
            return null;
        }
    }
}

