/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.jres;

import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.debug.ui.IJavaDebugUIConstants;
import org.eclipse.jdt.internal.debug.ui.jres.JREMessages;
import org.eclipse.jdt.launching.LibraryLocation;

public final class LibraryStandin {
    private IPath fSystemLibrary;
    private IPath fSystemLibrarySource;
    private IPath fPackageRootPath;
    private URL fJavadocLocation;

    public LibraryStandin(LibraryLocation libraryLocation) {
        this.fSystemLibrary = libraryLocation.getSystemLibraryPath();
        this.setSystemLibrarySourcePath(libraryLocation.getSystemLibrarySourcePath());
        this.setPackageRootPath(libraryLocation.getPackageRootPath());
        this.setJavadocLocation(libraryLocation.getJavadocLocation());
    }

    public IPath getSystemLibraryPath() {
        return this.fSystemLibrary;
    }

    public IPath getSystemLibrarySourcePath() {
        return this.fSystemLibrarySource;
    }

    void setSystemLibrarySourcePath(IPath path) {
        this.fSystemLibrarySource = path;
    }

    public IPath getPackageRootPath() {
        return this.fPackageRootPath;
    }

    void setPackageRootPath(IPath path) {
        this.fPackageRootPath = path;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LibraryStandin) {
            LibraryStandin lib = (LibraryStandin)obj;
            return this.getSystemLibraryPath().equals((Object)lib.getSystemLibraryPath()) && this.equals(this.getSystemLibrarySourcePath(), lib.getSystemLibrarySourcePath()) && this.equals(this.getPackageRootPath(), lib.getPackageRootPath()) && this.equalsOrNull(this.getJavadocLocation(), lib.getJavadocLocation());
        }
        return false;
    }

    public int hashCode() {
        return this.getSystemLibraryPath().hashCode();
    }

    protected boolean equals(IPath path1, IPath path2) {
        return this.equalsOrNull(path1, path2);
    }

    private boolean equalsOrNull(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public URL getJavadocLocation() {
        return this.fJavadocLocation;
    }

    void setJavadocLocation(URL url) {
        this.fJavadocLocation = url;
    }

    LibraryLocation toLibraryLocation() {
        return new LibraryLocation(this.getSystemLibraryPath(), this.getSystemLibrarySourcePath(), this.getPackageRootPath(), this.getJavadocLocation());
    }

    IStatus validate() {
        if (!this.getSystemLibraryPath().toFile().exists()) {
            return new Status(4, IJavaDebugUIConstants.PLUGIN_ID, 150, MessageFormat.format(JREMessages.LibraryStandin_0, this.getSystemLibraryPath().toOSString()), null);
        }
        IPath path = this.getSystemLibrarySourcePath();
        if (!path.isEmpty() && !path.toFile().exists()) {
            return new Status(4, IJavaDebugUIConstants.PLUGIN_ID, 150, MessageFormat.format(JREMessages.LibraryStandin_1, path.toOSString()), null);
        }
        return Status.OK_STATUS;
    }
}

