/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.x509;

import gnu.java.security.OID;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.x509.GnuPKIExtension;
import gnu.java.security.x509.ext.Extension;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CRLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;

class X509CRLEntry
extends java.security.cert.X509CRLEntry
implements GnuPKIExtension {
    private static final Logger log = Logger.getLogger(X509CRLEntry.class.getName());
    private byte[] encoded;
    private BigInteger serialNo;
    private Date revocationDate;
    private HashMap extensions = new HashMap();

    X509CRLEntry(int version, DERReader encoded) throws CRLException, IOException {
        try {
            this.parse(version, encoded);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception x) {
            throw new CRLException(x.toString());
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof X509CRLEntry)) {
            return false;
        }
        return ((X509CRLEntry)o).getSerialNumber().equals(this.serialNo) && ((X509CRLEntry)o).getRevocationDate().equals(this.revocationDate);
    }

    public int hashCode() {
        return this.serialNo.hashCode();
    }

    public byte[] getEncoded() throws CRLException {
        return (byte[])this.encoded.clone();
    }

    public BigInteger getSerialNumber() {
        return this.serialNo;
    }

    public Date getRevocationDate() {
        return (Date)this.revocationDate.clone();
    }

    public boolean hasExtensions() {
        return !this.extensions.isEmpty();
    }

    public String toString() {
        return "X509CRLEntry serial=" + this.serialNo + " revocation date=" + this.revocationDate + " ext=" + this.extensions;
    }

    public boolean hasUnsupportedCriticalExtension() {
        for (Extension e : this.extensions.values()) {
            if (!e.isCritical() || e.isSupported()) continue;
            return true;
        }
        return false;
    }

    public Set getCriticalExtensionOIDs() {
        HashSet<String> s = new HashSet<String>();
        for (Extension e : this.extensions.values()) {
            if (!e.isCritical()) continue;
            s.add(e.getOid().toString());
        }
        return Collections.unmodifiableSet(s);
    }

    public Set getNonCriticalExtensionOIDs() {
        HashSet<String> s = new HashSet<String>();
        for (Extension e : this.extensions.values()) {
            if (e.isCritical()) continue;
            s.add(e.getOid().toString());
        }
        return Collections.unmodifiableSet(s);
    }

    public byte[] getExtensionValue(String oid) {
        Extension e = this.getExtension(new OID(oid));
        if (e != null) {
            return e.getValue().getEncoded();
        }
        return null;
    }

    public Extension getExtension(OID oid) {
        return (Extension)this.extensions.get(oid);
    }

    public Collection getExtensions() {
        return this.extensions.values();
    }

    private void parse(int version, DERReader der) throws Exception {
        DERValue entry = der.read();
        if (!entry.isConstructed()) {
            throw new IOException("malformed revokedCertificate");
        }
        this.encoded = entry.getEncoded();
        int len = 0;
        DERValue val = der.read();
        this.serialNo = (BigInteger)val.getValue();
        len += val.getEncodedLength();
        val = der.read();
        this.revocationDate = (Date)val.getValue();
        if ((len += val.getEncodedLength()) < entry.getLength()) {
            if (version < 2) {
                throw new IOException("extra data in CRL entry");
            }
            DERValue exts = der.read();
            if (!exts.isConstructed()) {
                throw new IOException("malformed Extensions");
            }
            len = 0;
            while (len < exts.getLength()) {
                val = der.read();
                if (!val.isConstructed()) {
                    throw new IOException("malformed Extension");
                }
                Extension e = new Extension(val.getEncoded());
                this.extensions.put(e.getOid(), e);
                der.skip(val.getLength());
                len += val.getEncodedLength();
            }
        }
    }
}

