/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.x509.ext;

import gnu.java.security.OID;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.x509.ext.Extension;
import java.io.IOException;
import java.math.BigInteger;

public class CRLNumber
extends Extension.Value {
    public static final OID ID = new OID("2.5.29.20");
    private final BigInteger number;

    public CRLNumber(byte[] encoded) throws IOException {
        super(encoded);
        DERValue val = DERReader.read(encoded);
        if (val.getTag() != 2) {
            throw new IOException("malformed CRLNumber");
        }
        this.number = (BigInteger)val.getValue();
    }

    public CRLNumber(BigInteger number) {
        this.number = number;
    }

    public BigInteger getNumber() {
        return this.number;
    }

    public byte[] getEncoded() {
        if (this.encoded == null) {
            this.encoded = new DERValue(2, this.number).getEncoded();
        }
        return (byte[])this.encoded.clone();
    }

    public String toString() {
        return String.valueOf(CRLNumber.class.getName()) + " [ " + this.number + " ]";
    }
}

