/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import gnu.java.lang.CPStringBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.FileTypeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MimetypesFileTypeMap
extends FileTypeMap {
    private static final int PROG = 0;
    private static final int HOME = 1;
    private static final int SYS = 2;
    private static final int JAR = 3;
    private static final int DEF = 4;
    private static final String DEFAULT_MIME_TYPE = "application/octet-stream";
    private static boolean debug = false;
    private Map<String, String>[] mimetypes;

    static {
        try {
            String d = System.getProperty("javax.activation.debug");
            debug = Boolean.valueOf(d);
        }
        catch (SecurityException securityException) {}
    }

    public MimetypesFileTypeMap() {
        this.init(null);
    }

    public MimetypesFileTypeMap(String mimeTypeFileName) throws IOException {
        FileReader in = null;
        try {
            in = new FileReader(mimeTypeFileName);
            this.init(in);
        }
        finally {
            if (in != null) {
                ((Reader)in).close();
            }
        }
    }

    public MimetypesFileTypeMap(InputStream is) {
        this.init(new InputStreamReader(is));
    }

    private void init(Reader in) {
        List<URL> systemResources;
        int len;
        this.mimetypes = new Map[5];
        int i = 0;
        while (i < this.mimetypes.length) {
            this.mimetypes[i] = new HashMap<String, String>();
            ++i;
        }
        if (in != null) {
            if (debug) {
                System.out.println("MimetypesFileTypeMap: load PROG");
            }
            try {
                this.parse(this.mimetypes[0], in);
            }
            catch (IOException iOException) {}
        }
        if (debug) {
            System.out.println("MimetypesFileTypeMap: load HOME");
        }
        try {
            String home = System.getProperty("user.home");
            if (home != null) {
                this.parseFile(this.mimetypes[1], new CPStringBuilder(home).append(File.separatorChar).append(".mime.types").toString());
            }
        }
        catch (SecurityException securityException) {}
        if (debug) {
            System.out.println("MimetypesFileTypeMap: load SYS");
        }
        try {
            this.parseFile(this.mimetypes[2], new CPStringBuilder(System.getProperty("java.home")).append(File.separatorChar).append("lib").append(File.separatorChar).append("mime.types").toString());
        }
        catch (SecurityException securityException) {}
        if (debug) {
            System.out.println("MimetypesFileTypeMap: load JAR");
        }
        if ((len = (systemResources = this.getSystemResources("META-INF/mime.types")).size()) > 0) {
            int i2 = 0;
            while (i2 < len) {
                block31: {
                    InputStreamReader urlIn = null;
                    URL url = systemResources.get(i2);
                    try {
                        try {
                            urlIn = new InputStreamReader(url.openStream());
                            this.parse(this.mimetypes[3], urlIn);
                        }
                        catch (IOException iOException) {
                            if (urlIn != null) {
                                try {
                                    ((Reader)urlIn).close();
                                }
                                catch (IOException iOException2) {}
                            }
                            break block31;
                        }
                    }
                    catch (Throwable throwable) {
                        if (urlIn != null) {
                            try {
                                ((Reader)urlIn).close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    if (urlIn != null) {
                        try {
                            ((Reader)urlIn).close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                ++i2;
            }
        } else {
            this.parseResource(this.mimetypes[3], "/META-INF/mime.types");
        }
        if (debug) {
            System.out.println("MimetypesFileTypeMap: load DEF");
        }
        this.parseResource(this.mimetypes[4], "/META-INF/mimetypes.default");
    }

    public synchronized void addMimeTypes(String mime_types) {
        if (debug) {
            System.out.println("MimetypesFileTypeMap: add to PROG");
        }
        try {
            this.parse(this.mimetypes[0], new StringReader(mime_types));
        }
        catch (IOException iOException) {}
    }

    @Override
    public String getContentType(File f) {
        return this.getContentType(f.getName());
    }

    @Override
    public synchronized String getContentType(String filename) {
        int di = filename.lastIndexOf(46);
        if (di < 0) {
            return DEFAULT_MIME_TYPE;
        }
        String tail = filename.substring(di + 1);
        if (tail.length() < 1) {
            return DEFAULT_MIME_TYPE;
        }
        int i = 0;
        while (i < this.mimetypes.length) {
            String mimeType = this.mimetypes[i].get(tail);
            if (mimeType != null) {
                return mimeType;
            }
            ++i;
        }
        return DEFAULT_MIME_TYPE;
    }

    private void parseFile(Map<String, String> mimetypes, String filename) {
        block14: {
            FileReader in = null;
            try {
                try {
                    in = new FileReader(filename);
                    this.parse(mimetypes, in);
                }
                catch (IOException iOException) {
                    if (in != null) {
                        try {
                            ((Reader)in).close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        ((Reader)in).close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (in != null) {
                try {
                    ((Reader)in).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void parseResource(Map<String, String> mimetypes, String name) {
        block15: {
            Reader in = null;
            try {
                try {
                    InputStream is = this.getClass().getResourceAsStream(name);
                    if (is != null) {
                        in = new InputStreamReader(is);
                        this.parse(mimetypes, in);
                    }
                }
                catch (IOException iOException) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void parse(Map<String, String> mimetypes, Reader in) throws IOException {
        BufferedReader br = new BufferedReader(in);
        CPStringBuilder buf = null;
        String line = br.readLine();
        while (line != null) {
            int len = (line = line.trim()).length();
            if (len != 0 && line.charAt(0) != '#') {
                if (line.charAt(len - 1) == '\\') {
                    if (buf == null) {
                        buf = new CPStringBuilder();
                    }
                    buf.append(line.substring(0, len - 1));
                } else if (buf != null) {
                    buf.append(line);
                    this.parseEntry(mimetypes, buf.toString());
                    buf = null;
                } else {
                    this.parseEntry(mimetypes, line);
                }
            }
            line = br.readLine();
        }
    }

    private void parseEntry(Map<String, String> mimetypes, String line) {
        String mimeType = null;
        char[] chars = line.toCharArray();
        int len = chars.length;
        CPStringBuilder buffer = new CPStringBuilder();
        int i = 0;
        while (i < len) {
            char c = chars[i];
            if (Character.isWhitespace(c)) {
                if (mimeType == null) {
                    mimeType = buffer.toString();
                } else if (buffer.length() > 0) {
                    mimetypes.put(buffer.toString(), mimeType);
                }
                buffer.setLength(0);
            } else {
                buffer.append(c);
            }
            ++i;
        }
        if (buffer.length() > 0) {
            mimetypes.put(buffer.toString(), mimeType);
        }
    }

    private List<URL> getSystemResources(String name) {
        ArrayList<URL> acc = new ArrayList<URL>();
        try {
            Enumeration<URL> i = ClassLoader.getSystemResources(name);
            while (i.hasMoreElements()) {
                acc.add(i.nextElement());
            }
        }
        catch (IOException iOException) {}
        return acc;
    }
}

