// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_FONTCHOOSER_H
#define _GTKMM_FONTCHOOSER_H


#include <glibmm.h>

/* Copyright (C) 2011 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


#include <glibmm/interface.h>
#include <pangomm/fontface.h>
#include <pangomm/fontdescription.h>
#include <pangomm/fontfamily.h>

#ifndef DOXYGEN_SHOULD_SKIP_THIS
extern "C"
{
typedef struct _GtkFontChooserIface GtkFontChooserIface;
}
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkFontChooser GtkFontChooser;
typedef struct _GtkFontChooserClass GtkFontChooserClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class FontChooser_Class; } // namespace Gtk
namespace Gtk
{

/** An interface implemented by widgets displaying fonts.
 *
 * FontChooser widgets list the available fonts, styles and
 * sizes, allowing the user to select a font.
 *
 * To set the font which is initially selected, use set_font_name().
 *
 * To get the selected font use get_font_name().
 *
 * To change the text which is shown in the preview area, use set_preview_text().
 * 
 * @ingroup FontChooser
 * @newin{3,2}
 */

class FontChooser : public Glib::Interface
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef FontChooser CppObjectType;
  typedef FontChooser_Class CppClassType;
  typedef GtkFontChooser BaseObjectType;
  typedef GtkFontChooserIface BaseClassType;

private:
  friend class FontChooser_Class;
  static CppClassType fontchooser_class_;

  // noncopyable
  FontChooser(const FontChooser&);
  FontChooser& operator=(const FontChooser&);

protected:
  FontChooser(); // you must derive from this class

  /** Called by constructors of derived classes. Provide the result of 
   * the Class init() function to ensure that it is properly 
   * initialized.
   * 
   * @param interface_class The Class object for the derived type.
   */
  explicit FontChooser(const Glib::Interface_Class& interface_class);

public:
  // This is public so that C++ wrapper instances can be
  // created for C instances of unwrapped types.
  // For instance, if an unexpected C type implements the C interface. 
  explicit FontChooser(GtkFontChooser* castitem);

protected:
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~FontChooser();

  static void add_interface(GType gtype_implementer);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkFontChooser*       gobj()       { return reinterpret_cast<GtkFontChooser*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkFontChooser* gobj() const { return reinterpret_cast<GtkFontChooser*>(gobject_); }

private:

public:

  
  Glib::RefPtr<Pango::FontFamily> get_font_family();
  
  Glib::RefPtr<const Pango::FontFamily> get_font_family() const;

  
  Glib::RefPtr<Pango::FontFace> get_font_face();
  
  Glib::RefPtr<const Pango::FontFace> get_font_face() const;

  
  int get_font_size() const;

 
  Pango::FontDescription get_font_desc() const;
  
  void set_font_desc(const Pango::FontDescription& font_desc);
                                                            
  
  Glib::ustring get_font() const;
  
  void set_font(const Glib::ustring& font);
  
  Glib::ustring get_preview_text() const;
  
  void set_preview_text(const Glib::ustring& fontname);
  
  
  bool get_show_preview_entry() const;
  
  void set_show_preview_entry(bool show_preview_entry =  true);

/* TODO:
void             gtk_font_chooser_set_filter_func          (GtkFontChooser   *fontchooser,
                                                            GtkFontFilterFunc filter,
                                                            gpointer          user_data,
                                                            GDestroyNotify    destroy);
*/

  //gtkmmproc error: font-activated :  signal defs lookup failed

  //gtkmmproc error: font : property defs lookup failed.
  //gtkmmproc error: font-desc : property defs lookup failed.
  //gtkmmproc error: preview-text : property defs lookup failed.
  //gtkmmproc error: show-preview-entry : property defs lookup failed.


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::FontChooser
   */
  Glib::RefPtr<Gtk::FontChooser> wrap(GtkFontChooser* object, bool take_copy = false);

} // namespace Glib


#endif /* _GTKMM_FONTCHOOSER_H */

