#!/bin/sh
echo 'name: redis
version: 0.11
id: redis-0.11-d9f6cb05dbd8dd3a4039ebbd744dbbde

license: MIT
copyright: Copyright (c) 2009-2010 Alexander Bogdanov
maintainer: Alexander Bogdanov <andorn@gmail.com>
stability: beta
homepage:
package-url:
description: Redis (<http://redis.io>) is an open source, BSD licensed, advanced
             key-value store. It is often referred as a data structure server
             since keys can contain different data structures, such as strings,
             hashes, lists, sets and sorted sets.
             .
             This library is a Haskell driver for Redis. It'\''s tested with
             current git version and with v2.2.4 of redis server. It also
             tested with v2.0.5 and basic functions are works correctly but not
             all of them.
             .
             You can use Test module from the source package to run unit
             tests. Try /runhaskell Test.hs --help/ for usage info. Caution! Do not
             run tests on your working database - test database will be
             flushed.
             .
             There are simple benchmark module included: Benchmark.hs. It shows
             me about two times less requests per second than redis-benchmark
             from server distribution.
             .
             Please let me know if tests or benchmark goes terribly wrong.
             .
             Changes from v0.10:
             .
             - Simple optimisation of redis protocol replays parsing that leads to
             significant speed improvement on get-like commands
             .
             - New commandline options for test runner (see above)
             .
             - Simple benchmark included (see above)
             .
             - New commands implemented: brpoplpush (blocking rpoplpush),
             getrange, setrange, getbit and setbit
             .
             - getType reply is now parsed into RedisKeyType datatype instead
             of just returning Reply. Warning! It'\''s backward incompatible!
             .
             - info reply is now parsed into Map String String. Warning! It'\''s
             backward incompatible!
category: Database
author: Alexander Bogdanov <andorn@gmail.com>
pkgpath: databases/hs-redis
exposed: True
exposed-modules: Database.Redis.Redis Database.Redis.Monad
                 Database.Redis.ByteStringClass Database.Redis.Monad.State
                 Database.Redis.Utils.Lock Database.Redis.Utils.Monad.Lock
hidden-modules: Database.Redis.Internal Database.Redis.Info
import-dirs: /usr/local/lib/ghc/redis-0.11
library-dirs: /usr/local/lib/ghc/redis-0.11
hs-libraries: HSredis-0.11
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: MonadCatchIO-mtl-0.3.0.4-d2dba4754f14d16f9561e6570f2b735d
         base-4.3.1.0-4365831fa9af03083be195ed161cbbc1
         bytestring-0.9.1.10-d11caeadd9605139e1a59850ce083826
         containers-0.4.0.0-b4885363abca642443ccd842502a3b7e
         mtl-2.0.1.0-5b7a9cce5565d8cc8721ba4f95becf1b
         network-2.3.0.5-435de5913c7c66da653cc03396522a6b
         old-time-1.0.0.6-088ba18f14be11f5303a5ce07fd2f643
         parsec-3.1.1-ea1a88c91a616fb266a2214ec05870d5
         utf8-string-0.3.6-213e09c7f4f705610e4e35b79f03acb5
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-redis-0.11/html/redis.haddock
haddock-html: /usr/local/share/doc/hs-redis-0.11/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
