/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.ConcurrentHashMap;
import gnu.trove.TObjectHashingStrategy;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

public final class ConcurrentSoftHashMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V> {
    private final ConcurrentMap myMap;
    private static final Object NULL_KEY = new Object();
    private final ReferenceQueue myReferenceQueue = new ReferenceQueue();
    private Set entrySet = null;

    private void processQueue() {
        SoftKey wk;
        while ((wk = (SoftKey)this.myReferenceQueue.poll()) != null) {
            this.myMap.remove(wk);
        }
    }

    public ConcurrentSoftHashMap(int initialCapacity, float loadFactor) {
        this.myMap = new ConcurrentHashMap(initialCapacity, loadFactor, 4);
    }

    public ConcurrentSoftHashMap(int initialCapacity) {
        this.myMap = new ConcurrentHashMap(initialCapacity);
    }

    public ConcurrentSoftHashMap() {
        this.myMap = new ConcurrentHashMap();
    }

    public ConcurrentSoftHashMap(Map t) {
        this(Math.max(2 * t.size(), 11), 0.75f);
        this.putAll(t);
    }

    public ConcurrentSoftHashMap(final TObjectHashingStrategy<K> hashingStrategy) {
        this.myMap = new ConcurrentHashMap(new TObjectHashingStrategy<Key<K>>(){

            public int computeHashCode(Key<K> object) {
                return hashingStrategy.computeHashCode(object.get());
            }

            public boolean equals(Key<K> o1, Key<K> o2) {
                return hashingStrategy.equals(o1.get(), o2.get());
            }
        });
    }

    @Override
    public int size() {
        return this.entrySet().size();
    }

    @Override
    public boolean isEmpty() {
        return this.entrySet().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            return this.myMap.containsKey(NULL_KEY);
        }
        HardKey hardKey = new HardKey(key);
        boolean result = this.myMap.containsKey(hardKey);
        return result;
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            return this.myMap.get(NULL_KEY);
        }
        HardKey hardKey = new HardKey(key);
        Object result = this.myMap.get(hardKey);
        return result;
    }

    @Override
    public V put(K key, V value) {
        this.processQueue();
        SoftKey softKey = SoftKey.create(key, this.myReferenceQueue);
        return this.myMap.put(softKey == null ? NULL_KEY : softKey, value);
    }

    @Override
    public V remove(Object key) {
        this.processQueue();
        if (key == null) {
            return this.myMap.remove(NULL_KEY);
        }
        HardKey hardKey = new HardKey(key);
        Object result = this.myMap.remove(hardKey);
        return result;
    }

    @Override
    public void clear() {
        this.processQueue();
        this.myMap.clear();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    @Override
    public V putIfAbsent(K key, V value) {
        this.processQueue();
        return this.myMap.putIfAbsent(SoftKey.create(key, this.myReferenceQueue), value);
    }

    @Override
    public boolean remove(Object key, Object value) {
        this.processQueue();
        return this.myMap.remove(SoftKey.create(key, this.myReferenceQueue), value);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        this.processQueue();
        return this.myMap.replace(SoftKey.create(key, this.myReferenceQueue), oldValue, newValue);
    }

    @Override
    public V replace(K key, V value) {
        this.processQueue();
        return this.myMap.replace(SoftKey.create(key, this.myReferenceQueue), value);
    }

    private class EntrySet
    extends AbstractSet {
        Set hashEntrySet;

        private EntrySet() {
            this.hashEntrySet = ConcurrentSoftHashMap.this.myMap.entrySet();
        }

        @Override
        public Iterator iterator() {
            return new Iterator(){
                Iterator hashIterator;
                Entry next;
                {
                    this.hashIterator = EntrySet.this.hashEntrySet.iterator();
                    this.next = null;
                }

                @Override
                public boolean hasNext() {
                    while (this.hashIterator.hasNext()) {
                        Map.Entry ent = (Map.Entry)this.hashIterator.next();
                        SoftKey wk = (SoftKey)ent.getKey();
                        Object k = null;
                        if (wk != null) {
                            Object t = wk.get();
                            k = t;
                            if (t == null) continue;
                        }
                        this.next = new Entry(ent, k);
                        return true;
                    }
                    return false;
                }

                public Object next() {
                    if (this.next == null && !this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    Entry e = this.next;
                    this.next = null;
                    return e;
                }

                @Override
                public void remove() {
                    this.hashIterator.remove();
                }
            };
        }

        @Override
        public boolean isEmpty() {
            return !this.iterator().hasNext();
        }

        @Override
        public int size() {
            int j = 0;
            Iterator i = this.iterator();
            while (i.hasNext()) {
                ++j;
                i.next();
            }
            return j;
        }

        @Override
        public boolean remove(Object o) {
            boolean toRemove;
            ConcurrentSoftHashMap.this.processQueue();
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object ev = e.getValue();
            HardKey key = new HardKey(o);
            Object hv = ConcurrentSoftHashMap.this.myMap.get(key);
            boolean bl = hv == null ? ev == null && ConcurrentSoftHashMap.this.myMap.containsKey(key) : (toRemove = hv.equals(ev));
            if (toRemove) {
                ConcurrentSoftHashMap.this.myMap.remove(key);
            }
            return toRemove;
        }

        @Override
        public int hashCode() {
            int h = 0;
            for (Map.Entry ent : this.hashEntrySet) {
                Object v;
                SoftKey wk = (SoftKey)ent.getKey();
                if (wk == null) continue;
                h += wk.hashCode() ^ ((v = ent.getValue()) == null ? 0 : v.hashCode());
            }
            return h;
        }
    }

    private static class Entry
    implements Map.Entry {
        private final Map.Entry ent;
        private final Object key;

        Entry(Map.Entry ent, Object key) {
            this.ent = ent;
            this.key = key;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.ent.getValue();
        }

        public Object setValue(Object value) {
            return this.ent.setValue(value);
        }

        private static boolean valEquals(Object o1, Object o2) {
            return o1 == null ? o2 == null : o1.equals(o2);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Entry.valEquals(this.key, e.getKey()) && Entry.valEquals(this.getValue(), e.getValue());
        }

        @Override
        public int hashCode() {
            Object v = this.getValue();
            return (this.key == null ? 0 : this.key.hashCode()) ^ (v == null ? 0 : v.hashCode());
        }
    }

    private static class HardKey
    implements Key {
        private final Object myObject;
        private final int myHash;

        public HardKey(Object object) {
            this.myObject = object;
            this.myHash = object.hashCode();
        }

        public Object get() {
            return this.myObject;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Object t = this.get();
            Object u = ((Key)o).get();
            if (t == null || u == null) {
                return false;
            }
            if (t == u) {
                return true;
            }
            return t.equals(u);
        }

        public int hashCode() {
            return this.myHash;
        }
    }

    private static class SoftKey
    extends SoftReference
    implements Key {
        private final int myHash;

        private SoftKey(Object k) {
            super(k);
            this.myHash = k.hashCode();
        }

        public static SoftKey create(Object k) {
            return k != null ? new SoftKey(k) : null;
        }

        private SoftKey(Object k, ReferenceQueue q) {
            super(k, q);
            this.myHash = k.hashCode();
        }

        private static SoftKey create(Object k, ReferenceQueue q) {
            return k != null ? new SoftKey(k, q) : null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Object t = this.get();
            Object u = ((Key)o).get();
            if (t == null || u == null) {
                return false;
            }
            if (t == u) {
                return true;
            }
            return t.equals(u);
        }

        public int hashCode() {
            return this.myHash;
        }
    }

    private static interface Key<K> {
        public K get();
    }
}

