/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle;

import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.application.options.codeStyle.LanguageSelector;
import com.intellij.ide.DataManager;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.IncorrectOperationException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MultilanguageCodeStyleAbstractPanel
extends CodeStyleAbstractPanel {
    private Language myLanguage;
    private LanguageSelector myLanguageSelector;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.application.options.codeStyle.MultilanguageCodeStyleAbstractPanel");
    private int myLangSelectionIndex;
    private JTabbedPane tabbedPane;

    protected MultilanguageCodeStyleAbstractPanel(CodeStyleSettings settings) {
        super(settings);
    }

    public void setLanguageSelector(LanguageSelector langSelector) {
        this.myLanguageSelector = langSelector;
        this.setPanelLanguage(langSelector.getLanguage());
    }

    public void setPanelLanguage(Language language) {
        this.myLanguage = language;
        this.updatePreviewEditor();
    }

    protected abstract LanguageCodeStyleSettingsProvider.SettingsType getSettingsType();

    @Override
    protected String getPreviewText() {
        if (this.myLanguage == null) {
            return "";
        }
        String sample = LanguageCodeStyleSettingsProvider.getCodeSample(this.myLanguage, this.getSettingsType());
        if (sample == null) {
            return "";
        }
        return sample;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    protected FileType getFileType() {
        LanguageFileType languageFileType;
        FileType assocType;
        if (this.myLanguage != null && (assocType = this.myLanguage.getAssociatedFileType()) != null) {
            languageFileType = assocType;
            if (languageFileType == null) throw new IllegalStateException("@NotNull method com/intellij/application/options/codeStyle/MultilanguageCodeStyleAbstractPanel.getFileType must not return null");
            return languageFileType;
        }
        Language[] langs = LanguageCodeStyleSettingsProvider.getLanguagesWithCodeStyleSettings();
        if (langs.length > 0) {
            this.myLanguage = langs[0];
            FileType type = langs[0].getAssociatedFileType();
            if (type != null) {
                languageFileType = type;
                if (languageFileType == null) throw new IllegalStateException("@NotNull method com/intellij/application/options/codeStyle/MultilanguageCodeStyleAbstractPanel.getFileType must not return null");
                return languageFileType;
            }
        }
        if ((languageFileType = StdFileTypes.JAVA) != null) return languageFileType;
        throw new IllegalStateException("@NotNull method com/intellij/application/options/codeStyle/MultilanguageCodeStyleAbstractPanel.getFileType must not return null");
    }

    @Override
    @Nullable
    protected EditorHighlighter createHighlighter(EditorColorsScheme scheme) {
        Project project = (Project)PlatformDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)this.getPanel()));
        if (project == null) {
            project = ProjectManager.getInstance().getDefaultProject();
        }
        if (this.getFileType() instanceof LanguageFileType) {
            return ((LanguageFileType)this.getFileType()).getEditorHighlighter(project, null, scheme);
        }
        return null;
    }

    @Override
    protected PsiFile doReformat(final Project project, final PsiFile psiFile) {
        final String text = psiFile.getText();
        final PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)project);
        final Document doc = manager.getDocument(psiFile);
        CommandProcessor.getInstance().executeCommand(project, new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        doc.replaceString(0, doc.getTextLength(), (CharSequence)text);
                        manager.commitDocument(doc);
                        try {
                            CodeStyleManager.getInstance((Project)project).reformat((PsiElement)psiFile);
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                });
            }
        }, "", (Object)"");
        if (doc != null) {
            manager.commitDocument(doc);
        }
        return psiFile;
    }

    protected static JPanel createPreviewPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(IdeBorderFactory.createTitledBorder((String)"Preview"));
        panel.setPreferredSize(new Dimension(200, 0));
        return panel;
    }

    @Override
    protected void installPreviewPanel(JPanel previewPanel) {
        if (this.getSettingsType() != LanguageCodeStyleSettingsProvider.SettingsType.LANG_SPECIFIC) {
            this.tabbedPane = new JTabbedPane();
            this.tabbedPane.setTabLayoutPolicy(1);
            Language[] langs = LanguageCodeStyleSettingsProvider.getLanguagesWithCodeStyleSettings();
            if (langs.length == 0) {
                return;
            }
            for (Language lang : langs) {
                this.tabbedPane.addTab(lang.getDisplayName(), MultilanguageCodeStyleAbstractPanel.createDummy());
            }
            this.tabbedPane.setComponentAt(0, this.getEditor().getComponent());
            this.myLangSelectionIndex = 0;
            if (this.myLanguage == null) {
                this.setPanelLanguage(langs[0]);
            } else {
                this.updatePreviewEditor();
            }
            this.tabbedPane.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    MultilanguageCodeStyleAbstractPanel.this.onTabSelection((JTabbedPane)e.getSource());
                }
            });
            previewPanel.add((Component)this.tabbedPane, "Center");
            previewPanel.addAncestorListener(new AncestorListener(){

                @Override
                public void ancestorAdded(AncestorEvent event) {
                    MultilanguageCodeStyleAbstractPanel.this.selectCurrentLanguageTab();
                }

                @Override
                public void ancestorRemoved(AncestorEvent event) {
                }

                @Override
                public void ancestorMoved(AncestorEvent event) {
                }
            });
        } else {
            previewPanel.add((Component)this.getEditor().getComponent(), "Center");
            this.updatePreviewEditor();
        }
    }

    private void selectCurrentLanguageTab() {
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            if (!this.myLanguage.getDisplayName().equals(this.tabbedPane.getTitleAt(i))) continue;
            this.tabbedPane.setSelectedIndex(i);
            return;
        }
    }

    private void onTabSelection(JTabbedPane tabs) {
        int i = tabs.getSelectedIndex();
        tabs.setComponentAt(this.myLangSelectionIndex, MultilanguageCodeStyleAbstractPanel.createDummy());
        tabs.setComponentAt(i, this.getEditor().getComponent());
        this.myLangSelectionIndex = i;
        String selectionTitle = tabs.getTitleAt(i);
        Language lang = LanguageCodeStyleSettingsProvider.getLanguage(selectionTitle);
        if (lang != null && this.myLanguageSelector != null) {
            this.myLanguageSelector.setLanguage(lang);
        }
    }

    private static JComponent createDummy() {
        return new JLabel("");
    }
}

