/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle;

import com.intellij.application.options.codeStyle.MultilanguageCodeStyleAbstractPanel;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModel;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableCellRenderer;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.ClientPropertyHolder;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;

public abstract class OptionTableWithPreviewPanel
extends MultilanguageCodeStyleAbstractPanel {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.application.options.CodeStyleSpacesPanel");
    public final ColumnInfo TITLE = new ColumnInfo("TITLE"){

        public Object valueOf(Object o) {
            if (o instanceof MyTreeNode) {
                MyTreeNode node = (MyTreeNode)o;
                return node.getText();
            }
            return o.toString();
        }

        public Class getColumnClass() {
            return TreeTableModel.class;
        }
    };
    public final ColumnInfo VALUE = new ColumnInfo("VALUE"){
        private final TableCellEditor myEditor;
        private final TableCellRenderer myRenderer;
        {
            this.myEditor = new MyValueEditor();
            this.myRenderer = new MyValueRenderer();
        }

        public Object valueOf(Object o) {
            if (o instanceof MyTreeNode) {
                MyTreeNode node = (MyTreeNode)o;
                return node.getValue();
            }
            return null;
        }

        public TableCellRenderer getRenderer(Object o) {
            return this.myRenderer;
        }

        public TableCellEditor getEditor(Object item) {
            return this.myEditor;
        }

        public boolean isCellEditable(Object o) {
            return o instanceof MyTreeNode;
        }

        public void setValue(Object o, Object o1) {
            MyTreeNode node = (MyTreeNode)o;
            node.setValue(o1);
        }
    };
    public final ColumnInfo[] COLUMNS = new ColumnInfo[]{this.TITLE, this.VALUE};
    private final TreeCellRenderer myTitleRenderer = new TreeCellRenderer(){
        private final JLabel myLabel = new JLabel();

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value instanceof MyTreeNode) {
                MyTreeNode node = (MyTreeNode)value;
                this.myLabel.setText(node.getText());
                this.myLabel.setFont(this.myLabel.getFont().deriveFont(node.getKey() instanceof IntSelectionOptionKey ? 1 : 0));
            } else {
                this.myLabel.setText(value.toString());
                this.myLabel.setFont(this.myLabel.getFont().deriveFont(1));
            }
            Color foreground = selected ? UIUtil.getTableSelectionForeground() : UIUtil.getTableForeground();
            this.myLabel.setForeground(foreground);
            return this.myLabel;
        }
    };
    private final TreeTable myTreeTable;
    private final HashMap myKeyToFieldMap = new HashMap();
    private final ArrayList myKeys = new ArrayList();
    private final JPanel myPanel = new JPanel();

    public OptionTableWithPreviewPanel(CodeStyleSettings settings) {
        super(settings);
        this.myPanel.setLayout(new GridBagLayout());
        this.initTables();
        this.myTreeTable = this.createOptionsTree(settings);
        this.myPanel.add((Component)ScrollPaneFactory.createScrollPane((JComponent)this.myTreeTable), new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 1, new Insets(7, 7, 3, 4), 0, 0));
        JPanel previewPanel = OptionTableWithPreviewPanel.createPreviewPanel();
        this.myPanel.add((Component)previewPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 4), 0, 0));
        this.installPreviewPanel(previewPanel);
        this.addPanelToWatch(this.myPanel);
    }

    protected TreeTable createOptionsTree(CodeStyleSettings settings) {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
        String groupName = "";
        DefaultMutableTreeNode groupNode = null;
        for (int i = 0; i < this.myKeys.size(); ++i) {
            String newGroupName;
            Object key;
            if (this.myKeys.get(i) instanceof BooleanOptionKey) {
                key = (BooleanOptionKey)this.myKeys.get(i);
                newGroupName = ((BooleanOptionKey)key).groupName;
                if (!newGroupName.equals(groupName) || groupNode == null) {
                    groupName = newGroupName;
                    groupNode = new DefaultMutableTreeNode(newGroupName);
                    rootNode.add(groupNode);
                }
                groupNode.add(new MyTreeNode(key, ((BooleanOptionKey)key).cbName, settings));
                continue;
            }
            if (!(this.myKeys.get(i) instanceof IntSelectionOptionKey)) continue;
            key = (IntSelectionOptionKey)this.myKeys.get(i);
            newGroupName = ((IntSelectionOptionKey)key).groupName;
            if (!newGroupName.equals(groupName) || groupNode == null) {
                groupName = newGroupName;
                groupNode = new MyTreeNode(key, ((IntSelectionOptionKey)key).groupName, settings);
                rootNode.add(groupNode);
                continue;
            }
            LOG.assertTrue(false);
        }
        ListTreeTableModel model = new ListTreeTableModel((TreeNode)rootNode, this.COLUMNS);
        TreeTable treeTable = new TreeTable((TreeTableModel)model){

            public TreeTableCellRenderer createTableRenderer(TreeTableModel treeTableModel) {
                TreeTableCellRenderer tableRenderer = super.createTableRenderer(treeTableModel);
                UIUtil.setLineStyleAngled((ClientPropertyHolder)tableRenderer);
                tableRenderer.setRootVisible(false);
                tableRenderer.setShowsRootHandles(true);
                return tableRenderer;
            }

            public TableCellRenderer getCellRenderer(int row, int column) {
                TreePath treePath = this.getTree().getPathForRow(row);
                if (treePath == null) {
                    return super.getCellRenderer(row, column);
                }
                Object node = treePath.getLastPathComponent();
                TableCellRenderer renderer = OptionTableWithPreviewPanel.this.COLUMNS[column].getRenderer(node);
                return renderer == null ? super.getCellRenderer(row, column) : renderer;
            }

            public TableCellEditor getCellEditor(int row, int column) {
                TreePath treePath = this.getTree().getPathForRow(row);
                if (treePath == null) {
                    return super.getCellEditor(row, column);
                }
                Object node = treePath.getLastPathComponent();
                TableCellEditor editor = OptionTableWithPreviewPanel.this.COLUMNS[column].getEditor(node);
                return editor == null ? super.getCellEditor(row, column) : editor;
            }
        };
        treeTable.setRootVisible(false);
        TreeTableTree tree = treeTable.getTree();
        tree.setCellRenderer(this.myTitleRenderer);
        tree.setShowsRootHandles(true);
        treeTable.setSelectionMode(0);
        treeTable.setTableHeader(null);
        this.expandTree((JTree)tree);
        int maxWidth = tree.getPreferredScrollableViewportSize().width + 10;
        TableColumn titleColumn = treeTable.getColumnModel().getColumn(0);
        titleColumn.setPreferredWidth(maxWidth);
        titleColumn.setMinWidth(maxWidth);
        titleColumn.setMaxWidth(maxWidth);
        titleColumn.setResizable(false);
        TableColumn levelColumn = treeTable.getColumnModel().getColumn(1);
        JLabel value = new JLabel(ApplicationBundle.message((String)"option.table.sizing.text", (Object[])new Object[0]));
        Dimension valueSize = value.getPreferredSize();
        levelColumn.setPreferredWidth(valueSize.width);
        levelColumn.setMaxWidth(valueSize.width);
        levelColumn.setMinWidth(valueSize.width);
        levelColumn.setResizable(false);
        treeTable.setPreferredScrollableViewportSize(new Dimension(maxWidth + valueSize.width + 10, 20));
        return treeTable;
    }

    private void expandTree(JTree tree) {
        int rowCount;
        int oldRowCount = 0;
        while ((rowCount = tree.getRowCount()) != oldRowCount) {
            oldRowCount = rowCount;
            for (int i = 0; i < rowCount; ++i) {
                tree.expandRow(i);
            }
        }
    }

    protected abstract void initTables();

    private void resetNode(TreeNode node, CodeStyleSettings settings) {
        if (node instanceof MyTreeNode) {
            ((MyTreeNode)node).reset(settings);
        }
        for (int j = 0; j < node.getChildCount(); ++j) {
            TreeNode child = node.getChildAt(j);
            this.resetNode(child, settings);
        }
    }

    private void applyNode(TreeNode node, CodeStyleSettings settings) {
        if (node instanceof MyTreeNode) {
            ((MyTreeNode)node).apply(settings);
        }
        for (int j = 0; j < node.getChildCount(); ++j) {
            TreeNode child = node.getChildAt(j);
            this.applyNode(child, settings);
        }
    }

    private boolean isModified(TreeNode node, CodeStyleSettings settings) {
        if (node instanceof MyTreeNode && ((MyTreeNode)node).isModified(settings)) {
            return true;
        }
        for (int j = 0; j < node.getChildCount(); ++j) {
            TreeNode child = node.getChildAt(j);
            if (!this.isModified(child, settings)) continue;
            return true;
        }
        return false;
    }

    protected void initBooleanField(@NonNls String fieldName, String cbName, String groupName) {
        try {
            Class<CodeStyleSettings> styleSettingsClass = CodeStyleSettings.class;
            Field field = styleSettingsClass.getField(fieldName);
            BooleanOptionKey key = new BooleanOptionKey(groupName, cbName);
            this.myKeyToFieldMap.put((Object)key, (Object)field);
            this.myKeys.add(key);
        }
        catch (NoSuchFieldException e) {
        }
        catch (SecurityException e) {
            // empty catch block
        }
    }

    protected void initRadioGroupField(@NonNls String fieldName, String groupName, String[] rbNames, int[] values) {
        try {
            Class<CodeStyleSettings> styleSettingsClass = CodeStyleSettings.class;
            Field field = styleSettingsClass.getField(fieldName);
            IntSelectionOptionKey key = new IntSelectionOptionKey(groupName, rbNames, values);
            this.myKeyToFieldMap.put((Object)key, (Object)field);
            this.myKeys.add(key);
        }
        catch (NoSuchFieldException e) {
        }
        catch (SecurityException e) {
            // empty catch block
        }
    }

    @Override
    protected void prepareForReformat(PsiFile psiFile) {
    }

    private Object getSettingsValue(Object key, CodeStyleSettings settings) {
        try {
            if (key instanceof BooleanOptionKey) {
                Field field = (Field)this.myKeyToFieldMap.get(key);
                return field.getBoolean(settings) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (key instanceof IntSelectionOptionKey) {
                Field field = (Field)this.myKeyToFieldMap.get(key);
                IntSelectionOptionKey intKey = (IntSelectionOptionKey)key;
                int[] values = intKey.values;
                int value = field.getInt(settings);
                for (int i = 0; i < values.length; ++i) {
                    if (values[i] != value) continue;
                    return intKey.rbNames[i];
                }
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return null;
    }

    public void setSettingsValue(Object key, Object value, CodeStyleSettings settings) {
        try {
            if (key instanceof BooleanOptionKey) {
                Field field = (Field)this.myKeyToFieldMap.get(key);
                field.setBoolean(settings, (Boolean)value);
            } else if (key instanceof IntSelectionOptionKey) {
                Field field = (Field)this.myKeyToFieldMap.get(key);
                IntSelectionOptionKey intKey = (IntSelectionOptionKey)key;
                int[] values = intKey.values;
                for (int i = 0; i < values.length; ++i) {
                    if (!intKey.rbNames[i].equals(value)) continue;
                    field.setInt(settings, values[i]);
                    return;
                }
            }
        }
        catch (IllegalAccessException e) {
            // empty catch block
        }
    }

    @Override
    public void apply(CodeStyleSettings settings) {
        TreeModel treeModel = this.myTreeTable.getTree().getModel();
        TreeNode root = (TreeNode)treeModel.getRoot();
        this.applyNode(root, settings);
    }

    @Override
    public boolean isModified(CodeStyleSettings settings) {
        TreeModel treeModel = this.myTreeTable.getTree().getModel();
        TreeNode root = (TreeNode)treeModel.getRoot();
        return this.isModified(root, settings);
    }

    @Override
    public JComponent getPanel() {
        return this.myPanel;
    }

    @Override
    protected void resetImpl(CodeStyleSettings settings) {
        TreeModel treeModel = this.myTreeTable.getTree().getModel();
        TreeNode root = (TreeNode)treeModel.getRoot();
        this.resetNode(root, settings);
    }

    private class MyValueEditor
    extends AbstractTableCellEditor {
        private final JComboBox myComboBox = new JComboBox();
        private final JCheckBox myCheckBox = new JCheckBox();
        private Component myCurrentEditor = null;
        private MyTreeNode myCurrentNode = null;

        public MyValueEditor() {
            ActionListener synchronizer = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (MyValueEditor.this.myCurrentNode != null) {
                        MyValueEditor.this.myCurrentNode.setValue(MyValueEditor.this.getCellEditorValue());
                    }
                }
            };
            this.myComboBox.addActionListener(synchronizer);
            this.myCheckBox.addActionListener(synchronizer);
            this.myComboBox.putClientProperty("JComponent.sizeVariant", "small");
            this.myCheckBox.putClientProperty("JComponent.sizeVariant", "small");
        }

        public Object getCellEditorValue() {
            if (this.myCurrentEditor == this.myComboBox) {
                return this.myComboBox.getSelectedItem();
            }
            if (this.myCurrentEditor == this.myCheckBox) {
                return this.myCheckBox.isSelected() ? Boolean.TRUE : Boolean.FALSE;
            }
            return null;
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            DefaultMutableTreeNode defaultNode = (DefaultMutableTreeNode)((TreeTable)table).getTree().getPathForRow(row).getLastPathComponent();
            this.myCurrentEditor = null;
            this.myCurrentNode = null;
            if (defaultNode instanceof MyTreeNode) {
                MyTreeNode node = (MyTreeNode)defaultNode;
                if (node.getKey() instanceof BooleanOptionKey) {
                    this.myCurrentEditor = this.myCheckBox;
                    this.myCheckBox.setSelected(node.getValue() == Boolean.TRUE);
                } else {
                    this.myCurrentEditor = this.myComboBox;
                    this.myComboBox.removeAllItems();
                    IntSelectionOptionKey key = (IntSelectionOptionKey)node.getKey();
                    String[] values = key.rbNames;
                    for (int i = 0; i < values.length; ++i) {
                        this.myComboBox.addItem(values[i]);
                    }
                    this.myComboBox.setSelectedItem(node.getValue());
                }
                this.myCurrentNode = node;
            }
            this.myCurrentEditor.setBackground(table.getBackground());
            return this.myCurrentEditor;
        }
    }

    private class MyValueRenderer
    implements TableCellRenderer {
        private final JLabel myComboBox = new JLabel();
        private final JCheckBox myCheckBox = new JCheckBox();
        private final JPanel myEmptyLabel = new JPanel();

        private MyValueRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Color background = table.getBackground();
            if (value instanceof Boolean) {
                this.myCheckBox.setSelected((Boolean)value);
                this.myCheckBox.setBackground(background);
                return this.myCheckBox;
            }
            if (value instanceof String) {
                this.myComboBox.setText((String)value);
                this.myComboBox.setBackground(background);
                return this.myComboBox;
            }
            this.myCheckBox.putClientProperty("JComponent.sizeVariant", "small");
            this.myComboBox.putClientProperty("JComponent.sizeVariant", "small");
            this.myEmptyLabel.setBackground(background);
            return this.myEmptyLabel;
        }
    }

    private class MyTreeNode
    extends DefaultMutableTreeNode {
        private final Object myKey;
        private final String myText;
        private Object myValue;

        public MyTreeNode(Object key, String text, CodeStyleSettings settings) {
            this.myKey = key;
            this.myText = text;
            this.myValue = OptionTableWithPreviewPanel.this.getSettingsValue(key, settings);
        }

        public Object getKey() {
            return this.myKey;
        }

        public String getText() {
            return this.myText;
        }

        public Object getValue() {
            return this.myValue;
        }

        public void setValue(Object value) {
            this.myValue = value;
        }

        public void reset(CodeStyleSettings settings) {
            this.setValue(OptionTableWithPreviewPanel.this.getSettingsValue(this.myKey, settings));
        }

        public boolean isModified(CodeStyleSettings settings) {
            return !this.myValue.equals(OptionTableWithPreviewPanel.this.getSettingsValue(this.myKey, settings));
        }

        public void apply(CodeStyleSettings settings) {
            OptionTableWithPreviewPanel.this.setSettingsValue(this.myKey, this.myValue, settings);
        }
    }

    private static class IntSelectionOptionKey {
        final String groupName;
        final String[] rbNames;
        final int[] values;

        public IntSelectionOptionKey(String groupName, String[] rbNames, int[] values) {
            this.groupName = groupName;
            this.rbNames = rbNames;
            this.values = values;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IntSelectionOptionKey)) {
                return false;
            }
            IntSelectionOptionKey intSelectionOptionKey = (IntSelectionOptionKey)o;
            if (!this.groupName.equals(intSelectionOptionKey.groupName)) {
                return false;
            }
            return Arrays.equals(this.rbNames, intSelectionOptionKey.rbNames);
        }

        public int hashCode() {
            return this.groupName.hashCode() + this.rbNames[0].hashCode() * 29;
        }
    }

    private static class BooleanOptionKey {
        final String groupName;
        final String cbName;

        public BooleanOptionKey(String groupName, String cbName) {
            this.groupName = groupName;
            this.cbName = cbName;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof BooleanOptionKey)) {
                return false;
            }
            BooleanOptionKey key = (BooleanOptionKey)obj;
            return this.groupName.equals(key.groupName) && this.cbName.equals(key.cbName);
        }

        public int hashCode() {
            return this.cbName.hashCode();
        }
    }
}

