/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.ProgressableTextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightLevelUtil;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.markup.ErrorStripeRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class TrafficLightRenderer
implements ErrorStripeRenderer {
    private static final Icon IN_PROGRESS_ICON = IconLoader.getIcon((String)"/general/errorsInProgress.png");
    private static final Icon NO_ANALYSIS_ICON = IconLoader.getIcon((String)"/general/noAnalysis.png");
    private static final Icon NO_ICON = new EmptyIcon(IN_PROGRESS_ICON.getIconWidth(), IN_PROGRESS_ICON.getIconHeight());
    private final Project myProject;
    private final Document myDocument;
    private final PsiFile myFile;
    private final DaemonCodeAnalyzerImpl myDaemonCodeAnalyzer;
    @NonNls
    private static final String HTML_HEADER = "<html><body>";
    @NonNls
    private static final String HTML_FOOTER = "</body></html>";
    @NonNls
    private static final String BR = "<br>";
    @NonNls
    private static final String NO_PASS_FOR_MESSAGE_KEY_SUFFIX = ".for";
    private static final URL progressUrl = TrafficLightRenderer.class.getClassLoader().getResource("/general/progress.png");
    private static final URL progressPlaceHolderUrl = TrafficLightRenderer.class.getClassLoader().getResource("/general/progressTransparentPlaceHolder.png");

    @Nullable
    protected DaemonCodeAnalyzerStatus getDaemonCodeAnalyzerStatus(boolean fillErrorsCount) {
        PsiFile[] roots;
        if (this.myFile == null || this.myProject.isDisposed() || !this.myDaemonCodeAnalyzer.isHighlightingAvailable(this.myFile)) {
            return null;
        }
        ArrayList<String> noInspectionRoots = new ArrayList<String>();
        ArrayList<String> noHighlightingRoots = new ArrayList<String>();
        for (PsiFile file : roots = this.myFile.getPsiRoots()) {
            if (!HighlightLevelUtil.shouldHighlight((PsiElement)file)) {
                noHighlightingRoots.add(file.getLanguage().getID());
                continue;
            }
            if (HighlightLevelUtil.shouldInspect((PsiElement)file)) continue;
            noInspectionRoots.add(file.getLanguage().getID());
        }
        DaemonCodeAnalyzerStatus status = new DaemonCodeAnalyzerStatus();
        status.noInspectionRoots = noInspectionRoots.isEmpty() ? null : ArrayUtil.toStringArray(noInspectionRoots);
        status.noHighlightingRoots = noHighlightingRoots.isEmpty() ? null : ArrayUtil.toStringArray(noHighlightingRoots);
        SeverityRegistrar severityRegistrar = SeverityRegistrar.getInstance(this.myProject);
        status.errorCount = new int[severityRegistrar.getSeveritiesCount()];
        status.rootsNumber = roots.length;
        this.fillDaemonCodeAnalyzerErrorsSatus(status, fillErrorsCount);
        List<TextEditorHighlightingPass> passes = this.myDaemonCodeAnalyzer.getPassesToShowProgressFor(this.myFile);
        ArrayList<DaemonCodeAnalyzerStatus.PassStatus> passStati = new ArrayList<DaemonCodeAnalyzerStatus.PassStatus>();
        for (TextEditorHighlightingPass tepass : passes) {
            ProgressableTextEditorHighlightingPass pass;
            double progress;
            if (!(tepass instanceof ProgressableTextEditorHighlightingPass) || (progress = (pass = (ProgressableTextEditorHighlightingPass)tepass).getProgress()) < 0.0) continue;
            DaemonCodeAnalyzerStatus.PassStatus passStatus = new DaemonCodeAnalyzerStatus.PassStatus(pass.getPresentableName(), progress, pass.isFinished(), pass.getInProgressIcon());
            passStati.add(passStatus);
        }
        status.passStati = passStati;
        status.errorAnalyzingFinished = this.myDaemonCodeAnalyzer.isAllAnalysisFinished(this.myFile);
        return status;
    }

    protected void fillDaemonCodeAnalyzerErrorsSatus(DaemonCodeAnalyzerStatus status, boolean fillErrorsCount) {
        SeverityRegistrar severityRegistrar = SeverityRegistrar.getInstance(this.myProject);
        List<HighlightInfo> highlights = DaemonCodeAnalyzerImpl.getHighlights(this.myDocument, this.myProject);
        if (highlights == null) {
            highlights = Arrays.asList(HighlightInfo.EMPTY_ARRAY);
        }
        if (fillErrorsCount) {
            highlights = new ArrayList<HighlightInfo>(highlights);
            Collections.sort(highlights, new Comparator<HighlightInfo>(){

                @Override
                public int compare(HighlightInfo o1, HighlightInfo o2) {
                    return o1.getSeverity().myVal - o2.getSeverity().myVal;
                }
            });
            Arrays.fill(status.errorCount, 0);
            for (HighlightInfo highlight : highlights) {
                HighlightSeverity severity = highlight.getSeverity();
                int severityIdx = severityRegistrar.getSeverityIdx(severity);
                if (severityIdx == -1) continue;
                int n = severityIdx;
                status.errorCount[n] = status.errorCount[n] + 1;
            }
        } else {
            int severityIdx;
            HighlightSeverity severity = null;
            int count = severityRegistrar.getSeveritiesCount() - 1;
            HighlightSeverity maxSeverity = severityRegistrar.getSeverityByIndex(count);
            for (HighlightInfo info : highlights) {
                if (info.getSeverity() == maxSeverity) {
                    status.errorCount[count] = 1;
                    return;
                }
                if (severity != null && severityRegistrar.compare(severity, info.getSeverity()) > 0) continue;
                severity = info.getSeverity();
            }
            if (severity != null && (severityIdx = severityRegistrar.getSeverityIdx(severity)) != -1) {
                status.errorCount[severityIdx] = 1;
            }
        }
    }

    public final Project getProject() {
        return this.myProject;
    }

    public TrafficLightRenderer(Project project, DaemonCodeAnalyzerImpl highlighter, Document document, PsiFile file) {
        this.myProject = project;
        this.myDaemonCodeAnalyzer = highlighter;
        this.myDocument = document;
        this.myFile = file;
    }

    public String getTooltipMessage() {
        DaemonCodeAnalyzerStatus status = this.getDaemonCodeAnalyzerStatus(true);
        if (status == null) {
            return null;
        }
        String text = HTML_HEADER;
        if (status.noHighlightingRoots != null && status.noHighlightingRoots.length == status.rootsNumber) {
            text = text + DaemonBundle.message((String)"analysis.hasnot.been.run", (Object[])new Object[0]);
            text = text + HTML_FOOTER;
            return text;
        }
        if (status.errorAnalyzingFinished) {
            text = text + DaemonBundle.message((String)"analysis.completed", (Object[])new Object[0]);
        } else {
            text = text + DaemonBundle.message((String)"performing.code.analysis", (Object[])new Object[0]);
            text = text + "<table>";
            for (DaemonCodeAnalyzerStatus.PassStatus passStatus : status.passStati) {
                if (passStatus.finished) continue;
                text = text + "<tr><td>" + passStatus.name + ":</td><td>" + TrafficLightRenderer.renderProgressHtml(passStatus.progress) + "</td></tr>";
            }
            text = text + "</table>";
        }
        int currentSeverityErrors = 0;
        for (int i = status.errorCount.length - 1; i >= 0; --i) {
            if (status.errorCount[i] <= 0) continue;
            HighlightSeverity severity = SeverityRegistrar.getInstance(this.myProject).getSeverityByIndex(i);
            text = text + BR;
            String name = status.errorCount[i] > 1 ? StringUtil.pluralize((String)severity.toString().toLowerCase()) : severity.toString().toLowerCase();
            text = text + (status.errorAnalyzingFinished ? DaemonBundle.message((String)"errors.found", (Object[])new Object[]{status.errorCount[i], name}) : DaemonBundle.message((String)"errors.found.so.far", (Object[])new Object[]{status.errorCount[i], name}));
            currentSeverityErrors += status.errorCount[i];
        }
        if (currentSeverityErrors == 0) {
            text = text + BR;
            text = text + (status.errorAnalyzingFinished ? DaemonBundle.message((String)"no.errors.or.warnings.found", (Object[])new Object[0]) : DaemonBundle.message((String)"no.errors.or.warnings.found.so.far", (Object[])new Object[0]));
        }
        text = text + TrafficLightRenderer.getMessageByRoots(status.noHighlightingRoots, status.rootsNumber, "no.syntax.highlighting.performed");
        text = text + TrafficLightRenderer.getMessageByRoots(status.noInspectionRoots, status.rootsNumber, "no.inspections.performed");
        text = text + HTML_FOOTER;
        return text;
    }

    private static String renderProgressHtml(double progress) {
        int i;
        String text = "<table><tr><td>";
        int nBricks = 5;
        int nFilledBricks = (int)((double)nBricks * progress);
        for (i = 0; i < nFilledBricks; ++i) {
            text = text + "<img src=\"" + progressUrl + "\">";
        }
        while (i < nBricks) {
            text = text + "<img src=\"" + progressPlaceHolderUrl + "\">";
            ++i;
        }
        text = text + "&nbsp;" + String.format("%2.0f%%", progress * 100.0);
        text = text + "</td></tr></table>";
        return text;
    }

    private static String getMessageByRoots(String[] roots, int rootsNumber, @NonNls String prefix) {
        int length;
        if (roots != null && (length = roots.length) > 0) {
            return BR + (rootsNumber > 1 ? DaemonBundle.message((String)(prefix + NO_PASS_FOR_MESSAGE_KEY_SUFFIX), (Object[])new Object[]{StringUtil.join((String[])roots, (String)", ")}) : DaemonBundle.message((String)prefix, (Object[])new Object[0]));
        }
        return "";
    }

    public void paint(Component c, Graphics g, Rectangle r) {
        Icon icon = this.getIcon();
        int height = icon.getIconHeight();
        int width = icon.getIconWidth();
        icon.paintIcon(c, g, r.x + (r.width - width) / 2, r.y + (r.height - height) / 2);
    }

    private Icon getIcon() {
        Icon icon;
        DaemonCodeAnalyzerStatus status = this.getDaemonCodeAnalyzerStatus(false);
        if (status == null) {
            return NO_ICON;
        }
        if (status.noHighlightingRoots != null && status.noHighlightingRoots.length == status.rootsNumber) {
            return NO_ANALYSIS_ICON;
        }
        Icon inProgressMask = null;
        boolean atLeastOnePassFinished = status.errorAnalyzingFinished;
        for (DaemonCodeAnalyzerStatus.PassStatus passStatus : status.passStati) {
            Icon progressIcon;
            atLeastOnePassFinished |= passStatus.finished;
            if (passStatus.finished || (progressIcon = passStatus.inProgressIcon) == null) continue;
            inProgressMask = inProgressMask == null ? progressIcon : LayeredIcon.create((Icon)inProgressMask, (Icon)progressIcon);
        }
        Icon icon2 = icon = status.errorAnalyzingFinished ? HighlightDisplayLevel.DO_NOT_SHOW.getIcon() : IN_PROGRESS_ICON;
        if (atLeastOnePassFinished) {
            SeverityRegistrar severityRegistrar = SeverityRegistrar.getInstance(this.myProject);
            for (int i = status.errorCount.length - 1; i >= 0; --i) {
                if (status.errorCount[i] == 0) continue;
                icon = severityRegistrar.getRendererIconByIndex(i);
                break;
            }
        }
        if (inProgressMask != null) {
            icon = LayeredIcon.create((Icon)icon, inProgressMask);
        }
        return icon;
    }

    public static class DaemonCodeAnalyzerStatus {
        public boolean errorAnalyzingFinished;
        public List<PassStatus> passStati = new ArrayList<PassStatus>();
        public String[] noHighlightingRoots;
        public String[] noInspectionRoots;
        public int[] errorCount;
        public int rootsNumber;

        public String toString() {
            String s = "DS: finished=" + this.errorAnalyzingFinished;
            s = s + "; pass statuses: " + this.passStati.size() + "; ";
            for (PassStatus passStatus : this.passStati) {
                s = s + String.format("(%s %2.0f%% %b)", passStatus.name, passStatus.progress * 100.0, passStatus.finished);
            }
            return s;
        }

        public static class PassStatus {
            private final String name;
            private final double progress;
            private final boolean finished;
            public Icon inProgressIcon;

            public PassStatus(String name, double progress, boolean finished, Icon inProgressIcon) {
                this.name = name;
                this.progress = progress;
                this.finished = finished;
                this.inProgressIcon = inProgressIcon;
            }
        }
    }
}

