/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiVariable;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SideEffectWarningDialog
extends DialogWrapper {
    private final PsiVariable myVariable;
    private final String myBeforeText;
    private final String myAfterText;
    private final boolean myCanCopeWithSideEffects;
    private AbstractAction myMakeStmtAction;
    private AbstractAction myRemoveAllAction;
    private AbstractAction myCancelAllAction;
    public static final int MAKE_STATEMENT = 1;
    public static final int DELETE_ALL = 2;
    public static final int CANCEL = 0;

    public SideEffectWarningDialog(Project project, boolean canBeParent, PsiVariable variable, String beforeText, String afterText, boolean canCopeWithSideEffects) {
        super(project, canBeParent);
        this.myVariable = variable;
        this.myBeforeText = beforeText;
        this.myAfterText = afterText;
        this.myCanCopeWithSideEffects = canCopeWithSideEffects;
        this.setTitle(QuickFixBundle.message("side.effects.warning.dialog.title", new Object[0]));
        this.init();
    }

    protected Action[] createActions() {
        ArrayList<AbstractAction> actions = new ArrayList<AbstractAction>();
        this.myRemoveAllAction = new AbstractAction(){
            {
                UIUtil.setActionNameAndMnemonic((String)QuickFixBundle.message("side.effect.action.remove", new Object[0]), (Action)this);
                this.putValue("DefaultAction", this);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                SideEffectWarningDialog.this.close(2);
            }
        };
        actions.add(this.myRemoveAllAction);
        if (this.myCanCopeWithSideEffects) {
            this.myMakeStmtAction = new AbstractAction(){
                {
                    UIUtil.setActionNameAndMnemonic((String)QuickFixBundle.message("side.effect.action.transform", new Object[0]), (Action)this);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    SideEffectWarningDialog.this.close(1);
                }
            };
            actions.add(this.myMakeStmtAction);
        }
        this.myCancelAllAction = new AbstractAction(){
            {
                UIUtil.setActionNameAndMnemonic((String)QuickFixBundle.message("side.effect.action.cancel", new Object[0]), (Action)this);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                SideEffectWarningDialog.this.doCancelAction();
            }
        };
        actions.add(this.myCancelAllAction);
        return actions.toArray(new Action[actions.size()]);
    }

    protected Action getCancelAction() {
        return this.myCancelAllAction;
    }

    protected Action getOKAction() {
        return this.myRemoveAllAction;
    }

    public void doCancelAction() {
        this.close(0);
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        String text = this.sideEffectsDescription();
        JLabel label = new JLabel(text);
        label.setIcon(Messages.getWarningIcon());
        panel.add((Component)label, "North");
        return panel;
    }

    protected String sideEffectsDescription() {
        if (this.myCanCopeWithSideEffects) {
            return QuickFixBundle.message("side.effect.message2", this.myVariable.getName(), this.myVariable.getType().getPresentableText(), this.myBeforeText, this.myAfterText);
        }
        return QuickFixBundle.message("side.effect.message1", this.myVariable.getName());
    }
}

