/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.config;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.impl.config.IntentionActionMetaData;
import com.intellij.codeInsight.intention.impl.config.IntentionUsagePanel;
import com.intellij.codeInsight.intention.impl.config.ResourceTextDescriptor;
import com.intellij.codeInsight.intention.impl.config.TextDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.TitledSeparator;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class IntentionDescriptionPanel {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.intention.impl.config.IntentionDescriptionPanel");
    private JPanel myPanel;
    private JPanel myAfterPanel;
    private JPanel myBeforePanel;
    private JEditorPane myDescriptionBrowser;
    private TitledSeparator myBeforeSeparator;
    private TitledSeparator myAfterSeparator;
    private JPanel myPoweredByPanel;
    private final List<IntentionUsagePanel> myBeforeUsagePanels;
    private final List<IntentionUsagePanel> myAfterUsagePanels;
    @NonNls
    private static final String BEFORE_TEMPLATE = "before.java.template";
    @NonNls
    private static final String AFTER_TEMPLATE = "after.java.template";

    public IntentionDescriptionPanel() {
        this.$$$setupUI$$$();
        this.myBeforeUsagePanels = new ArrayList<IntentionUsagePanel>();
        this.myAfterUsagePanels = new ArrayList<IntentionUsagePanel>();
    }

    public void reset(IntentionActionMetaData actionMetaData, String filter) {
        try {
            TextDescriptor url = actionMetaData.getDescription();
            String description = url == null ? CodeInsightBundle.message((String)"under.construction.string", (Object[])new Object[0]) : SearchUtil.markup(url.getText(), filter);
            this.myDescriptionBrowser.setText(description);
            this.setupPoweredByPanel(actionMetaData);
            IntentionDescriptionPanel.showUsages(this.myBeforePanel, this.myBeforeSeparator, this.myBeforeUsagePanels, actionMetaData.getExampleUsagesBefore());
            IntentionDescriptionPanel.showUsages(this.myAfterPanel, this.myAfterSeparator, this.myAfterUsagePanels, actionMetaData.getExampleUsagesAfter());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    IntentionDescriptionPanel.this.myPanel.revalidate();
                }
            });
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private void setupPoweredByPanel(IntentionActionMetaData actionMetaData) {
        JLabel owner;
        PluginId pluginId;
        PluginId pluginId2 = pluginId = actionMetaData == null ? null : actionMetaData.getPluginId();
        if (pluginId == null) {
            String label = "<html><body><b>" + ApplicationNamesInfo.getInstance().getFullProductName() + "</b></body></html>";
            owner = new JLabel(label);
        } else {
            final IdeaPluginDescriptor pluginDescriptor = PluginManager.getPlugin((PluginId)pluginId);
            HyperlinkLabel label = new HyperlinkLabel(CodeInsightBundle.message((String)"powered.by.plugin", (Object[])new Object[]{pluginDescriptor.getName()}));
            label.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    final PluginManagerConfigurable pluginConfigurable = PluginManagerConfigurable.getInstance();
                    Project project = ProjectManager.getInstance().getDefaultProject();
                    ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)pluginConfigurable, new Runnable(){

                        @Override
                        public void run() {
                            pluginConfigurable.select(pluginDescriptor);
                        }
                    });
                }
            });
            owner = label;
        }
        this.myPoweredByPanel.removeAll();
        this.myPoweredByPanel.add((Component)owner, "Center");
    }

    public void reset(String intentionCategory) {
        try {
            String text = CodeInsightBundle.message((String)"intention.settings.category.text", (Object[])new Object[]{intentionCategory});
            this.myDescriptionBrowser.setText(text);
            this.setupPoweredByPanel(null);
            URL beforeURL = this.getClass().getClassLoader().getResource(this.getClass().getPackage().getName().replace('.', '/') + "/" + BEFORE_TEMPLATE);
            IntentionDescriptionPanel.showUsages(this.myBeforePanel, this.myBeforeSeparator, this.myBeforeUsagePanels, new ResourceTextDescriptor[]{new ResourceTextDescriptor(beforeURL)});
            URL afterURL = this.getClass().getClassLoader().getResource(this.getClass().getPackage().getName().replace('.', '/') + "/" + AFTER_TEMPLATE);
            IntentionDescriptionPanel.showUsages(this.myAfterPanel, this.myAfterSeparator, this.myAfterUsagePanels, new ResourceTextDescriptor[]{new ResourceTextDescriptor(afterURL)});
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    IntentionDescriptionPanel.this.myPanel.revalidate();
                }
            });
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private static void showUsages(JPanel panel, TitledSeparator separator, List<IntentionUsagePanel> usagePanels, @Nullable TextDescriptor[] exampleUsages) throws IOException {
        boolean reuse;
        GridBagConstraints gb = null;
        boolean bl = reuse = exampleUsages != null && panel.getComponents().length == exampleUsages.length;
        if (!reuse) {
            IntentionDescriptionPanel.disposeUsagePanels(usagePanels);
            panel.setLayout(new GridBagLayout());
            panel.removeAll();
            gb = new GridBagConstraints();
            gb.anchor = 18;
            gb.fill = 1;
            gb.gridheight = 0;
            gb.gridwidth = 1;
            gb.gridx = 0;
            gb.gridy = 0;
            gb.insets = new Insets(0, 0, 0, 0);
            gb.ipadx = 5;
            gb.ipady = 5;
            gb.weightx = 1.0;
            gb.weighty = 1.0;
        }
        if (exampleUsages != null) {
            for (int i = 0; i < exampleUsages.length; ++i) {
                IntentionUsagePanel usagePanel;
                TextDescriptor exampleUsage = exampleUsages[i];
                String name = exampleUsage.getFileName();
                FileTypeManagerEx fileTypeManager = FileTypeManagerEx.getInstanceEx();
                String extension = fileTypeManager.getExtension(name);
                FileType fileType = fileTypeManager.getFileTypeByExtension(extension);
                if (reuse) {
                    usagePanel = (IntentionUsagePanel)panel.getComponent(i);
                } else {
                    usagePanel = new IntentionUsagePanel();
                    usagePanels.add(usagePanel);
                }
                usagePanel.reset(exampleUsage.getText(), fileType);
                separator.setText(name);
                if (reuse) continue;
                if (i == exampleUsages.length) {
                    gb.gridwidth = 0;
                }
                panel.add((Component)usagePanel, gb);
                ++gb.gridx;
            }
        }
        panel.revalidate();
        panel.repaint();
    }

    public JPanel getComponent() {
        return this.myPanel;
    }

    public void dispose() {
        IntentionDescriptionPanel.disposeUsagePanels(this.myBeforeUsagePanels);
        IntentionDescriptionPanel.disposeUsagePanels(this.myAfterUsagePanels);
    }

    private static void disposeUsagePanels(List<IntentionUsagePanel> usagePanels) {
        for (IntentionUsagePanel usagePanel : usagePanels) {
            usagePanel.dispose();
        }
        usagePanels.clear();
    }

    public void init(int preferredWidth) {
        double height = (this.myDescriptionBrowser.getSize().getHeight() + this.myBeforePanel.getSize().getHeight() + this.myAfterPanel.getSize().getHeight()) / 3.0;
        Dimension newd = new Dimension(preferredWidth, (int)height);
        this.myDescriptionBrowser.setSize(newd);
        this.myDescriptionBrowser.setPreferredSize(newd);
        this.myDescriptionBrowser.setMaximumSize(newd);
        this.myDescriptionBrowser.setMinimumSize(newd);
        this.myBeforePanel.setSize(newd);
        this.myBeforePanel.setPreferredSize(newd);
        this.myBeforePanel.setMaximumSize(newd);
        this.myBeforePanel.setMinimumSize(newd);
        this.myAfterPanel.setSize(newd);
        this.myAfterPanel.setPreferredSize(newd);
        this.myAfterPanel.setMaximumSize(newd);
        this.myAfterPanel.setMinimumSize(newd);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JEditorPane jEditorPane;
        TitledSeparator titledSeparator;
        TitledSeparator titledSeparator2;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        this.myPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(8, 2, new Insets(5, 5, 5, 5), -1, -1, false, false));
        this.myAfterPanel = jPanel3 = new JPanel();
        jPanel4.add((Component)jPanel3, new GridConstraints(7, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myBeforePanel = jPanel2 = new JPanel();
        jPanel4.add((Component)jPanel2, new GridConstraints(5, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setHorizontalTextPosition(0);
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/CodeInsightBundle").getString("dialog.intention.settings.description.usage.example.title"));
        jLabel.setHorizontalAlignment(0);
        jPanel4.add((Component)jLabel, new GridConstraints(3, 0, 1, 2, 8, 1, 0, 0, null, null, null));
        this.myBeforeSeparator = titledSeparator2 = new TitledSeparator();
        jPanel4.add((Component)titledSeparator2, new GridConstraints(4, 0, 1, 2, 0, 1, 7, 0, null, null, null));
        this.myAfterSeparator = titledSeparator = new TitledSeparator();
        jPanel4.add((Component)titledSeparator, new GridConstraints(6, 0, 1, 2, 0, 1, 7, 0, null, null, null));
        TitledSeparator titledSeparator3 = new TitledSeparator();
        titledSeparator3.setText(ResourceBundle.getBundle("messages/CodeInsightBundle").getString("dialog.intention.settings.description.panel.title"));
        jPanel4.add((Component)titledSeparator3, new GridConstraints(0, 0, 1, 2, 0, 1, 7, 0, null, null, null));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel4.add((Component)jScrollPane, new GridConstraints(1, 0, 1, 2, 0, 3, 7, 3, null, null, null));
        this.myDescriptionBrowser = jEditorPane = new JEditorPane();
        jEditorPane.setContentType("text/html");
        jEditorPane.setEditable(false);
        jScrollPane.setViewportView(jEditorPane);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/CodeInsightBundle").getString("powered.by"));
        jPanel5.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPoweredByPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

