/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.instructions;

import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.openapi.progress.ProgressManager;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;

public abstract class Instruction {
    private int myIndex;
    private final ArrayList<DfaMemoryState> myProcessedStates = new ArrayList();

    protected Instruction() {
    }

    protected final DfaInstructionState[] nextInstruction(DataFlowRunner runner, DfaMemoryState stateBefore) {
        return new DfaInstructionState[]{new DfaInstructionState(runner.getInstruction(this.getIndex() + 1), stateBefore)};
    }

    public abstract DfaInstructionState[] accept(DataFlowRunner var1, DfaMemoryState var2, InstructionVisitor var3);

    public boolean isMemoryStateProcessed(DfaMemoryState dfaMemState) {
        for (DfaMemoryState state : this.myProcessedStates) {
            ProgressManager.checkCanceled();
            if (!dfaMemState.equals(state)) continue;
            return true;
        }
        return false;
    }

    public boolean setMemoryStateProcessed(DfaMemoryState dfaMemState) {
        if (this.myProcessedStates.size() > 300) {
            return false;
        }
        this.myProcessedStates.add(dfaMemState);
        return true;
    }

    public void setIndex(int index) {
        this.myIndex = index;
    }

    public int getIndex() {
        return this.myIndex;
    }

    @NonNls
    public String toString() {
        return super.toString();
    }
}

