/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.classParsing;

import com.intellij.compiler.SymbolTable;
import com.intellij.compiler.classParsing.AnnotationConstantValue;
import com.intellij.compiler.classParsing.ClassFileReader;
import com.intellij.compiler.classParsing.FieldInfo;
import com.intellij.compiler.classParsing.MemberInfoExternalizer;
import com.intellij.compiler.classParsing.MethodInfo;
import com.intellij.compiler.classParsing.ReferenceInfo;
import com.intellij.compiler.make.CacheCorruptedException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.ArrayUtil;
import com.intellij.util.cls.ClsFormatException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;

public final class ClassInfo
implements Cloneable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.classParsing.ClassInfo");
    private static final ReferenceInfo[] EMPTY_REF_ARRAY = new ReferenceInfo[0];
    private final int myQualifiedName;
    private final int myGenericSignature;
    private final int mySuperQualifiedName;
    private final int myFlags;
    private String myPath;
    private final String mySourceFileName;
    private final int[] mySuperInterfaces;
    private final FieldInfo[] myFields;
    private final MethodInfo[] myMethods;
    private ReferenceInfo[] myReferences;
    private final AnnotationConstantValue[] myRuntimeVisibleAnnotations;
    private final AnnotationConstantValue[] myRuntimeInvisibleAnnotations;
    private boolean myIsDirty = false;

    public ClassInfo(ClassFileReader reader, SymbolTable symbolTable) throws CacheCorruptedException {
        try {
            int superQName;
            int qName;
            this.myQualifiedName = qName = symbolTable.getId(reader.getQualifiedName());
            String genericSignature = reader.getGenericSignature();
            this.myGenericSignature = genericSignature != null ? symbolTable.getId(genericSignature) : -1;
            this.myPath = reader.getPath();
            String superClass = reader.getSuperClass();
            this.mySuperQualifiedName = superQName = "".equals(superClass) ? -1 : symbolTable.getId(superClass);
            LOG.assertTrue(superQName != qName);
            String[] superInterfaces = reader.getSuperInterfaces();
            this.mySuperInterfaces = ArrayUtil.newIntArray((int)superInterfaces.length);
            for (int idx = 0; idx < superInterfaces.length; ++idx) {
                this.mySuperInterfaces[idx] = symbolTable.getId(superInterfaces[idx]);
            }
            String sourceFileName = reader.getSourceFileName();
            this.mySourceFileName = sourceFileName != null ? sourceFileName : "";
            this.myFlags = reader.getAccessFlags();
            this.myRuntimeVisibleAnnotations = reader.getRuntimeVisibleAnnotations();
            this.myRuntimeInvisibleAnnotations = reader.getRuntimeInvisibleAnnotations();
            Collection<ReferenceInfo> refs = reader.getReferences();
            this.myReferences = refs.toArray(new ReferenceInfo[refs.size()]);
            this.myFields = reader.getFields();
            this.myMethods = reader.getMethods();
        }
        catch (ClsFormatException e) {
            throw new CacheCorruptedException(e);
        }
    }

    public ClassInfo(DataInput in) throws IOException {
        this.myQualifiedName = in.readInt();
        this.mySuperQualifiedName = in.readInt();
        this.myGenericSignature = in.readInt();
        this.myFlags = in.readInt();
        this.myPath = in.readUTF();
        this.mySourceFileName = in.readUTF();
        int ifaceCount = in.readInt();
        this.mySuperInterfaces = new int[ifaceCount];
        for (int idx = 0; idx < ifaceCount; ++idx) {
            this.mySuperInterfaces[idx] = in.readInt();
        }
        int fieldCount = in.readInt();
        this.myFields = new FieldInfo[fieldCount];
        for (int idx = 0; idx < fieldCount; ++idx) {
            this.myFields[idx] = new FieldInfo(in);
        }
        int methodCount = in.readInt();
        this.myMethods = new MethodInfo[methodCount];
        for (int idx = 0; idx < methodCount; ++idx) {
            this.myMethods[idx] = new MethodInfo(in);
        }
        int refCount = in.readInt();
        this.myReferences = refCount > 0 ? new ReferenceInfo[refCount] : EMPTY_REF_ARRAY;
        for (int idx = 0; idx < refCount; ++idx) {
            this.myReferences[idx] = MemberInfoExternalizer.loadReferenceInfo(in);
        }
        this.myRuntimeVisibleAnnotations = MemberInfoExternalizer.readAnnotationConstantValueArray1(in);
        this.myRuntimeInvisibleAnnotations = MemberInfoExternalizer.readAnnotationConstantValueArray1(in);
    }

    public ClassInfo clone() {
        try {
            return (ClassInfo)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public void save(DataOutput out) throws IOException {
        out.writeInt(this.myQualifiedName);
        out.writeInt(this.mySuperQualifiedName);
        out.writeInt(this.myGenericSignature);
        out.writeInt(this.myFlags);
        out.writeUTF(this.myPath);
        out.writeUTF(this.mySourceFileName);
        out.writeInt(this.mySuperInterfaces.length);
        for (int ifaceQName : this.mySuperInterfaces) {
            out.writeInt(ifaceQName);
        }
        out.writeInt(this.myFields.length);
        for (FieldInfo field : this.myFields) {
            field.save(out);
        }
        out.writeInt(this.myMethods.length);
        for (MethodInfo method : this.myMethods) {
            method.save(out);
        }
        out.writeInt(this.myReferences.length);
        for (ReferenceInfo info : this.myReferences) {
            MemberInfoExternalizer.saveReferenceInfo(out, info);
        }
        MemberInfoExternalizer.writeConstantValueArray1(out, this.myRuntimeVisibleAnnotations);
        MemberInfoExternalizer.writeConstantValueArray1(out, this.myRuntimeInvisibleAnnotations);
    }

    public boolean isDirty() {
        return this.myIsDirty;
    }

    public int getQualifiedName() throws IOException {
        return this.myQualifiedName;
    }

    public int getGenericSignature() throws IOException {
        return this.myGenericSignature;
    }

    public int getSuperQualifiedName() throws IOException {
        return this.mySuperQualifiedName;
    }

    public int[] getSuperInterfaces() throws IOException {
        return this.mySuperInterfaces;
    }

    public int getFlags() throws IOException {
        return this.myFlags;
    }

    public String getPath() throws IOException {
        return this.myPath;
    }

    public void setPath(String path) {
        this.myIsDirty |= !Comparing.equal((String)this.myPath, (String)path);
        this.myPath = path;
    }

    public String getSourceFileName() throws IOException {
        return this.mySourceFileName;
    }

    public AnnotationConstantValue[] getRuntimeVisibleAnnotations() throws IOException {
        return this.myRuntimeVisibleAnnotations;
    }

    public AnnotationConstantValue[] getRuntimeInvisibleAnnotations() throws IOException {
        return this.myRuntimeInvisibleAnnotations;
    }

    public ReferenceInfo[] getReferences() {
        return this.myReferences;
    }

    public void clearReferences() {
        this.myReferences = EMPTY_REF_ARRAY;
    }

    public FieldInfo[] getFields() {
        return this.myFields;
    }

    public MethodInfo[] getMethods() {
        return this.myMethods;
    }
}

