/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.compiler.CompilerMessageImpl;
import com.intellij.compiler.impl.CompositeScope;
import com.intellij.compiler.impl.ProjectCompileScope;
import com.intellij.compiler.impl.TranslatingCompilerFilesMonitor;
import com.intellij.compiler.make.DependencyCache;
import com.intellij.compiler.progress.CompilerTask;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerMessage;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.compiler.ex.CompileContextEx;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.OrderedSet;
import com.intellij.util.indexing.FileBasedIndex;
import gnu.trove.TIntHashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompileContextImpl
extends UserDataHolderBase
implements CompileContextEx {
    private final Project myProject;
    private final CompilerTask myTask;
    private final Map<CompilerMessageCategory, Collection<CompilerMessage>> myMessages = new EnumMap<CompilerMessageCategory, Collection<CompilerMessage>>(CompilerMessageCategory.class);
    private CompileScope myCompileScope;
    private final DependencyCache myDependencyCache;
    private final boolean myMake;
    private final boolean myIsRebuild;
    private boolean myRebuildRequested = false;
    private String myRebuildReason;
    private final Map<VirtualFile, Module> myRootToModuleMap = new HashMap();
    private final Map<Module, Set<VirtualFile>> myModuleToRootsMap = new HashMap();
    private final Set<VirtualFile> myGeneratedTestRoots = new java.util.HashSet<VirtualFile>();
    private VirtualFile[] myOutputDirectories;
    private Set<VirtualFile> myTestOutputDirectories;
    private final TIntHashSet myGeneratedSources = new TIntHashSet();
    private final ProjectFileIndex myProjectFileIndex;
    private final ProjectCompileScope myProjectCompileScope;
    private final long myStartCompilationStamp;
    private final Map<Module, VirtualFile[]> myModuleToRootsCache = new HashMap();

    public CompileContextImpl(Project project, CompilerTask compilerSession, CompileScope compileScope, DependencyCache dependencyCache, boolean isMake, boolean isRebuild) {
        this.myProject = project;
        this.myTask = compilerSession;
        this.myCompileScope = compileScope;
        this.myDependencyCache = dependencyCache;
        this.myMake = isMake;
        this.myIsRebuild = isRebuild;
        this.myStartCompilationStamp = System.currentTimeMillis();
        this.myProjectFileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        this.myProjectCompileScope = new ProjectCompileScope(this.myProject);
        if (compilerSession != null) {
            compilerSession.setContentIdKey((Key)compileScope.getUserData(CompilerManager.CONTENT_ID_KEY));
        }
        this.recalculateOutputDirs();
    }

    @Override
    public void recalculateOutputDirs() {
        Module[] allModules = ModuleManager.getInstance((Project)this.myProject).getModules();
        OrderedSet allDirs = new OrderedSet(TObjectHashingStrategy.CANONICAL);
        java.util.HashSet<VirtualFile> testOutputDirs = new java.util.HashSet<VirtualFile>();
        java.util.HashSet<VirtualFile> productionOutputDirs = new java.util.HashSet<VirtualFile>();
        for (Module module : allModules) {
            VirtualFile testsOutput;
            CompilerModuleExtension manager = CompilerModuleExtension.getInstance((Module)module);
            VirtualFile output = manager.getCompilerOutputPath();
            if (output != null && output.isValid()) {
                allDirs.add(output);
                productionOutputDirs.add(output);
            }
            if ((testsOutput = manager.getCompilerOutputPathForTests()) == null || !testsOutput.isValid()) continue;
            allDirs.add(testsOutput);
            testOutputDirs.add(testsOutput);
        }
        this.myOutputDirectories = VfsUtil.toVirtualFileArray((Collection)allDirs);
        testOutputDirs.removeAll(productionOutputDirs);
        this.myTestOutputDirectories = Collections.unmodifiableSet(testOutputDirs);
    }

    @Override
    public void markGenerated(Collection<VirtualFile> files) {
        for (VirtualFile file : files) {
            this.myGeneratedSources.add(FileBasedIndex.getFileId(file));
        }
    }

    @Override
    public long getStartCompilationStamp() {
        return this.myStartCompilationStamp;
    }

    @Override
    public boolean isGenerated(VirtualFile file) {
        String procGenRoot;
        if (this.myGeneratedSources.contains(FileBasedIndex.getFileId(file))) {
            return true;
        }
        for (VirtualFile root : this.myRootToModuleMap.keySet()) {
            if (!VfsUtil.isAncestor((VirtualFile)root, (VirtualFile)file, (boolean)false)) continue;
            return true;
        }
        Module module = this.getModuleByFile(file);
        return module != null && (procGenRoot = CompilerPaths.getAnnotationProcessorsGenerationPath((Module)module)) != null && VfsUtil.isAncestor((File)new File(procGenRoot), (File)new File(file.getPath()), (boolean)true);
    }

    @Override
    public void updateZippedOuput(String outputDir, String relativePath) throws IOException {
    }

    @Override
    public void commitZipFiles() {
    }

    @Override
    public void commitZip(String outputDir) throws IOException {
    }

    public Project getProject() {
        return this.myProject;
    }

    @Override
    public DependencyCache getDependencyCache() {
        return this.myDependencyCache;
    }

    public CompilerMessage[] getMessages(CompilerMessageCategory category) {
        Collection<CompilerMessage> collection = this.myMessages.get(category);
        if (collection == null) {
            return CompilerMessage.EMPTY_ARRAY;
        }
        return collection.toArray(new CompilerMessage[collection.size()]);
    }

    public void addMessage(CompilerMessageCategory category, String message, String url, int lineNum, int columnNum) {
        CompilerMessageImpl msg = new CompilerMessageImpl(this.myProject, category, message, url, lineNum, columnNum, null);
        this.addMessage(msg);
    }

    public void addMessage(CompilerMessageCategory category, String message, String url, int lineNum, int columnNum, Navigatable navigatable) {
        CompilerMessageImpl msg = new CompilerMessageImpl(this.myProject, category, message, url, lineNum, columnNum, navigatable);
        this.addMessage(msg);
    }

    @Override
    public void addMessage(CompilerMessage msg) {
        HashSet messages = this.myMessages.get(msg.getCategory());
        if (messages == null) {
            messages = new HashSet();
            this.myMessages.put(msg.getCategory(), (Collection<CompilerMessage>)messages);
        }
        if (messages.add((CompilerMessage)msg)) {
            this.myTask.addMessage(msg);
        }
    }

    public int getMessageCount(CompilerMessageCategory category) {
        if (category != null) {
            Collection<CompilerMessage> collection = this.myMessages.get(category);
            return collection != null ? collection.size() : 0;
        }
        int count = 0;
        for (Collection<CompilerMessage> collection : this.myMessages.values()) {
            if (collection == null) continue;
            count += collection.size();
        }
        return count;
    }

    public CompileScope getCompileScope() {
        return this.myCompileScope;
    }

    public CompileScope getProjectCompileScope() {
        return this.myProjectCompileScope;
    }

    public void requestRebuildNextTime(String message) {
        if (!this.myRebuildRequested) {
            this.myRebuildRequested = true;
            this.myRebuildReason = message;
            this.addMessage(CompilerMessageCategory.ERROR, message, null, -1, -1);
        }
    }

    public boolean isRebuildRequested() {
        return this.myRebuildRequested;
    }

    public String getRebuildReason() {
        return this.myRebuildReason;
    }

    public ProgressIndicator getProgressIndicator() {
        return this.myTask.getIndicator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void assignModule(@NotNull VirtualFile root, @NotNull Module module, boolean isTestSource) {
        if (root == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/impl/CompileContextImpl.assignModule must not be null");
        }
        if (module == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/compiler/impl/CompileContextImpl.assignModule must not be null");
        }
        try {
            this.myRootToModuleMap.put(root, module);
            HashSet set = this.myModuleToRootsMap.get(module);
            if (set == null) {
                set = new HashSet();
                this.myModuleToRootsMap.put(module, (Set<VirtualFile>)set);
            }
            set.add((VirtualFile)root);
            if (isTestSource) {
                this.myGeneratedTestRoots.add(root);
            }
        }
        finally {
            this.myModuleToRootsCache.remove(module);
        }
    }

    @Override
    @Nullable
    public VirtualFile getSourceFileByOutputFile(VirtualFile outputFile) {
        return TranslatingCompilerFilesMonitor.getSourceFileByOutput(outputFile);
    }

    public Module getModuleByFile(VirtualFile file) {
        Module module = this.myProjectFileIndex.getModuleForFile(file);
        if (module != null) {
            return module;
        }
        for (VirtualFile root : this.myRootToModuleMap.keySet()) {
            if (!VfsUtil.isAncestor((VirtualFile)root, (VirtualFile)file, (boolean)false)) continue;
            return this.myRootToModuleMap.get(root);
        }
        return null;
    }

    public VirtualFile[] getSourceRoots(Module module) {
        VirtualFile[] cachedRoots = this.myModuleToRootsCache.get(module);
        if (cachedRoots != null) {
            if (CompileContextImpl.areFilesValid(cachedRoots)) {
                return cachedRoots;
            }
            this.myModuleToRootsCache.remove(module);
        }
        Set<VirtualFile> additionalRoots = this.myModuleToRootsMap.get(module);
        VirtualFile[] moduleRoots = ModuleRootManager.getInstance((Module)module).getSourceRoots();
        if (additionalRoots == null || additionalRoots.isEmpty()) {
            this.myModuleToRootsCache.put(module, moduleRoots);
            return moduleRoots;
        }
        VirtualFile[] allRoots = new VirtualFile[additionalRoots.size() + moduleRoots.length];
        System.arraycopy(moduleRoots, 0, allRoots, 0, moduleRoots.length);
        int index = moduleRoots.length;
        for (VirtualFile additionalRoot : additionalRoots) {
            allRoots[index++] = additionalRoot;
        }
        this.myModuleToRootsCache.put(module, allRoots);
        return allRoots;
    }

    private static boolean areFilesValid(VirtualFile[] files) {
        for (VirtualFile file : files) {
            if (file.isValid()) continue;
            return false;
        }
        return true;
    }

    public VirtualFile[] getAllOutputDirectories() {
        return this.myOutputDirectories;
    }

    @Override
    @NotNull
    public Set<VirtualFile> getTestOutputDirectories() {
        Set<VirtualFile> set = this.myTestOutputDirectories;
        if (set == null) {
            throw new IllegalStateException("@NotNull method com/intellij/compiler/impl/CompileContextImpl.getTestOutputDirectories must not return null");
        }
        return set;
    }

    public VirtualFile getModuleOutputDirectory(Module module) {
        return CompilerPaths.getModuleOutputDirectory((Module)module, (boolean)false);
    }

    public VirtualFile getModuleOutputDirectoryForTests(Module module) {
        return CompilerPaths.getModuleOutputDirectory((Module)module, (boolean)true);
    }

    public boolean isMake() {
        return this.myMake;
    }

    public boolean isRebuild() {
        return this.myIsRebuild;
    }

    @Override
    public void addScope(CompileScope additionalScope) {
        this.myCompileScope = new CompositeScope(this.myCompileScope, additionalScope);
    }

    @Override
    public boolean isInTestSourceContent(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/impl/CompileContextImpl.isInTestSourceContent must not be null");
        }
        if (this.myProjectFileIndex.isInTestSourceContent(fileOrDir)) {
            return true;
        }
        for (VirtualFile root : this.myGeneratedTestRoots) {
            if (!VfsUtil.isAncestor((VirtualFile)root, (VirtualFile)fileOrDir, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isInSourceContent(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/impl/CompileContextImpl.isInSourceContent must not be null");
        }
        if (this.myProjectFileIndex.isInSourceContent(fileOrDir)) {
            return true;
        }
        for (VirtualFile root : this.myRootToModuleMap.keySet()) {
            if (!VfsUtil.isAncestor((VirtualFile)root, (VirtualFile)fileOrDir, (boolean)false)) continue;
            return true;
        }
        return false;
    }
}

