/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl.javaCompiler;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerConfigurationImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.ex.CompileContextEx;
import com.intellij.openapi.module.LanguageLevelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.Chunk;
import com.intellij.util.PathUtil;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.containers.OrderedSet;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ModuleChunk
extends Chunk<Module> {
    private final CompileContextEx myContext;
    private final Map<Module, List<VirtualFile>> myModuleToFilesMap = new THashMap();
    private final Map<VirtualFile, VirtualFile> myTransformedToOriginalMap = new THashMap();
    private int mySourcesFilter = 3;
    public static final int SOURCES = 1;
    public static final int TEST_SOURCES = 2;
    public static final int ALL_SOURCES = 3;

    public ModuleChunk(CompileContextEx context, Chunk<Module> chunk, Map<Module, List<VirtualFile>> moduleToFilesMap) {
        super(chunk.getNodes());
        this.myContext = context;
        Iterator i$ = chunk.getNodes().iterator();
        while (i$.hasNext()) {
            Module module;
            List<VirtualFile> files = moduleToFilesMap.get(module = (Module)i$.next());
            this.myModuleToFilesMap.put(module, (List<VirtualFile>)(files == null ? Collections.emptyList() : new ArrayList<VirtualFile>(files)));
        }
    }

    public void setSourcesFilter(int filter) {
        this.mySourcesFilter = filter;
    }

    public void substituteWithTransformedVersion(Module module, int fileIndex, VirtualFile transformedFile) {
        List<VirtualFile> moduleFiles = this.getFilesToCompile(module);
        VirtualFile currentFile = moduleFiles.get(fileIndex);
        moduleFiles.set(fileIndex, transformedFile);
        VirtualFile originalFile = this.myTransformedToOriginalMap.remove(currentFile);
        if (originalFile == null) {
            originalFile = currentFile;
        }
        this.myTransformedToOriginalMap.put(transformedFile, originalFile);
    }

    public VirtualFile getOriginalFile(VirtualFile file) {
        VirtualFile original = this.myTransformedToOriginalMap.get(file);
        return original != null ? original : file;
    }

    @NotNull
    public List<VirtualFile> getFilesToCompile(Module forModule) {
        List<VirtualFile> list = this.myModuleToFilesMap.get(forModule);
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/compiler/impl/javaCompiler/ModuleChunk.getFilesToCompile must not return null");
        }
        return list;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public List<VirtualFile> getFilesToCompile() {
        if (this.getModuleCount() == 0) {
            v0 = Collections.emptyList();
            if (v0 == null) lbl-1000:
            // 2 sources

            {
                throw new IllegalStateException("@NotNull method com/intellij/compiler/impl/javaCompiler/ModuleChunk.getFilesToCompile must not return null");
            }
            return v0;
        }
        modules = this.getNodes();
        filesToCompile = new ArrayList<VirtualFile>();
        for (Module module : modules) {
            moduleCompilableFiles = this.getFilesToCompile(module);
            if (this.mySourcesFilter == 3) {
                filesToCompile.addAll(moduleCompilableFiles);
                continue;
            }
            for (VirtualFile file : moduleCompilableFiles) {
                originalFile = this.myTransformedToOriginalMap.get(file);
                if (originalFile == null) {
                    originalFile = file;
                }
                if (this.mySourcesFilter == 2) {
                    if (!this.myContext.isInTestSourceContent(originalFile)) continue;
                    filesToCompile.add(file);
                    continue;
                }
                if (this.myContext.isInTestSourceContent(originalFile)) continue;
                filesToCompile.add(file);
            }
        }
        ** while ((v0 = filesToCompile) == null)
lbl30:
        // 1 sources

        return v0;
    }

    public Sdk getJdk() {
        Module module = (Module)this.getNodes().iterator().next();
        return ModuleRootManager.getInstance((Module)module).getSdk();
    }

    public VirtualFile[] getSourceRoots() {
        return (VirtualFile[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<VirtualFile[]>(){

            public VirtualFile[] compute() {
                return ModuleChunk.this.filterRoots(ModuleChunk.this.getAllSourceRoots(), ((Module)ModuleChunk.this.getNodes().iterator().next()).getProject());
            }
        });
    }

    public VirtualFile[] getSourceRoots(final Module module) {
        if (!this.getNodes().contains(module)) {
            return VirtualFile.EMPTY_ARRAY;
        }
        return (VirtualFile[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<VirtualFile[]>(){

            public VirtualFile[] compute() {
                return ModuleChunk.this.filterRoots(ModuleChunk.this.myContext.getSourceRoots(module), module.getProject());
            }
        });
    }

    private VirtualFile[] filterRoots(VirtualFile[] roots, Project project) {
        ArrayList<VirtualFile> filteredRoots = new ArrayList<VirtualFile>(roots.length);
        CompilerConfigurationImpl compilerConfiguration = (CompilerConfigurationImpl)CompilerConfiguration.getInstance((Project)project);
        for (VirtualFile root : roots) {
            if (this.mySourcesFilter != 3 && (!this.myContext.isInTestSourceContent(root) ? (this.mySourcesFilter & 1) == 0 : (this.mySourcesFilter & 2) == 0) || compilerConfiguration.isExcludedFromCompilation(root)) continue;
            filteredRoots.add(root);
        }
        return VfsUtil.toVirtualFileArray(filteredRoots);
    }

    private VirtualFile[] getAllSourceRoots() {
        Set modules = this.getNodes();
        HashSet<VirtualFile> roots = new HashSet<VirtualFile>();
        for (Module module : modules) {
            roots.addAll(Arrays.asList(this.myContext.getSourceRoots(module)));
        }
        return VfsUtil.toVirtualFileArray(roots);
    }

    public String getCompilationClasspath() {
        OrderedSet<VirtualFile> cpFiles = this.getCompilationClasspathFiles();
        return ModuleChunk.convertToStringPath(cpFiles);
    }

    public OrderedSet<VirtualFile> getCompilationClasspathFiles() {
        Set modules = this.getNodes();
        OrderedSet cpFiles = new OrderedSet(TObjectHashingStrategy.CANONICAL);
        for (Module module : modules) {
            OrderEntry[] orderEntries = ModuleRootManager.getInstance((Module)module).getOrderEntries();
            boolean skip = true;
            for (OrderEntry orderEntry : orderEntries) {
                if (orderEntry instanceof JdkOrderEntry) {
                    skip = false;
                    continue;
                }
                if (skip) continue;
                if ((this.mySourcesFilter & 2) == 0) {
                    cpFiles.addAll(Arrays.asList(orderEntry.getFiles(OrderRootType.PRODUCTION_COMPILATION_CLASSES)));
                    continue;
                }
                cpFiles.addAll(Arrays.asList(orderEntry.getFiles(OrderRootType.COMPILATION_CLASSES)));
            }
        }
        return cpFiles;
    }

    public String getCompilationBootClasspath() {
        return ModuleChunk.convertToStringPath(this.getCompilationBootClasspathFiles());
    }

    public OrderedSet<VirtualFile> getCompilationBootClasspathFiles() {
        Set modules = this.getNodes();
        OrderedSet cpFiles = new OrderedSet(TObjectHashingStrategy.CANONICAL);
        OrderedSet jdkFiles = new OrderedSet(TObjectHashingStrategy.CANONICAL);
        block0: for (Module module : modules) {
            OrderEntry[] orderEntries;
            for (OrderEntry orderEntry : orderEntries = ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
                if (orderEntry instanceof JdkOrderEntry) {
                    jdkFiles.addAll(Arrays.asList(orderEntry.getFiles(OrderRootType.CLASSES)));
                    continue block0;
                }
                if ((this.mySourcesFilter & 2) == 0) {
                    cpFiles.addAll(Arrays.asList(orderEntry.getFiles(OrderRootType.PRODUCTION_COMPILATION_CLASSES)));
                    continue;
                }
                cpFiles.addAll(Arrays.asList(orderEntry.getFiles(OrderRootType.COMPILATION_CLASSES)));
            }
        }
        cpFiles.addAll((Collection)jdkFiles);
        return cpFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String convertToStringPath(OrderedSet<VirtualFile> cpFiles) {
        StringBuilder classpathBuffer = StringBuilderSpinAllocator.alloc();
        try {
            for (VirtualFile file : cpFiles) {
                String path = PathUtil.getLocalPath((VirtualFile)file);
                if (path == null) continue;
                if (classpathBuffer.length() > 0) {
                    classpathBuffer.append(File.pathSeparatorChar);
                }
                classpathBuffer.append(path);
            }
            String string = classpathBuffer.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)classpathBuffer);
        }
    }

    public int getModuleCount() {
        return this.getNodes().size();
    }

    public Module[] getModules() {
        Set nodes = this.getNodes();
        return nodes.toArray(new Module[nodes.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSourcePath() {
        if (this.getModuleCount() == 0) {
            return "";
        }
        final VirtualFile[] filteredRoots = this.getSourceRoots();
        final StringBuilder buffer = StringBuilderSpinAllocator.alloc();
        try {
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    for (VirtualFile root : filteredRoots) {
                        if (buffer.length() > 0) {
                            buffer.append(File.pathSeparatorChar);
                        }
                        buffer.append(root.getPath().replace('/', File.separatorChar));
                    }
                }
            });
            String string = buffer.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)buffer);
        }
    }

    public LanguageLevel getLanguageLevel() {
        return LanguageLevelUtil.getEffectiveLanguageLevel((Module)this.getModules()[0]);
    }
}

