/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.progress;

import com.intellij.CommonBundle;
import com.intellij.compiler.progress.CompilerTask;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.util.Alarm;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.Border;

public class CompilerProgressDialog
extends DialogWrapper {
    private final JLabel myStatusLabel = new JLabel();
    private final JLabel myStatisticsLabel = new JLabel();
    private final JButton myCancelButton = new JButton(CommonBundle.getCancelButtonText());
    private final JButton myBackgroundButton = new JButton(CommonBundle.getBackgroundButtonText());
    private final JPanel myFunPanel = new JPanel(new BorderLayout());
    private final CompilerTask myTask;
    private final Alarm myInstallFunAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);

    public CompilerProgressDialog(final CompilerTask task, Project project) {
        super(project, false);
        this.myTask = task;
        this.setTitle(CompilerBundle.message((String)"compile.progress.title", (Object[])new Object[0]));
        this.init();
        this.setCrossClosesWindow(false);
        final JComponent cmp = ProgressManager.getInstance().getProvidedFunComponent(project, "compilation");
        if (cmp != null) {
            Runnable installer = new Runnable(){

                @Override
                public void run() {
                    if (task.getIndicator().isRunning() && !task.getIndicator().isCanceled() && CompilerProgressDialog.this.isShowing()) {
                        CompilerProgressDialog.this.setFunComponent(cmp);
                    }
                }
            };
            this.myInstallFunAlarm.addRequest(installer, 3000, task.getIndicator().getModalityState());
        }
    }

    public Container getContentPane() {
        return this.getRootPane() != null ? super.getContentPane() : null;
    }

    private void setFunComponent(JComponent c) {
        this.myFunPanel.removeAll();
        if (c != null) {
            this.myFunPanel.add((Component)new JSeparator(), "North");
            this.myFunPanel.add((Component)c, "Center");
            this.myFunPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        }
        this.pack();
        this.centerRelativeToParent();
    }

    public void setStatusText(String text) {
        this.myStatusLabel.setText(text);
    }

    public void setStatisticsText(String text) {
        this.myStatisticsLabel.setText(text);
    }

    protected JComponent createCenterPanel() {
        return this.myFunPanel;
    }

    protected Border createContentPaneBorder() {
        return null;
    }

    protected JComponent createNorthPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.myStatisticsLabel.setHorizontalAlignment(2);
        this.myStatisticsLabel.setPreferredSize(new Dimension(380, 20));
        this.myStatisticsLabel.setMinimumSize(new Dimension(380, 20));
        panel.add((Component)this.myStatisticsLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 16, 2, new Insets(0, 0, 2, 0), 0, 0));
        this.myStatusLabel.setHorizontalAlignment(2);
        this.myStatusLabel.setPreferredSize(new Dimension(380, 20));
        this.myStatusLabel.setMinimumSize(new Dimension(380, 20));
        panel.add((Component)this.myStatusLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 2, new Insets(2, 0, 0, 0), 0, 0));
        this.myCancelButton.setFocusPainted(false);
        panel.add((Component)this.myCancelButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 15, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.myBackgroundButton.setFocusPainted(false);
        panel.add((Component)this.myBackgroundButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.myCancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CompilerProgressDialog.this.myCancelButton.setEnabled(false);
                CompilerProgressDialog.this.myTask.cancel();
            }
        });
        this.myBackgroundButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CompilerProgressDialog.this.myBackgroundButton.setEnabled(false);
                CompilerProgressDialog.this.myTask.sendToBackground();
            }
        });
        return panel;
    }

    protected JComponent createSouthPanel() {
        return null;
    }

    public void doCancelAction() {
        this.myCancelButton.setEnabled(false);
        this.myTask.cancel();
    }

    protected boolean isProgressDialog() {
        return true;
    }

    public String getStatusText() {
        return this.myStatusLabel.getText();
    }

    public String getStatistics() {
        return this.myStatisticsLabel.getText();
    }
}

