/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.actions.AutoRendererAction;
import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ViewAsGroup
extends ActionGroup {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.actions.ViewAsGroup");
    private AnAction[] myChildren = AnAction.EMPTY_ARRAY;

    public ViewAsGroup() {
        super(null, true);
    }

    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        return this.myChildren;
    }

    private static AnAction[] calcChildren(DebuggerTreeNodeImpl[] nodes) {
        AnAction[] viewAsActions;
        ArrayList<RendererAction> renderers = new ArrayList<RendererAction>();
        List<NodeRenderer> allRenderers = NodeRendererSettings.getInstance().getAllRenderers();
        boolean anyValueDescriptor = false;
        for (NodeRenderer nodeRenderer : allRenderers) {
            boolean allApp = true;
            for (DebuggerTreeNodeImpl node : nodes) {
                NodeDescriptorImpl descriptor = node.getDescriptor();
                if (!(descriptor instanceof ValueDescriptorImpl)) continue;
                anyValueDescriptor = true;
                ValueDescriptorImpl valueDescriptor = (ValueDescriptorImpl)descriptor;
                if (!valueDescriptor.isValueValid() || nodeRenderer.isApplicable(valueDescriptor.getType())) continue;
                allApp = false;
                break;
            }
            if (!anyValueDescriptor) {
                return AnAction.EMPTY_ARRAY;
            }
            if (!allApp) continue;
            renderers.add(new RendererAction(nodeRenderer));
        }
        ArrayList<Object> children = new ArrayList<Object>();
        for (AnAction viewAsAction : viewAsActions = ((DefaultActionGroup)ActionManager.getInstance().getAction("Debugger.Representation")).getChildren(null)) {
            if (viewAsAction instanceof AutoRendererAction) {
                if (renderers.size() <= 1) continue;
                viewAsAction.getTemplatePresentation().setVisible(true);
                children.add(viewAsAction);
                continue;
            }
            children.add(viewAsAction);
        }
        children.add(Separator.getInstance());
        children.addAll(renderers);
        return children.toArray(new AnAction[children.size()]);
    }

    public void update(final AnActionEvent event) {
        if (!DebuggerAction.isFirstStart(event)) {
            return;
        }
        DebuggerContextImpl debuggerContext = DebuggerAction.getDebuggerContext(event.getDataContext());
        final DebuggerTreeNodeImpl[] selectedNodes = DebuggerAction.getSelectedNodes(event.getDataContext());
        debuggerContext.getDebugProcess().getManagerThread().schedule(new DebuggerContextCommandImpl(debuggerContext){

            @Override
            public void threadAction() {
                ViewAsGroup.access$202(ViewAsGroup.this, ViewAsGroup.calcChildren(selectedNodes));
                DebuggerAction.enableAction(event, ViewAsGroup.this.myChildren.length > 0);
            }
        });
    }

    static /* synthetic */ AnAction[] access$202(ViewAsGroup x0, AnAction[] x1) {
        x0.myChildren = x1;
        return x1;
    }

    private static class RendererAction
    extends ToggleAction {
        private final NodeRenderer myNodeRenderer;

        public RendererAction(NodeRenderer nodeRenderer) {
            super(nodeRenderer.getName());
            this.myNodeRenderer = nodeRenderer;
        }

        public boolean isSelected(AnActionEvent e) {
            DebuggerTreeNodeImpl[] nodes = DebuggerAction.getSelectedNodes(e.getDataContext());
            if (nodes == null) {
                return false;
            }
            for (DebuggerTreeNodeImpl node : nodes) {
                if (!(node.getDescriptor() instanceof ValueDescriptorImpl) || ((ValueDescriptorImpl)node.getDescriptor()).getLastRenderer() == this.myNodeRenderer) continue;
                return false;
            }
            return true;
        }

        public void setSelected(AnActionEvent e, final boolean state) {
            DebuggerContextImpl debuggerContext = DebuggerAction.getDebuggerContext(e.getDataContext());
            final DebuggerTreeNodeImpl[] nodes = DebuggerAction.getSelectedNodes(e.getDataContext());
            LOG.assertTrue(debuggerContext != null && nodes != null);
            debuggerContext.getDebugProcess().getManagerThread().schedule(new DebuggerContextCommandImpl(debuggerContext){

                @Override
                public void threadAction() {
                    for (DebuggerTreeNodeImpl node : nodes) {
                        if (!(node.getDescriptor() instanceof ValueDescriptorImpl)) continue;
                        ValueDescriptorImpl valueDescriptor = (ValueDescriptorImpl)node.getDescriptor();
                        if (!state) continue;
                        valueDescriptor.setRenderer(RendererAction.this.myNodeRenderer);
                        node.calcRepresentation();
                    }
                }
            });
        }
    }
}

