/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.settings;

import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.execution.ui.layout.impl.RunnerLayoutSettings;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.ui.classFilter.ClassFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public class DebuggerSettings
implements JDOMExternalizable,
ApplicationComponent,
Cloneable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.settings.DebuggerSettings");
    public static final int SOCKET_TRANSPORT = 0;
    public static final int SHMEM_TRANSPORT = 1;
    @NonNls
    public static final String SUSPEND_ALL = "SuspendAll";
    @NonNls
    public static final String SUSPEND_THREAD = "SuspendThread";
    @NonNls
    public static final String SUSPEND_NONE = "SuspendNone";
    @NonNls
    public static final String EVALUATE_FRAGMENT = "EvaluateFragment";
    @NonNls
    public static final String EVALUATE_EXPRESSION = "EvaluateExpression";
    @NonNls
    public static final String RUN_HOTSWAP_ALWAYS = "RunHotswapAlways";
    @NonNls
    public static final String RUN_HOTSWAP_NEVER = "RunHotswapNever";
    @NonNls
    public static final String RUN_HOTSWAP_ASK = "RunHotswapAsk";
    public boolean TRACING_FILTERS_ENABLED;
    public int VALUE_LOOKUP_DELAY;
    public int DEBUGGER_TRANSPORT;
    public boolean FORCE_CLASSIC_VM;
    public boolean DISABLE_JIT;
    public boolean HIDE_DEBUGGER_ON_PROCESS_TERMINATION;
    public boolean HOTSWAP_IN_BACKGROUND = true;
    public boolean SKIP_SYNTHETIC_METHODS;
    public boolean SKIP_CONSTRUCTORS;
    public boolean SKIP_GETTERS;
    public boolean SKIP_CLASSLOADERS;
    public String EVALUATION_DIALOG_TYPE;
    public String RUN_HOTSWAP_AFTER_COMPILE;
    public boolean COMPILE_BEFORE_HOTSWAP;
    public volatile boolean WATCH_RETURN_VALUES = false;
    public volatile boolean AUTO_VARIABLES_MODE = false;
    private ClassFilter[] mySteppingFilters = ClassFilter.EMPTY_ARRAY;
    private Map<String, ContentState> myContentStates = new HashMap<String, ContentState>();

    public void disposeComponent() {
    }

    public void initComponent() {
    }

    public ClassFilter[] getSteppingFilters() {
        ClassFilter[] rv = new ClassFilter[this.mySteppingFilters.length];
        for (int idx = 0; idx < rv.length; ++idx) {
            rv[idx] = this.mySteppingFilters[idx].clone();
        }
        return rv;
    }

    void setSteppingFilters(ClassFilter[] steppingFilters) {
        this.mySteppingFilters = steppingFilters != null ? steppingFilters : ClassFilter.EMPTY_ARRAY;
    }

    public void readExternal(Element parentNode) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)parentNode);
        ArrayList<ClassFilter> filtersList = new ArrayList<ClassFilter>();
        for (Object o : parentNode.getChildren("filter")) {
            Element filter = (Element)o;
            filtersList.add(DebuggerUtilsEx.create(filter));
        }
        this.setSteppingFilters(filtersList.toArray(new ClassFilter[filtersList.size()]));
        filtersList.clear();
        List contents = parentNode.getChildren("content");
        this.myContentStates.clear();
        for (Object content : contents) {
            ContentState state = new ContentState((Element)content);
            this.myContentStates.put(state.getType(), state);
        }
    }

    public void writeExternal(Element parentNode) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)parentNode);
        for (ClassFilter mySteppingFilter : this.mySteppingFilters) {
            Element element = new Element("filter");
            parentNode.addContent(element);
            mySteppingFilter.writeExternal(element);
        }
        for (ContentState eachState : this.myContentStates.values()) {
            Element content;
            if (!eachState.write(content = new Element("content"))) continue;
            parentNode.addContent(content);
        }
    }

    public static DebuggerSettings getInstance() {
        return (DebuggerSettings)ServiceManager.getService(DebuggerSettings.class);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DebuggerSettings)) {
            return false;
        }
        DebuggerSettings secondSettings = (DebuggerSettings)obj;
        return this.TRACING_FILTERS_ENABLED == secondSettings.TRACING_FILTERS_ENABLED && this.VALUE_LOOKUP_DELAY == secondSettings.VALUE_LOOKUP_DELAY && this.DEBUGGER_TRANSPORT == secondSettings.DEBUGGER_TRANSPORT && this.FORCE_CLASSIC_VM == secondSettings.FORCE_CLASSIC_VM && this.DISABLE_JIT == secondSettings.DISABLE_JIT && this.HIDE_DEBUGGER_ON_PROCESS_TERMINATION == secondSettings.HIDE_DEBUGGER_ON_PROCESS_TERMINATION && this.HOTSWAP_IN_BACKGROUND == secondSettings.HOTSWAP_IN_BACKGROUND && this.SKIP_SYNTHETIC_METHODS == secondSettings.SKIP_SYNTHETIC_METHODS && this.SKIP_CLASSLOADERS == secondSettings.SKIP_CLASSLOADERS && this.SKIP_CONSTRUCTORS == secondSettings.SKIP_CONSTRUCTORS && this.SKIP_GETTERS == secondSettings.SKIP_GETTERS && this.COMPILE_BEFORE_HOTSWAP == secondSettings.COMPILE_BEFORE_HOTSWAP && (this.RUN_HOTSWAP_AFTER_COMPILE != null ? this.RUN_HOTSWAP_AFTER_COMPILE.equals(secondSettings.RUN_HOTSWAP_AFTER_COMPILE) : secondSettings.RUN_HOTSWAP_AFTER_COMPILE == null) && DebuggerUtilsEx.filterEquals(this.mySteppingFilters, secondSettings.mySteppingFilters);
    }

    public DebuggerSettings clone() {
        try {
            DebuggerSettings cloned = (DebuggerSettings)super.clone();
            cloned.myContentStates = new HashMap<String, ContentState>();
            for (Map.Entry<String, ContentState> entry : this.myContentStates.entrySet()) {
                cloned.myContentStates.put(entry.getKey(), entry.getValue().clone());
            }
            cloned.mySteppingFilters = new ClassFilter[this.mySteppingFilters.length];
            for (int idx = 0; idx < this.mySteppingFilters.length; ++idx) {
                cloned.mySteppingFilters[idx] = this.mySteppingFilters[idx].clone();
            }
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    public String getComponentName() {
        return "DebuggerSettings";
    }

    public ContentState getContentState(String type) {
        ContentState state = this.myContentStates.get(type);
        if (state == null) {
            state = new ContentState(type);
            this.myContentStates.put(type, state);
        }
        return state;
    }

    public RunnerLayoutSettings getLayoutSettings() {
        return RunnerLayoutSettings.getInstance();
    }

    public static class ContentState
    implements Cloneable {
        private final String myType;
        private boolean myMinimized;
        private String mySelectedTab;
        private double mySplitProportion;
        private boolean myDetached;
        private boolean myHorizontalToolbar;
        private boolean myMaximized;

        public ContentState(String type) {
            this.myType = type;
        }

        public ContentState(Element element) {
            this.myType = element.getAttributeValue("type");
            this.myMinimized = "true".equalsIgnoreCase(element.getAttributeValue("minimized"));
            this.myMaximized = "true".equalsIgnoreCase(element.getAttributeValue("maximized"));
            this.mySelectedTab = element.getAttributeValue("selected");
            String split = element.getAttributeValue("split");
            if (split != null) {
                this.mySplitProportion = Double.valueOf(split);
            }
            this.myDetached = "true".equalsIgnoreCase(element.getAttributeValue("detached"));
            this.myHorizontalToolbar = !"false".equalsIgnoreCase(element.getAttributeValue("horizontal"));
        }

        public boolean write(Element element) {
            element.setAttribute("type", this.myType);
            element.setAttribute("minimized", Boolean.valueOf(this.myMinimized).toString());
            element.setAttribute("maximized", Boolean.valueOf(this.myMaximized).toString());
            if (this.mySelectedTab != null) {
                element.setAttribute("selected", this.mySelectedTab);
            }
            element.setAttribute("split", new Double(this.mySplitProportion).toString());
            element.setAttribute("detached", Boolean.valueOf(this.myDetached).toString());
            element.setAttribute("horizontal", Boolean.valueOf(this.myHorizontalToolbar).toString());
            return true;
        }

        public String getType() {
            return this.myType;
        }

        public String getSelectedTab() {
            return this.mySelectedTab;
        }

        public boolean isMinimized() {
            return this.myMinimized;
        }

        public void setMinimized(boolean minimized) {
            this.myMinimized = minimized;
        }

        public void setMaximized(boolean maximized) {
            this.myMaximized = maximized;
        }

        public boolean isMaximized() {
            return this.myMaximized;
        }

        public void setSelectedTab(String selectedTab) {
            this.mySelectedTab = selectedTab;
        }

        public void setSplitProportion(double splitProportion) {
            this.mySplitProportion = splitProportion;
        }

        public double getSplitProportion(double defaultValue) {
            return this.mySplitProportion <= 0.0 || this.mySplitProportion >= 1.0 ? defaultValue : this.mySplitProportion;
        }

        public void setDetached(boolean detached) {
            this.myDetached = detached;
        }

        public boolean isDetached() {
            return this.myDetached;
        }

        public boolean isHorizontalToolbar() {
            return this.myHorizontalToolbar;
        }

        public void setHorizontalToolbar(boolean horizontalToolbar) {
            this.myHorizontalToolbar = horizontalToolbar;
        }

        public ContentState clone() throws CloneNotSupportedException {
            return (ContentState)super.clone();
        }
    }
}

