/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.sun.jdi.Method;
import java.util.HashMap;
import java.util.Map;

public class MethodsTracker {
    private final Map<Method, Integer> myMethodToOccurrenceMap = new HashMap<Method, Integer>();

    public MethodOccurrence getMethodOccurrence(Method method) {
        return new MethodOccurrence(method, this.assignOccurrenceIndex(method));
    }

    private int getOccurrenceCount(Method method) {
        if (method == null) {
            return 0;
        }
        Integer integer = this.myMethodToOccurrenceMap.get(method);
        return integer != null ? integer : 0;
    }

    private int assignOccurrenceIndex(Method method) {
        if (method == null) {
            return 0;
        }
        int count = this.getOccurrenceCount(method);
        this.myMethodToOccurrenceMap.put(method, count + 1);
        return count;
    }

    public final class MethodOccurrence {
        private final Method myMethod;
        private final int myIndex;

        private MethodOccurrence(Method method, int index) {
            this.myMethod = method;
            this.myIndex = index;
        }

        public Method getMethod() {
            return this.myMethod;
        }

        public int getIndex() {
            return MethodsTracker.this.getOccurrenceCount(this.myMethod) - this.myIndex;
        }

        public boolean isRecursive() {
            return MethodsTracker.this.getOccurrenceCount(this.myMethod) > 1;
        }
    }
}

