/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class PerformanceWatcher
implements ApplicationComponent {
    private Thread myThread;
    private int myLoopCounter;
    private int mySwingThreadCounter;
    private final Semaphore myShutdownSemaphore = new Semaphore(1);
    private ThreadMXBean myThreadMXBean;
    private Method myDumpAllThreadsMethod;
    private final DateFormat myDateFormat = new SimpleDateFormat("yyyyMMdd-HHmmss");
    private File myLogDir;
    private int myUnresponsiveDuration = 0;
    private File myCurHangLogDir;
    private List<StackTraceElement> myStacktraceCommonPart;
    private int UNRESPONSIVE_THRESHOLD = 5;
    private int UNRESPONSIVE_INTERVAL = 5;

    @NotNull
    public String getComponentName() {
        if ("PerformanceWatcher" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/diagnostic/PerformanceWatcher.getComponentName must not return null");
        }
        return "PerformanceWatcher";
    }

    public void initComponent() {
        String interval;
        if (PerformanceWatcher.shallNotWatch()) {
            return;
        }
        String threshold = System.getProperty("performance.watcher.threshold");
        if (threshold != null) {
            try {
                this.UNRESPONSIVE_THRESHOLD = Integer.parseInt(threshold);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((interval = System.getProperty("performance.watcher.interval")) != null) {
            try {
                this.UNRESPONSIVE_INTERVAL = Integer.parseInt(interval);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (this.UNRESPONSIVE_THRESHOLD == 0 || this.UNRESPONSIVE_INTERVAL == 0) {
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                PerformanceWatcher.deleteOldThreadDumps();
            }
        });
        this.myLogDir = new File(PathManager.getLogPath() + "/threadDumps-" + this.myDateFormat.format(new Date()) + "-" + ApplicationInfo.getInstance().getBuild().asString());
        this.myLogDir.mkdirs();
        this.myCurHangLogDir = this.myLogDir;
        this.myThreadMXBean = ManagementFactory.getThreadMXBean();
        try {
            this.myDumpAllThreadsMethod = ThreadMXBean.class.getMethod("dumpAllThreads", Boolean.TYPE, Boolean.TYPE);
        }
        catch (NoSuchMethodException e) {
            this.myDumpAllThreadsMethod = null;
        }
        try {
            this.myShutdownSemaphore.acquire();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.myThread = new Thread(new Runnable(){

            @Override
            public void run() {
                PerformanceWatcher.this.checkEDTResponsiveness();
            }
        }, "Performance watcher");
        this.myThread.setPriority(1);
        this.myThread.start();
    }

    private static void deleteOldThreadDumps() {
        Object[] dirs;
        File allLogsDir = new File(PathManager.getSystemPath(), "log");
        if (allLogsDir.isDirectory() && (dirs = allLogsDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("threadDumps-");
            }
        })) != null) {
            Arrays.sort(dirs);
            for (int i = 0; i < dirs.length - 11; ++i) {
                FileUtil.delete((File)new File(allLogsDir, (String)dirs[i]));
            }
        }
    }

    public void disposeComponent() {
        if (PerformanceWatcher.shallNotWatch()) {
            return;
        }
        this.myShutdownSemaphore.release();
        try {
            this.myThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static boolean shallNotWatch() {
        return ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment() || Boolean.getBoolean("do.not.watch.threads");
    }

    private void checkEDTResponsiveness() {
        while (true) {
            try {
                if (this.myShutdownSemaphore.tryAcquire(this.UNRESPONSIVE_INTERVAL, TimeUnit.SECONDS)) {
                }
            }
            catch (InterruptedException e) {}
            break;
            if (this.mySwingThreadCounter != this.myLoopCounter) {
                ++this.myUnresponsiveDuration;
                if (this.myUnresponsiveDuration == this.UNRESPONSIVE_THRESHOLD) {
                    this.myCurHangLogDir = new File(this.myLogDir, this.myDateFormat.format(new Date()));
                    this.myCurHangLogDir.mkdirs();
                }
                if (this.myUnresponsiveDuration >= this.UNRESPONSIVE_THRESHOLD) {
                    this.dumpThreads();
                }
            } else {
                if (this.myUnresponsiveDuration >= this.UNRESPONSIVE_THRESHOLD) {
                    this.myCurHangLogDir.renameTo(new File(this.myLogDir, this.getLogDirForHang()));
                    this.myUnresponsiveDuration = 0;
                    this.myCurHangLogDir = this.myLogDir;
                    this.myStacktraceCommonPart = null;
                }
                this.myUnresponsiveDuration = 0;
            }
            ++this.myLoopCounter;
            SwingUtilities.invokeLater(new SwingThreadRunnable(this.myLoopCounter));
        }
    }

    private String getLogDirForHang() {
        StringBuilder name = new StringBuilder(this.myCurHangLogDir.getName());
        name.append("-").append(this.myUnresponsiveDuration);
        if (this.myStacktraceCommonPart != null && !this.myStacktraceCommonPart.isEmpty()) {
            StackTraceElement element = this.myStacktraceCommonPart.get(0);
            name.append("-").append(StringUtil.getShortName((String)element.getClassName())).append(".").append(element.getMethodName());
        }
        return name.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpThreads() {
        FileOutputStream fos;
        File f = new File(this.myCurHangLogDir, "threadDump-" + this.myDateFormat.format(new Date()) + ".txt");
        try {
            fos = new FileOutputStream(f);
        }
        catch (FileNotFoundException e) {
            return;
        }
        OutputStreamWriter writer = new OutputStreamWriter(fos);
        try {
            this.dumpThreadsToFile(writer);
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException e) {}
        }
    }

    private void dumpThreadsToFile(OutputStreamWriter f) {
        boolean dumpSuccessful = false;
        if (this.myDumpAllThreadsMethod != null) {
            try {
                ThreadInfo[] threads;
                for (ThreadInfo info : threads = (ThreadInfo[])this.myDumpAllThreadsMethod.invoke((Object)this.myThreadMXBean, false, false)) {
                    if (info == null) continue;
                    this.dumpThreadInfo(info, f);
                }
                dumpSuccessful = true;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!dumpSuccessful) {
            ThreadInfo[] threadInfo;
            long[] threadIds = this.myThreadMXBean.getAllThreadIds();
            for (ThreadInfo info : threadInfo = this.myThreadMXBean.getThreadInfo(threadIds, Integer.MAX_VALUE)) {
                if (info == null) continue;
                try {
                    this.dumpThreadInfo(info, f);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void dumpThreadInfo(ThreadInfo info, OutputStreamWriter f) throws IOException {
        StackTraceElement[] stackTraceElements = info.getStackTrace();
        PerformanceWatcher.dumpCallStack(info, f, stackTraceElements);
        if (info.getThreadName().equals("AWT-EventQueue-1")) {
            if (this.myStacktraceCommonPart == null) {
                this.myStacktraceCommonPart = new ArrayList<StackTraceElement>();
                Collections.addAll(this.myStacktraceCommonPart, stackTraceElements);
            } else {
                this.updateStacktraceCommonPart(stackTraceElements);
            }
        }
    }

    private void updateStacktraceCommonPart(StackTraceElement[] stackTraceElements) {
        for (int i = 0; i < this.myStacktraceCommonPart.size() && i < stackTraceElements.length; ++i) {
            StackTraceElement el2;
            StackTraceElement el1 = this.myStacktraceCommonPart.get(this.myStacktraceCommonPart.size() - i - 1);
            if (el1.equals(el2 = stackTraceElements[stackTraceElements.length - i - 1])) continue;
            this.myStacktraceCommonPart = this.myStacktraceCommonPart.subList(this.myStacktraceCommonPart.size() - i, this.myStacktraceCommonPart.size());
            break;
        }
    }

    private static void dumpCallStack(ThreadInfo info, OutputStreamWriter f, StackTraceElement[] stackTraceElements) throws IOException {
        f.write("\"" + info.getThreadName() + "\"\n");
        for (StackTraceElement element : stackTraceElements) {
            f.write("\tat " + element.toString() + "\n");
        }
        f.write("\n");
    }

    private class SwingThreadRunnable
    implements Runnable {
        private final int myCount;

        private SwingThreadRunnable(int count) {
            this.myCount = count;
        }

        @Override
        public void run() {
            PerformanceWatcher.this.mySwingThreadCounter = this.myCount;
        }
    }
}

