/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.testframework.CompositePrintable;
import com.intellij.execution.testframework.ExternalOutput;
import com.intellij.execution.testframework.HyperLink;
import com.intellij.execution.testframework.Printable;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.PrinterMark;
import com.intellij.execution.ui.ConsoleViewContentType;

public class DeferingPrinter
extends CompositePrintable
implements Printer.Intermediate {
    private final boolean myCollectOutput;

    public DeferingPrinter(boolean collectOutput) {
        this.myCollectOutput = collectOutput;
    }

    @Override
    public void print(String text, ConsoleViewContentType contentType) {
        this.addLast(new ExternalOutput(text, contentType));
    }

    @Override
    public void onNewAvailable(Printable printable) {
        this.addLast(printable);
    }

    @Override
    public void printHyperlink(String text, HyperlinkInfo info) {
        this.addLast(new HyperLink(text, info));
    }

    @Override
    public void mark() {
        this.addLast(new PrinterMark());
    }

    @Override
    public void printOn(Printer printer) {
        super.printOn(printer);
        if (!this.myCollectOutput) {
            this.clear();
        }
    }
}

