/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.ui.statistics;

import com.intellij.execution.testframework.sm.SMTestsRunnerBundle;
import com.intellij.execution.testframework.sm.runner.ProxyFilters;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.ui.TestsPresentationUtil;
import com.intellij.execution.testframework.sm.runner.ui.statistics.BaseColumn;
import com.intellij.execution.testframework.sm.runner.ui.statistics.ColoredRenderer;
import com.intellij.ui.ColoredTableCellRenderer;
import java.util.Comparator;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NonNls;

public class ColumnResults
extends BaseColumn
implements Comparator<SMTestProxy> {
    @NonNls
    public static final String UNDEFINED = SMTestsRunnerBundle.message("sm.test.runner.ui.tabs.statistics.columns.results.undefined", new Object[0]);

    public ColumnResults() {
        super(SMTestsRunnerBundle.message("sm.test.runner.ui.tabs.statistics.columns.results.title", new Object[0]));
    }

    public Comparator<SMTestProxy> getComparator() {
        return this;
    }

    @Override
    public int compare(SMTestProxy proxy1, SMTestProxy proxy2) {
        if (proxy1.isSuite()) {
            if (proxy2.isSuite()) {
                return this.compareSuites(proxy1, proxy2);
            }
            return 1;
        }
        if (proxy2.isSuite()) {
            return -1;
        }
        return this.compareTests(proxy1, proxy2);
    }

    private int compareTests(SMTestProxy test1, SMTestProxy test2) {
        int weight1 = test1.getMagnitudeInfo().getSortWeight();
        int weight2 = test2.getMagnitudeInfo().getSortWeight();
        return this.compareInt(weight1, weight2);
    }

    private int compareSuites(SMTestProxy suite1, SMTestProxy suite2) {
        int failures2;
        int errors2;
        int errors1 = suite1.getChildren(ProxyFilters.FILTER_ERRORS).size();
        int errorsComparison = this.compareInt(errors1, errors2 = suite2.getChildren(ProxyFilters.FILTER_ERRORS).size());
        if (errorsComparison != 0) {
            return errorsComparison;
        }
        int failures1 = suite1.getChildren(ProxyFilters.FILTER_FAILURES).size();
        int failuresComparison = this.compareInt(failures1, failures2 = suite2.getChildren(ProxyFilters.FILTER_FAILURES).size());
        if (failuresComparison != 0) {
            return failuresComparison;
        }
        int passed1 = suite1.getChildren(ProxyFilters.FILTER_PASSED).size();
        int passed2 = suite2.getChildren(ProxyFilters.FILTER_PASSED).size();
        return this.compareInt(passed1, passed2);
    }

    private int compareInt(int first, int second) {
        if (first < second) {
            return -1;
        }
        if (first > second) {
            return 1;
        }
        return 0;
    }

    public String valueOf(SMTestProxy testProxy) {
        return UNDEFINED;
    }

    public TableCellRenderer getRenderer(SMTestProxy proxy) {
        return new ResultsCellRenderer(proxy);
    }

    public static class ResultsCellRenderer
    extends ColoredTableCellRenderer
    implements ColoredRenderer {
        private final SMTestProxy myProxy;

        public ResultsCellRenderer(SMTestProxy proxy) {
            this.myProxy = proxy;
        }

        @Override
        public void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
            if (this.myProxy.isSuite()) {
                TestsPresentationUtil.appendSuiteStatusColorPresentation(this.myProxy, this);
            } else {
                TestsPresentationUtil.appendTestStatusColorPresentation(this.myProxy, this);
            }
        }
    }
}

