/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration;

import com.intellij.history.FileRevisionTimestampComparator;
import com.intellij.history.Label;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.history.LocalHistoryConfiguration;
import com.intellij.history.core.LocalVcs;
import com.intellij.history.core.storage.Storage;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.LocalHistoryService;
import com.intellij.history.utils.LocalHistoryLog;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.VirtualFileManagerEx;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class LocalHistoryComponent
extends LocalHistory
implements ProjectComponent {
    private final Project myProject;
    private final StartupManagerEx myStartupManager;
    private final ProjectRootManagerEx myRootManager;
    private final VirtualFileManagerEx myFileManager;
    private final CommandProcessor myCommandProcessor;
    private final LocalHistoryConfiguration myConfiguration;
    private Storage myStorage;
    private LocalVcs myVcs;
    private LocalHistoryService myService;
    private IdeaGateway myGateway;
    private final AtomicBoolean isInitialized = new AtomicBoolean();
    private Runnable myShutdownTask;

    public static LocalHistoryComponent getComponentInstance(Project p) {
        return (LocalHistoryComponent)((Object)p.getComponent(LocalHistory.class));
    }

    public static LocalVcs getLocalVcsFor(Project p) {
        return LocalHistoryComponent.getComponentInstance(p).getLocalVcs();
    }

    public static IdeaGateway getGatewayFor(Project p) {
        return LocalHistoryComponent.getComponentInstance(p).getGateway();
    }

    public LocalHistoryComponent(Project p, StartupManager sm, ProjectRootManagerEx rm, VirtualFileManagerEx fm, CommandProcessor cp, LocalHistoryConfiguration c) {
        this.myProject = p;
        this.myStartupManager = (StartupManagerEx)sm;
        this.myRootManager = rm;
        this.myFileManager = fm;
        this.myCommandProcessor = cp;
        this.myConfiguration = c;
    }

    public void initComponent() {
        if (this.isDefaultProject()) {
            return;
        }
        this.myShutdownTask = new Runnable(){

            @Override
            public void run() {
                LocalHistoryComponent.this.disposeComponent();
            }
        };
        ShutDownTracker.getInstance().registerShutdownTask(this.myShutdownTask);
        Disposer.register((Disposable)this.myProject, (Disposable)new Disposable(){

            public void dispose() {
                LocalHistoryComponent.this.disposeComponent();
            }
        });
        this.myStartupManager.registerPreStartupActivity(new Runnable(){

            @Override
            public void run() {
                LocalHistoryComponent.this.init();
            }
        });
    }

    protected void init() {
        this.initVcs();
        this.initService();
        this.isInitialized.set(true);
    }

    protected void initVcs() {
        this.myStorage = new Storage(this.getStorageDir());
        this.myVcs = new LocalVcs(this.myStorage);
    }

    protected void initService() {
        this.myGateway = new IdeaGateway(this.myProject);
        this.myService = new LocalHistoryService(this.myVcs, this.myGateway, this.myConfiguration, this.myStartupManager, this.myRootManager, this.myFileManager, this.myCommandProcessor);
    }

    public File getStorageDir() {
        File vcsDir = new File(this.getSystemPath(), "LocalHistory");
        return new File(vcsDir, this.myProject.getLocationHash());
    }

    protected String getSystemPath() {
        return PathManager.getSystemPath();
    }

    public void save() {
        if (!this.isInitialized()) {
            return;
        }
        this.myVcs.save();
    }

    public void disposeComponent() {
        if (this.isInitialized.getAndSet(false)) {
            this.myVcs.purgeObsoleteAndSave(this.myConfiguration.PURGE_PERIOD);
            this.doCloseVcs();
            this.doCloseService();
            this.cleanupStorageAfterTestCase();
        }
        ShutDownTracker.getInstance().unregisterShutdownTask(this.myShutdownTask);
    }

    protected void cleanupStorageAfterTestCase() {
        if (this.isUnitTestMode()) {
            FileUtil.delete((File)this.getStorageDir());
        }
    }

    protected boolean isUnitTestMode() {
        return ApplicationManagerEx.getApplicationEx().isUnitTestMode();
    }

    public void doCloseVcs() {
        this.myStorage.close();
    }

    protected void doCloseService() {
        this.myService.shutdown();
    }

    protected boolean isDefaultProject() {
        return this.myProject.isDefault();
    }

    public LocalHistoryAction startAction(String name) {
        if (!this.isInitialized()) {
            return LocalHistoryAction.NULL;
        }
        return this.myService.startAction(name);
    }

    public Label putUserLabel(String name) {
        if (!this.isInitialized()) {
            return Label.NULL_INSTANCE;
        }
        this.myGateway.registerUnsavedDocuments(this.myVcs);
        return this.myVcs.putUserLabel(name);
    }

    public Label putUserLabel(VirtualFile f, String name) {
        if (!this.isInitialized()) {
            return Label.NULL_INSTANCE;
        }
        this.myGateway.registerUnsavedDocuments(this.myVcs);
        return this.myVcs.putUserLabel(f.getPath(), name);
    }

    public Label putSystemLabel(String name, int color) {
        if (!this.isInitialized()) {
            return Label.NULL_INSTANCE;
        }
        this.myGateway.registerUnsavedDocuments(this.myVcs);
        return this.myVcs.putSystemLabel(name, color);
    }

    public void registerUnsavedDocuments(VirtualFile file) {
        if (!this.isInitialized()) {
            return;
        }
        this.myGateway.registerUnsavedDocuments(this.myVcs, file);
    }

    public byte[] getByteContent(VirtualFile f, FileRevisionTimestampComparator c) {
        if (!this.isInitialized()) {
            return null;
        }
        if (!this.isUnderControl(f)) {
            return null;
        }
        return this.myVcs.getByteContent(f.getPath(), c);
    }

    public boolean isUnderControl(VirtualFile f) {
        if (!this.isInitialized()) {
            return false;
        }
        return this.myGateway.getFileFilter().isAllowedAndUnderContentRoot(f);
    }

    public boolean hasUnavailableContent(VirtualFile f) {
        if (!this.isInitialized()) {
            return false;
        }
        if (!this.isUnderControl(f)) {
            return false;
        }
        if (!f.isValid()) {
            LocalHistoryLog.LOG.warn("File is invalid: " + f);
            return false;
        }
        Entry entry = this.myVcs.findEntry(f.getPath());
        if (entry == null) {
            LocalHistoryLog.LOG.warn("Entry does not exist for " + f);
            return false;
        }
        return entry.hasUnavailableContent();
    }

    private boolean isInitialized() {
        return this.isInitialized.get();
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("Local History" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/history/integration/LocalHistoryComponent.getComponentName must not return null");
        }
        return "Local History";
    }

    public LocalVcs getLocalVcs() {
        return this.myVcs;
    }

    public IdeaGateway getGateway() {
        return this.myGateway;
    }

    public void projectOpened() {
    }

    public void projectClosed() {
    }
}

