/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.ChooseComponentsToExportDialog;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ExportableApplicationComponent;
import com.intellij.openapi.components.ExportableBean;
import com.intellij.openapi.components.ExportableComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.ZipUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.Icon;

public class ExportSettingsAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.actions.ExportSettingsAction");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(AnActionEvent e) {
        ArrayList<ExportableComponent> exportableComponents = new ArrayList<ExportableComponent>();
        Map<File, Set<ExportableComponent>> fileToComponents = ExportSettingsAction.getRegisteredComponentsAndFiles(exportableComponents);
        ChooseComponentsToExportDialog dialog = new ChooseComponentsToExportDialog(exportableComponents, fileToComponents, true, IdeBundle.message((String)"title.select.components.to.export", (Object[])new Object[0]), IdeBundle.message((String)"prompt.please.check.all.components.to.export", (Object[])new Object[0]));
        dialog.show();
        if (!dialog.isOK()) {
            return;
        }
        Set<ExportableComponent> markedComponents = dialog.getExportableComponents();
        if (markedComponents.size() == 0) {
            return;
        }
        HashSet<File> exportFiles = new HashSet<File>();
        for (ExportableComponent markedComponent : markedComponents) {
            File[] files = markedComponent.getExportFiles();
            exportFiles.addAll(Arrays.asList(files));
        }
        ApplicationManager.getApplication().saveSettings();
        try {
            int ret;
            File saveFile = dialog.getExportFile();
            if (saveFile.exists() && (ret = Messages.showOkCancelDialog((String)IdeBundle.message((String)"prompt.overwrite.settings.file", (Object[])new Object[]{FileUtil.toSystemDependentName((String)saveFile.getPath())}), (String)IdeBundle.message((String)"title.file.already.exists", (Object[])new Object[0]), (Icon)Messages.getWarningIcon())) != 0) {
                return;
            }
            JarOutputStream output = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(saveFile)));
            try {
                File configPath = new File(PathManager.getConfigPath());
                HashSet writtenItemRelativePaths = new HashSet();
                for (File file : exportFiles) {
                    String rPath = FileUtil.getRelativePath((File)configPath, (File)file);
                    assert (rPath != null);
                    String relativePath = FileUtil.toSystemIndependentName((String)rPath);
                    if (!file.exists()) continue;
                    ZipUtil.addFileOrDirRecursively((ZipOutputStream)output, (File)saveFile, (File)file, (String)relativePath, null, writtenItemRelativePaths);
                }
                File magicFile = new File(FileUtil.getTempDirectory(), "IntelliJ IDEA Global Settings");
                FileUtil.createIfDoesntExist((File)magicFile);
                magicFile.deleteOnExit();
                ZipUtil.addFileToZip((ZipOutputStream)output, (File)magicFile, (String)"IntelliJ IDEA Global Settings", writtenItemRelativePaths, null);
            }
            finally {
                output.close();
            }
            Messages.showMessageDialog((String)IdeBundle.message((String)"message.settings.exported.successfully", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.export.successful", (Object[])new Object[0]), (Icon)Messages.getInformationIcon());
        }
        catch (IOException e1) {
            Messages.showErrorDialog((String)IdeBundle.message((String)"error.writing.settings", (Object[])new Object[]{e1.toString()}), (String)IdeBundle.message((String)"title.error.writing.file", (Object[])new Object[0]));
        }
    }

    public static Map<File, Set<ExportableComponent>> getRegisteredComponentsAndFiles(List<ExportableComponent> exportableComponents) {
        ExportableBean[] exportableBeans;
        HashMap<File, Set<ExportableComponent>> fileToComponents = new HashMap<File, Set<ExportableComponent>>();
        ArrayList<Object> components = new ArrayList<Object>(Arrays.asList(ApplicationManager.getApplication().getComponents(ExportableApplicationComponent.class)));
        for (ExportableBean exportableBean : exportableBeans = (ExportableBean[])Extensions.getExtensions((ExtensionPointName)ExportableComponent.EXTENSION_POINT)) {
            String serviceClass = exportableBean.serviceInterface;
            if (serviceClass == null) {
                LOG.error("Service interface not specified in " + ExportableComponent.EXTENSION_POINT);
                continue;
            }
            try {
                Class<?> aClass = Class.forName(serviceClass, true, exportableBean.getPluginDescriptor().getPluginClassLoader());
                Object service = ServiceManager.getService(aClass);
                if (service == null) {
                    LOG.error("Can't find service: " + serviceClass);
                    continue;
                }
                if (!(service instanceof ExportableComponent)) {
                    LOG.error("Service " + serviceClass + " is registered in exportable EP, but doesn't implement ExportableComponent");
                    continue;
                }
                components.add((ExportableComponent)service);
            }
            catch (ClassNotFoundException e) {
                LOG.error((Throwable)e);
            }
        }
        for (ExportableComponent exportableComponent : components) {
            File[] exportFiles;
            exportableComponents.add(exportableComponent);
            for (File exportFile : exportFiles = exportableComponent.getExportFiles()) {
                HashSet<ExportableComponent> componentsTied = (HashSet<ExportableComponent>)fileToComponents.get(exportFile);
                if (componentsTied == null) {
                    componentsTied = new HashSet<ExportableComponent>();
                    fileToComponents.put(exportFile, componentsTied);
                }
                componentsTied.add(exportableComponent);
            }
        }
        return fileToComponents;
    }
}

