/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.InternalTemplateBean;
import com.intellij.ide.fileTemplates.impl.FileTemplateImpl;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ExportableComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.SystemProperties;
import com.intellij.util.messages.MessageBus;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class FileTemplateManagerImpl
extends FileTemplateManager
implements ExportableComponent,
JDOMExternalizable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.fileTemplates.impl.FileTemplateManagerImpl");
    @NonNls
    private static final String DEFAULT_TEMPLATE_EXTENSION = "ft";
    @NonNls
    private static final String TEMPLATES_DIR = "fileTemplates";
    @NonNls
    private static final String DEFAULT_TEMPLATES_TOP_DIR = "fileTemplates";
    @NonNls
    private static final String INTERNAL_DIR = "internal";
    @NonNls
    private static final String INCLUDES_DIR = "includes";
    @NonNls
    private static final String CODETEMPLATES_DIR = "code";
    @NonNls
    private static final String J2EE_TEMPLATES_DIR = "j2ee";
    private final String myName;
    @NonNls
    private final String myDefaultTemplatesDir;
    @NonNls
    private final String myTemplatesDir;
    private MyTemplates myTemplates;
    private final RecentTemplatesManager myRecentList;
    private volatile boolean myLoaded;
    private final FileTemplateManagerImpl myInternalTemplatesManager;
    private final FileTemplateManagerImpl myPatternsManager;
    private final FileTemplateManagerImpl myCodeTemplatesManager;
    private final FileTemplateManagerImpl myJ2eeTemplatesManager;
    private final MyDeletedTemplatesManager myDeletedTemplatesManager;
    private VirtualFile myDefaultDescription;
    private static VirtualFile[] ourTopDirs;
    private final FileTypeManagerEx myTypeManager;
    @NonNls
    private static final String ELEMENT_DELETED_TEMPLATES = "deleted_templates";
    @NonNls
    private static final String ELEMENT_DELETED_INCLUDES = "deleted_includes";
    @NonNls
    private static final String ELEMENT_RECENT_TEMPLATES = "recent_templates";
    @NonNls
    private static final String ELEMENT_TEMPLATES = "templates";
    @NonNls
    private static final String ELEMENT_INTERNAL_TEMPLATE = "internal_template";
    @NonNls
    private static final String ELEMENT_TEMPLATE = "template";
    @NonNls
    private static final String ATTRIBUTE_NAME = "name";
    @NonNls
    private static final String ATTRIBUTE_REFORMAT = "reformat";
    private final Object LOCK;
    private static final Object TOP_DIRS_LOCK;
    private final FileTemplateManagerImpl[] myChildren;

    public static FileTemplateManagerImpl getInstanceImpl() {
        return (FileTemplateManagerImpl)ServiceManager.getService(FileTemplateManager.class);
    }

    public FileTemplateManagerImpl(@NotNull FileTypeManagerEx typeManager, @NotNull MessageBus bus) {
        if (typeManager == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl.<init> must not be null");
        }
        if (bus == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl.<init> must not be null");
        }
        this("Default", ".", typeManager, new FileTemplateManagerImpl("Internal", INTERNAL_DIR, typeManager, null, null, null, null), new FileTemplateManagerImpl("Includes", INCLUDES_DIR, typeManager, null, null, null, null), new FileTemplateManagerImpl("Code", CODETEMPLATES_DIR, typeManager, null, null, null, null), new FileTemplateManagerImpl("J2EE", J2EE_TEMPLATES_DIR, typeManager, null, null, null, null));
        bus.connect().subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void before(List<? extends VFileEvent> events) {
            }

            public void after(List<? extends VFileEvent> events) {
                FileTemplateManagerImpl.refreshTopDirs();
            }
        });
    }

    private FileTemplateManagerImpl(@NotNull @NonNls String name, @NotNull @NonNls String defaultTemplatesDirName, @NotNull FileTypeManagerEx fileTypeManagerEx, FileTemplateManagerImpl internalTemplatesManager, FileTemplateManagerImpl patternsManager, FileTemplateManagerImpl codeTemplatesManager, FileTemplateManagerImpl j2eeTemplatesManager) {
        FileTemplateManagerImpl[] fileTemplateManagerImplArray;
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl.<init> must not be null");
        }
        if (defaultTemplatesDirName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl.<init> must not be null");
        }
        if (fileTypeManagerEx == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl.<init> must not be null");
        }
        this.myRecentList = new RecentTemplatesManager();
        this.myLoaded = false;
        this.myDeletedTemplatesManager = new MyDeletedTemplatesManager();
        this.LOCK = new Object();
        this.myName = name;
        this.myDefaultTemplatesDir = defaultTemplatesDirName;
        this.myTemplatesDir = "fileTemplates" + (defaultTemplatesDirName.equals(".") ? "" : File.separator + defaultTemplatesDirName);
        this.myTypeManager = fileTypeManagerEx;
        this.myInternalTemplatesManager = internalTemplatesManager;
        this.myPatternsManager = patternsManager;
        this.myCodeTemplatesManager = codeTemplatesManager;
        this.myJ2eeTemplatesManager = j2eeTemplatesManager;
        if (internalTemplatesManager == null) {
            fileTemplateManagerImplArray = new FileTemplateManagerImpl[]{};
        } else {
            FileTemplateManagerImpl[] fileTemplateManagerImplArray2 = new FileTemplateManagerImpl[4];
            fileTemplateManagerImplArray2[0] = internalTemplatesManager;
            fileTemplateManagerImplArray2[1] = patternsManager;
            fileTemplateManagerImplArray2[2] = codeTemplatesManager;
            fileTemplateManagerImplArray = fileTemplateManagerImplArray2;
            fileTemplateManagerImplArray2[3] = j2eeTemplatesManager;
        }
        this.myChildren = fileTemplateManagerImplArray;
        if (ApplicationManager.getApplication().isUnitTestMode() && defaultTemplatesDirName.equals(INTERNAL_DIR)) {
            for (String tname : Arrays.asList("Class", "AnnotationType", "Enum", "Interface")) {
                for (FileTemplate template : this.getAllTemplates()) {
                    if (!template.getName().equals(tname)) continue;
                    this.myTemplates.removeTemplate(template);
                    break;
                }
                FileTemplateImpl fileTemplate = new FileTemplateImpl(FileTemplateManagerImpl.normalizeText(this.getTestClassTemplateText(tname)), tname, "java");
                fileTemplate.setReadOnly(true);
                fileTemplate.setModified(false);
                this.myTemplates.addTemplate(fileTemplate);
                fileTemplate.setInternal(true);
            }
        }
    }

    @NotNull
    public File[] getExportFiles() {
        File[] fileArray = new File[]{this.getParentDirectory(false), PathManager.getDefaultOptionsFile()};
        if (fileArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl.getExportFiles must not return null");
        }
        return fileArray;
    }

    @NotNull
    public String getPresentableName() {
        String string = IdeBundle.message((String)"item.file.templates", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl.getPresentableName must not return null");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public FileTemplate[] getAllTemplates() {
        this.ensureTemplatesAreLoaded();
        Object object = this.LOCK;
        // MONITORENTER : object
        FileTemplate[] fileTemplateArray = this.myTemplates.getAllTemplates();
        // MONITOREXIT : object
        if (fileTemplateArray != null) return fileTemplateArray;
        throw new IllegalStateException("@NotNull method com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl.getAllTemplates must not return null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileTemplate getTemplate(@NotNull @NonNls String templateName) {
        if (templateName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl.getTemplate must not be null");
        }
        this.ensureTemplatesAreLoaded();
        Object object = this.LOCK;
        synchronized (object) {
            return this.myTemplates.findByName(templateName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public FileTemplate addTemplate(@NotNull @NonNls String name, @NotNull @NonNls String extension) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl.addTemplate must not be null");
        }
        if (extension == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl.addTemplate must not be null");
        }
        this.invalidate();
        this.ensureTemplatesAreLoaded();
        Object object = this.LOCK;
        // MONITORENTER : object
        LOG.assertTrue(name.length() > 0);
        if (this.myTemplates.findByName(name) != null) {
            LOG.error("Duplicate template " + name);
        }
        FileTemplateImpl fileTemplate = new FileTemplateImpl("", name, extension);
        this.myTemplates.addTemplate(fileTemplate);
        FileTemplateImpl fileTemplateImpl = fileTemplate;
        // MONITOREXIT : object
        if (fileTemplateImpl != null) return fileTemplateImpl;
        throw new IllegalStateException("@NotNull method com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl.addTemplate must not return null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTemplate(@NotNull FileTemplate template, boolean fromDiskOnly) {
        if (template == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl.removeTemplate must not be null");
        }
        this.ensureTemplatesAreLoaded();
        Object object = this.LOCK;
        synchronized (object) {
            this.myTemplates.removeTemplate(template);
            try {
                ((FileTemplateImpl)template).removeFromDisk();
            }
            catch (Exception e) {
                LOG.error("Unable to remove template", (Throwable)e);
            }
            if (!fromDiskOnly) {
                this.myDeletedTemplatesManager.addName(template.getName() + "." + template.getExtension() + "." + DEFAULT_TEMPLATE_EXTENSION);
            }
            this.invalidate();
        }
    }

    @Override
    public void removeInternal(@NotNull FileTemplate template) {
        if (template == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl.removeInternal must not be null");
        }
        LOG.assertTrue(this.myInternalTemplatesManager != null);
        this.myInternalTemplatesManager.removeTemplate(template, true);
    }

    @Override
    public FileTemplate addInternal(@NotNull @NonNls String name, @NotNull @NonNls String extension) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl.addInternal must not be null");
        }
        if (extension == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl.addInternal must not be null");
        }
        return this.myInternalTemplatesManager.addTemplate(name, extension);
    }

    @Override
    @NotNull
    public Properties getDefaultProperties() {
        Properties props = new Properties();
        Date date = new Date();
        props.setProperty("DATE", DateFormat.getDateInstance().format(date));
        props.setProperty("TIME", DateFormat.getTimeInstance().format(date));
        Calendar calendar = Calendar.getInstance();
        props.setProperty("YEAR", Integer.toString(calendar.get(1)));
        props.setProperty("MONTH", FileTemplateManagerImpl.getCalendarValue(calendar, 2));
        props.setProperty("DAY", FileTemplateManagerImpl.getCalendarValue(calendar, 5));
        props.setProperty("HOUR", FileTemplateManagerImpl.getCalendarValue(calendar, 11));
        props.setProperty("MINUTE", FileTemplateManagerImpl.getCalendarValue(calendar, 12));
        props.setProperty("USER", SystemProperties.getUserName());
        Properties properties = props;
        if (properties == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl.getDefaultProperties must not return null");
        }
        return properties;
    }

    private static String getCalendarValue(Calendar calendar, int field) {
        String result;
        int val = calendar.get(field);
        if (field == 2) {
            ++val;
        }
        if ((result = Integer.toString(val)).length() == 1) {
            return "0" + result;
        }
        return result;
    }

    private File getParentDirectory(boolean create) {
        boolean created;
        File configPath = new File(PathManager.getConfigPath());
        File templatesPath = new File(configPath, this.myTemplatesDir);
        if (!templatesPath.exists() && create && !(created = templatesPath.mkdirs())) {
            LOG.error("Cannot create directory: " + templatesPath.getAbsolutePath());
        }
        return templatesPath;
    }

    private void ensureTemplatesAreLoaded() {
        if (this.myLoaded) {
            return;
        }
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = FileTemplateManagerImpl.this.LOCK;
                synchronized (object) {
                    if (FileTemplateManagerImpl.this.myLoaded) {
                        return;
                    }
                    FileTemplateManagerImpl.this.loadTemplates();
                }
                FileTemplateManagerImpl.this.myLoaded = true;
            }
        });
    }

    private void loadTemplates() {
        FileTemplate[] allTemplates;
        Collection<VirtualFile> defaultTemplates = this.getDefaultTemplates();
        for (VirtualFile file : defaultTemplates) {
            if (!file.getName().equals("default.html")) continue;
            this.myDefaultDescription = file;
        }
        File templateDir = this.getParentDirectory(false);
        File[] files = templateDir.listFiles();
        if (files == null) {
            files = new File[]{};
        }
        if (this.myTemplates == null) {
            this.myTemplates = new MyTemplates();
        }
        ArrayList<FileTemplate> existingTemplates = new ArrayList<FileTemplate>();
        for (File file : files) {
            if (file.isDirectory() || FileTypeManagerEx.getInstance().isFileIgnored(file.getName())) continue;
            String name = file.getName();
            String extension = this.myTypeManager.getExtension(name);
            name = name.substring(0, name.length() - extension.length() - 1);
            if (file.isHidden() || name.length() == 0) continue;
            FileTemplate existing = this.myTemplates.findByName(name);
            if (existing == null || existing.isDefault()) {
                if (existing != null) {
                    this.myTemplates.removeTemplate(existing);
                }
                FileTemplateImpl fileTemplate = new FileTemplateImpl(file, name, extension, false);
                this.myTemplates.addTemplate(fileTemplate);
                existingTemplates.add(fileTemplate);
                continue;
            }
            LOG.assertTrue(!((FileTemplateImpl)existing).isModified());
            ((FileTemplateImpl)existing).invalidate();
            existingTemplates.add(existing);
        }
        LOG.debug("FileTemplateManagerImpl.loadTemplates() reading default templates...");
        for (VirtualFile file : defaultTemplates) {
            VirtualFile description;
            if (FileTypeManagerEx.getInstance().isFileIgnored(file.getName())) continue;
            String name = file.getName();
            String extension = this.myTypeManager.getExtension(name);
            name = name.substring(0, name.length() - extension.length() - 1);
            if (extension.equals("html")) continue;
            if (!extension.equals(DEFAULT_TEMPLATE_EXTENSION)) {
                LOG.error(file.toString() + " should have *." + DEFAULT_TEMPLATE_EXTENSION + " extension!");
            }
            extension = this.myTypeManager.getExtension(name);
            FileTemplate aTemplate = this.myTemplates.findByName(name = name.substring(0, name.length() - extension.length() - 1));
            if (aTemplate == null) {
                FileTemplateImpl fileTemplate = new FileTemplateImpl(file, name, extension);
                this.myTemplates.addTemplate(fileTemplate);
                aTemplate = fileTemplate;
            }
            if ((description = this.getDescriptionForTemplate(file)) == null) continue;
            ((FileTemplateImpl)aTemplate).setDescription(description);
        }
        for (FileTemplate template : allTemplates = this.myTemplates.getAllTemplates()) {
            FileTemplateImpl templateImpl = (FileTemplateImpl)template;
            if (templateImpl.isDefault() || existingTemplates.contains(templateImpl) || templateImpl.isNew()) continue;
            this.myTemplates.removeTemplate(templateImpl);
            templateImpl.removeFromDisk();
        }
    }

    private void saveTemplates() {
        try {
            if (this.myTemplates != null) {
                for (FileTemplate template : this.myTemplates.getAllTemplates()) {
                    FileTemplateImpl templateImpl = (FileTemplateImpl)template;
                    if (!templateImpl.isModified()) continue;
                    templateImpl.writeExternal(this.getParentDirectory(true));
                }
            }
            for (FileTemplateManagerImpl child : this.myChildren) {
                super.saveTemplates();
            }
        }
        catch (IOException e) {
            LOG.error("Unable to save templates", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public Collection<String> getRecentNames() {
        this.ensureTemplatesAreLoaded();
        Object object = this.LOCK;
        // MONITORENTER : object
        this.validateRecentNames();
        Collection<String> collection = this.myRecentList.getRecentNames(25);
        // MONITOREXIT : object
        if (collection != null) return collection;
        throw new IllegalStateException("@NotNull method com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl.getRecentNames must not return null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRecentName(@NotNull @NonNls String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl.addRecentName must not be null");
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.myRecentList.addName(name);
        }
    }

    public void readExternal(Element element) throws InvalidDataException {
        Element templatesElement;
        Element recentElement;
        Element deletedIncludesElement;
        Element deletedTemplatesElement = element.getChild(ELEMENT_DELETED_TEMPLATES);
        if (deletedTemplatesElement != null) {
            this.myDeletedTemplatesManager.readExternal(deletedTemplatesElement);
        }
        if ((deletedIncludesElement = element.getChild(ELEMENT_DELETED_INCLUDES)) != null) {
            this.myPatternsManager.myDeletedTemplatesManager.readExternal(deletedIncludesElement);
        }
        if ((recentElement = element.getChild(ELEMENT_RECENT_TEMPLATES)) != null) {
            this.myRecentList.readExternal(recentElement);
        }
        if ((templatesElement = element.getChild(ELEMENT_TEMPLATES)) != null) {
            this.invalidate();
            FileTemplate[] internals = this.getInternalTemplates();
            List children = templatesElement.getChildren();
            for (Object aChildren : children) {
                FileTemplate template;
                Element child = (Element)aChildren;
                String name = child.getAttributeValue(ATTRIBUTE_NAME);
                boolean reformat = Boolean.TRUE.toString().equals(child.getAttributeValue(ATTRIBUTE_REFORMAT));
                if (child.getName().equals(ELEMENT_INTERNAL_TEMPLATE)) {
                    for (FileTemplate internal : internals) {
                        if (!name.equals(internal.getName())) continue;
                        internal.setAdjust(reformat);
                    }
                    continue;
                }
                if (!child.getName().equals(ELEMENT_TEMPLATE) || (template = this.getTemplate(name)) == null) continue;
                template.setAdjust(reformat);
            }
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        FileTemplate[] allTemplates;
        FileTemplate[] internals;
        this.saveTemplates();
        this.validateRecentNames();
        Element deletedTemplatesElement = new Element(ELEMENT_DELETED_TEMPLATES);
        element.addContent(deletedTemplatesElement);
        this.myDeletedTemplatesManager.writeExternal(deletedTemplatesElement);
        Element deletedIncludesElement = new Element(ELEMENT_DELETED_INCLUDES);
        element.addContent(deletedIncludesElement);
        this.myPatternsManager.myDeletedTemplatesManager.writeExternal(deletedIncludesElement);
        Element recentElement = new Element(ELEMENT_RECENT_TEMPLATES);
        element.addContent(recentElement);
        this.myRecentList.writeExternal(recentElement);
        Element templatesElement = new Element(ELEMENT_TEMPLATES);
        element.addContent(templatesElement);
        this.invalidate();
        for (FileTemplate internal : internals = this.getInternalTemplates()) {
            templatesElement.addContent(FileTemplateManagerImpl.createElement(internal, true));
        }
        for (FileTemplate fileTemplate : allTemplates = this.getAllTemplates()) {
            templatesElement.addContent(FileTemplateManagerImpl.createElement(fileTemplate, false));
        }
    }

    private static Element createElement(FileTemplate template, boolean isInternal) {
        Element templateElement = new Element(isInternal ? ELEMENT_INTERNAL_TEMPLATE : ELEMENT_TEMPLATE);
        templateElement.setAttribute(ATTRIBUTE_NAME, template.getName());
        templateElement.setAttribute(ATTRIBUTE_REFORMAT, Boolean.toString(template.isAdjust()));
        return templateElement;
    }

    private void validateRecentNames() {
        if (this.myTemplates != null) {
            FileTemplate[] allTemplates;
            ArrayList<String> allNames = new ArrayList<String>(this.myTemplates.size());
            for (FileTemplate fileTemplate : allTemplates = this.myTemplates.getAllTemplates()) {
                allNames.add(fileTemplate.getName());
            }
            this.myRecentList.validateNames(allNames);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidate() {
        Object object = this.LOCK;
        synchronized (object) {
            this.saveAll();
            this.myLoaded = false;
            if (this.myTemplates != null) {
                FileTemplate[] allTemplates;
                for (FileTemplate template : allTemplates = this.myTemplates.getAllTemplates()) {
                    ((FileTemplateImpl)template).invalidate();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveAll() {
        Object object = this.LOCK;
        synchronized (object) {
            this.saveTemplates();
        }
    }

    @Override
    @NotNull
    public FileTemplate[] getInternalTemplates() {
        InternalTemplateBean[] internalTemplateBeans = (InternalTemplateBean[])Extensions.getExtensions(InternalTemplateBean.EP_NAME);
        FileTemplate[] result = new FileTemplate[internalTemplateBeans.length];
        for (int i = 0; i < internalTemplateBeans.length; ++i) {
            result[i] = this.getInternalTemplate(internalTemplateBeans[i].name);
        }
        if (result == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl.getInternalTemplates must not return null");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileTemplate getInternalTemplate(@NotNull @NonNls String templateName) {
        if (templateName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl.getInternalTemplate must not be null");
        }
        Object object = this.LOCK;
        synchronized (object) {
            LOG.assertTrue(this.myInternalTemplatesManager != null);
            FileTemplateImpl template = (FileTemplateImpl)this.myInternalTemplatesManager.getTemplate(templateName);
            if (template == null) {
                template = (FileTemplateImpl)this.getTemplate(templateName);
            }
            if (template == null) {
                template = (FileTemplateImpl)this.getJ2eeTemplate(templateName);
                if (template != null) {
                    template.setAdjust(true);
                } else {
                    String text = FileTemplateManagerImpl.normalizeText(this.getDefaultClassTemplateText(templateName));
                    template = (FileTemplateImpl)this.myInternalTemplatesManager.addTemplate(templateName, "java");
                    template.setText(text);
                }
            }
            template.setInternal(true);
            return template;
        }
    }

    private static String normalizeText(String text) {
        text = StringUtil.convertLineSeparators((String)text);
        text = StringUtil.replace((String)text, (String)"$NAME$", (String)"${NAME}");
        text = StringUtil.replace((String)text, (String)"$PACKAGE_NAME$", (String)"${PACKAGE_NAME}");
        text = StringUtil.replace((String)text, (String)"$DATE$", (String)"${DATE}");
        text = StringUtil.replace((String)text, (String)"$TIME$", (String)"${TIME}");
        text = StringUtil.replace((String)text, (String)"$USER$", (String)"${USER}");
        return text;
    }

    @NonNls
    private String getTestClassTemplateText(@NotNull @NonNls String templateName) {
        if (templateName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl.getTestClassTemplateText must not be null");
        }
        return "package $PACKAGE_NAME$;\npublic " + this.internalTemplateToSubject(templateName) + " $NAME$ { }";
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String internalTemplateToSubject(@NotNull @NonNls String templateName) {
        String string;
        if (templateName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl.internalTemplateToSubject must not be null");
        }
        for (InternalTemplateBean bean : (InternalTemplateBean[])Extensions.getExtensions(InternalTemplateBean.EP_NAME)) {
            if (!bean.name.equals(templateName) || bean.subject == null) continue;
            string = bean.subject;
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl.internalTemplateToSubject must not return null");
            return string;
        }
        string = templateName.toLowerCase();
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl.internalTemplateToSubject must not return null");
    }

    @Override
    @NotNull
    public String localizeInternalTemplateName(@NotNull FileTemplate template) {
        if (template == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl.localizeInternalTemplateName must not be null");
        }
        String string = template.getName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl.localizeInternalTemplateName must not return null");
        }
        return string;
    }

    @NonNls
    private String getDefaultClassTemplateText(@NotNull @NonNls String templateName) {
        if (templateName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl.getDefaultClassTemplateText must not be null");
        }
        return IdeBundle.message((String)"template.default.class.comment", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()}) + "package $PACKAGE_NAME$;\n" + "public " + this.internalTemplateToSubject(templateName) + " $NAME$ { }";
    }

    @Override
    public FileTemplate getCodeTemplate(@NotNull @NonNls String templateName) {
        if (templateName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl.getCodeTemplate must not be null");
        }
        return FileTemplateManagerImpl.getTemplateFromManager(templateName, this.myCodeTemplatesManager);
    }

    @Override
    public FileTemplate getJ2eeTemplate(@NotNull @NonNls String templateName) {
        if (templateName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl.getJ2eeTemplate must not be null");
        }
        return FileTemplateManagerImpl.getTemplateFromManager(templateName, this.myJ2eeTemplatesManager);
    }

    private static FileTemplate getTemplateFromManager(@NotNull @NonNls String templateName, @NotNull FileTemplateManagerImpl templatesManager) {
        FileTemplate template;
        if (templateName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl.getTemplateFromManager must not be null");
        }
        if (templatesManager == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl.getTemplateFromManager must not be null");
        }
        String name = templateName;
        String extension = templatesManager.myTypeManager.getExtension(name);
        if (extension.length() > 0) {
            name = name.substring(0, name.length() - extension.length() - 1);
        }
        if ((template = templatesManager.getTemplate(name)) != null) {
            if (extension.equals(template.getExtension())) {
                return template;
            }
        } else {
            if (ApplicationManager.getApplication().isUnitTestMode() && templateName.endsWith("ForTest")) {
                return null;
            }
            String message = templatesManager.templateNotFoundMessage(templateName);
            LOG.error(message);
        }
        return null;
    }

    private String templateNotFoundMessage(String templateName) {
        Collection<VirtualFile> defaultTemplates = this.getDefaultTemplates();
        String message = "Unable to find template '" + templateName + "' in " + this + "\n   Default templates are: " + FileTemplateManagerImpl.toString(defaultTemplates);
        message = message + "\n   Default template dir: '" + this.myDefaultTemplatesDir + "'";
        for (VirtualFile topDir : FileTemplateManagerImpl.getTopTemplatesDir()) {
            VirtualFile parentDir = this.myDefaultTemplatesDir.equals(".") ? topDir : topDir.findChild(this.myDefaultTemplatesDir);
            message = parentDir == null ? message + "\n   No templates in '" + topDir.getPath() + "'" : message + "\n   " + parentDir.getPath() + ": " + FileTemplateManagerImpl.toString(FileTemplateManagerImpl.listDir(parentDir));
        }
        message = message + "\n   Deleted templates: " + this.myDeletedTemplatesManager.DELETED_DEFAULT_TEMPLATES;
        return message;
    }

    private static String toString(Collection<VirtualFile> defaultTemplates) {
        return StringUtil.join(defaultTemplates, (Function)new Function<VirtualFile, String>(){

            public String fun(VirtualFile virtualFile) {
                return virtualFile.getPresentableUrl();
            }
        }, (String)", ");
    }

    private VirtualFile getDescriptionForTemplate(VirtualFile vfile) {
        if (vfile != null) {
            VirtualFile parent = vfile.getParent();
            assert (parent != null);
            String name = vfile.getName();
            String extension = this.myTypeManager.getExtension(name);
            if (extension.equals(DEFAULT_TEMPLATE_EXTENSION)) {
                Locale locale;
                String descName = MessageFormat.format("{0}_{1}_{2}.html", name = name.substring(0, name.length() - extension.length() - 1), (locale = Locale.getDefault()).getLanguage(), locale.getCountry());
                VirtualFile descFile = parent.findChild(descName);
                if (descFile != null && descFile.isValid()) {
                    return descFile;
                }
                descName = MessageFormat.format("{0}_{1}.html", name, locale.getLanguage());
                descFile = parent.findChild(descName);
                if (descFile != null && descFile.isValid()) {
                    return descFile;
                }
                descFile = parent.findChild(name + ".html");
                if (descFile != null && descFile.isValid()) {
                    return descFile;
                }
            }
        }
        return null;
    }

    private static List<VirtualFile> listDir(VirtualFile vfile) {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        if (vfile != null && vfile.isDirectory()) {
            VirtualFile[] children;
            for (VirtualFile child : children = vfile.getChildren()) {
                if (child.isDirectory()) continue;
                result.add(child);
            }
        }
        return result;
    }

    private void removeDeletedTemplates(Set<VirtualFile> files) {
        Iterator<VirtualFile> iterator = files.iterator();
        while (iterator.hasNext()) {
            VirtualFile file = iterator.next();
            String nameWithExtension = file.getName();
            if (!this.myDeletedTemplatesManager.contains(nameWithExtension)) continue;
            iterator.remove();
        }
    }

    private static VirtualFile getDefaultFromManager(@NotNull @NonNls String name, @NotNull @NonNls String extension, @NotNull FileTemplateManagerImpl manager) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl.getDefaultFromManager must not be null");
        }
        if (extension == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl.getDefaultFromManager must not be null");
        }
        if (manager == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl.getDefaultFromManager must not be null");
        }
        Collection<VirtualFile> files = manager.getDefaultTemplates();
        for (VirtualFile file : files) {
            String fullName;
            if (!DEFAULT_TEMPLATE_EXTENSION.equals(file.getExtension()) || !(fullName = file.getNameWithoutExtension()).equals(name + "." + extension)) continue;
            return file;
        }
        return null;
    }

    public VirtualFile getDefaultTemplate(@NotNull @NonNls String name, @NotNull @NonNls String extension) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl.getDefaultTemplate must not be null");
        }
        if (extension == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl.getDefaultTemplate must not be null");
        }
        VirtualFile result = FileTemplateManagerImpl.getDefaultFromManager(name, extension, this);
        if (result != null) {
            return result;
        }
        for (FileTemplateManagerImpl child : this.myChildren) {
            result = FileTemplateManagerImpl.getDefaultFromManager(name, extension, child);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public FileTemplate getDefaultTemplate(@NotNull @NonNls String name) {
        FileTemplateImpl fileTemplateImpl;
        VirtualFile file;
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl.getDefaultTemplate must not be null");
        }
        String extension = this.myTypeManager.getExtension(name);
        String nameWithoutExtension = StringUtil.trimEnd((String)name, (String)("." + extension));
        if (extension.length() == 0) {
            extension = "java";
        }
        if ((file = this.getDefaultTemplate(nameWithoutExtension, extension)) == null) {
            String message = "";
            for (FileTemplateManagerImpl child : (FileTemplateManagerImpl[])ArrayUtil.append((Object[])this.myChildren, (Object)this)) {
                message = message + child.templateNotFoundMessage(name) + "\n";
            }
            LOG.error(message);
            fileTemplateImpl = null;
            throw new IllegalStateException("@NotNull method com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl.getDefaultTemplate must not return null");
        } else {
            fileTemplateImpl = new FileTemplateImpl(file, nameWithoutExtension, extension);
            if (fileTemplateImpl == null) throw new IllegalStateException("@NotNull method com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl.getDefaultTemplate must not return null");
            return fileTemplateImpl;
        }
    }

    @NotNull
    private Collection<VirtualFile> getDefaultTemplates() {
        LOG.assertTrue(!StringUtil.isEmpty((String)this.myDefaultTemplatesDir), (Object)this.myDefaultTemplatesDir);
        VirtualFile[] topDirs = FileTemplateManagerImpl.getTopTemplatesDir();
        if (LOG.isDebugEnabled()) {
            String message = "Top dirs found: ";
            for (int i = 0; i < topDirs.length; ++i) {
                VirtualFile topDir = topDirs[i];
                message = message + (i > 0 ? ", " : "") + topDir.getPresentableUrl();
            }
            LOG.debug(message);
        }
        THashSet templatesList = new THashSet();
        for (VirtualFile topDir : topDirs) {
            VirtualFile parentDir;
            VirtualFile virtualFile = parentDir = this.myDefaultTemplatesDir.equals(".") ? topDir : topDir.findChild(this.myDefaultTemplatesDir);
            if (parentDir == null) continue;
            templatesList.addAll(FileTemplateManagerImpl.listDir(parentDir));
        }
        this.removeDeletedTemplates((Set<VirtualFile>)templatesList);
        THashSet tHashSet = templatesList;
        if (tHashSet == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl.getDefaultTemplates must not return null");
        }
        return tHashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void refreshTopDirs() {
        Object object = TOP_DIRS_LOCK;
        synchronized (object) {
            if (ourTopDirs != null) {
                for (VirtualFile dir : ourTopDirs) {
                    if (dir.exists()) continue;
                    ourTopDirs = null;
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private static VirtualFile[] getTopTemplatesDir() {
        VirtualFile[] virtualFileArray;
        Object object = TOP_DIRS_LOCK;
        synchronized (object) {
            IdeaPluginDescriptor[] plugins;
            if (ourTopDirs != null) {
                // MONITOREXIT @DISABLED, blocks:[2, 9] lbl4 : MonitorExitStatement: MONITOREXIT : var0
                virtualFileArray = ourTopDirs;
                if (ourTopDirs == null) throw new IllegalStateException("@NotNull method com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl.getTopTemplatesDir must not return null");
                return virtualFileArray;
            }
            THashSet dirList = new THashSet();
            FileTemplateManagerImpl.appendDefaultTemplatesDirFromClassloader(FileTemplateManagerImpl.class.getClassLoader(), (Set<VirtualFile>)dirList);
            for (IdeaPluginDescriptor ideaPluginDescriptor : plugins = ApplicationManager.getApplication().getPlugins()) {
                if (!(ideaPluginDescriptor instanceof IdeaPluginDescriptorImpl) || !((IdeaPluginDescriptorImpl)ideaPluginDescriptor).isEnabled()) continue;
                FileTemplateManagerImpl.appendDefaultTemplatesDirFromClassloader(ideaPluginDescriptor.getPluginClassLoader(), (Set<VirtualFile>)dirList);
            }
            ourTopDirs = VfsUtil.toVirtualFileArray((Collection)dirList);
            for (IdeaPluginDescriptor ideaPluginDescriptor : ourTopDirs) {
                ideaPluginDescriptor.refresh(true, true);
            }
        }
        virtualFileArray = ourTopDirs;
        if (ourTopDirs != null) return virtualFileArray;
        throw new IllegalStateException("@NotNull method com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl.getTopTemplatesDir must not return null");
    }

    private static void appendDefaultTemplatesDirFromClassloader(ClassLoader classLoader, Set<VirtualFile> dirList) {
        try {
            Enumeration<URL> systemResources = classLoader.getResources("fileTemplates");
            if (systemResources != null && systemResources.hasMoreElements()) {
                HashSet<URL> urls = new HashSet<URL>();
                while (systemResources.hasMoreElements()) {
                    URL nextURL = systemResources.nextElement();
                    if (urls.contains(nextURL)) continue;
                    urls.add(nextURL);
                    String vfUrl = VfsUtil.convertFromUrl((URL)nextURL);
                    VirtualFile dir = VirtualFileManager.getInstance().refreshAndFindFileByUrl(vfUrl);
                    if (dir == null) {
                        LOG.error("Cannot find file by URL: " + nextURL);
                        continue;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Top directory: " + dir.getPresentableUrl());
                    }
                    dirList.add(dir);
                }
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    @Override
    @NotNull
    public FileTemplate[] getAllPatterns() {
        FileTemplate[] fileTemplateArray = this.myPatternsManager.getAllTemplates();
        if (fileTemplateArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl.getAllPatterns must not return null");
        }
        return fileTemplateArray;
    }

    @Override
    public FileTemplate getPattern(@NotNull @NonNls String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl.getPattern must not be null");
        }
        return this.myPatternsManager.getTemplate(name);
    }

    @Override
    public FileTemplate addPattern(@NotNull @NonNls String name, @NotNull @NonNls String extension) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl.addPattern must not be null");
        }
        if (extension == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl.addPattern must not be null");
        }
        LOG.assertTrue(this.myPatternsManager != null);
        return this.myPatternsManager.addTemplate(name, extension);
    }

    @Override
    public void removePattern(@NotNull FileTemplate template, boolean fromDiskOnly) {
        if (template == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl.removePattern must not be null");
        }
        LOG.assertTrue(this.myPatternsManager != null);
        this.myPatternsManager.removeTemplate(template, fromDiskOnly);
    }

    @Override
    @NotNull
    public FileTemplate[] getAllCodeTemplates() {
        LOG.assertTrue(this.myCodeTemplatesManager != null);
        FileTemplate[] fileTemplateArray = this.myCodeTemplatesManager.getAllTemplates();
        if (fileTemplateArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl.getAllCodeTemplates must not return null");
        }
        return fileTemplateArray;
    }

    @Override
    @NotNull
    public FileTemplate[] getAllJ2eeTemplates() {
        LOG.assertTrue(this.myJ2eeTemplatesManager != null);
        FileTemplate[] fileTemplateArray = this.myJ2eeTemplatesManager.getAllTemplates();
        if (fileTemplateArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl.getAllJ2eeTemplates must not return null");
        }
        return fileTemplateArray;
    }

    @Override
    @NotNull
    public FileTemplate addCodeTemplate(@NotNull @NonNls String name, @NotNull @NonNls String extension) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl.addCodeTemplate must not be null");
        }
        if (extension == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl.addCodeTemplate must not be null");
        }
        LOG.assertTrue(this.myCodeTemplatesManager != null);
        FileTemplate fileTemplate = this.myCodeTemplatesManager.addTemplate(name, extension);
        if (fileTemplate == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl.addCodeTemplate must not return null");
        }
        return fileTemplate;
    }

    @Override
    @NotNull
    public FileTemplate addJ2eeTemplate(@NotNull @NonNls String name, @NotNull @NonNls String extension) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl.addJ2eeTemplate must not be null");
        }
        if (extension == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl.addJ2eeTemplate must not be null");
        }
        LOG.assertTrue(this.myJ2eeTemplatesManager != null);
        FileTemplate fileTemplate = this.myJ2eeTemplatesManager.addTemplate(name, extension);
        if (fileTemplate == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl.addJ2eeTemplate must not return null");
        }
        return fileTemplate;
    }

    @Override
    public void removeCodeTemplate(@NotNull FileTemplate template, boolean fromDiskOnly) {
        if (template == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl.removeCodeTemplate must not be null");
        }
        LOG.assertTrue(this.myCodeTemplatesManager != null);
        this.myCodeTemplatesManager.removeTemplate(template, fromDiskOnly);
    }

    @Override
    public void removeJ2eeTemplate(@NotNull FileTemplate template, boolean fromDiskOnly) {
        if (template == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl.removeJ2eeTemplate must not be null");
        }
        LOG.assertTrue(this.myJ2eeTemplatesManager != null);
        this.myJ2eeTemplatesManager.removeTemplate(template, fromDiskOnly);
    }

    public VirtualFile getDefaultTemplateDescription() {
        return this.myDefaultDescription;
    }

    public VirtualFile getDefaultIncludeDescription() {
        return this.myPatternsManager.myDefaultDescription;
    }

    @NonNls
    public String toString() {
        return this.myName + " file template manager";
    }

    static {
        TOP_DIRS_LOCK = new Object();
    }

    private static class RecentTemplatesManager
    implements JDOMExternalizable {
        public JDOMExternalizableStringList RECENT_TEMPLATES = new JDOMExternalizableStringList();

        private RecentTemplatesManager() {
        }

        public void addName(@NotNull @NonNls String name) {
            if (name == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl$RecentTemplatesManager.addName must not be null");
            }
            this.RECENT_TEMPLATES.remove((Object)name);
            this.RECENT_TEMPLATES.add((Object)name);
        }

        @NotNull
        public Collection<String> getRecentNames(int max) {
            int size = this.RECENT_TEMPLATES.size();
            int resultSize = Math.min(max, size);
            List list = this.RECENT_TEMPLATES.subList(size - resultSize, size);
            if (list == null) {
                throw new IllegalStateException("@NotNull method com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl$RecentTemplatesManager.getRecentNames must not return null");
            }
            return list;
        }

        public void validateNames(List<String> validNames) {
            this.RECENT_TEMPLATES.retainAll(validNames);
        }

        public void readExternal(Element element) throws InvalidDataException {
            DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        }

        public void writeExternal(Element element) throws WriteExternalException {
            DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
        }
    }

    private static class MyDeletedTemplatesManager
    implements JDOMExternalizable {
        public JDOMExternalizableStringList DELETED_DEFAULT_TEMPLATES = new JDOMExternalizableStringList();

        private MyDeletedTemplatesManager() {
        }

        public void addName(@NotNull @NonNls String nameWithExtension) {
            if (nameWithExtension == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl$MyDeletedTemplatesManager.addName must not be null");
            }
            this.DELETED_DEFAULT_TEMPLATES.remove((Object)nameWithExtension);
            this.DELETED_DEFAULT_TEMPLATES.add((Object)nameWithExtension);
        }

        public boolean contains(@NotNull @NonNls String nameWithExtension) {
            if (nameWithExtension == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl$MyDeletedTemplatesManager.contains must not be null");
            }
            return this.DELETED_DEFAULT_TEMPLATES.contains((Object)nameWithExtension);
        }

        public void readExternal(Element element) throws InvalidDataException {
            DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        }

        public void writeExternal(Element element) throws WriteExternalException {
            DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
        }
    }

    private static class MyTemplates {
        private final List<FileTemplate> myTemplatesList = new ArrayList<FileTemplate>();

        private MyTemplates() {
        }

        public int size() {
            return this.myTemplatesList.size();
        }

        public void removeTemplate(FileTemplate template) {
            this.myTemplatesList.remove(template);
        }

        @NotNull
        public FileTemplate[] getAllTemplates() {
            FileTemplate[] fileTemplateArray = this.myTemplatesList.toArray(new FileTemplate[this.myTemplatesList.size()]);
            if (fileTemplateArray == null) {
                throw new IllegalStateException("@NotNull method com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl$MyTemplates.getAllTemplates must not return null");
            }
            return fileTemplateArray;
        }

        public FileTemplate findByName(@NotNull @NonNls String name) {
            if (name == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl$MyTemplates.findByName must not be null");
            }
            for (FileTemplate template : this.myTemplatesList) {
                if (!template.getName().equals(name)) continue;
                return template;
            }
            return null;
        }

        public void addTemplate(@NotNull FileTemplate newTemplate) {
            if (newTemplate == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl$MyTemplates.addTemplate must not be null");
            }
            String newName = newTemplate.getName();
            for (FileTemplate template : this.myTemplatesList) {
                if (template == newTemplate) {
                    return;
                }
                if (template.getName().compareToIgnoreCase(newName) <= 0) continue;
                this.myTemplatesList.add(this.myTemplatesList.indexOf(template), newTemplate);
                return;
            }
            this.myTemplatesList.add(newTemplate);
        }
    }
}

