/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.DiffToolbar;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class DiffToolbarImpl
implements DiffToolbar {
    private final DefaultActionGroup myActionGroup = new DefaultActionGroup();
    private ActionToolbar myActionToolbar;

    public void registerKeyboardActions(JComponent registerActionsTo) {
        AnAction[] actions;
        for (AnAction action : actions = this.getAllActions()) {
            action.registerCustomShortcutSet(action.getShortcutSet(), registerActionsTo);
        }
    }

    public AnAction[] getAllActions() {
        return this.myActionGroup.getChildren(null);
    }

    public boolean removeActionById(String actionId) {
        AnAction[] allActions;
        for (AnAction action : allActions = this.getAllActions()) {
            if (!actionId.equals(ActionManager.getInstance().getId(action))) continue;
            this.removeAction(action);
            return true;
        }
        return false;
    }

    public void removeAction(AnAction action) {
        this.myActionGroup.remove(action);
        this.updateToolbar();
    }

    public JComponent getComponent() {
        if (this.myActionToolbar == null) {
            this.myActionToolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)this.myActionGroup, true);
        }
        return this.myActionToolbar.getComponent();
    }

    public void addAction(@NotNull AnAction action) {
        if (action == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/diff/impl/DiffToolbarImpl.addAction must not be null");
        }
        this.myActionGroup.add(action);
        this.updateToolbar();
    }

    private void updateToolbar() {
        if (this.myActionToolbar != null) {
            this.myActionToolbar.updateActionsImmediately();
        }
    }

    public void addSeparator() {
        this.myActionGroup.addSeparator();
        this.updateToolbar();
    }

    public void reset(DiffRequest.ToolbarAddons toolBar) {
        this.myActionGroup.removeAll();
        toolBar.customize((DiffToolbar)this);
    }
}

