/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.incrementalMerge.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JComponent;

public class EditorPlace
extends JComponent
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.impl.incrementalMerge.ui.EditorPlace");
    private final ComponentState myState;
    private final ArrayList<EditorListener> myListeners = new ArrayList();
    private Editor myEditor = null;

    public EditorPlace(ComponentState state) {
        this.myState = state;
        this.setLayout(new BorderLayout());
    }

    @Override
    public void addNotify() {
        if (this.myEditor != null) {
            super.addNotify();
            return;
        }
        this.createEditor();
        super.addNotify();
        this.revalidate();
    }

    private void createEditor() {
        LOG.assertTrue(this.myEditor == null);
        this.myEditor = this.myState.createEditor();
        if (this.myEditor == null) {
            return;
        }
        this.add((Component)this.myEditor.getComponent(), "Center");
        this.fireEditorCreated();
    }

    public void addListener(EditorListener listener) {
        this.myListeners.add(listener);
    }

    private void fireEditorCreated() {
        EditorListener[] listeners;
        for (EditorListener listener : listeners = this.getListeners()) {
            listener.onEditorCreated(this);
        }
    }

    private void fireEditorReleased(Editor releasedEditor) {
        EditorListener[] listeners;
        for (EditorListener listener : listeners = this.getListeners()) {
            listener.onEditorReleased(releasedEditor);
        }
    }

    private EditorListener[] getListeners() {
        EditorListener[] listeners = new EditorListener[this.myListeners.size()];
        this.myListeners.toArray(listeners);
        return listeners;
    }

    @Override
    public void removeNotify() {
        this.removeEditor();
        super.removeNotify();
    }

    private void removeEditor() {
        if (this.myEditor != null) {
            Editor releasedEditor = this.myEditor;
            this.remove(this.myEditor.getComponent());
            EditorPlace.getEditorFactory().releaseEditor(this.myEditor);
            this.myEditor = null;
            this.fireEditorReleased(releasedEditor);
        }
    }

    public Editor getEditor() {
        return this.myEditor;
    }

    public void setDocument(Document document) {
        if (document == this.getDocument()) {
            return;
        }
        this.removeEditor();
        this.myState.setDocument(document);
        this.createEditor();
    }

    private Document getDocument() {
        return this.myState.getDocument();
    }

    public ComponentState getState() {
        return this.myState;
    }

    private static EditorFactory getEditorFactory() {
        return EditorFactory.getInstance();
    }

    public JComponent getContentComponent() {
        return this.myEditor == null ? null : this.myEditor.getContentComponent();
    }

    public void dispose() {
        this.removeEditor();
    }

    public static abstract class ViewProperty<T> {
        private final T myDefault;

        protected ViewProperty(T aDefault) {
            this.myDefault = aDefault;
        }

        public void updateEditor(Editor editor, T value, ComponentState state) {
            if (editor == null) {
                return;
            }
            if (value == null) {
                value = this.myDefault;
            }
            EditorEx editorEx = (EditorEx)editor;
            this.doUpdateEditor(editorEx, value, state);
        }

        protected abstract void doUpdateEditor(EditorEx var1, T var2, ComponentState var3);
    }

    public static interface EditorListener {
        public void onEditorCreated(EditorPlace var1);

        public void onEditorReleased(Editor var1);
    }

    public static abstract class ComponentState {
        private Document myDocument;

        public abstract Editor createEditor();

        public void setDocument(Document document) {
            this.myDocument = document;
        }

        public Document getDocument() {
            return this.myDocument;
        }

        public abstract <T> void updateValue(Editor var1, ViewProperty<T> var2, T var3);
    }
}

