/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.ui.TypingTarget;
import com.intellij.openapi.util.ActionCallback;
import java.awt.AlphaComposite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.InputMethodEvent;
import java.awt.im.InputMethodRequests;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.Scrollable;

public class EditorComponentImpl
extends JComponent
implements Scrollable,
DataProvider,
Queryable,
TypingTarget {
    private final EditorImpl myEditor;

    public EditorComponentImpl(EditorImpl editor) {
        this.myEditor = editor;
        this.enableEvents(2056L);
        this.enableInputMethods(true);
        this.setFocusCycleRoot(true);
        this.setOpaque(true);
    }

    public EditorImpl getEditor() {
        return this.myEditor;
    }

    public Object getData(String dataId) {
        if (this.myEditor.isRendererMode()) {
            return null;
        }
        if (PlatformDataKeys.EDITOR.is(dataId)) {
            return this.myEditor.getVirtualFile() == null ? this.myEditor : null;
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            return this.myEditor.getDeleteProvider();
        }
        if (PlatformDataKeys.CUT_PROVIDER.is(dataId)) {
            return this.myEditor.getCutProvider();
        }
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return this.myEditor.getCopyProvider();
        }
        if (PlatformDataKeys.PASTE_PROVIDER.is(dataId)) {
            return this.myEditor.getPasteProvider();
        }
        return null;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.myEditor.getPreferredSize();
    }

    protected void fireResized() {
        this.processComponentEvent(new ComponentEvent(this, 101));
    }

    @Override
    protected void processInputMethodEvent(InputMethodEvent e) {
        super.processInputMethodEvent(e);
        if (!e.isConsumed()) {
            switch (e.getID()) {
                case 1100: {
                    this.myEditor.replaceInputMethodText(e);
                }
                case 1101: {
                    this.myEditor.inputMethodCaretPositionChanged(e);
                }
            }
            e.consume();
        }
    }

    public ActionCallback type(String text) {
        return this.myEditor.type(text);
    }

    @Override
    public InputMethodRequests getInputMethodRequests() {
        return this.myEditor.getInputMethodRequests();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics g) {
        ((ApplicationImpl)ApplicationManager.getApplication()).editorPaintStart();
        try {
            ((Graphics2D)g).setComposite(AlphaComposite.Src);
            UISettings.setupAntialiasing((Graphics)g);
            this.myEditor.paint(g);
        }
        finally {
            ((ApplicationImpl)ApplicationManager.getApplication()).editorPaintFinish();
        }
    }

    public void repaintEditorComponent() {
        this.repaint();
    }

    public void repaintEditorComponent(int x, int y, int width, int height) {
        this.repaint(x, y, width, height);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.myEditor.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 1) {
            return this.myEditor.getLineHeight();
        }
        return EditorUtil.getSpaceWidth(0, this.myEditor);
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 1) {
            int lineHeight = this.myEditor.getLineHeight();
            if (direction > 0) {
                int lineNumber = (visibleRect.y + visibleRect.height) / lineHeight;
                return lineHeight * lineNumber - visibleRect.y;
            }
            int lineNumber = (visibleRect.y - visibleRect.height) / lineHeight;
            return visibleRect.y - lineHeight * lineNumber;
        }
        return visibleRect.width;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return this.getParent() instanceof JViewport && this.getParent().getWidth() > this.getPreferredSize().width;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return this.getParent() instanceof JViewport && this.getParent().getHeight() > this.getPreferredSize().height;
    }

    public void putInfo(Map<String, String> info) {
        this.myEditor.putInfo(info);
    }
}

