/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.openapi.application.ModalityStateListener;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.event.EditorEventMulticasterImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerAdapter;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EventDispatcher;
import com.intellij.util.SmartList;
import com.intellij.util.text.CharArrayCharSequence;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class EditorFactoryImpl
extends EditorFactory {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.editor.impl.EditorFactoryImpl");
    private final EditorEventMulticasterImpl myEditorEventMulticaster = new EditorEventMulticasterImpl();
    private final EventDispatcher<EditorFactoryListener> myEditorFactoryEventDispatcher = EventDispatcher.create(EditorFactoryListener.class);
    private final ArrayList<Editor> myEditors = new ArrayList();
    private static final Key<String> EDITOR_CREATOR = new Key("Editor creator");
    private final ModalityStateListener myModalityStateListener = new ModalityStateListener(){

        public void beforeModalityStateChanged(boolean entering) {
            for (Editor editor : EditorFactoryImpl.this.myEditors) {
                ((EditorImpl)editor).beforeModalityStateChanged();
            }
        }
    };

    public EditorFactoryImpl(ProjectManager projectManager) {
        projectManager.addProjectManagerListener((ProjectManagerListener)new ProjectManagerAdapter(){

            public void projectClosed(final Project project) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        EditorFactoryImpl.this.validateEditorsAreReleased(project);
                    }
                });
            }
        });
    }

    @NotNull
    public String getComponentName() {
        if ("EditorFactory" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/EditorFactoryImpl.getComponentName must not return null");
        }
        return "EditorFactory";
    }

    public void initComponent() {
        LaterInvocator.addModalityStateListener(this.myModalityStateListener);
    }

    public void validateEditorsAreReleased(Project project) {
        for (Editor editor : this.myEditors) {
            if (editor.getProject() != project && editor.getProject() != null) continue;
            EditorFactoryImpl.fireEditorNotReleasedError(editor);
        }
    }

    private static void fireEditorNotReleasedError(Editor editor) {
        String creator = (String)editor.getUserData(EDITOR_CREATOR);
        if (creator == null) {
            LOG.error("Editor for the document with class:" + editor.getClass().getName() + " and the following text hasn't been released:\n" + editor.getDocument().getText());
        } else {
            LOG.error("Editor with class:" + editor.getClass().getName() + " hasn't been released:\n" + creator);
        }
    }

    public void disposeComponent() {
        LaterInvocator.removeModalityStateListener(this.myModalityStateListener);
    }

    @NotNull
    public Document createDocument(@NotNull char[] text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/EditorFactoryImpl.createDocument must not be null");
        }
        Document document = this.createDocument((CharSequence)new CharArrayCharSequence(text));
        if (document == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/EditorFactoryImpl.createDocument must not return null");
        }
        return document;
    }

    @NotNull
    public Document createDocument(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/EditorFactoryImpl.createDocument must not be null");
        }
        DocumentImpl document = new DocumentImpl(text);
        this.myEditorEventMulticaster.registerDocument(document);
        DocumentImpl documentImpl = document;
        if (documentImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/EditorFactoryImpl.createDocument must not return null");
        }
        return documentImpl;
    }

    @NotNull
    public Document createDocument(boolean allowUpdatesWithoutWriteAction) {
        DocumentImpl document = new DocumentImpl(allowUpdatesWithoutWriteAction);
        this.myEditorEventMulticaster.registerDocument(document);
        DocumentImpl documentImpl = document;
        if (documentImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/EditorFactoryImpl.createDocument must not return null");
        }
        return documentImpl;
    }

    public void refreshAllEditors() {
        for (Editor editor : this.myEditors) {
            ((EditorEx)editor).reinitSettings();
        }
    }

    public Editor createEditor(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/EditorFactoryImpl.createEditor must not be null");
        }
        return this.createEditor(document, false, null);
    }

    public Editor createViewer(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/EditorFactoryImpl.createViewer must not be null");
        }
        return this.createEditor(document, true, null);
    }

    public Editor createEditor(@NotNull Document document, Project project) {
        if (document == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/EditorFactoryImpl.createEditor must not be null");
        }
        return this.createEditor(document, false, project);
    }

    public Editor createViewer(@NotNull Document document, Project project) {
        if (document == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/EditorFactoryImpl.createViewer must not be null");
        }
        return this.createEditor(document, true, project);
    }

    public Editor createEditor(@NotNull Document document, Project project, @NotNull FileType fileType, boolean isViewer) {
        if (document == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/EditorFactoryImpl.createEditor must not be null");
        }
        if (fileType == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/editor/impl/EditorFactoryImpl.createEditor must not be null");
        }
        Editor editor = this.createEditor(document, isViewer, project);
        ((EditorEx)editor).setHighlighter(EditorHighlighterFactory.getInstance().createEditorHighlighter(project, fileType));
        return editor;
    }

    public Editor createEditor(@NotNull Document document, Project project, @NotNull VirtualFile file, boolean isViewer) {
        if (document == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/EditorFactoryImpl.createEditor must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/editor/impl/EditorFactoryImpl.createEditor must not be null");
        }
        Editor editor = this.createEditor(document, isViewer, project);
        ((EditorEx)editor).setHighlighter(EditorHighlighterFactory.getInstance().createEditorHighlighter(project, file));
        return editor;
    }

    private Editor createEditor(@NotNull Document document, boolean isViewer, Project project) {
        if (document == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/EditorFactoryImpl.createEditor must not be null");
        }
        Document hostDocument = document instanceof DocumentWindow ? ((DocumentWindow)document).getDelegate() : document;
        EditorImpl editor = new EditorImpl(hostDocument, isViewer, project);
        this.myEditors.add(editor);
        this.myEditorEventMulticaster.registerEditor(editor);
        ((EditorFactoryListener)this.myEditorFactoryEventDispatcher.getMulticaster()).editorCreated(new EditorFactoryEvent((EditorFactory)this, (Editor)editor));
        if (LOG.isDebugEnabled()) {
            LOG.debug("number of Editor's:" + this.myEditors.size());
        }
        String text = StringUtil.getThrowableText((Throwable)new RuntimeException("Editor created"));
        editor.putUserData(EDITOR_CREATOR, text);
        return editor;
    }

    public void releaseEditor(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/EditorFactoryImpl.releaseEditor must not be null");
        }
        editor.putUserData(EDITOR_CREATOR, null);
        ((EditorImpl)editor).release();
        this.myEditors.remove(editor);
        ((EditorFactoryListener)this.myEditorFactoryEventDispatcher.getMulticaster()).editorReleased(new EditorFactoryEvent((EditorFactory)this, editor));
        if (LOG.isDebugEnabled()) {
            LOG.debug("number of Editor's:" + this.myEditors.size());
        }
    }

    @NotNull
    public Editor[] getEditors(@NotNull Document document, Project project) {
        if (document == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/EditorFactoryImpl.getEditors must not be null");
        }
        List list = null;
        for (Editor editor : this.myEditors) {
            Project project1 = editor.getProject();
            if (!editor.getDocument().equals(document) || project != null && project1 != null && !project1.equals(project)) continue;
            if (list == null) {
                list = new SmartList();
            }
            list.add(editor);
        }
        Editor[] editorArray = list == null ? Editor.EMPTY_ARRAY : list.toArray(new Editor[list.size()]);
        if (editorArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/EditorFactoryImpl.getEditors must not return null");
        }
        return editorArray;
    }

    @NotNull
    public Editor[] getEditors(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/EditorFactoryImpl.getEditors must not be null");
        }
        Editor[] editorArray = this.getEditors(document, null);
        if (editorArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/EditorFactoryImpl.getEditors must not return null");
        }
        return editorArray;
    }

    @NotNull
    public Editor[] getAllEditors() {
        Editor[] editorArray = this.myEditors.toArray(new Editor[this.myEditors.size()]);
        if (editorArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/EditorFactoryImpl.getAllEditors must not return null");
        }
        return editorArray;
    }

    public void addEditorFactoryListener(@NotNull EditorFactoryListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/EditorFactoryImpl.addEditorFactoryListener must not be null");
        }
        this.myEditorFactoryEventDispatcher.addListener((EventListener)listener);
    }

    public void removeEditorFactoryListener(@NotNull EditorFactoryListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/EditorFactoryImpl.removeEditorFactoryListener must not be null");
        }
        this.myEditorFactoryEventDispatcher.removeListener((EventListener)listener);
    }

    @NotNull
    public EditorEventMulticaster getEventMulticaster() {
        EditorEventMulticasterImpl editorEventMulticasterImpl = this.myEditorEventMulticaster;
        if (editorEventMulticasterImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/EditorFactoryImpl.getEventMulticaster must not return null");
        }
        return editorEventMulticasterImpl;
    }
}

