/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.ide.caches.FileContent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.ArrayBlockingQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileContentQueue {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.startup.FileContentQueue");
    private static final long SIZE_THRESHOLD = 0x100000L;
    private long myTotalSize;
    private final ArrayBlockingQueue<FileContent> myQueue = new ArrayBlockingQueue(256);
    private FileContent myPushbackBuffer;

    public void queue(final Collection<VirtualFile> files, final @Nullable ProgressIndicator indicator) {
        Runnable contentLoadingRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    for (VirtualFile file : files) {
                        if (indicator != null) {
                            indicator.checkCanceled();
                        }
                        FileContentQueue.this.put(file);
                    }
                    try {
                        FileContentQueue.this.myQueue.put(new FileContent(null));
                    }
                    catch (InterruptedException e) {
                        LOG.error((Throwable)e);
                    }
                }
                catch (ProcessCanceledException e) {
                }
                catch (InterruptedException e) {
                    LOG.error((Throwable)e);
                }
            }
        };
        ApplicationManager.getApplication().executeOnPooledThread(contentLoadingRunnable);
    }

    private void put(VirtualFile file) throws InterruptedException {
        FileContent content = new FileContent(file);
        if (file.isValid()) {
            if (!this.doLoadContent(content)) {
                content.setEmptyContent();
            }
        } else {
            content.setEmptyContent();
        }
        this.myQueue.put(content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doLoadContent(FileContent content) throws InterruptedException {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        long contentLength = content.getLength();
        boolean counterUpdated = false;
        try {
            if (contentLength < (long)PersistentFS.MAX_INTELLISENSE_FILESIZE) {
                FileContentQueue fileContentQueue = this;
                synchronized (fileContentQueue) {
                    while (this.myTotalSize > 0x100000L) {
                        if (indicator != null) {
                            indicator.checkCanceled();
                        }
                        this.wait(300L);
                    }
                    this.myTotalSize += contentLength;
                    counterUpdated = true;
                }
                content.getBytes();
            }
            return true;
        }
        catch (Throwable e) {
            if (counterUpdated) {
                FileContentQueue fileContentQueue = this;
                synchronized (fileContentQueue) {
                    this.myTotalSize -= contentLength;
                    this.notifyAll();
                }
            }
            if (e instanceof ProcessCanceledException) {
                throw (ProcessCanceledException)e;
            }
            if (e instanceof InterruptedException) {
                throw (InterruptedException)e;
            }
            if (e instanceof IOException || e instanceof InvalidVirtualFileAccessException) {
                LOG.info(e);
            } else {
                LOG.error(e);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileContent take() {
        FileContent result;
        FileContentQueue fileContentQueue = this;
        synchronized (fileContentQueue) {
            if (this.myPushbackBuffer != null) {
                FileContent result2 = this.myPushbackBuffer;
                this.myPushbackBuffer = null;
                return result2;
            }
        }
        try {
            result = this.myQueue.take();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        VirtualFile file = result.getVirtualFile();
        if (file == null) {
            return null;
        }
        if (result.getLength() < (long)PersistentFS.MAX_INTELLISENSE_FILESIZE) {
            FileContentQueue fileContentQueue2 = this;
            synchronized (fileContentQueue2) {
                try {
                    this.myTotalSize -= result.getLength();
                }
                finally {
                    this.notifyAll();
                }
            }
        }
        return result;
    }

    public synchronized void pushback(@NotNull FileContent content) {
        if (content == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/project/FileContentQueue.pushback must not be null");
        }
        LOG.assertTrue(this.myPushbackBuffer == null, (Object)"Pushback buffer is already full");
        this.myPushbackBuffer = content;
    }
}

