/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExcludeFolder;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.InheritedJdkOrderEntry;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleExtension;
import com.intellij.openapi.roots.ModuleJdkOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.PersistentOrderRootType;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.ClonableContentEntry;
import com.intellij.openapi.roots.impl.ClonableOrderEntry;
import com.intellij.openapi.roots.impl.ContentEntryImpl;
import com.intellij.openapi.roots.impl.InheritedJdkOrderEntryImpl;
import com.intellij.openapi.roots.impl.LibraryOrderEntryImpl;
import com.intellij.openapi.roots.impl.ModuleJdkOrderEntryImpl;
import com.intellij.openapi.roots.impl.ModuleLibraryTable;
import com.intellij.openapi.roots.impl.ModuleOrderEntryImpl;
import com.intellij.openapi.roots.impl.ModuleRootManagerImpl;
import com.intellij.openapi.roots.impl.ModuleSourceOrderEntryImpl;
import com.intellij.openapi.roots.impl.OrderEntryBaseImpl;
import com.intellij.openapi.roots.impl.OrderEntryFactory;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.RootConfigurationAccessor;
import com.intellij.openapi.roots.impl.RootModelComponentBase;
import com.intellij.openapi.roots.impl.WritableOrderEntry;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerContainer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RootModelImpl
implements ModifiableRootModel {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.impl.RootModelImpl");
    private final Set<ContentEntry> myContent = new TreeSet<ContentEntry>(ContentComparator.INSTANCE);
    private final List<OrderEntry> myOrderEntries = new Order();
    private OrderEntry[] myCachedOrderEntries;
    private final ModuleLibraryTable myModuleLibraryTable;
    final ModuleRootManagerImpl myModuleRootManager;
    private boolean myWritable;
    final VirtualFilePointerListener myVirtualFilePointerListener;
    private final VirtualFilePointerManager myFilePointerManager;
    VirtualFilePointer myExplodedDirectoryPointer;
    private String myExplodedDirectory;
    final List<RootModelComponentBase> myComponents = new ArrayList<RootModelComponentBase>();
    private boolean myExcludeExploded;
    @NonNls
    private static final String EXPLODED_TAG = "exploded";
    @NonNls
    private static final String ATTRIBUTE_URL = "url";
    @NonNls
    private static final String URL_ATTR = "url";
    @NonNls
    private static final String EXCLUDE_EXPLODED_TAG = "exclude-exploded";
    private boolean myDisposed = false;
    private final Set<ModuleExtension> myExtensions = new TreeSet<ModuleExtension>();
    private final Map<PersistentOrderRootType, VirtualFilePointerContainer> myOrderRootPointerContainers = new HashMap<PersistentOrderRootType, VirtualFilePointerContainer>();
    private final RootConfigurationAccessor myConfigurationAccessor;
    @NonNls
    private static final String ROOT_ELEMENT = "root";
    private final ProjectRootManagerImpl myProjectRootManager;
    private final Disposable myDisposable = Disposer.newDisposable();

    RootModelImpl(ModuleRootManagerImpl moduleRootManager, ProjectRootManagerImpl projectRootManager, VirtualFilePointerManager filePointerManager) {
        this.myModuleRootManager = moduleRootManager;
        this.myProjectRootManager = projectRootManager;
        this.myFilePointerManager = filePointerManager;
        this.myWritable = false;
        this.myVirtualFilePointerListener = projectRootManager.getVirtualFilePointerListener();
        this.addSourceOrderEntries();
        this.myModuleLibraryTable = new ModuleLibraryTable(this, this.myProjectRootManager);
        for (ModuleExtension extension : (ModuleExtension[])Extensions.getExtensions((ExtensionPointName)ModuleExtension.EP_NAME, (AreaInstance)moduleRootManager.getModule())) {
            ModuleExtension model = extension.getModifiableModel(false);
            Disposer.register((Disposable)this.myDisposable, (Disposable)model);
            this.myExtensions.add(model);
        }
        this.myConfigurationAccessor = new RootConfigurationAccessor();
    }

    private void addSourceOrderEntries() {
        this.myOrderEntries.add(new ModuleSourceOrderEntryImpl(this));
    }

    RootModelImpl(Element element, ModuleRootManagerImpl moduleRootManager, ProjectRootManagerImpl projectRootManager, VirtualFilePointerManager filePointerManager) throws InvalidDataException {
        this.myProjectRootManager = projectRootManager;
        this.myFilePointerManager = filePointerManager;
        this.myModuleRootManager = moduleRootManager;
        this.myModuleLibraryTable = new ModuleLibraryTable(this, this.myProjectRootManager);
        this.myVirtualFilePointerListener = null;
        List contentChildren = element.getChildren("content");
        for (Object aContentChildren : contentChildren) {
            Element child = (Element)aContentChildren;
            ContentEntryImpl contentEntry = new ContentEntryImpl(child, this);
            this.myContent.add(contentEntry);
        }
        List orderElements = element.getChildren("orderEntry");
        boolean moduleSourceAdded = false;
        for (Object orderElement : orderElements) {
            Element child = (Element)orderElement;
            OrderEntry orderEntry = OrderEntryFactory.createOrderEntryByElement(child, this, this.myProjectRootManager);
            if (orderEntry instanceof ModuleSourceOrderEntry) {
                if (moduleSourceAdded) continue;
                moduleSourceAdded = true;
            }
            this.myOrderEntries.add(orderEntry);
        }
        if (!moduleSourceAdded) {
            this.myOrderEntries.add(new ModuleSourceOrderEntryImpl(this));
        }
        this.myExcludeExploded = element.getChild(EXCLUDE_EXPLODED_TAG) != null;
        this.myExplodedDirectoryPointer = this.getOutputPathValue(element, EXPLODED_TAG, true);
        this.myExplodedDirectory = RootModelImpl.getOutputPathValue(element, EXCLUDE_EXPLODED_TAG);
        this.myWritable = true;
        for (PersistentOrderRootType orderRootType : OrderRootType.getAllPersistentTypes()) {
            Element pathsElement;
            String paths = orderRootType.getModulePathsName();
            if (paths == null || (pathsElement = element.getChild(paths)) == null) continue;
            VirtualFilePointerContainer container = this.myFilePointerManager.createContainer(this.myDisposable, this.myVirtualFilePointerListener);
            this.myOrderRootPointerContainers.put(orderRootType, container);
            container.readExternal(pathsElement, ROOT_ELEMENT);
        }
        RootModelImpl originalRootModel = moduleRootManager.getRootModel();
        for (ModuleExtension extension : originalRootModel.myExtensions) {
            ModuleExtension model = extension.getModifiableModel(false);
            model.readExternal(element);
            Disposer.register((Disposable)this.myDisposable, (Disposable)model);
            this.myExtensions.add(model);
        }
        this.myConfigurationAccessor = new RootConfigurationAccessor();
    }

    public boolean isWritable() {
        return this.myWritable;
    }

    public RootConfigurationAccessor getConfigurationAccessor() {
        return this.myConfigurationAccessor;
    }

    RootModelImpl(RootModelImpl rootModel, ModuleRootManagerImpl moduleRootManager, boolean writable, RootConfigurationAccessor rootConfigurationAccessor, VirtualFilePointerListener virtualFilePointerListener, VirtualFilePointerManager filePointerManager, ProjectRootManagerImpl projectRootManager) {
        this.myFilePointerManager = filePointerManager;
        this.myModuleRootManager = moduleRootManager;
        this.myProjectRootManager = projectRootManager;
        this.myModuleLibraryTable = new ModuleLibraryTable(this, this.myProjectRootManager);
        this.myWritable = writable;
        this.myConfigurationAccessor = rootConfigurationAccessor;
        LOG.assertTrue(!writable || virtualFilePointerListener == null);
        this.myVirtualFilePointerListener = virtualFilePointerListener;
        this.setExplodedFrom(rootModel, virtualFilePointerListener, filePointerManager);
        Set<ContentEntry> thatContent = rootModel.myContent;
        for (ContentEntry contentEntry : thatContent) {
            if (!(contentEntry instanceof ClonableContentEntry)) continue;
            this.myContent.add(((ClonableContentEntry)contentEntry).cloneEntry(this));
        }
        this.setOrderEntriesFrom(rootModel);
        this.copyContainersFrom(rootModel);
        for (ModuleExtension extension : rootModel.myExtensions) {
            ModuleExtension model = extension.getModifiableModel(writable);
            Disposer.register((Disposable)this.myDisposable, (Disposable)model);
            this.myExtensions.add(model);
        }
    }

    private void setExplodedFrom(RootModelImpl rootModel, VirtualFilePointerListener virtualFilePointerListener, VirtualFilePointerManager filePointerManager) {
        if (rootModel.myExplodedDirectoryPointer != null) {
            this.myExplodedDirectoryPointer = filePointerManager.duplicate(rootModel.myExplodedDirectoryPointer, (Disposable)this.getModule(), virtualFilePointerListener);
        }
        this.myExplodedDirectory = rootModel.myExplodedDirectory;
        this.myExcludeExploded = rootModel.myExcludeExploded;
    }

    private void copyContainersFrom(RootModelImpl rootModel) {
        this.myOrderRootPointerContainers.clear();
        for (PersistentOrderRootType orderRootType : OrderRootType.getAllPersistentTypes()) {
            VirtualFilePointerContainer otherContainer = rootModel.getOrderRootContainer(orderRootType);
            if (otherContainer == null) continue;
            this.myOrderRootPointerContainers.put(orderRootType, otherContainer.clone(this.myDisposable, this.myVirtualFilePointerListener));
        }
    }

    private void setOrderEntriesFrom(RootModelImpl rootModel) {
        this.myOrderEntries.clear();
        for (OrderEntry orderEntry : rootModel.myOrderEntries) {
            if (!(orderEntry instanceof ClonableOrderEntry)) continue;
            this.myOrderEntries.add(((ClonableOrderEntry)orderEntry).cloneEntry(this, this.myProjectRootManager, this.myFilePointerManager));
        }
    }

    @Nullable
    private VirtualFilePointerContainer getOrderRootContainer(PersistentOrderRootType orderRootType) {
        return this.myOrderRootPointerContainers.get(orderRootType);
    }

    @NotNull
    public VirtualFile[] getOrderedRoots(OrderRootType type) {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (OrderEntry orderEntry : this.getOrderEntries()) {
            result.addAll(Arrays.asList(orderEntry.getFiles(type)));
        }
        VirtualFile[] virtualFileArray = (VirtualFile[])ContainerUtil.toArray(result, (Object[])new VirtualFile[result.size()]);
        if (virtualFileArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/RootModelImpl.getOrderedRoots must not return null");
        }
        return virtualFileArray;
    }

    @NotNull
    public String[] getOrderedRootUrls(OrderRootType type) {
        ArrayList<String> result = new ArrayList<String>();
        for (OrderEntry orderEntry : this.getOrderEntries()) {
            result.addAll(Arrays.asList(orderEntry.getUrls(type)));
        }
        String[] stringArray = (String[])ContainerUtil.toArray(result, (Object[])new String[result.size()]);
        if (stringArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/RootModelImpl.getOrderedRootUrls must not return null");
        }
        return stringArray;
    }

    @NotNull
    public VirtualFile[] getContentRoots() {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (ContentEntry contentEntry : this.myContent) {
            VirtualFile file = contentEntry.getFile();
            if (file == null) continue;
            result.add(file);
        }
        VirtualFile[] virtualFileArray = (VirtualFile[])ContainerUtil.toArray(result, (Object[])new VirtualFile[result.size()]);
        if (virtualFileArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/RootModelImpl.getContentRoots must not return null");
        }
        return virtualFileArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String[] getContentRootUrls() {
        String[] stringArray;
        if (this.myContent.isEmpty()) {
            stringArray = ArrayUtil.EMPTY_STRING_ARRAY;
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/RootModelImpl.getContentRootUrls must not return null");
            return stringArray;
        }
        ArrayList<String> result = new ArrayList<String>(this.myContent.size());
        for (ContentEntry contentEntry : this.myContent) {
            result.add(contentEntry.getUrl());
        }
        stringArray = (String[])ContainerUtil.toArray(result, (Object[])new String[result.size()]);
        if (stringArray != null) return stringArray;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/RootModelImpl.getContentRootUrls must not return null");
    }

    @NotNull
    public String[] getExcludeRootUrls() {
        SmartList result = new SmartList();
        for (ContentEntry contentEntry : this.myContent) {
            ExcludeFolder[] excludeFolders;
            for (ExcludeFolder excludeFolder : excludeFolders = contentEntry.getExcludeFolders()) {
                result.add(excludeFolder.getUrl());
            }
        }
        String[] stringArray = (String[])ContainerUtil.toArray((List)result, (Object[])new String[result.size()]);
        if (stringArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/RootModelImpl.getExcludeRootUrls must not return null");
        }
        return stringArray;
    }

    @NotNull
    public VirtualFile[] getExcludeRoots() {
        SmartList result = new SmartList();
        for (ContentEntry contentEntry : this.myContent) {
            ExcludeFolder[] excludeFolders;
            for (ExcludeFolder excludeFolder : excludeFolders = contentEntry.getExcludeFolders()) {
                VirtualFile file = excludeFolder.getFile();
                if (file == null) continue;
                result.add(file);
            }
        }
        VirtualFile[] virtualFileArray = (VirtualFile[])ContainerUtil.toArray((List)result, (Object[])new VirtualFile[result.size()]);
        if (virtualFileArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/RootModelImpl.getExcludeRoots must not return null");
        }
        return virtualFileArray;
    }

    @NotNull
    public String[] getSourceRootUrls() {
        SmartList result = new SmartList();
        for (ContentEntry contentEntry : this.myContent) {
            SourceFolder[] sourceFolders;
            for (SourceFolder sourceFolder : sourceFolders = contentEntry.getSourceFolders()) {
                result.add(sourceFolder.getUrl());
            }
        }
        String[] stringArray = (String[])ContainerUtil.toArray((List)result, (Object[])new String[result.size()]);
        if (stringArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/RootModelImpl.getSourceRootUrls must not return null");
        }
        return stringArray;
    }

    @NotNull
    public VirtualFile[] getSourceRoots() {
        SmartList result = new SmartList();
        for (ContentEntry contentEntry : this.myContent) {
            SourceFolder[] sourceFolders;
            for (SourceFolder sourceFolder : sourceFolders = contentEntry.getSourceFolders()) {
                VirtualFile file = sourceFolder.getFile();
                if (file == null) continue;
                result.add(file);
            }
        }
        VirtualFile[] virtualFileArray = (VirtualFile[])ContainerUtil.toArray((List)result, (Object[])new VirtualFile[result.size()]);
        if (virtualFileArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/RootModelImpl.getSourceRoots must not return null");
        }
        return virtualFileArray;
    }

    public ContentEntry[] getContentEntries() {
        return this.myContent.toArray(new ContentEntry[this.myContent.size()]);
    }

    @NotNull
    public OrderEntry[] getOrderEntries() {
        OrderEntry[] cachedOrderEntries = this.myCachedOrderEntries;
        if (cachedOrderEntries == null) {
            this.myCachedOrderEntries = cachedOrderEntries = this.myOrderEntries.toArray(new OrderEntry[this.myOrderEntries.size()]);
        }
        if (cachedOrderEntries == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/RootModelImpl.getOrderEntries must not return null");
        }
        return cachedOrderEntries;
    }

    Iterator<OrderEntry> getOrderIterator() {
        return Collections.unmodifiableList(this.myOrderEntries).iterator();
    }

    public void removeContentEntry(ContentEntry entry) {
        this.assertWritable();
        LOG.assertTrue(this.myContent.contains(entry));
        this.myContent.remove(entry);
    }

    public void addOrderEntry(OrderEntry entry) {
        this.assertWritable();
        LOG.assertTrue(!this.myOrderEntries.contains(entry));
        this.myOrderEntries.add(entry);
    }

    public LibraryOrderEntry addLibraryEntry(Library library) {
        this.assertWritable();
        LibraryOrderEntryImpl libraryOrderEntry = new LibraryOrderEntryImpl(library, this, this.myProjectRootManager);
        assert (libraryOrderEntry.isValid());
        this.myOrderEntries.add(libraryOrderEntry);
        return libraryOrderEntry;
    }

    public LibraryOrderEntry addInvalidLibrary(String name, String level) {
        this.assertWritable();
        LibraryOrderEntryImpl libraryOrderEntry = new LibraryOrderEntryImpl(name, level, this, this.myProjectRootManager);
        this.myOrderEntries.add(libraryOrderEntry);
        return libraryOrderEntry;
    }

    public ModuleOrderEntry addModuleOrderEntry(Module module) {
        this.assertWritable();
        LOG.assertTrue(!module.equals(this.getModule()));
        LOG.assertTrue(Comparing.equal((Object)this.myModuleRootManager.getModule().getProject(), (Object)module.getProject()));
        ModuleOrderEntryImpl moduleOrderEntry = new ModuleOrderEntryImpl(module, this);
        this.myOrderEntries.add(moduleOrderEntry);
        return moduleOrderEntry;
    }

    public ModuleOrderEntry addInvalidModuleEntry(String name) {
        this.assertWritable();
        LOG.assertTrue(!name.equals(this.getModule().getName()));
        ModuleOrderEntryImpl moduleOrderEntry = new ModuleOrderEntryImpl(name, this);
        this.myOrderEntries.add(moduleOrderEntry);
        return moduleOrderEntry;
    }

    public LibraryOrderEntry findLibraryOrderEntry(Library library) {
        for (OrderEntry orderEntry : this.getOrderEntries()) {
            if (!(orderEntry instanceof LibraryOrderEntry) || !library.equals(((LibraryOrderEntry)orderEntry).getLibrary())) continue;
            return (LibraryOrderEntry)orderEntry;
        }
        return null;
    }

    public void removeOrderEntry(OrderEntry entry) {
        this.assertWritable();
        this.removeOrderEntryInternal(entry);
    }

    private void removeOrderEntryInternal(OrderEntry entry) {
        LOG.assertTrue(this.myOrderEntries.contains(entry));
        this.myOrderEntries.remove(entry);
    }

    public void rearrangeOrderEntries(OrderEntry[] newEntries) {
        this.assertWritable();
        this.assertValidRearrangement(newEntries);
        this.myOrderEntries.clear();
        this.myOrderEntries.addAll(Arrays.asList(newEntries));
    }

    private void assertValidRearrangement(OrderEntry[] newEntries) {
        String error = this.checkValidRearrangement(newEntries);
        LOG.assertTrue(error == null, (Object)error);
    }

    private String checkValidRearrangement(OrderEntry[] newEntries) {
        if (newEntries.length != this.myOrderEntries.size()) {
            return "Size mismatch: old size=" + this.myOrderEntries.size() + "; new size=" + newEntries.length;
        }
        HashSet set = new HashSet();
        for (OrderEntry newEntry : newEntries) {
            if (!this.myOrderEntries.contains(newEntry)) {
                return "Trying to add nonexisting order entry " + newEntry;
            }
            if (set.contains(newEntry)) {
                return "Trying to add duplicate order entry " + newEntry;
            }
            set.add(newEntry);
        }
        return null;
    }

    public void clear() {
        Sdk jdk = this.getSdk();
        this.myContent.clear();
        this.myOrderEntries.clear();
        this.setSdk(jdk);
        this.addSourceOrderEntries();
    }

    public void commit() {
        this.myModuleRootManager.commitModel(this);
        this.myWritable = false;
    }

    public void docommit() {
        assert (this.isWritable());
        if (!RootModelImpl.vptrEqual(this.myExplodedDirectoryPointer, this.getSourceModel().myExplodedDirectoryPointer)) {
            this.getSourceModel().setExplodedDirectory(this.getExplodedDirectoryUrl());
        }
        this.getSourceModel().myExcludeExploded = this.myExcludeExploded;
        if (this.areOrderEntriesChanged()) {
            this.getSourceModel().setOrderEntriesFrom(this);
        }
        if (this.areContentEntriesChanged()) {
            this.getSourceModel().myContent.clear();
            for (ContentEntry contentEntry : this.myContent) {
                this.getSourceModel().myContent.add(((ClonableContentEntry)contentEntry).cloneEntry(this.getSourceModel()));
            }
        }
        if (this.areOrderRootPointerContainersChanged()) {
            this.getSourceModel().copyContainersFrom(this);
        }
        this.getSourceModel().setExplodedFrom(this, this.myVirtualFilePointerListener, this.myFilePointerManager);
        for (ModuleExtension extension : this.myExtensions) {
            if (!extension.isChanged()) continue;
            extension.commit();
        }
    }

    @NotNull
    public LibraryTable getModuleLibraryTable() {
        ModuleLibraryTable moduleLibraryTable = this.myModuleLibraryTable;
        if (moduleLibraryTable == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/RootModelImpl.getModuleLibraryTable must not return null");
        }
        return moduleLibraryTable;
    }

    public <R> R processOrder(RootPolicy<R> policy, R initialValue) {
        Object result = initialValue;
        for (OrderEntry orderEntry : this.getOrderEntries()) {
            result = orderEntry.accept(policy, result);
        }
        return result;
    }

    public Project getProject() {
        return this.myProjectRootManager.getProject();
    }

    @NotNull
    public ContentEntry addContentEntry(VirtualFile file) {
        ContentEntry contentEntry = this.addContentEntry(new ContentEntryImpl(file, this));
        if (contentEntry == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/RootModelImpl.addContentEntry must not return null");
        }
        return contentEntry;
    }

    @NotNull
    public ContentEntry addContentEntry(String url) {
        ContentEntry contentEntry = this.addContentEntry(new ContentEntryImpl(url, this));
        if (contentEntry == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/RootModelImpl.addContentEntry must not return null");
        }
        return contentEntry;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    private ContentEntry addContentEntry(ContentEntry e) {
        if (this.myContent.contains(e)) {
            for (ContentEntry contentEntry : this.getContentEntries()) {
                if (ContentComparator.INSTANCE.compare(contentEntry, e) != 0) continue;
                return contentEntry;
            }
        }
        this.myContent.add(e);
        return e;
    }

    public void writeExternal(Element element) throws WriteExternalException {
        for (ModuleExtension extension : this.myExtensions) {
            extension.writeExternal(element);
        }
        if (this.myExplodedDirectory != null) {
            Element pathElement = new Element(EXPLODED_TAG);
            pathElement.setAttribute("url", this.myExplodedDirectory);
            element.addContent(pathElement);
        }
        if (this.myExcludeExploded) {
            element.addContent(new Element(EXCLUDE_EXPLODED_TAG));
        }
        for (ContentEntry contentEntry : this.myContent) {
            if (!(contentEntry instanceof ContentEntryImpl)) continue;
            Element subElement = new Element("content");
            ((ContentEntryImpl)contentEntry).writeExternal(subElement);
            element.addContent(subElement);
        }
        for (OrderEntry orderEntry : this.getOrderEntries()) {
            if (!(orderEntry instanceof WritableOrderEntry)) continue;
            ((WritableOrderEntry)orderEntry).writeExternal(element);
        }
        for (PersistentOrderRootType orderRootType : this.myOrderRootPointerContainers.keySet()) {
            VirtualFilePointerContainer container = this.myOrderRootPointerContainers.get(orderRootType);
            if (container == null || container.size() <= 0) continue;
            Element javaDocPaths = new Element(orderRootType.getModulePathsName());
            container.writeExternal(javaDocPaths, ROOT_ELEMENT);
            element.addContent(javaDocPaths);
        }
    }

    public void setSdk(Sdk jdk) {
        this.assertWritable();
        ModuleJdkOrderEntryImpl jdkLibraryEntry = jdk != null ? new ModuleJdkOrderEntryImpl(jdk, this, this.myProjectRootManager) : null;
        this.replaceEntryOfType(JdkOrderEntry.class, jdkLibraryEntry);
    }

    public void setInvalidSdk(String jdkName, String jdkType) {
        this.assertWritable();
        this.replaceEntryOfType(JdkOrderEntry.class, new ModuleJdkOrderEntryImpl(jdkName, jdkType, this, this.myProjectRootManager));
    }

    public void inheritSdk() {
        this.assertWritable();
        this.replaceEntryOfType(JdkOrderEntry.class, new InheritedJdkOrderEntryImpl(this, this.myProjectRootManager));
    }

    public <T extends OrderEntry> void replaceEntryOfType(Class<T> entryClass, T entry) {
        this.assertWritable();
        for (int i = 0; i < this.myOrderEntries.size(); ++i) {
            OrderEntry orderEntry = this.myOrderEntries.get(i);
            if (!entryClass.isInstance(orderEntry)) continue;
            this.myOrderEntries.remove(i);
            if (entry != null) {
                this.myOrderEntries.add(i, entry);
            }
            return;
        }
        if (entry != null) {
            this.myOrderEntries.add(0, entry);
        }
    }

    public Sdk getSdk() {
        for (OrderEntry orderEntry : this.getOrderEntries()) {
            if (!(orderEntry instanceof JdkOrderEntry)) continue;
            return ((JdkOrderEntry)orderEntry).getJdk();
        }
        return null;
    }

    public boolean isSdkInherited() {
        for (OrderEntry orderEntry : this.getOrderEntries()) {
            if (!(orderEntry instanceof InheritedJdkOrderEntry)) continue;
            return true;
        }
        return false;
    }

    public String getSdkName() {
        for (OrderEntry orderEntry : this.getOrderEntries()) {
            if (!(orderEntry instanceof JdkOrderEntry)) continue;
            return ((JdkOrderEntry)orderEntry).getJdkName();
        }
        return null;
    }

    public void assertWritable() {
        LOG.assertTrue(this.myWritable);
    }

    public boolean isDependsOn(Module module) {
        for (OrderEntry entry : this.getOrderEntries()) {
            Module module1;
            if (!(entry instanceof ModuleOrderEntry) || (module1 = ((ModuleOrderEntry)entry).getModule()) != module) continue;
            return true;
        }
        return false;
    }

    public void projectOpened() {
        for (ContentEntry contentEntry : this.myContent) {
            ((RootModelComponentBase)contentEntry).projectOpened();
        }
        for (OrderEntry orderEntry : this.myOrderEntries) {
            ((RootModelComponentBase)orderEntry).projectOpened();
        }
    }

    public void projectClosed() {
        for (ContentEntry contentEntry : this.myContent) {
            ((RootModelComponentBase)contentEntry).projectClosed();
        }
        for (OrderEntry orderEntry : this.myOrderEntries) {
            ((RootModelComponentBase)orderEntry).projectClosed();
        }
    }

    public boolean isOrderEntryDisposed() {
        for (OrderEntry entry : this.myOrderEntries) {
            if (!(entry instanceof RootModelComponentBase) || !((RootModelComponentBase)entry).isDisposed()) continue;
            return true;
        }
        return false;
    }

    public VirtualFile getExplodedDirectory() {
        return this.myExplodedDirectoryPointer == null ? null : this.myExplodedDirectoryPointer.getFile();
    }

    public void setExplodedDirectory(VirtualFile file) {
        this.setExplodedDirectory(file == null ? null : file.getUrl());
    }

    public void setExplodedDirectory(String url) {
        this.myExplodedDirectory = url;
        this.myExplodedDirectoryPointer = url == null ? null : this.myFilePointerManager.create(url, this.myDisposable, this.myVirtualFilePointerListener);
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModuleRootManager.getModule();
        if (module == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/RootModelImpl.getModule must not return null");
        }
        return module;
    }

    public String getExplodedDirectoryUrl() {
        return this.myExplodedDirectoryPointer == null ? null : this.myExplodedDirectoryPointer.getUrl();
    }

    private static boolean vptrEqual(VirtualFilePointer p1, VirtualFilePointer p2) {
        if (p1 == null && p2 == null) {
            return true;
        }
        if (p1 == null || p2 == null) {
            return false;
        }
        return Comparing.equal((String)p1.getUrl(), (String)p2.getUrl());
    }

    public boolean isChanged() {
        if (!this.myWritable) {
            return false;
        }
        if (!RootModelImpl.vptrEqual(this.myExplodedDirectoryPointer, this.getSourceModel().myExplodedDirectoryPointer)) {
            return true;
        }
        for (ModuleExtension moduleExtension : this.myExtensions) {
            if (!moduleExtension.isChanged()) continue;
            return true;
        }
        return this.myExcludeExploded != this.getSourceModel().myExcludeExploded || this.areOrderEntriesChanged() || this.areContentEntriesChanged() || this.areOrderRootPointerContainersChanged();
    }

    private boolean areOrderRootPointerContainersChanged() {
        if (this.myOrderRootPointerContainers.size() != this.getSourceModel().myOrderRootPointerContainers.size()) {
            return true;
        }
        for (PersistentOrderRootType type : this.myOrderRootPointerContainers.keySet()) {
            String[] otherUrls;
            VirtualFilePointerContainer container = this.myOrderRootPointerContainers.get(type);
            VirtualFilePointerContainer otherContainer = this.getSourceModel().myOrderRootPointerContainers.get(type);
            if (container == null || otherContainer == null) {
                if (container == otherContainer) continue;
                return true;
            }
            String[] urls = container.getUrls();
            if (urls.length != (otherUrls = otherContainer.getUrls()).length) {
                return true;
            }
            for (int i = 0; i < urls.length; ++i) {
                if (Comparing.strEqual((String)urls[i], (String)otherUrls[i])) continue;
                return true;
            }
        }
        return false;
    }

    private boolean areContentEntriesChanged() {
        return ArrayUtil.lexicographicCompare((Object[])this.getContentEntries(), (Object[])this.getSourceModel().getContentEntries()) != 0;
    }

    private boolean areOrderEntriesChanged() {
        OrderEntry[] sourceOrderEntries;
        OrderEntry[] orderEntries = this.getOrderEntries();
        if (orderEntries.length != (sourceOrderEntries = this.getSourceModel().getOrderEntries()).length) {
            return true;
        }
        for (int i = 0; i < orderEntries.length; ++i) {
            OrderEntry orderEntry = orderEntries[i];
            OrderEntry sourceOrderEntry = sourceOrderEntries[i];
            if (RootModelImpl.orderEntriesEquals(orderEntry, sourceOrderEntry)) continue;
            return true;
        }
        return false;
    }

    private static boolean orderEntriesEquals(OrderEntry orderEntry1, OrderEntry orderEntry2) {
        OrderRootType[] allTypes;
        String name2;
        String name1;
        if (!((OrderEntryBaseImpl)orderEntry1).sameType(orderEntry2)) {
            return false;
        }
        if (orderEntry1 instanceof JdkOrderEntry) {
            if (!(orderEntry2 instanceof JdkOrderEntry)) {
                return false;
            }
            if (orderEntry1 instanceof InheritedJdkOrderEntry && orderEntry2 instanceof ModuleJdkOrderEntry) {
                return false;
            }
            if (orderEntry2 instanceof InheritedJdkOrderEntry && orderEntry1 instanceof ModuleJdkOrderEntry) {
                return false;
            }
            if (orderEntry1 instanceof ModuleJdkOrderEntry && orderEntry2 instanceof ModuleJdkOrderEntry && !Comparing.strEqual((String)(name1 = ((ModuleJdkOrderEntry)orderEntry1).getJdkName()), (String)(name2 = ((ModuleJdkOrderEntry)orderEntry2).getJdkName()))) {
                return false;
            }
        }
        if (orderEntry1 instanceof ExportableOrderEntry) {
            if (((ExportableOrderEntry)orderEntry1).isExported() != ((ExportableOrderEntry)orderEntry2).isExported()) {
                return false;
            }
            if (((ExportableOrderEntry)orderEntry1).getScope() != ((ExportableOrderEntry)orderEntry2).getScope()) {
                return false;
            }
        }
        if (orderEntry1 instanceof ModuleOrderEntry) {
            LOG.assertTrue(orderEntry2 instanceof ModuleOrderEntry);
            name1 = ((ModuleOrderEntry)orderEntry1).getModuleName();
            name2 = ((ModuleOrderEntry)orderEntry2).getModuleName();
            return Comparing.equal((String)name1, (String)name2);
        }
        if (orderEntry1 instanceof LibraryOrderEntry) {
            boolean equal;
            LOG.assertTrue(orderEntry2 instanceof LibraryOrderEntry);
            LibraryOrderEntry libraryOrderEntry1 = (LibraryOrderEntry)orderEntry1;
            LibraryOrderEntry libraryOrderEntry2 = (LibraryOrderEntry)orderEntry2;
            boolean bl = equal = Comparing.equal((String)libraryOrderEntry1.getLibraryName(), (String)libraryOrderEntry2.getLibraryName()) && Comparing.equal((String)libraryOrderEntry1.getLibraryLevel(), (String)libraryOrderEntry2.getLibraryLevel());
            if (!equal) {
                return false;
            }
        }
        for (OrderRootType type : allTypes = OrderRootType.getAllTypes()) {
            Object[] orderedRootUrls2;
            Object[] orderedRootUrls1 = orderEntry1.getUrls(type);
            if (Arrays.equals(orderedRootUrls1, orderedRootUrls2 = orderEntry2.getUrls(type))) continue;
            return false;
        }
        return true;
    }

    void makeExternalChange(Runnable runnable) {
        if (this.myWritable || this.myDisposed) {
            return;
        }
        this.myModuleRootManager.makeRootsChange(runnable);
    }

    public void dispose() {
        assert (!this.myDisposed);
        Disposer.dispose((Disposable)this.myDisposable);
        this.myExtensions.clear();
        this.myWritable = false;
        this.myDisposed = true;
    }

    public boolean isExcludeExplodedDirectory() {
        return this.myExcludeExploded;
    }

    public void setExcludeExplodedDirectory(boolean excludeExplodedDir) {
        this.myExcludeExploded = excludeExplodedDir;
    }

    @NotNull
    public String[] getDependencyModuleNames() {
        List result = this.processOrder(new CollectDependentModules(), new ArrayList());
        String[] stringArray = (String[])ContainerUtil.toArray((List)result, (Object[])new String[result.size()]);
        if (stringArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/RootModelImpl.getDependencyModuleNames must not return null");
        }
        return stringArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public VirtualFile[] getRootPaths(OrderRootType rootType) {
        VirtualFile[] virtualFileArray;
        VirtualFilePointerContainer container = this.myOrderRootPointerContainers.get(rootType);
        if (container != null) {
            virtualFileArray = container.getFiles();
            if (virtualFileArray == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/RootModelImpl.getRootPaths must not return null");
            return virtualFileArray;
        }
        for (ModuleExtension extension : this.myExtensions) {
            VirtualFile[] files = extension.getRootPaths(rootType);
            if (files == null) continue;
            virtualFileArray = files;
            if (files == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/RootModelImpl.getRootPaths must not return null");
            return virtualFileArray;
        }
        virtualFileArray = VirtualFile.EMPTY_ARRAY;
        if (VirtualFile.EMPTY_ARRAY != null) return virtualFileArray;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/RootModelImpl.getRootPaths must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String[] getRootUrls(OrderRootType rootType) {
        String[] stringArray;
        VirtualFilePointerContainer container = this.myOrderRootPointerContainers.get(rootType);
        if (container != null) {
            stringArray = container.getUrls();
            if (stringArray == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/RootModelImpl.getRootUrls must not return null");
            return stringArray;
        }
        for (ModuleExtension extension : this.myExtensions) {
            String[] urls = extension.getRootUrls(rootType);
            if (urls == null) continue;
            stringArray = urls;
            if (urls == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/RootModelImpl.getRootUrls must not return null");
            return stringArray;
        }
        stringArray = ArrayUtil.EMPTY_STRING_ARRAY;
        if (ArrayUtil.EMPTY_STRING_ARRAY != null) return stringArray;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/RootModelImpl.getRootUrls must not return null");
    }

    @NotNull
    public Module[] getModuleDependencies() {
        Module[] moduleArray = this.getModuleDependencies(true);
        if (moduleArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/RootModelImpl.getModuleDependencies must not return null");
        }
        return moduleArray;
    }

    @NotNull
    public Module[] getModuleDependencies(boolean includeTests) {
        ArrayList<Module> result = new ArrayList<Module>();
        for (OrderEntry entry : this.getOrderEntries()) {
            Module module1;
            if (!(entry instanceof ModuleOrderEntry)) continue;
            ModuleOrderEntry moduleOrderEntry = (ModuleOrderEntry)entry;
            if (!includeTests && moduleOrderEntry.getScope() == DependencyScope.TEST || (module1 = moduleOrderEntry.getModule()) == null) continue;
            result.add(module1);
        }
        Module[] moduleArray = (Module[])ContainerUtil.toArray(result, (Object[])new Module[result.size()]);
        if (moduleArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/RootModelImpl.getModuleDependencies must not return null");
        }
        return moduleArray;
    }

    private RootModelImpl getSourceModel() {
        this.assertWritable();
        return this.myModuleRootManager.getRootModel();
    }

    public void setRootUrls(OrderRootType orderRootType, String[] urls) {
        this.assertWritable();
        VirtualFilePointerContainer container = this.myOrderRootPointerContainers.get(orderRootType);
        if (container == null) {
            container = this.myFilePointerManager.createContainer(this.myDisposable, this.myVirtualFilePointerListener);
            this.myOrderRootPointerContainers.put((PersistentOrderRootType)orderRootType, container);
        }
        container.clear();
        for (String url : urls) {
            container.add(url);
        }
    }

    @Nullable
    private VirtualFilePointer getOutputPathValue(Element element, String tag, boolean createPointer) {
        Element outputPathChild = element.getChild(tag);
        VirtualFilePointer vptr = null;
        if (outputPathChild != null && createPointer) {
            String outputPath = outputPathChild.getAttributeValue("url");
            vptr = this.myFilePointerManager.create(outputPath, this.myDisposable, this.myVirtualFilePointerListener);
        }
        return vptr;
    }

    @Nullable
    private static String getOutputPathValue(Element element, String tag) {
        Element outputPathChild = element.getChild(tag);
        if (outputPathChild != null) {
            return outputPathChild.getAttributeValue("url");
        }
        return null;
    }

    public <T> T getModuleExtension(Class<T> klass) {
        for (ModuleExtension extension : this.myExtensions) {
            if (!klass.isAssignableFrom(extension.getClass())) continue;
            return (T)extension;
        }
        return null;
    }

    void registerOnDispose(Disposable disposable) {
        Disposer.register((Disposable)this.myDisposable, (Disposable)disposable);
    }

    static /* synthetic */ OrderEntry[] access$102(RootModelImpl x0, OrderEntry[] x1) {
        x0.myCachedOrderEntries = x1;
        return x1;
    }

    private static class CollectDependentModules
    extends RootPolicy<List<String>> {
        private CollectDependentModules() {
        }

        public List<String> visitModuleOrderEntry(ModuleOrderEntry moduleOrderEntry, List<String> arrayList) {
            arrayList.add(moduleOrderEntry.getModuleName());
            return arrayList;
        }
    }

    private class Order
    extends ArrayList<OrderEntry> {
        private Order() {
        }

        @Override
        public void clear() {
            super.clear();
            this.clearCachedEntries();
        }

        @Override
        public OrderEntry set(int i, OrderEntry orderEntry) {
            super.set(i, orderEntry);
            ((OrderEntryBaseImpl)orderEntry).setIndex(i);
            this.clearCachedEntries();
            return orderEntry;
        }

        @Override
        public boolean add(OrderEntry orderEntry) {
            super.add(orderEntry);
            ((OrderEntryBaseImpl)orderEntry).setIndex(this.size() - 1);
            this.clearCachedEntries();
            return true;
        }

        @Override
        public void add(int i, OrderEntry orderEntry) {
            super.add(i, orderEntry);
            this.clearCachedEntries();
            this.setIndicies(i);
        }

        @Override
        public OrderEntry remove(int i) {
            OrderEntry entry = (OrderEntry)super.remove(i);
            this.setIndicies(i);
            this.clearCachedEntries();
            return entry;
        }

        @Override
        public boolean remove(Object o) {
            int index = this.indexOf(o);
            if (index < 0) {
                return false;
            }
            this.remove(index);
            this.clearCachedEntries();
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends OrderEntry> collection) {
            int startSize = this.size();
            boolean result = super.addAll(collection);
            this.setIndicies(startSize);
            this.clearCachedEntries();
            return result;
        }

        @Override
        public boolean addAll(int i, Collection<? extends OrderEntry> collection) {
            boolean result = super.addAll(i, collection);
            this.setIndicies(i);
            this.clearCachedEntries();
            return result;
        }

        @Override
        public void removeRange(int i, int i1) {
            super.removeRange(i, i1);
            this.clearCachedEntries();
            this.setIndicies(i);
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            boolean result = super.removeAll(collection);
            this.setIndicies(0);
            this.clearCachedEntries();
            return result;
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            boolean result = super.retainAll(collection);
            this.setIndicies(0);
            this.clearCachedEntries();
            return result;
        }

        private void clearCachedEntries() {
            RootModelImpl.access$102(RootModelImpl.this, null);
        }

        private void setIndicies(int startIndex) {
            for (int j = startIndex; j < this.size(); ++j) {
                ((OrderEntryBaseImpl)this.get(j)).setIndex(j);
            }
        }
    }

    private static class ContentComparator
    implements Comparator<ContentEntry> {
        public static final ContentComparator INSTANCE = new ContentComparator();

        private ContentComparator() {
        }

        @Override
        public int compare(ContentEntry o1, ContentEntry o2) {
            return o1.getUrl().compareTo(o2.getUrl());
        }
    }
}

