/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.ide.util.ElementsChooser;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ui.util.CellAppearanceUtils;
import java.awt.Color;
import javax.swing.Icon;

public class ModuleChooserElement
implements ElementsChooser.ElementProperties {
    private final String myName;
    private final Module myModule;
    private ModuleOrderEntry myOrderEntry;

    public ModuleChooserElement(Module module, ModuleOrderEntry orderEntry) {
        this.myModule = module;
        this.myOrderEntry = orderEntry;
        this.myName = module != null ? module.getName() : orderEntry.getModuleName();
    }

    public Module getModule() {
        return this.myModule;
    }

    public ModuleOrderEntry getOrderEntry() {
        return this.myOrderEntry;
    }

    public void setOrderEntry(ModuleOrderEntry orderEntry) {
        this.myOrderEntry = orderEntry;
    }

    public String getName() {
        return this.myName;
    }

    @Override
    public Icon getIcon() {
        if (this.myModule != null) {
            return this.myModule.getModuleType().getNodeIcon(false);
        }
        return CellAppearanceUtils.INVALID_ICON;
    }

    @Override
    public Color getColor() {
        return this.myModule == null ? Color.RED : null;
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModuleChooserElement)) {
            return false;
        }
        ModuleChooserElement chooserElement = (ModuleChooserElement)o;
        return this.myName.equals(chooserElement.myName);
    }

    public int hashCode() {
        return this.myName.hashCode();
    }
}

