/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.ui.OrderPanel;

public class ModuleDependantsPanel
extends OrderPanel<ModifiableRootModel> {
    private final Module myModule;

    public ModuleDependantsPanel(Module module) {
        super(ModifiableRootModel.class, true);
        this.myModule = module;
    }

    public boolean isCheckable(ModifiableRootModel entry) {
        return true;
    }

    public boolean isChecked(ModifiableRootModel model) {
        OrderEntry[] entries;
        for (OrderEntry entry : entries = model.getOrderEntries()) {
            ModuleOrderEntry moduleOrderEntry;
            if (!(entry instanceof ModuleOrderEntry) || (moduleOrderEntry = (ModuleOrderEntry)entry).getModule() != this.myModule) continue;
            return true;
        }
        return false;
    }

    public void setChecked(ModifiableRootModel model, boolean checked) {
        if (checked) {
            model.addModuleOrderEntry(this.myModule);
        } else {
            OrderEntry[] entries;
            for (OrderEntry entry : entries = model.getOrderEntries()) {
                ModuleOrderEntry moduleOrderEntry;
                if (!(entry instanceof ModuleOrderEntry) || (moduleOrderEntry = (ModuleOrderEntry)entry).getModule() != this.myModule) continue;
                model.removeOrderEntry((OrderEntry)moduleOrderEntry);
                break;
            }
        }
    }
}

