/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraryEditor;

import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.ItemElementDescriptor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryTableEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryTableTreeContentElement;

class ItemElement
extends LibraryTableTreeContentElement {
    private final LibraryTableTreeContentElement myParent;
    private final Library myLibrary;
    private final String myUrl;
    private final OrderRootType myRootType;
    private final boolean myIsJarDirectory;
    private final boolean myValid;

    public ItemElement(LibraryTableTreeContentElement parent, Library library, String url, OrderRootType rootType, boolean isJarDirectory, boolean isValid) {
        this.myParent = parent;
        this.myLibrary = library;
        this.myUrl = url;
        this.myRootType = rootType;
        this.myIsJarDirectory = isJarDirectory;
        this.myValid = isValid;
    }

    @Override
    public LibraryTableTreeContentElement getParent() {
        return this.myParent;
    }

    @Override
    public OrderRootType getOrderRootType() {
        return null;
    }

    @Override
    public NodeDescriptor createDescriptor(NodeDescriptor parentDescriptor, LibraryTableEditor parentEditor) {
        return new ItemElementDescriptor(parentDescriptor, this);
    }

    public String getUrl() {
        return this.myUrl;
    }

    public boolean isJarDirectory() {
        return this.myIsJarDirectory;
    }

    public boolean isValid() {
        return this.myValid;
    }

    public OrderRootType getRootType() {
        return this.myRootType;
    }

    public Library getLibrary() {
        return this.myLibrary;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ItemElement)) {
            return false;
        }
        ItemElement itemElement = (ItemElement)o;
        if (!this.myLibrary.equals(itemElement.myLibrary)) {
            return false;
        }
        if (!this.myParent.equals(itemElement.myParent)) {
            return false;
        }
        if (!this.myRootType.equals((Object)itemElement.myRootType)) {
            return false;
        }
        return this.myUrl.equals(itemElement.myUrl);
    }

    public int hashCode() {
        int result = this.myParent.hashCode();
        result = 29 * result + this.myLibrary.hashCode();
        result = 29 * result + this.myUrl.hashCode();
        result = 29 * result + this.myRootType.hashCode();
        return result;
    }
}

