/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diff.impl.patch.formove.FilePathComparator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.FileHolder;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class RecursiveFileHolder
implements FileHolder {
    protected final FileHolder.HolderType myHolderType;
    protected final Map<VirtualFile, String> myFiles = new HashMap<VirtualFile, String>();
    protected List<VirtualFile> mySwitchRoots;
    protected final Project myProject;

    public RecursiveFileHolder(Project project, FileHolder.HolderType holderType) {
        this.myProject = project;
        this.myHolderType = holderType;
    }

    @Override
    public synchronized void cleanAll() {
        this.myFiles.clear();
        if (this.mySwitchRoots != null) {
            this.mySwitchRoots.clear();
        }
    }

    @Override
    public void cleanScope(final VcsDirtyScope scope) {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                RecursiveFileHolder recursiveFileHolder = RecursiveFileHolder.this;
                synchronized (recursiveFileHolder) {
                    if (RecursiveFileHolder.this.myProject.isDisposed()) {
                        return;
                    }
                    ArrayList<VirtualFile> currentFiles = new ArrayList<VirtualFile>(RecursiveFileHolder.this.myFiles.keySet());
                    for (VirtualFile file : currentFiles) {
                        if (!RecursiveFileHolder.this.isFileDirty(scope, file)) continue;
                        if (RecursiveFileHolder.this.mySwitchRoots != null) {
                            RecursiveFileHolder.this.mySwitchRoots.remove(file);
                        }
                        RecursiveFileHolder.this.myFiles.remove(file);
                    }
                }
            }
        });
    }

    protected boolean isFileDirty(VcsDirtyScope scope, VirtualFile file) {
        return this.fileDropped(file) || scope.belongsTo((FilePath)new FilePathImpl(file));
    }

    @Override
    public FileHolder.HolderType getType() {
        return this.myHolderType;
    }

    protected boolean fileDropped(VirtualFile file) {
        return !file.isValid() || ProjectLevelVcsManager.getInstance((Project)this.myProject).getVcsFor(file) == null;
    }

    public synchronized void addFile(VirtualFile file, @NotNull String branchName, boolean recursive) {
        if (branchName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vcs/changes/RecursiveFileHolder.addFile must not be null");
        }
        this.myFiles.put(file, branchName);
    }

    private void preCheckFiles() {
        for (int i = 0; i < this.mySwitchRoots.size() - 1; ++i) {
            VirtualFile switchRoot = this.mySwitchRoots.get(i);
            String parentUrl = this.myFiles.get(switchRoot);
            ListIterator<VirtualFile> iterator = this.mySwitchRoots.listIterator(i + 1);
            while (iterator.hasNext()) {
                VirtualFile file = (VirtualFile)iterator.next();
                String childUrl = this.myFiles.get(file);
                if (!VfsUtil.isAncestor((VirtualFile)switchRoot, (VirtualFile)file, (boolean)true) || !childUrl.startsWith(parentUrl)) continue;
                if (childUrl.length() > parentUrl.length()) {
                    String subUrl = childUrl.substring(parentUrl.length());
                    String string = subUrl = subUrl.startsWith("/") ? subUrl.substring(1) : subUrl;
                    String relativePath = VfsUtil.getRelativePath((VirtualFile)file, (VirtualFile)switchRoot, (char)'/');
                    if (relativePath == null || !(relativePath = relativePath.startsWith("/") ? relativePath.substring(1) : relativePath).equals(subUrl)) continue;
                    iterator.remove();
                    continue;
                }
                if (childUrl.length() != parentUrl.length()) continue;
                iterator.remove();
            }
        }
        Iterator<Map.Entry<VirtualFile, String>> iterator = this.myFiles.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<VirtualFile, String> entry = iterator.next();
            if (this.mySwitchRoots.contains(entry.getKey())) continue;
            iterator.remove();
        }
    }

    public synchronized void calculateChildren() {
        this.mySwitchRoots = new ArrayList<VirtualFile>(this.myFiles.keySet());
        Collections.sort(this.mySwitchRoots, FilePathComparator.getInstance());
        this.preCheckFiles();
        Collections.reverse(this.mySwitchRoots);
    }

    public synchronized void removeFile(VirtualFile file) {
        this.myFiles.remove(file);
        if (this.mySwitchRoots != null) {
            this.mySwitchRoots.remove(file);
        }
    }

    @Override
    public synchronized RecursiveFileHolder copy() {
        RecursiveFileHolder copyHolder = new RecursiveFileHolder(this.myProject, this.myHolderType);
        copyHolder.myFiles.putAll(this.myFiles);
        return copyHolder;
    }

    public synchronized boolean containsFile(VirtualFile file) {
        return this.getBranchForFile(file) != null;
    }

    public synchronized MultiMap<String, VirtualFile> getBranchToFileMap() {
        MultiMap result = new MultiMap();
        for (Map.Entry<VirtualFile, String> e : this.myFiles.entrySet()) {
            result.putValue((Object)e.getValue(), (Object)e.getKey());
        }
        return result;
    }

    public String getBranchForFile(VirtualFile file) {
        for (VirtualFile vf : this.myFiles.keySet()) {
            if (!VfsUtil.isAncestor((VirtualFile)vf, (VirtualFile)file, (boolean)false)) continue;
            return this.myFiles.get(vf);
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecursiveFileHolder that = (RecursiveFileHolder)o;
        return ((Object)this.myFiles).equals(that.myFiles);
    }

    public int hashCode() {
        return ((Object)this.myFiles).hashCode();
    }
}

